/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.CardView;
import android.support.v7.widget.Toolbar;
import android.text.util.Linkify;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkVersion;
import com.unvired.database.DBException;
import com.unvired.logger.Logger;
import com.unvired.model.ApplicationVersion;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.IconHelper;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.UITheme;
import java.io.InputStream;

public class AboutUsActivity
extends AppCompatActivity
implements View.OnClickListener {
    protected static float density = 0.0f;
    private int dp2 = 2;
    private int dp4 = 4;
    private int dp8 = 8;
    private int dp16 = 16;
    private int dp20 = 20;
    private int dp24 = 24;
    private int dp32 = 32;
    private int dp48 = 48;
    private int dp56 = 56;
    private int dp72 = 72;
    private ImageView supportEmailIcon;
    private ImageView salesEmailIcon;
    private ImageView companyIcon;
    private MessageHelper messageHelper = MessageHelper.getInstance();

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        this.getWindow().requestFeature(8);
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.init();
        this.setIcon();
        Toolbar toolbar = UIStyle.getToolBar((Context)this);
        this.setSupportActionBar(toolbar);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AboutUsActivity.this.onBackPressed();
            }
        });
        LinearLayout.LayoutParams cardParam = new LinearLayout.LayoutParams(-1, -2);
        cardParam.setMargins(this.dp8, this.dp8, this.dp8, this.dp8);
        LinearLayout homeLayout = new LinearLayout((Context)this);
        homeLayout.setLayoutParams(UIStyle.getLayoutParam());
        homeLayout.setOrientation(1);
        homeLayout.addView((View)this.getFirstCardView(), (ViewGroup.LayoutParams)cardParam);
        homeLayout.addView((View)this.getSecondCardView(), (ViewGroup.LayoutParams)cardParam);
        homeLayout.addView((View)this.getThirdCardView(), (ViewGroup.LayoutParams)cardParam);
        ScrollView scrollView = new ScrollView((Context)this);
        scrollView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        scrollView.setBackgroundColor(UITheme.getBackgroundColor());
        scrollView.addView((View)homeLayout);
        LinearLayout rootLinearLayout = new LinearLayout((Context)this);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        rootLinearLayout.setLayoutParams(params);
        rootLinearLayout.setOrientation(1);
        rootLinearLayout.addView((View)toolbar);
        rootLinearLayout.addView((View)scrollView);
        this.setContentView((View)rootLinearLayout);
    }

    private void init() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        density = displayMetrics.density;
        this.dp2 = (int)(density * 2.0f);
        this.dp4 = (int)(density * 4.0f);
        this.dp8 = (int)(density * 8.0f);
        this.dp16 = (int)(density * 16.0f);
        this.dp20 = (int)(density * 20.0f);
        this.dp24 = (int)(density * 24.0f);
        this.dp32 = (int)(density * 32.0f);
        this.dp48 = (int)(density * 48.0f);
        this.dp56 = (int)(density * 56.0f);
        this.dp72 = (int)(density * 72.0f);
    }

    public void setIcon() {
        this.supportEmailIcon = UIStyle.getHomeIcons((Context)this);
        this.salesEmailIcon = UIStyle.getHomeIcons((Context)this);
        this.companyIcon = UIStyle.getUnviredHomeIconSmall((Context)this);
        this.supportEmailIcon.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_email.png"), (String)""));
        this.salesEmailIcon.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_email.png"), (String)""));
    }

    private CardView getFirstCardView() {
        LinearLayout iconMainLayout = new LinearLayout((Context)this);
        iconMainLayout.setLayoutParams(UIStyle.getLayoutParam());
        iconMainLayout.setGravity(17);
        iconMainLayout.addView((View)this.companyIcon);
        TextView appNameLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView companyLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView websiteURLLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView copyrightLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView supportLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView salesLabel = UIStyle.getDetailLabelTextView((Context)this);
        appNameLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_APP_NAME_LABEL));
        companyLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_COMPANY_LABEL));
        websiteURLLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_WEBSITE_LABEL));
        copyrightLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_COPYRIGHT_LABEL));
        supportLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_SUPPORT_LABEL));
        salesLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_SALES_LABEL));
        TextView appName = UIStyle.getDetailContentTextView((Context)this);
        TextView company = UIStyle.getDetailContentTextView((Context)this);
        TextView websiteURL = UIStyle.getDetailContentTextView((Context)this);
        TextView copyright = UIStyle.getDetailContentTextView((Context)this);
        TextView support = UIStyle.getDetailContentTextView((Context)this);
        TextView sales = UIStyle.getDetailContentTextView((Context)this);
        String applicationName = null;
        try {
            applicationName = ApplicationManager.getInstance().getApplicationMeta().getDescription();
        }
        catch (DBException e) {
            Logger.log(8, ((Object)((Object)this)).getClass().getName(), "setLayout", "Exception caught while setting Layout for AboutUsActivity, " + e.getMessage());
        }
        if (applicationName != null) {
            appName.setText((CharSequence)applicationName);
        } else {
            appName.setText((CharSequence)"");
        }
        company.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_COMPANY));
        websiteURL.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_WEBSITE));
        copyright.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_COPYRIGHT));
        support.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_SUPPORT));
        sales.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_SALES));
        websiteURL.setLinkTextColor(-16776961);
        Linkify.addLinks((TextView)websiteURL, (int)1);
        final String supportEmail = support.getText().toString();
        final String salesEmail = sales.getText().toString();
        LinearLayout supportEmailIconLayout = new LinearLayout((Context)this);
        supportEmailIconLayout.setLayoutParams(UIStyle.getLayoutParam());
        supportEmailIconLayout.setGravity(21);
        supportEmailIconLayout.addView((View)this.supportEmailIcon);
        LinearLayout salesEmailIconLayout = new LinearLayout((Context)this);
        salesEmailIconLayout.setLayoutParams(UIStyle.getLayoutParam());
        salesEmailIconLayout.setGravity(21);
        salesEmailIconLayout.addView((View)this.salesEmailIcon);
        LinearLayout supportEmailLayout = new LinearLayout((Context)this);
        supportEmailLayout.setOrientation(0);
        supportEmailLayout.addView((View)support);
        supportEmailLayout.addView((View)supportEmailIconLayout);
        supportEmailLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AboutUsActivity.this.sendEmail(supportEmail, "", "");
            }
        });
        LinearLayout salesEmailLayout = new LinearLayout((Context)this);
        salesEmailLayout.setOrientation(0);
        salesEmailLayout.addView((View)sales);
        salesEmailLayout.addView((View)salesEmailIconLayout);
        salesEmailLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AboutUsActivity.this.sendEmail(salesEmail, "", "");
            }
        });
        LinearLayout layout2 = new LinearLayout((Context)this);
        layout2.setOrientation(1);
        layout2.setPadding(this.dp16, this.dp16, this.dp16, this.dp16);
        layout2.addView((View)iconMainLayout);
        layout2.addView((View)appNameLabel);
        layout2.addView((View)appName);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)companyLabel);
        layout2.addView((View)company);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)websiteURLLabel);
        layout2.addView((View)websiteURL);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)copyrightLabel);
        layout2.addView((View)copyright);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)supportLabel);
        layout2.addView((View)supportEmailLayout);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)salesLabel);
        layout2.addView((View)salesEmailLayout);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        CardView cardView = UIStyle.getCardView((Context)this);
        cardView.addView((View)layout2);
        return cardView;
    }

    private CardView getSecondCardView() {
        TextView creditLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView tradeMarkLabel = UIStyle.getDetailLabelTextView((Context)this);
        creditLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_CREDIT_LABEL));
        tradeMarkLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_TRADEMARK_LABEL));
        TextView credit = UIStyle.getDetailContentTextView((Context)this);
        TextView tradeMark = UIStyle.getDetailContentTextView((Context)this);
        credit.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_CREDIT));
        tradeMark.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_TRADEMARK));
        LinearLayout layout2 = new LinearLayout((Context)this);
        layout2.setOrientation(1);
        layout2.setPadding(this.dp16, this.dp16, this.dp16, this.dp16);
        layout2.addView((View)creditLabel);
        layout2.addView((View)credit);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)tradeMarkLabel);
        layout2.addView((View)tradeMark);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        CardView cardView = UIStyle.getCardView((Context)this);
        cardView.addView((View)layout2);
        return cardView;
    }

    private CardView getThirdCardView() {
        TextView applicationSVNBuildVersionLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView frameworkSVNBuildVersionLabel = UIStyle.getDetailLabelTextView((Context)this);
        applicationSVNBuildVersionLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_APPLICATION_LABEL));
        frameworkSVNBuildVersionLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.ABOUT_US_ACTIVITY_UNVIRED_FRAMEWORK_LABEL));
        TextView frameworkSVNBuildVersion = UIStyle.getDetailContentTextView((Context)this);
        TextView applicationSVNBuildVersion = UIStyle.getDetailContentTextView((Context)this);
        String frameworkVersion = FrameworkVersion.getFrameworkVersion();
        String frameworkBuildVersion = FrameworkVersion.getFrameworkBuildNumber();
        frameworkSVNBuildVersion.setText((CharSequence)("Version: " + frameworkVersion + "\n" + "Build No: " + frameworkBuildVersion + "\nSVN: " + FrameworkVersion.getFrameworkSVNText()));
        String applicationBuildVersion = "";
        String applicationVersion = "";
        String applicationVersionFromApp = ApplicationVersion.getAPPLICATION_VERSION();
        applicationVersion = !Strings.isNullOrEmpty((String)applicationVersionFromApp) ? applicationVersionFromApp : FrameworkVersion.getApplicationVersion();
        String appMetaVersion = FrameworkVersion.getApplicationMetaVersion();
        String appBuildVersion = ApplicationVersion.getBUILD_NUMBER();
        if (!Strings.isNullOrEmpty((String)appBuildVersion)) {
            applicationBuildVersion = appBuildVersion;
        }
        applicationSVNBuildVersion.setText((CharSequence)("Version: " + applicationVersion + "\n" + "Build No: " + applicationBuildVersion + "\n" + "Data Model: " + appMetaVersion));
        LinearLayout layout2 = new LinearLayout((Context)this);
        layout2.setOrientation(1);
        layout2.setPadding(this.dp16, this.dp16, this.dp16, this.dp16);
        layout2.addView((View)applicationSVNBuildVersionLabel);
        layout2.addView((View)applicationSVNBuildVersion);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)frameworkSVNBuildVersionLabel);
        layout2.addView((View)frameworkSVNBuildVersion);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        CardView cardView = UIStyle.getCardView((Context)this);
        cardView.addView((View)layout2);
        return cardView;
    }

    private void sendEmail(String emailId, String subject, String msg) {
        Intent send = new Intent("android.intent.action.SEND", Uri.parse((String)("mailto:" + emailId)));
        send.putExtra("android.intent.extra.SUBJECT", subject);
        send.putExtra("android.intent.extra.TEXT", msg);
        send.putExtra("android.intent.extra.EMAIL", new String[]{emailId});
        send.setType("text/plain");
        this.startActivity(Intent.createChooser((Intent)send, (CharSequence)"SendMail.."));
    }

    private void browseURI(String url) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)url));
        this.startActivity(i);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return false;
    }

    public void onBackPressed() {
        this.finish();
        super.onBackPressed();
    }

    public void onClick(View v) {
    }
}

