/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import com.unvired.login.UnviredAccount;
import com.unvired.ui.LoginActivity;
import com.unvired.ui.UIStyle;
import com.unvired.ui.adapter.AccountsAdapter;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import com.unvired.utils.UITheme;
import java.util.List;

public class AccountsActivity
extends AppCompatActivity
implements View.OnClickListener {
    private RecyclerView recyclerView = null;
    private static final int ADD_ACCOUNT_MENU_ID = 101;
    boolean switchAccount = false;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        this.getWindow().requestFeature(8);
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        Toolbar toolbar = UIStyle.getToolBar((Context)this);
        toolbar.setTitle((CharSequence)"Account");
        Bundle extras = this.getIntent().getExtras();
        if (extras != null) {
            this.switchAccount = extras.getBoolean("SWITCH_ACCOUNT");
            if (this.switchAccount) {
                toolbar.setTitle((CharSequence)"Choose Account");
                toolbar.setNavigationIcon(null);
            }
        }
        this.setSupportActionBar(toolbar);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountsActivity.this.onBackPressed();
            }
        });
        this.recyclerView = new RecyclerView((Context)this);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setSelected(true);
        LinearLayout homeLayout = new LinearLayout((Context)this);
        homeLayout.setOrientation(1);
        homeLayout.addView((View)toolbar);
        homeLayout.addView((View)this.recyclerView);
        this.setContentView((View)homeLayout);
        this.loadAccounts();
    }

    private void loadAccounts() {
        List<UnviredAccount> accountList = PathManager.getInstance().getAllAccounts();
        AccountsAdapter accountsAdapter = new AccountsAdapter((Activity)this, accountList, this.switchAccount);
        this.recyclerView.setAdapter((RecyclerView.Adapter)accountsAdapter);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        if (!this.switchAccount) {
            menu.add(0, 101, 0, (CharSequence)"Add Account");
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        } else if (item.getItemId() == 101) {
            FrameworkHelper.shutdown();
            Intent intent = new Intent(FrameworkHelper.getApplicationContext(), LoginActivity.class);
            intent.addFlags(0x10008000);
            this.startActivity(intent);
        }
        return false;
    }

    public void onBackPressed() {
        this.finish();
        super.onBackPressed();
    }

    public void onClick(View v) {
    }
}

