/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.CardView;
import android.support.v7.widget.Toolbar;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TextView;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.response.HTTPResponse;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.UITheme;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApplicationStatusTabPage
extends AppCompatActivity
implements View.OnClickListener {
    private TextView statusValue;
    private LinearLayout statusValueLayout;
    private ProgressBar progressBar;
    private HTTPResponse httpResponse = null;
    private boolean connected = false;
    private boolean testingConnection = false;
    protected static float density = 0.0f;
    private Toolbar toolbar;
    private int dp2 = 2;
    private int dp4 = 4;
    private int dp8 = 8;
    private int dp16 = 16;
    private int dp20 = 20;
    private int dp24 = 24;
    private int dp32 = 32;
    private int dp48 = 48;
    private int dp56 = 56;
    private int dp72 = 72;
    private MessageHelper messageHelper = MessageHelper.getInstance();
    private boolean applicationInDemoMode = false;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.init();
        this.setProgressBar();
        this.toolbar = UIStyle.getToolBar((Context)this);
        try {
            this.applicationInDemoMode = UserSettingsManager.getInstance().getDemoMode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSupportActionBar(this.toolbar);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ApplicationStatusTabPage.this.onBackPressed();
            }
        });
        LinearLayout.LayoutParams cardParam = new LinearLayout.LayoutParams(-1, -2);
        cardParam.setMargins(this.dp8, this.dp8, this.dp8, this.dp8);
        LinearLayout homeLayout = new LinearLayout((Context)this);
        homeLayout.setLayoutParams(UIStyle.getLayoutParam());
        homeLayout.setOrientation(1);
        homeLayout.addView((View)this.getAppCard(), (ViewGroup.LayoutParams)cardParam);
        homeLayout.addView((View)this.getPropertiesCard(), (ViewGroup.LayoutParams)cardParam);
        ScrollView scrollView = new ScrollView((Context)this);
        scrollView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        scrollView.setBackgroundColor(UITheme.getBackgroundColor());
        scrollView.addView((View)homeLayout);
        LinearLayout rootLinearLayout = new LinearLayout((Context)this);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        rootLinearLayout.setLayoutParams(params);
        rootLinearLayout.setOrientation(1);
        rootLinearLayout.addView((View)this.toolbar);
        rootLinearLayout.addView((View)scrollView);
        this.setContentView((View)rootLinearLayout);
    }

    private void init() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        density = displayMetrics.density;
        this.dp2 = (int)(density * 2.0f);
        this.dp4 = (int)(density * 4.0f);
        this.dp8 = (int)(density * 8.0f);
        this.dp16 = (int)(density * 16.0f);
        this.dp20 = (int)(density * 20.0f);
        this.dp24 = (int)(density * 24.0f);
        this.dp32 = (int)(density * 32.0f);
        this.dp48 = (int)(density * 48.0f);
        this.dp56 = (int)(density * 56.0f);
        this.dp72 = (int)(density * 72.0f);
    }

    private CardView getAppCard() {
        TextView applicationHeader = UIStyle.getSectionHeaderTextView((Context)this);
        TextView statusLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView userLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView urlLabel = UIStyle.getDetailLabelTextView((Context)this);
        this.statusValue = UIStyle.getDetailContentTextView((Context)this);
        TextView userValue = UIStyle.getDetailContentTextView((Context)this);
        TextView urlValue = UIStyle.getDetailContentTextView((Context)this);
        this.statusValue.setOnClickListener((View.OnClickListener)this);
        this.statusValueLayout = new LinearLayout((Context)this);
        this.statusValueLayout.addView((View)this.statusValue);
        applicationHeader.setText((CharSequence)"Application");
        statusLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.APPLICATION_STATUS_TAB_PAGE_ACTIVITY_IS_APPLICATION_ACTIVE));
        userLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.APPLICATION_STATUS_TAB_PAGE_ACTIVITY_USER));
        urlLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.APPLICATION_STATUS_TAB_PAGE_ACTIVITY_URL));
        String appId = ApplicationManager.getInstance().getApplicationId();
        if (appId == null || appId.length() <= 0) {
            this.statusValue.setText((CharSequence)"Demo");
            this.statusValue.setTextColor(-65536);
            this.statusValueLayout.removeAllViews();
            this.statusValueLayout.addView((View)this.statusValue);
        } else {
            this.testingConnection = true;
            this.statusValueLayout.removeAllViews();
            this.statusValueLayout.addView((View)this.progressBar);
            this.testConnection();
        }
        try {
            userValue.setText((CharSequence)UserSettingsManager.getInstance().getUnviredUserId());
            urlValue.setText((CharSequence)FrameworkSettingsManager.getInstance().getUrl());
        }
        catch (Exception exception) {
            Logger.log(8, ((Object)((Object)this)).getClass().getName(), "initialize", "Exception caught while setting Text for Server UserId and Server URL, " + exception.getMessage());
        }
        LinearLayout layout2 = new LinearLayout((Context)this);
        layout2.setLayoutParams(UIStyle.getLayoutParam());
        layout2.setOrientation(1);
        layout2.setPadding(this.dp16, this.dp16, this.dp16, this.dp16);
        layout2.addView((View)applicationHeader);
        layout2.addView((View)statusLabel);
        layout2.addView((View)this.statusValueLayout);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)userLabel);
        layout2.addView((View)userValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)urlLabel);
        layout2.addView((View)urlValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        CardView cardView = UIStyle.getCardView((Context)this);
        cardView.addView((View)layout2);
        return cardView;
    }

    private CardView getPropertiesCard() {
        FrameworkSettingsManager frameworkSettingsManager = null;
        UserSettingsManager userSettingsManager = null;
        TextView propertiesHeader = UIStyle.getSectionHeaderTextView((Context)this);
        TextView serverIdLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView serverTypeLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView actIdLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView deviceIdLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView deviceNameLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView deviceTypeLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView deviceIdentifierLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView secLevelLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView companyAliasLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView csrLevelLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView serverIdValue = UIStyle.getDetailContentTextView((Context)this);
        TextView serverTypeValue = UIStyle.getDetailContentTextView((Context)this);
        TextView actIdValue = UIStyle.getDetailContentTextView((Context)this);
        TextView deviceIdValue = UIStyle.getDetailContentTextView((Context)this);
        TextView deviceNameValue = UIStyle.getDetailContentTextView((Context)this);
        TextView deviceTypeValue = UIStyle.getDetailContentTextView((Context)this);
        TextView deviceIdentifierValue = UIStyle.getDetailContentTextView((Context)this);
        TextView secLevelValue = UIStyle.getDetailContentTextView((Context)this);
        TextView companyAliasValue = UIStyle.getDetailContentTextView((Context)this);
        TextView csrLevelValue = UIStyle.getDetailContentTextView((Context)this);
        propertiesHeader.setText((CharSequence)"Properties");
        serverIdLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_SERVER_ID));
        serverTypeLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_SERVER_TYPE));
        actIdLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_ACT_ID));
        deviceIdLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_FE_USER_ID));
        deviceNameLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_FE_ID));
        deviceTypeLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_FE_ID_TYPE));
        deviceIdentifierLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_FE_ID_IDENTIFIER));
        secLevelLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_SEC_LEVEL));
        companyAliasLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_COMPANY_ALIAS));
        csrLevelLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.PROPERTIES_TAB_PAGE_ACTIVITY_CSR_URL));
        try {
            frameworkSettingsManager = FrameworkManager.getInstance().getFrameworkSettingsManager();
            userSettingsManager = UserSettingsManager.getInstance();
        }
        catch (Exception e) {
            Logger.log(8, ((Object)((Object)this)).getClass().getName(), "initializePropertiesTab", "Exception: " + e.getMessage());
            return null;
        }
        try {
            String serverId = frameworkSettingsManager.getServerId();
            String serverType = frameworkSettingsManager.getServerType();
            String actId = frameworkSettingsManager.getActId();
            String feUserId = frameworkSettingsManager.getFrontEndUserId();
            String feId = frameworkSettingsManager.getFEAdapterName();
            String feIdType = frameworkSettingsManager.getFEAdapterType();
            String feIdIdentifier = frameworkSettingsManager.getFEUserIDIdentifier();
            int secLevel = frameworkSettingsManager.getSecLevel();
            String csrUrl = frameworkSettingsManager.getCsrUrl();
            String companyAlias = frameworkSettingsManager.getCompanyAlias();
            if (serverId != null && serverId.length() > 0) {
                serverIdValue.setText((CharSequence)serverId);
            }
            if (serverType != null && serverType.length() > 0) {
                serverTypeValue.setText((CharSequence)serverType);
            }
            if (actId != null && actId.length() > 0) {
                actIdValue.setText((CharSequence)actId);
            }
            if (feUserId != null && feUserId.length() > 0) {
                deviceIdValue.setText((CharSequence)feUserId);
            }
            if (feId != null && feId.length() > 0) {
                deviceNameValue.setText((CharSequence)feId);
            }
            if (feIdType != null && feIdType.length() > 0) {
                deviceTypeValue.setText((CharSequence)feIdType);
            }
            if (feIdIdentifier != null && feIdIdentifier.length() > 0) {
                deviceIdentifierValue.setText((CharSequence)feIdIdentifier);
            }
            if (companyAlias != null && companyAlias.length() > 0) {
                companyAliasValue.setText((CharSequence)companyAlias);
            }
            if (secLevel == FrameworkSettingsManager.SECURITY_LEVEL_SHARED_KEY_WITH_HTTP) {
                secLevelValue.setText((CharSequence)"HTTP");
            } else if (secLevel == FrameworkSettingsManager.SECURITY_LEVEL_CLIENT_CERTIFICATE_WITH_HTTPS) {
                secLevelValue.setText((CharSequence)"Client Certificate With HTTPS");
            } else if (secLevel == FrameworkSettingsManager.SECURITY_LEVEL_SHARED_KEY_WITH_HTTPS) {
                secLevelValue.setText((CharSequence)"HTTPS");
            }
            if (csrUrl != null && csrUrl.length() > 0) {
                csrLevelValue.setText((CharSequence)csrUrl);
            }
        }
        catch (DBException dbe) {
            Logger.log(8, ((Object)((Object)this)).getClass().getName(), "setLayout", dbe.getMessage());
        }
        LinearLayout layout2 = new LinearLayout((Context)this);
        layout2.setLayoutParams(UIStyle.getLayoutParam());
        layout2.setOrientation(1);
        layout2.setPadding(this.dp16, this.dp16, this.dp16, this.dp16);
        layout2.addView((View)propertiesHeader);
        layout2.addView((View)serverIdLabel);
        layout2.addView((View)serverIdValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)serverTypeLabel);
        layout2.addView((View)serverTypeValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)actIdLabel);
        layout2.addView((View)actIdValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)deviceIdLabel);
        layout2.addView((View)deviceIdValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)deviceNameLabel);
        layout2.addView((View)deviceNameValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)deviceTypeLabel);
        layout2.addView((View)deviceTypeValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)deviceIdentifierLabel);
        layout2.addView((View)deviceIdentifierValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)secLevelLabel);
        layout2.addView((View)secLevelValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)companyAliasLabel);
        layout2.addView((View)companyAliasValue);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        CardView cardView = UIStyle.getCardView((Context)this);
        cardView.addView((View)layout2);
        return cardView;
    }

    private void setProgressBar() {
        this.progressBar = new ProgressBar((Context)this, null, 16843399);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.progressBar.setOnClickListener((View.OnClickListener)this);
        if (Build.VERSION.SDK_INT >= 21) {
            this.progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)Color.rgb((int)0, (int)128, (int)0)));
            this.progressBar.setProgressTintList(ColorStateList.valueOf((int)Color.rgb((int)0, (int)128, (int)0)));
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return false;
    }

    public void onBackPressed() {
        this.finish();
        super.onBackPressed();
    }

    private void testConnection() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        ApplicationStatusTabPage.this.httpResponse = ApplicationStatusTabPage.this.getHTTPResponse();
                        if (ApplicationStatusTabPage.this.httpResponse.getResponseCode() == 200) {
                            ApplicationStatusTabPage.this.connected = true;
                        } else {
                            ApplicationStatusTabPage.this.connected = false;
                        }
                        ApplicationStatusTabPage.this.httpResponse = null;
                    }
                    catch (ApplicationException e) {
                        Logger.log(8, this.getClass().getName(), "testConnection", e.getMessage());
                    }
                    catch (DBException e) {
                        Logger.log(8, this.getClass().getName(), "testConnection", e.getMessage());
                    }
                    ApplicationStatusTabPage.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ApplicationStatusTabPage.this.testingConnection) {
                                ApplicationStatusTabPage.this.updateStatus();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Logger.log(8, this.getClass().getName(), "testConnection", e.getMessage());
                }
            }
        });
        t.start();
    }

    private HTTPResponse getHTTPResponse() throws ApplicationException, DBException {
        FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
        String serverId = frameworkSettingsManager.getServerId();
        ApplicationManager applicationManager = ApplicationManager.getInstance();
        String applicationId = applicationManager.getApplicationId();
        String applicationName = applicationManager.getApplicationName();
        Document pingDocument = FrameworkHelper.getSenderDocumentRoot(9000, null, serverId, applicationName, applicationId);
        Element root = pingDocument.getDocumentElement();
        Element dataElement = pingDocument.createElement("data");
        dataElement.setAttribute("subtype", String.valueOf(100));
        root.appendChild(dataElement);
        byte[] xml = FrameworkHelper.getBytes(pingDocument);
        HTTPResponse httpResponse = HTTPConnection.postDirect("ADMIN_SERVICES", String.valueOf(9000), String.valueOf(100), null, new String(xml), applicationName, null, null);
        return httpResponse;
    }

    private void updateStatus() {
        if (this.connected) {
            this.statusValue.setText((CharSequence)"Connected");
            this.statusValue.setTextColor(Color.rgb((int)0, (int)128, (int)0));
        } else {
            this.statusValue.setText((CharSequence)"Disconnected");
            this.statusValue.setTextColor(-65536);
        }
        this.statusValueLayout.removeAllViews();
        this.statusValueLayout.addView((View)this.statusValue);
        this.testingConnection = false;
    }

    public void onClick(View v) {
        if (v == this.statusValue && !this.applicationInDemoMode) {
            this.testingConnection = true;
            this.statusValueLayout.removeAllViews();
            this.statusValueLayout.addView((View)this.progressBar);
            this.testConnection();
        }
        if (v == this.progressBar && !this.applicationInDemoMode) {
            this.testingConnection = false;
            this.connected = false;
            this.updateStatus();
        }
    }
}

