/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v7.widget.AppCompatButton;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.unvired.database.DBException;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationService;
import com.unvired.login.LoginParameters;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.TokenHelper;
import com.unvired.utils.UITheme;
import java.io.InputStream;

public class DemoModeSelectionActivity
extends Activity
implements View.OnClickListener {
    protected static float density = 0.0f;
    private static String appName;
    private ImageView unvIcon = null;
    private AppCompatButton demoModeButton;
    private AppCompatButton normalModeButton;
    private LinearLayout mainLayout = null;
    private LinearLayout iconMainLayout = null;
    private LinearLayout appNameMainLayout = null;
    private LinearLayout demoButtonsMainLayout = null;
    private LinearLayout normalButtonsMainLayout = null;
    protected TextView applName = null;
    private DemoModeSelectionActivity demoModeSelectionActivity = null;
    private MessageHelper messageHelper = MessageHelper.getInstance();
    private int dp16;
    private int deviceHeightQtr = 0;

    public static void setAppName(String appName) {
        DemoModeSelectionActivity.appName = appName;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.demoModeSelectionActivity = this;
        if (LoginParameters.getCustomThemeResource() != null) {
            UITheme.setCustomTheme(LoginParameters.getCustomThemeResource());
        } else if (LoginParameters.getUITheme() != null) {
            UITheme.setTheme(LoginParameters.getUITheme());
        }
        UITheme.applyTheme(this);
        this.setRequestedOrientation(1);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        this.deviceHeightQtr = displayMetrics.heightPixels / 4;
        this.dp16 = UIStyle.dp16;
        this.setLayout();
        if (TokenHelper.isTokenInfoAvailable()) {
            try {
                LoginParameters.setDemoModeRequired(false);
                LoginParameters.setDemoModeListener(null);
                AuthenticationService.login((Context)this.demoModeSelectionActivity);
                this.finish();
            }
            catch (ApplicationException applicationException) {
                Logger.log(8, ((Object)((Object)this)).getClass().getName(), "onClick", applicationException.getMessage());
            }
            catch (DBException dbException) {
                Logger.log(8, ((Object)((Object)this)).getClass().getName(), "onClick", dbException.getMessage());
            }
        }
    }

    private void setLayout() {
        InputStream logoIcon = LoginParameters.getLogo();
        int width = (int)(250.0f * UIStyle.density);
        int height = (int)(125.0f * UIStyle.density);
        this.unvIcon = new ImageView((Context)this);
        this.unvIcon.setLayoutParams(new ViewGroup.LayoutParams(width, height));
        if (logoIcon != null) {
            Drawable unviredIcon = Drawable.createFromStream((InputStream)logoIcon, (String)"");
            this.unvIcon.setBackgroundDrawable(unviredIcon);
        } else {
            this.unvIcon = UIStyle.getUnviredHomeIconLargeBlue((Context)this);
        }
        this.demoModeButton = new AppCompatButton((Context)this);
        this.normalModeButton = new AppCompatButton((Context)this);
        this.demoModeButton.setLayoutParams(UIStyle.getLayoutParam());
        this.normalModeButton.setLayoutParams(UIStyle.getLayoutParam());
        this.demoModeButton.setBackground(UIStyle.getButtonBG());
        this.normalModeButton.setBackground(UIStyle.getButtonBG());
        this.demoModeButton.setTextColor(UITheme.getTextColor());
        this.normalModeButton.setTextColor(UITheme.getTextColor());
        this.demoModeButton.setOnClickListener((View.OnClickListener)this);
        this.normalModeButton.setOnClickListener((View.OnClickListener)this);
        this.demoModeButton.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.DEMO_MODE_SELECTION_ACTIVITY_DEMO_MODE));
        this.normalModeButton.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.DEMO_MODE_SELECTION_ACTIVITY_SETUP));
        this.demoModeButton.setTypeface(null, 1);
        this.normalModeButton.setTypeface(null, 1);
        this.applName = new TextView((Context)this);
        this.applName.setText((CharSequence)LoginParameters.getAppTitle());
        this.applName.setTypeface(null, 1);
        this.applName.setTextColor(UITheme.getTextColorSecondary());
        this.applName.setTextSize(30.0f);
        this.applName.setGravity(17);
        this.appNameMainLayout = new LinearLayout((Context)this);
        this.appNameMainLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, this.deviceHeightQtr));
        this.appNameMainLayout.setOrientation(1);
        this.appNameMainLayout.setGravity(17);
        this.appNameMainLayout.addView((View)this.applName);
        this.demoButtonsMainLayout = new LinearLayout((Context)this);
        this.demoButtonsMainLayout.setLayoutParams(UIStyle.getLayoutParam());
        this.demoButtonsMainLayout.setOrientation(1);
        this.demoButtonsMainLayout.setPadding(this.dp16, this.dp16, this.dp16, this.dp16);
        this.demoButtonsMainLayout.setGravity(17);
        this.demoButtonsMainLayout.addView((View)this.demoModeButton);
        this.normalButtonsMainLayout = new LinearLayout((Context)this);
        this.normalButtonsMainLayout.setLayoutParams(UIStyle.getLayoutParam());
        this.normalButtonsMainLayout.setOrientation(1);
        this.normalButtonsMainLayout.setPadding(this.dp16, this.dp16, this.dp16, this.dp16);
        this.normalButtonsMainLayout.setGravity(17);
        this.normalButtonsMainLayout.addView((View)this.normalModeButton);
        this.iconMainLayout = new LinearLayout((Context)this);
        this.iconMainLayout.setLayoutParams(UIStyle.getLayoutParam());
        this.iconMainLayout.setOrientation(1);
        this.iconMainLayout.setGravity(17);
        this.iconMainLayout.setPadding(0, 0, 0, UIStyle.dp56);
        this.iconMainLayout.addView((View)this.unvIcon);
        this.mainLayout = new LinearLayout((Context)this);
        this.mainLayout.setLayoutParams(UIStyle.getLayoutParam());
        this.mainLayout.setOrientation(1);
        this.mainLayout.setBackgroundColor(-1);
        this.mainLayout.setPadding(this.dp16, this.dp16, this.dp16, this.dp16);
        this.mainLayout.addView((View)this.appNameMainLayout);
        this.mainLayout.addView((View)this.iconMainLayout);
        this.mainLayout.addView((View)this.demoButtonsMainLayout);
        this.mainLayout.addView((View)this.normalButtonsMainLayout);
        ScrollView scrollView = new ScrollView((Context)this);
        scrollView.setLayoutParams(UIStyle.getLayoutParam());
        scrollView.setBackgroundColor(-1);
        scrollView.addView((View)this.mainLayout);
        this.setContentView((View)scrollView);
    }

    protected void onResume() {
        super.onResume();
    }

    public void onClick(View v) {
        if (v == this.demoModeButton) {
            this.initializeDemoMode();
        } else {
            try {
                LoginParameters.setDemoModeRequired(false);
                LoginParameters.setDemoModeListener(null);
                AuthenticationService.login((Context)this.demoModeSelectionActivity);
                this.finish();
            }
            catch (ApplicationException applicationException) {
                Logger.log(8, ((Object)((Object)this)).getClass().getName(), "onClick", applicationException.getMessage());
            }
            catch (DBException dbException) {
                Logger.log(8, ((Object)((Object)this)).getClass().getName(), "onClick", dbException.getMessage());
            }
        }
    }

    private void initializeDemoMode() {
        LoginParameters.setAppName(appName);
        MessageHelper messageHelper = MessageHelper.getInstance();
        final ProgressDialog progressDialog = ProgressDialog.show((Context)this, (CharSequence)"", (CharSequence)messageHelper.getValue(messageHelper.WAIT_MESSAGE), (boolean)true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AuthenticationService.loginWithDemoData(DemoModeSelectionActivity.this.demoModeSelectionActivity.getApplicationContext(), LoginParameters.getDemoData());
                }
                catch (Exception e) {
                    Logger.e("Exception caught while initializing DemoMode: " + e.getMessage());
                }
                progressDialog.dismiss();
                DemoModeSelectionActivity.this.finish();
            }
        }).start();
    }

    public void onBackPressed() {
        super.onBackPressed();
    }
}

