/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.widget.Button;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.UITheme;

public class ErrorMessageActivity
extends AppCompatActivity {
    private MessageHelper messageHelper = MessageHelper.getInstance();
    private Activity activity;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.activity = this;
        this.getConfirmationDialogReset();
    }

    protected void getConfirmationDialogReset() {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
        alertDialog.setMessage((CharSequence)this.messageHelper.getValue(this.messageHelper.CANNOT_READ_APPLICATION_DATABASE));
        alertDialog.setCancelable(false);
        alertDialog.setCanceledOnTouchOutside(false);
        alertDialog.setButton(-1, (CharSequence)"Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                NotificationListener notificationListener = SyncEngine.getInstance().getNotificationListener();
                FrameworkHelper.resetApplication(true);
                if (notificationListener != null) {
                    notificationListener.notifyApplicationReset();
                }
                ErrorMessageActivity.this.activity.finish();
            }
        });
        alertDialog.show();
        Button buttonPositive = alertDialog.getButton(-1);
        if (buttonPositive != null) {
            buttonPositive.setTextColor(UITheme.getColorPrimary());
        }
    }
}

