/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.CardView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.unvired.model.InfoMessage;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.UIConstants;
import com.unvired.utils.UITheme;

public class InfoMessageDetailsActivity
extends AppCompatActivity {
    private TextView dateLabel;
    private TextView beNameLabel;
    private TextView categoryLabel;
    private TextView messageLabel;
    private TextView date = null;
    private TextView beName = null;
    private TextView category = null;
    private TextView message = null;
    private TextView dateDivider = null;
    private TextView beNameDivider = null;
    private TextView categoryDivider = null;
    private TextView messageDivider = null;
    private LinearLayout mainLayout = null;
    private MessageHelper messageHelper = MessageHelper.getInstance();
    private Toolbar toolbar;
    private ImageView backIcon;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.toolbar = UIStyle.getToolBar((Context)this);
        this.setSupportActionBar(this.toolbar);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InfoMessageDetailsActivity.this.onBackPressed();
            }
        });
        this.setLayout();
    }

    private void setLayout() {
        this.dateLabel = UIStyle.getDetailLabelTextView((Context)this);
        this.beNameLabel = UIStyle.getDetailLabelTextView((Context)this);
        this.categoryLabel = UIStyle.getDetailLabelTextView((Context)this);
        this.messageLabel = UIStyle.getDetailLabelTextView((Context)this);
        this.dateLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.INFO_MESSAGE_DETAILS_ACTIVITY_DATE));
        this.beNameLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.INFO_MESSAGE_DETAILS_ACTIVITY_BE_NAME));
        this.categoryLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.INFO_MESSAGE_DETAILS_ACTIVITY_CATEGORY));
        this.messageLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.INFO_MESSAGE_DETAILS_ACTIVITY_MESSAGE));
        this.date = UIStyle.getDetailContentTextView((Context)this);
        this.beName = UIStyle.getDetailContentTextView((Context)this);
        this.category = UIStyle.getDetailContentTextView((Context)this);
        this.message = UIStyle.getDetailContentTextView((Context)this);
        this.dateDivider = UIStyle.getDivider((Context)this);
        this.beNameDivider = UIStyle.getDivider((Context)this);
        this.categoryDivider = UIStyle.getDivider((Context)this);
        this.messageDivider = UIStyle.getDivider((Context)this);
        InfoMessage infoMessage = (InfoMessage)com.unvired.utils.Context.getInstance().get(UIConstants.SELECTED_INFO_MESSAGE_OBJECT);
        this.setText(infoMessage);
        this.mainLayout = new LinearLayout((Context)this);
        this.mainLayout.setLayoutParams(UIStyle.getLayoutParam());
        this.mainLayout.setBackgroundColor(-1);
        this.mainLayout.setOrientation(1);
        this.mainLayout.setPadding(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp16);
        this.mainLayout.addView((View)this.dateLabel);
        this.mainLayout.addView((View)this.date);
        this.mainLayout.addView((View)this.dateDivider);
        this.mainLayout.addView((View)this.beNameLabel);
        this.mainLayout.addView((View)this.beName);
        this.mainLayout.addView((View)this.beNameDivider);
        this.mainLayout.addView((View)this.categoryLabel);
        this.mainLayout.addView((View)this.category);
        this.mainLayout.addView((View)this.categoryDivider);
        this.mainLayout.addView((View)this.messageLabel);
        this.mainLayout.addView((View)this.message);
        this.mainLayout.addView((View)this.messageDivider);
        CardView cardView = UIStyle.getCardView((Context)this);
        cardView.addView((View)this.mainLayout);
        LinearLayout.LayoutParams cardParam = new LinearLayout.LayoutParams(-1, -2);
        cardParam.setMargins(UIStyle.dp8, UIStyle.dp8, UIStyle.dp8, UIStyle.dp8);
        LinearLayout cardLayout = new LinearLayout((Context)this);
        cardLayout.setOrientation(1);
        cardLayout.addView((View)cardView, (ViewGroup.LayoutParams)cardParam);
        ScrollView scrollView = new ScrollView((Context)this);
        scrollView.setBackgroundColor(UITheme.getBackgroundColor());
        scrollView.addView((View)cardLayout);
        LinearLayout layout2 = new LinearLayout((Context)this);
        layout2.setBackgroundColor(UITheme.getBackgroundColor());
        layout2.setOrientation(1);
        layout2.addView((View)this.toolbar);
        layout2.addView((View)scrollView);
        this.setContentView((View)layout2);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return false;
    }

    public void onBackPressed() {
        this.finish();
        super.onBackPressed();
        com.unvired.utils.Context.getInstance().remove(UIConstants.SELECTED_INFO_MESSAGE_OBJECT);
    }

    public void onResume() {
        com.unvired.utils.Context.getInstance().add(UIConstants.SELECTED_INFO_MESSAGE_OBJECT, (Object)this);
        super.onResume();
    }

    private void setText(InfoMessage infoMessage) {
        long dateValue = infoMessage.getTimeStamp();
        String beNameValue = infoMessage.getBeName();
        String categoryValue = infoMessage.getCategory();
        String messageValue = infoMessage.getMessage();
        this.date.setText((CharSequence)FrameworkHelper.getDateString(dateValue));
        if (beNameValue != null && beNameValue.length() > 0) {
            this.beName.setText((CharSequence)beNameValue);
        } else {
            this.beNameLabel.setVisibility(8);
            this.beName.setVisibility(8);
            this.beNameDivider.setVisibility(8);
        }
        if (categoryValue != null && categoryValue.length() > 0) {
            this.category.setText((CharSequence)categoryValue);
        } else {
            this.categoryLabel.setVisibility(8);
            this.category.setVisibility(8);
            this.categoryDivider.setVisibility(8);
        }
        if (messageValue != null && messageValue.length() > 0) {
            this.message.setText((CharSequence)messageValue);
        } else {
            this.messageLabel.setVisibility(8);
            this.message.setVisibility(8);
            this.messageDivider.setVisibility(8);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }
}

