/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.logger.Logger;
import com.unvired.model.InfoMessage;
import com.unvired.ui.UIStyle;
import com.unvired.ui.adapter.InfoMessageAdapter;
import com.unvired.ui.controller.InfoMessageHelper;
import com.unvired.ui.resources.IconHelper;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.UITheme;
import com.unvired.utils.uiutils.DividerItemDecoration;
import java.io.InputStream;
import java.util.List;

public class InfoMessagesActivity
extends AppCompatActivity {
    private InfoMessage selectedErrorStructure;
    private static List<InfoMessage> errorDataList = null;
    private MessageHelper messageHelper = MessageHelper.getInstance();
    private TextView emptyInfo;
    private static final int DELETE_ALL_MENU_ID = 200;
    private InfoMessage infoMsgToBeDeleted;
    private static List<String> infoMessageEmptyList = null;
    private RecyclerView recyclerView = null;
    private InfoMessageAdapter adapter;
    private Activity activity;
    private ImageView backIcon;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.activity = this;
        Toolbar toolbar = UIStyle.getToolBar((Context)this);
        this.setSupportActionBar(toolbar);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InfoMessagesActivity.this.onBackPressed();
            }
        });
        this.recyclerView = new RecyclerView((Context)this);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        DividerItemDecoration itemDecoration = new DividerItemDecoration((Activity)this, 1);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setBackgroundColor(-1);
        this.emptyInfo = UIStyle.getLabelTextView((Context)this);
        this.emptyInfo.setPadding(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp16);
        this.emptyInfo.setText((CharSequence)"No info messages to be displayed");
        this.emptyInfo.setVisibility(8);
        LinearLayout homeLayout = new LinearLayout((Context)this);
        homeLayout.setOrientation(1);
        homeLayout.addView((View)toolbar);
        homeLayout.addView((View)this.emptyInfo);
        homeLayout.addView((View)this.recyclerView);
        this.setContentView((View)homeLayout);
        errorDataList = InfoMessageHelper.getAllInfoMessages();
        if (errorDataList != null) {
            this.loadErrorList();
        } else {
            this.displayEmptyInfo();
        }
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        menu.clear();
        menu.setHeaderTitle((CharSequence)"Action");
        menu.add(0, 0, 0, (CharSequence)"Delete");
    }

    public boolean onContextItemSelected(MenuItem item) {
        if ("Delete".equals(item.getTitle())) {
            this.onDeleteInfoMessage(this.infoMsgToBeDeleted);
            return true;
        }
        return true;
    }

    public void onDeleteInfoMessage(InfoMessage infoMessage) {
        FrameworkManager frameworkManager = FrameworkManager.getInstance();
        IDataManager dataManager = frameworkManager.getDataManager();
        try {
            if (infoMessage != null) {
                dataManager.delete(infoMessage);
            }
        }
        catch (DBException dbException) {
            Logger.log(8, ((Object)((Object)this)).getClass().getName(), "onDeleteInfoMessage", dbException.getMessage());
        }
        this.loadErrorList();
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        Drawable icDelete = Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_action_delete.png"), (String)"");
        icDelete.setBounds(0, 0, UIStyle.dp24, UIStyle.dp24);
        if (menu != null) {
            menu.clear();
        }
        if (errorDataList != null) {
            MenuItem delete_all_menu = menu.add(0, 200, 0, (CharSequence)"Delete All");
            delete_all_menu.setShowAsActionFlags(2);
            delete_all_menu.setIcon(icDelete);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 200) {
            this.deleteAllErrors();
        } else if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return false;
    }

    public void onBackPressed() {
        this.finish();
        super.onBackPressed();
    }

    private void displayEmptyInfo() {
        this.recyclerView.setAdapter(null);
        this.emptyInfo.setVisibility(0);
    }

    protected void deleteAllErrors() {
        this.confirmationDialogDeleteAll();
    }

    protected void confirmationDialogDeleteAll() {
        Button buttonNegative;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)this.messageHelper.getValue(this.messageHelper.CONFIRMATION_DELETE_ALL_INFO_MESSAGES));
        builder.setPositiveButton((CharSequence)this.messageHelper.getValue(this.messageHelper.OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                InfoMessageHelper.deleteAllInfoMessages();
                InfoMessagesActivity.this.displayEmptyInfo();
            }
        });
        builder.setNegativeButton((CharSequence)this.messageHelper.getValue(this.messageHelper.CANCEL), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
        Button buttonPositive = alertDialog.getButton(-1);
        if (buttonPositive != null) {
            buttonPositive.setTextColor(UITheme.getColorPrimary());
        }
        if ((buttonNegative = alertDialog.getButton(-2)) != null) {
            buttonNegative.setTextColor(UITheme.getDividerColor());
        }
    }

    private void loadErrorList() {
        errorDataList.clear();
        errorDataList = InfoMessageHelper.getAllInfoMessages();
        if (errorDataList != null) {
            this.adapter = new InfoMessageAdapter((Activity)this, errorDataList);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        } else {
            this.displayEmptyInfo();
        }
    }
}

