/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.app.SearchManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.text.SpannableString;
import android.text.style.BackgroundColorSpan;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.ui.R;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.IconHelper;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.UITheme;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Field;

public class LogActivity
extends AppCompatActivity
implements SearchView.OnQueryTextListener {
    private MessageHelper messageHelper = MessageHelper.getInstance();
    protected static float density = 0.0f;
    private Handler handler = new Handler();
    private String userIdValue = null;
    private TextView logSizeTextView;
    private AppCompatEditText logValueTextView;
    private ScrollView scrollView;
    private SearchView searchView;
    private ProgressDialog progressDialog;
    private Toolbar toolbar;
    private boolean searching = false;
    private static final int SEARCH_MENU_ID = 100;
    private static final int DELETE_LOGS_MENU_ID = 101;
    private static final int GOTO_TOP_MENU_ID = 102;
    private static final int GOTO_BOTTOM_MENU_ID = 103;
    private static final int REFRESH_MENU_ID = 104;
    private static final int SEND_LOGS_VIA_EMAIL_MENU_ID = 105;
    private static final int SEND_LOGS_TO_SERVER = 106;
    private static final int SET_LOGGER_LEVEL = 107;
    private static int base = 0;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.toolbar = UIStyle.getToolBar((Context)this);
        this.setSupportActionBar(this.toolbar);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogActivity.this.onBackPressed();
            }
        });
        this.logSizeTextView = UIStyle.getSectionHeaderTextView((Context)this);
        this.logSizeTextView.setLayoutParams(UIStyle.getLayoutParam());
        this.logSizeTextView.setPadding(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp20);
        this.logValueTextView = new AppCompatEditText((Context)this);
        this.logValueTextView.setSupportBackgroundTintList(ColorStateList.valueOf((int)0));
        this.logValueTextView.setInputType(131217);
        this.logValueTextView.setTypeface(Typeface.DEFAULT);
        this.logValueTextView.clearFocus();
        this.logValueTextView.setFocusable(false);
        this.setValues();
        this.scrollView = new ScrollView((Context)this);
        this.scrollView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.scrollView.setPadding(UIStyle.dp16, 0, UIStyle.dp16, UIStyle.dp20);
        this.scrollView.addView((View)this.logValueTextView);
        LinearLayout homeLayout = new LinearLayout((Context)this);
        homeLayout.setLayoutParams(UIStyle.getLayoutParam());
        homeLayout.setOrientation(1);
        homeLayout.setBackgroundColor(-1);
        homeLayout.addView((View)this.toolbar);
        homeLayout.addView((View)this.logSizeTextView);
        homeLayout.addView((View)this.scrollView);
        this.setContentView((View)homeLayout);
    }

    private void setValues() {
        this.progressDialog = new ProgressDialog((Context)this);
        this.progressDialog.setTitle((CharSequence)"Please wait...");
        this.progressDialog.setMessage((CharSequence)"Loading..");
        this.progressDialog.setProgressStyle(0);
        this.progressDialog.setIndeterminate(true);
        this.progressDialog.setCancelable(false);
        this.progressDialog.setCanceledOnTouchOutside(false);
        this.progressDialog.show();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                LogActivity.this.userIdValue = Logger.getLogs();
                LogActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (LogActivity.this.userIdValue != null && LogActivity.this.userIdValue.length() > 0) {
                            int sizeValue = LogActivity.this.userIdValue.getBytes().length;
                            LogActivity.this.logSizeTextView.setText((CharSequence)("Size:" + (float)sizeValue / 1000.0f + " Kb"));
                            LogActivity.this.logValueTextView.setText((CharSequence)LogActivity.this.userIdValue);
                        } else {
                            LogActivity.this.logSizeTextView.setText((CharSequence)"Size:0 Kb");
                            LogActivity.this.logValueTextView.setText((CharSequence)"No logs available");
                        }
                    }
                });
                LogActivity.this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        LogActivity.this.progressDialog.dismiss();
                    }
                }, 2000L);
            }
        });
        t.start();
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        if (this.logSizeTextView != null && "Size:0 Kb".equals(this.logSizeTextView.getText().toString())) {
            return false;
        }
        if (menu != null) {
            menu.clear();
        }
        MenuItem search_item = menu.add(0, 100, 1, (CharSequence)"Search");
        menu.add(0, 101, 2, (CharSequence)"Delete Logs");
        menu.add(0, 102, 3, (CharSequence)"Goto Top");
        menu.add(0, 103, 4, (CharSequence)"Goto Bottom");
        menu.add(0, 104, 5, (CharSequence)"Refresh");
        menu.add(0, 105, 6, (CharSequence)"Send logs via Email");
        menu.add(0, 106, 7, (CharSequence)"Send logs to Server");
        menu.add(0, 107, 8, (CharSequence)"Set Log Level");
        search_item.setActionView((View)new SearchView((Context)this));
        search_item.setShowAsActionFlags(2);
        SearchManager searchManager = (SearchManager)this.getSystemService("search");
        this.searchView = (SearchView)menu.findItem(100).getActionView();
        this.searchView.setSearchableInfo(searchManager.getSearchableInfo(this.getComponentName()));
        this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        ImageView mSearchButton = (ImageView)this.searchView.findViewById(R.id.search_button);
        if (mSearchButton != null) {
            mSearchButton.setColorFilter(UITheme.getTextColor());
        }
        SearchView.SearchAutoComplete mSearchSrcTextView = (SearchView.SearchAutoComplete)this.searchView.findViewById(R.id.search_src_text);
        mSearchSrcTextView.setTextColor(UITheme.getTextColor());
        ImageView mCloseButton = (ImageView)this.searchView.findViewById(R.id.search_close_btn);
        if (mCloseButton != null) {
            mCloseButton.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_clear.png"), (String)""));
            mCloseButton.setColorFilter(UITheme.getTextColor());
        }
        try {
            Field cursorField = TextView.class.getDeclaredField("mCursorDrawableRes");
            cursorField.setAccessible(true);
            cursorField.set(mSearchSrcTextView, R.drawable.abc_text_cursor_material);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 101) {
            Logger.deleteLogs();
            if (this.logSizeTextView != null) {
                this.logSizeTextView.setText((CharSequence)"Size:0 Kb");
            }
            if (this.logValueTextView != null) {
                this.logValueTextView.setText((CharSequence)"");
            }
        } else if (item.getItemId() == 104) {
            this.setValues();
        } else if (item.getItemId() == 102) {
            this.gotoTop();
        } else if (item.getItemId() == 103) {
            this.gotoBottom();
        } else if (item.getItemId() == 105) {
            Logger.sendLogFileViaEmail((Activity)this, "", "", "");
        } else if (item.getItemId() == 106) {
            try {
                Logger.sendLogToServerInSync(null);
                this.displayToast("Sending Logs to server...");
            }
            catch (ApplicationException e) {
                Logger.log(8, ((Object)((Object)this)).getClass().getName(), "sendLogsToServer", "Exception while sending logs to server " + e.getMessage());
            }
        } else if (item.getItemId() == 107) {
            this.setLoggerLevel();
        } else if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return false;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1222) {
            new File(FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/log.txt").delete();
            new File(FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/log.zip").delete();
        }
    }

    public void onBackPressed() {
        if (this.searchView != null && this.searchView.hasFocus()) {
            this.searchView.clearFocus();
            return;
        }
        if (this.searchView != null && this.searching) {
            this.searchView.onActionViewCollapsed();
            this.searching = false;
            return;
        }
        try {
            new File(FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/log.txt").delete();
            new File(FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/log.zip").delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.finish();
        super.onBackPressed();
    }

    private void gotoTop() {
        this.scrollView.fullScroll(33);
    }

    private void gotoBottom() {
        this.scrollView.fullScroll(130);
    }

    public void onResume() {
        super.onResume();
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putString("USER_ID", this.logValueTextView.getText().toString());
        super.onSaveInstanceState(savedInstanceState);
    }

    private void showInfo(boolean error, String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton((CharSequence)this.messageHelper.getValue(this.messageHelper.OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    protected void displayToast(String msg) {
        Context context = this.getApplicationContext();
        Toast toast = Toast.makeText((Context)context, (CharSequence)msg, (int)1);
        toast.show();
    }

    private void setLoggerLevel() {
        Object[] logLevelTypes = new String[]{"Error", "Important", "Debug"};
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"Level");
        ListView listView = new ListView((Context)this);
        ArrayAdapter adapter = new ArrayAdapter((Context)this, R.layout.select_dialog_multichoice_material, logLevelTypes);
        listView.setChoiceMode(1);
        listView.setSelected(true);
        listView.setAdapter((ListAdapter)adapter);
        builder.setView((View)listView);
        final AlertDialog dialog = builder.create();
        dialog.show();
        if (Logger.getDefaultLogLevel() == 8) {
            listView.setItemChecked(0, true);
        } else if (Logger.getDefaultLogLevel() == 7) {
            listView.setItemChecked(1, true);
        } else if (Logger.getDefaultLogLevel() == 9) {
            listView.setItemChecked(2, true);
        }
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                int logLevel = 8;
                switch (position) {
                    case 0: {
                        logLevel = 8;
                        break;
                    }
                    case 1: {
                        logLevel = 7;
                        break;
                    }
                    case 2: {
                        logLevel = 9;
                    }
                }
                Logger.setLogLevel(logLevel);
                try {
                    FrameworkSettingsManager.getInstance().setLogLevel(logLevel);
                }
                catch (DBException e) {
                    e.printStackTrace();
                }
                dialog.dismiss();
            }
        });
    }

    public boolean onQueryTextSubmit(String query) {
        this.searching = true;
        StringReader readText = null;
        BufferedReader readBuffer = null;
        String currentText = this.logValueTextView.getText().toString().substring(base);
        readText = new StringReader(currentText);
        readBuffer = new BufferedReader(readText);
        try {
            String line = readBuffer.readLine();
            boolean found = false;
            while (line != null || !found) {
                if (line.contains(query)) {
                    line = null;
                    found = true;
                }
                if (line == null) continue;
                line = readBuffer.readLine();
            }
            if (found) {
                int selectionStart = currentText.indexOf(query);
                int selectionEnd = currentText.indexOf(query) + query.length();
                String logFile = this.logValueTextView.getText().toString();
                SpannableString wordtoSpan = new SpannableString((CharSequence)logFile);
                wordtoSpan.setSpan((Object)new BackgroundColorSpan(-256), base + selectionStart, base + selectionEnd, 33);
                this.logValueTextView.setText((CharSequence)wordtoSpan, TextView.BufferType.SPANNABLE);
                this.logValueTextView.setSelection((base += selectionEnd) + selectionStart);
                return true;
            }
            this.showInfo(false, "No Matches.");
        }
        catch (IOException e) {
            Logger.log(8, ((Object)((Object)this)).getClass().getName(), "getTextToFind", "Error while searching specified text from file: " + e.getMessage());
        }
        catch (NullPointerException e) {
            this.showInfo(false, "No Matches.");
        }
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        this.searching = true;
        return false;
    }
}

