/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputLayout;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.google.common.base.Strings;
import com.unvired.core.FrameworkVersion;
import com.unvired.core.UserSettingsManager;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationResponse;
import com.unvired.login.AuthenticationService;
import com.unvired.login.IAuthenticationResponse;
import com.unvired.login.LoginListener;
import com.unvired.login.LoginParameters;
import com.unvired.login.MultipleFrontendUsersResponse;
import com.unvired.model.ApplicationVersion;
import com.unvired.model.InitialURL;
import com.unvired.ui.R;
import com.unvired.ui.SSOLoginActivity;
import com.unvired.ui.UIStyle;
import com.unvired.ui.WaitingForTokenActivity;
import com.unvired.ui.adapter.LoginURLAdapter;
import com.unvired.ui.resources.IconHelper;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.UITheme;
import com.unvired.utils.uiutils.ClearableEditText;
import com.unvired.utils.uiutils.PasswordEditText;
import com.unvired.utils.uiutils.ProgressButton;
import java.io.InputStream;
import java.util.Vector;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;

public class LoginActivity
extends AppCompatActivity
implements View.OnClickListener {
    private static final int MENU_ITEM_UNVIRED_ID_LOGIN = 1;
    private static final int MENU_ITEM_ADS_LOGIN = 2;
    private static final int MENU_ITEM_SAP_LOGIN = 3;
    private static final int MENU_ITEM_EMAIL_LOGIN = 6;
    private static final int MENU_ITEM_FORGOT_PASSWORD = 4;
    private static final int MENU_ITEM_CLEAR_DATA = 5;
    private static final int MENU_ITEM_SAML2_LOGIN = 7;
    private String urlInput;
    private String domainInput;
    private ScrollView rootLayout;
    private ImageView appImage;
    private ImageView loginTypeImage = null;
    private TextView loginTypeText = null;
    private TextInputLayout urlLayout;
    private ClearableEditText urlEditText;
    private ImageView urlImageView;
    private TextInputLayout companyLayout;
    private ClearableEditText companyAliasEditText;
    private TextInputLayout usernameLayout;
    private ClearableEditText userIdEditText;
    private TextInputLayout passwordLayout;
    private PasswordEditText passwordEditText;
    private TextInputLayout domainLayout;
    private ClearableEditText domainEditText;
    private ProgressButton loginButton;
    private TextView ssoLogin;
    private TextView changeLoginType;
    private TextView sendLinkToLogin;
    private TextView versionText;
    public static LoginActivity loginActivity;
    private LoginURLAdapter loginURLAdapter;
    private AlertDialog dialog = null;
    private Vector<InitialURL> listOfURLs = null;
    private static Vector<InitialURL> clientURLs;
    private ProgressDialog urlProgressDialog;
    private static boolean isCancelled;
    private AuthenticateAndActivateThread authenticateAndActivateThread = null;
    private Thread thread = null;

    public void onCreate(Bundle savedInstanceState) {
        this.getWindow().setSoftInputMode(3);
        super.onCreate(savedInstanceState);
        loginActivity = this;
        UITheme.applyTheme((Activity)this);
        this.setContentView(R.layout.activity_login);
        this.initViews();
        this.setClickListeners();
        this.setValues();
        this.resetLayout();
    }

    private void initViews() {
        this.rootLayout = (ScrollView)this.findViewById(R.id.rootLayout);
        this.appImage = (ImageView)this.findViewById(R.id.appImage);
        this.loginTypeImage = (ImageView)this.findViewById(R.id.loginTypeImage);
        this.loginTypeText = (TextView)this.findViewById(R.id.loginTypeText);
        this.urlLayout = (TextInputLayout)this.findViewById(R.id.urlLayout);
        this.urlEditText = (ClearableEditText)this.findViewById(R.id.urlEditText);
        this.urlImageView = (ImageView)this.findViewById(R.id.urlImageView);
        this.companyLayout = (TextInputLayout)this.findViewById(R.id.companyLayout);
        this.companyAliasEditText = (ClearableEditText)this.findViewById(R.id.companyEditText);
        this.usernameLayout = (TextInputLayout)this.findViewById(R.id.usernameLayout);
        this.userIdEditText = (ClearableEditText)this.findViewById(R.id.usernameEditText);
        this.passwordLayout = (TextInputLayout)this.findViewById(R.id.passwordLayout);
        this.passwordEditText = (PasswordEditText)this.findViewById(R.id.passwordEditText);
        this.domainLayout = (TextInputLayout)this.findViewById(R.id.domainLayout);
        this.domainEditText = (ClearableEditText)this.findViewById(R.id.domainEditText);
        this.loginButton = (ProgressButton)this.findViewById(R.id.login);
        this.ssoLogin = (TextView)this.findViewById(R.id.ssoLogin);
        this.changeLoginType = (TextView)this.findViewById(R.id.changeLoginType);
        this.sendLinkToLogin = (TextView)this.findViewById(R.id.sendLinkToLogin);
        this.versionText = (TextView)this.findViewById(R.id.versionText);
    }

    private void setClickListeners() {
        this.urlImageView.setOnClickListener((View.OnClickListener)this);
        this.loginButton.setOnClickListener(this);
        this.ssoLogin.setOnClickListener((View.OnClickListener)this);
        this.changeLoginType.setOnClickListener((View.OnClickListener)this);
        this.sendLinkToLogin.setOnClickListener((View.OnClickListener)this);
        this.registerForContextMenu((View)this.changeLoginType);
    }

    private void setValues() {
        String applicationVersionFromApp;
        MessageHelper messageHelper = MessageHelper.getInstance();
        this.urlEditText.setText(LoginParameters.getUrl());
        if (!Strings.isNullOrEmpty((String)LoginParameters.getCompanyAlias())) {
            this.companyLayout.setHint((CharSequence)LoginParameters.getCompanyAlias());
        } else {
            this.companyLayout.setHint((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_COMPANY_ALIAS));
        }
        this.companyAliasEditText.setText(Strings.isNullOrEmpty((String)LoginParameters.getCompanyAlias()) ? LoginParameters.getCompany() : LoginParameters.getCompanyAlias());
        if (LoginParameters.getCurrentLoginType() != null) {
            switch (LoginParameters.getCurrentLoginType()) {
                case UNVIRED_ID: {
                    this.userIdEditText.setText(LoginParameters.getUnviredUserId());
                    this.passwordEditText.setText(LoginParameters.getUnviredPassword());
                    break;
                }
                case ADS: {
                    this.userIdEditText.setText(LoginParameters.getADSUserId());
                    this.passwordEditText.setText(LoginParameters.getADSPassword());
                    this.domainEditText.setText(LoginParameters.getADSDomain());
                    this.domainEditText.setHint(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DOMAIN));
                    break;
                }
                case SAP: {
                    this.userIdEditText.setText(LoginParameters.getADSUserId());
                    this.passwordEditText.setText(LoginParameters.getADSPassword());
                    this.domainEditText.setHint(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_PORT));
                    break;
                }
                case EMAIL: {
                    this.userIdEditText.setText(LoginParameters.getUnviredUserId());
                    this.passwordEditText.setText(LoginParameters.getUnviredPassword());
                }
            }
        } else {
            this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_TITLE));
        }
        InputStream logoIcon = LoginParameters.getLogo();
        if (logoIcon != null) {
            Drawable unviredIcon = Drawable.createFromStream((InputStream)logoIcon, (String)"");
            this.appImage.setImageDrawable(unviredIcon);
        } else {
            this.appImage.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.unvired_logo_white));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.urlImageView.setImageTintList(ColorStateList.valueOf((int)UITheme.getColorPrimary()));
        }
        String applicationVersion = !Strings.isNullOrEmpty((String)(applicationVersionFromApp = ApplicationVersion.getAPPLICATION_VERSION())) ? applicationVersionFromApp : FrameworkVersion.getApplicationVersion();
        this.versionText.setText((CharSequence)("Version: " + applicationVersion));
        if (LoginParameters.getLoginBackgroundImageResource() != null) {
            this.rootLayout.setBackground(Drawable.createFromStream((InputStream)LoginParameters.getLoginBackgroundImageResource(), (String)""));
        } else {
            this.rootLayout.setBackgroundColor(UITheme.getColorPrimary());
        }
        this.loginButton.setBackground(UIStyle.getButtonBG());
        this.loginButton.setTextColor(UITheme.getTextColor());
    }

    private void resetLayout() {
        MessageHelper messageHelper = MessageHelper.getInstance();
        if (LoginParameters.getInitialURLs() == null || LoginParameters.getInitialURLs().size() < 2) {
            this.urlImageView.setVisibility(8);
        } else {
            this.urlImageView.setVisibility(0);
        }
        if (!LoginParameters.isShowCompanyField()) {
            this.companyLayout.setVisibility(8);
        } else {
            this.companyLayout.setVisibility(0);
        }
        if (LoginParameters.passwordLessLoginAllowed()) {
            this.sendLinkToLogin.setVisibility(0);
        } else {
            this.sendLinkToLogin.setVisibility(8);
        }
        if (LoginParameters.getLoginTypes().length > 1) {
            this.changeLoginType.setVisibility(0);
        } else {
            this.changeLoginType.setVisibility(8);
        }
        this.ssoLogin.setVisibility(8);
        this.domainLayout.setVisibility(8);
        switch (LoginParameters.getCurrentLoginType()) {
            case UNVIRED_ID: {
                this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_UNVIRED_ID));
                this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("unvired_icon_64.png"), (String)""));
                break;
            }
            case ADS: {
                this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_ADS));
                this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("ads_login.png"), (String)""));
                this.domainEditText.setHint(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DOMAIN));
                this.domainLayout.setVisibility(0);
                break;
            }
            case SAP: {
                this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_SAP));
                this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("sap_login.png"), (String)""));
                this.domainEditText.setHint(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_PORT));
                this.domainLayout.setVisibility(0);
                break;
            }
            case EMAIL: {
                this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_EMAIL));
                this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("email_login.png"), (String)""));
                break;
            }
            case SAML2: {
                this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_UNVIRED_ID));
                this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("unvired_icon_64.png"), (String)""));
                this.ssoLogin.setVisibility(0);
                this.sendLinkToLogin.setVisibility(8);
                break;
            }
            case O_AUTH: {
                this.ssoLogin.setVisibility(0);
                this.sendLinkToLogin.setVisibility(8);
            }
        }
    }

    public void onClick(View v) {
        String url;
        MessageHelper messageHelper = MessageHelper.getInstance();
        if (v == this.loginButton || v == this.sendLinkToLogin) {
            AuthenticationService.loginActivity = this;
            AuthenticationService.progressButton = this.loginButton;
            if (messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_CANCEL).equals(this.loginButton.getText())) {
                if (this.authenticateAndActivateThread != null) {
                    this.authenticateAndActivateThread.cancel();
                }
                if (this.thread != null && this.thread.isAlive()) {
                    this.thread.interrupt();
                    this.thread = null;
                }
                this.loginButton.setText(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN));
                this.loginButton.removeDrawable();
                this.enableAllFields();
                return;
            }
            url = null;
            String companyAlias = null;
            String userId = this.userIdEditText.getText().toString().toUpperCase();
            String password = this.passwordEditText.getText().toString();
            String domain = this.domainEditText.getText().toString();
            if (!userId.isEmpty()) {
                userId = userId.trim();
            }
            if (!password.isEmpty()) {
                password = password.trim();
            }
            if (!domain.isEmpty()) {
                domain = domain.trim();
            }
            if (LoginParameters.LOGIN_MODE.UNVIRED_ID_AUTH_ACTIVATE == LoginParameters.getLoginMode()) {
                url = this.urlEditText.getText().toString();
                companyAlias = this.companyAliasEditText.getText().toString().toUpperCase();
                if (Strings.isNullOrEmpty((String)companyAlias)) {
                    companyAlias = LoginParameters.getCompany();
                }
                if (!Strings.isNullOrEmpty((String)url)) {
                    url = url.trim();
                }
                if (!Strings.isNullOrEmpty((String)companyAlias)) {
                    companyAlias = companyAlias.trim();
                }
            } else if (LoginParameters.LOGIN_MODE.UNVIRED_ID_FORGOT_PASSWORD_REAUTH == LoginParameters.getLoginMode()) {
                this.handleResetPassword(userId, password);
                return;
            }
            boolean proceed = false;
            if (v == this.sendLinkToLogin) {
                proceed = this.validateForToken(url, userId, domain, companyAlias);
            } else if ("SSO".equals(this.loginButton.getTag())) {
                proceed = this.validateForSSO(url, companyAlias);
                this.loginButton.setTag(null);
            } else {
                proceed = this.validate(url, userId, password, domain, companyAlias);
            }
            if (!proceed) {
                return;
            }
            if (url != null && !url.startsWith("http://") && !url.startsWith("https://")) {
                url = "http://" + url;
            }
            this.handleLogin(url, userId, password, domain, companyAlias);
        } else if (v == this.changeLoginType) {
            v.showContextMenu();
        } else if (v == this.urlImageView) {
            this.loadInitialURLList();
        }
        if (v == this.ssoLogin) {
            url = null;
            String companyAlias = null;
            if (LoginParameters.LOGIN_MODE.UNVIRED_ID_AUTH_ACTIVATE == LoginParameters.getLoginMode()) {
                url = this.urlEditText.getText().toString();
                companyAlias = this.companyAliasEditText.getText().toString().toUpperCase();
                if (Strings.isNullOrEmpty((String)companyAlias)) {
                    companyAlias = LoginParameters.getCompany();
                }
                if (!Strings.isNullOrEmpty((String)url)) {
                    url = url.trim();
                }
                if (!Strings.isNullOrEmpty((String)companyAlias)) {
                    companyAlias = companyAlias.trim();
                }
            }
            if (!this.validateForSSO(url, companyAlias)) {
                return;
            }
            LoginParameters.setUrl(url);
            LoginParameters.setCompany(companyAlias);
            this.startActivityForResult(new Intent((Context)this, SSOLoginActivity.class), 100);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 100 && resultCode == -1) {
            String dataString;
            if (data == null || Strings.isNullOrEmpty((String)(dataString = data.getStringExtra("data")))) {
                this.showInfo(true, "Unable to login. Please try after some time.");
                return;
            }
            if (dataString.contains("&error")) {
                String error = dataString.substring(dataString.indexOf("&error=") + 7);
                this.showInfo(true, error);
                return;
            }
            String token = dataString.substring(dataString.indexOf("&token=") + 7);
            LoginParameters.setJwtToken(token);
            this.loginButton.setTag("SSO");
            this.loginButton.performClick();
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putString("URL", this.urlEditText.getText() == null ? "" : this.urlEditText.getText().toString());
        savedInstanceState.putString("USER_ID", this.userIdEditText.getText() == null ? "" : this.userIdEditText.getText().toString());
        savedInstanceState.putString("PASSWORD", this.passwordEditText.getText() == null ? "" : this.passwordEditText.getText().toString());
        savedInstanceState.putString("DOMAIN", this.domainEditText.getText() == null ? "" : this.domainEditText.getText().toString());
        savedInstanceState.putString("COMPANY_ALIAS", this.companyAliasEditText.getText() == null ? "" : this.companyAliasEditText.getText().toString());
        super.onSaveInstanceState(savedInstanceState);
    }

    public boolean onContextItemSelected(MenuItem item) {
        int selectedItemId = item.getItemId();
        switch (selectedItemId) {
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 2: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.ADS);
                this.resetLayout();
                return true;
            }
            case 1: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.UNVIRED_ID);
                this.resetLayout();
                return true;
            }
            case 3: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.SAP);
                this.resetLayout();
                return true;
            }
            case 6: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.EMAIL);
                this.resetLayout();
                return true;
            }
            case 7: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.SAML2);
                this.resetLayout();
                return true;
            }
        }
        return false;
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        MessageHelper messageHelper = MessageHelper.getInstance();
        menu.setHeaderTitle((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_OPTIONS));
        LoginParameters.LOGIN_MODE loginMode = LoginParameters.getLoginMode();
        switch (loginMode) {
            case UNVIRED_ID_LOCAL_AUTH: {
                menu.add(0, 4, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_FORGOT_PASSWORD));
                menu.add(0, 5, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_CLEAR_DATA));
                return;
            }
            case UNVIRED_ID_FORGOT_PASSWORD_REAUTH: {
                this.changeLoginType.setVisibility(8);
                this.sendLinkToLogin.setVisibility(8);
                return;
            }
        }
        menu.setHeaderTitle((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_OPTIONS_LOGIN_TYPES_TITLE));
        this.setMenuItems(menu);
    }

    private void setMenuItems(ContextMenu menu) {
        LoginParameters.LOGIN_TYPE[] loginTypes = LoginParameters.getLoginTypes();
        if (loginTypes == null || loginTypes.length < 2) {
            return;
        }
        LoginParameters.LOGIN_TYPE currentloginType = LoginParameters.getCurrentLoginType();
        MessageHelper messageHelper = MessageHelper.getInstance();
        block6: for (LoginParameters.LOGIN_TYPE loginType : loginTypes) {
            switch (loginType) {
                case UNVIRED_ID: {
                    MenuItem item = menu.add(0, 1, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_UNVIRED_ID));
                    if (currentloginType != LoginParameters.LOGIN_TYPE.UNVIRED_ID) continue block6;
                    item.setCheckable(true);
                    item.setChecked(true);
                    continue block6;
                }
                case ADS: {
                    MenuItem item = menu.add(0, 2, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_ADS));
                    if (currentloginType != LoginParameters.LOGIN_TYPE.ADS) continue block6;
                    item.setCheckable(true);
                    item.setChecked(true);
                    continue block6;
                }
                case SAP: {
                    MenuItem item = menu.add(0, 3, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_SAP));
                    if (currentloginType != LoginParameters.LOGIN_TYPE.SAP) continue block6;
                    item.setCheckable(true);
                    item.setChecked(true);
                    continue block6;
                }
                case EMAIL: {
                    MenuItem item = menu.add(0, 6, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_EMAIL));
                    if (currentloginType != LoginParameters.LOGIN_TYPE.EMAIL) continue block6;
                    item.setCheckable(true);
                    item.setChecked(true);
                }
            }
        }
    }

    private void handleResetPassword(final String forgotToken, final String newPassword) {
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                final IAuthenticationResponse authenticationResponse = AuthenticationService.resetPassword(forgotToken, newPassword);
                if (authenticationResponse instanceof AuthenticationResponse) {
                    LoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            LoginActivity.this.showInfo(false, ((AuthenticationResponse)authenticationResponse).getMessage());
                        }
                    });
                }
            }
        });
        t1.start();
    }

    private AlertDialog showInfo(boolean error, String message) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
        if (error) {
            alertDialog.setTitle((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DIALOG_TITLE));
        } else {
            alertDialog.setTitle((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DIALOG_TITLE));
        }
        alertDialog.setMessage((CharSequence)message);
        alertDialog.setButton(-1, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DIALOG_BUTTON_OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        alertDialog.show();
        Button button = alertDialog.getButton(-1);
        button.setTextColor(UITheme.getColorPrimary());
        return alertDialog;
    }

    private void disableAllFields() {
        this.companyAliasEditText.setEnabled(false);
        this.urlEditText.setEnabled(false);
        this.userIdEditText.setEnabled(false);
        this.passwordEditText.setEnabled(false);
        this.domainEditText.setEnabled(false);
        this.ssoLogin.setEnabled(false);
        this.ssoLogin.setOnClickListener(null);
        this.changeLoginType.setEnabled(false);
        this.changeLoginType.setOnClickListener(null);
        this.sendLinkToLogin.setEnabled(false);
        this.sendLinkToLogin.setOnClickListener(null);
        this.urlImageView.setEnabled(false);
        this.urlImageView.setOnClickListener(null);
    }

    public void enableAllFields() {
        this.companyAliasEditText.setEnabled(true);
        this.urlEditText.setEnabled(true);
        this.userIdEditText.setEnabled(true);
        this.passwordEditText.setEnabled(true);
        this.domainEditText.setEnabled(true);
        this.ssoLogin.setEnabled(true);
        this.ssoLogin.setOnClickListener((View.OnClickListener)this);
        this.changeLoginType.setEnabled(true);
        this.changeLoginType.setOnClickListener((View.OnClickListener)this);
        this.sendLinkToLogin.setEnabled(true);
        this.sendLinkToLogin.setOnClickListener((View.OnClickListener)this);
        this.urlImageView.setEnabled(true);
        this.urlImageView.setOnClickListener((View.OnClickListener)this);
        this.loginButton.setOnClickListener(this);
        this.loginButton.setBackground(UIStyle.getButtonBG());
    }

    private void handleLogin(String url, String userId, String password, String domain, String companyAlias) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        if (LoginParameters.getLoginMode() == LoginParameters.LOGIN_MODE.UNVIRED_ID_LOCAL_AUTH) {
            try {
                UserSettingsManager settingsManager = UserSettingsManager.getInstance();
                url = settingsManager.getServerUrl();
                domain = settingsManager.getADSDomain();
                companyAlias = settingsManager.getCompanyAlias();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LoginParameters.setUrl(url);
        LoginParameters.setCompany(companyAlias);
        LoginParameters.setUnviredUserId(userId);
        LoginParameters.setUnviredPassword(password);
        LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
        switch (loginType) {
            case UNVIRED_ID: 
            case EMAIL: {
                LoginParameters.setUnviredIdCredentials(userId, password);
                break;
            }
            case ADS: 
            case SAP: {
                LoginParameters.setADSCredentials(userId, password, domain);
            }
        }
        LoginListener loginListener = LoginParameters.getLoginListener();
        switch (LoginParameters.getLoginMode()) {
            case UNVIRED_ID_LOCAL_AUTH: {
                if (password == null || password.isEmpty()) {
                    this.loginButton.startRotate();
                    this.disableAllFields();
                    this.loginButton.setText(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_CANCEL));
                    this.loginButton.setOnAnimFinishListener(new ProgressButton.onAnimFinish(){

                        @Override
                        public void onFinish() {
                            LoginActivity.this.enableAllFields();
                        }
                    });
                    this.authenticateAndActivateThread = new AuthenticateAndActivateThread(this);
                    this.thread = new Thread(this.authenticateAndActivateThread);
                    this.thread.start();
                    break;
                }
                AuthenticationResponse authenticationResponse = AuthenticationService.authenticateLocal(this.getApplicationContext());
                if (IAuthenticationResponse.RESPONSE_STATUS.SUCCESS == authenticationResponse.getResponseStatus()) {
                    if (loginListener != null) {
                        LoginParameters.setUnviredPassword(null);
                        LoginParameters.setADSPassword(null);
                        LoginParameters.setMD5Password(null);
                        AuthenticationService.setLoginSuccessful();
                        loginListener.loginSuccessful();
                    }
                    loginActivity.finish();
                    break;
                }
                final String error = authenticationResponse.getMessage();
                loginActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        LoginActivity.this.showInfo(true, error);
                    }
                });
                if (loginListener == null) break;
                loginListener.loginFailure(error);
                break;
            }
            case UNVIRED_ID_AUTH_ACTIVATE: {
                this.loginButton.startRotate();
                this.disableAllFields();
                this.loginButton.setText(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_CANCEL));
                this.loginButton.setOnAnimFinishListener(new ProgressButton.onAnimFinish(){

                    @Override
                    public void onFinish() {
                        LoginActivity.this.enableAllFields();
                    }
                });
                this.authenticateAndActivateThread = new AuthenticateAndActivateThread(this);
                this.thread = new Thread(this.authenticateAndActivateThread);
                this.thread.start();
                break;
            }
            case UNVIRED_ID_FORGOT_PASSWORD_REAUTH: {
                this.loginButton.startRotate();
                this.disableAllFields();
                this.loginButton.setBackgroundColor(UITheme.getDividerColor());
                this.loginButton.setOnClickListener(null);
                this.loginButton.setOnAnimFinishListener(new ProgressButton.onAnimFinish(){

                    @Override
                    public void onFinish() {
                        LoginActivity.this.loginButton.setBackgroundColor(UITheme.getColorPrimary());
                        LoginActivity.this.enableAllFields();
                    }
                });
                break;
            }
        }
    }

    private boolean validate(String url, String userId, String password, String domain, String companyAlias) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        switch (LoginParameters.getLoginMode()) {
            case UNVIRED_ID_AUTH_ACTIVATE: {
                if (Strings.isNullOrEmpty((String)companyAlias)) {
                    this.companyLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_COMPANY_ALIAS));
                    this.companyAliasEditText.requestFocus();
                    return false;
                }
                this.companyLayout.setErrorEnabled(false);
                if (Strings.isNullOrEmpty((String)url)) {
                    this.urlLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_URL));
                    this.urlEditText.requestFocus();
                    return false;
                }
                this.urlLayout.setErrorEnabled(false);
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
                if (Strings.isNullOrEmpty((String)password)) {
                    this.passwordLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_PASSWORD));
                    this.passwordEditText.requestFocus();
                    return false;
                }
                this.passwordLayout.setErrorEnabled(false);
                if (LoginParameters.getCurrentLoginType() == LoginParameters.LOGIN_TYPE.ADS && Strings.isNullOrEmpty((String)domain)) {
                    this.domainLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_DOMAIN));
                    this.domainEditText.requestFocus();
                    return false;
                }
                this.domainLayout.setErrorEnabled(false);
                if (LoginParameters.getCurrentLoginType() == LoginParameters.LOGIN_TYPE.SAP && Strings.isNullOrEmpty((String)domain)) {
                    this.domainLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_PORT_NAME));
                    this.domainEditText.requestFocus();
                    return false;
                }
                this.domainLayout.setErrorEnabled(false);
                break;
            }
            case UNVIRED_ID_LOCAL_AUTH: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
                if (Strings.isNullOrEmpty((String)password)) {
                    this.passwordLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_PASSWORD));
                    this.passwordEditText.requestFocus();
                    return false;
                }
                this.passwordLayout.setErrorEnabled(false);
                break;
            }
            case UNVIRED_ID_FORGOT_PASSWORD_REAUTH: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
            }
        }
        return true;
    }

    private boolean validateForToken(String url, String userId, String domain, String companyAlias) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        switch (LoginParameters.getLoginMode()) {
            case UNVIRED_ID_AUTH_ACTIVATE: {
                if (Strings.isNullOrEmpty((String)companyAlias)) {
                    this.companyLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_COMPANY_ALIAS));
                    this.companyAliasEditText.requestFocus();
                    return false;
                }
                this.companyLayout.setErrorEnabled(false);
                if (Strings.isNullOrEmpty((String)url)) {
                    this.urlLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_URL));
                    this.urlEditText.requestFocus();
                    return false;
                }
                this.urlLayout.setErrorEnabled(false);
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
                if (LoginParameters.getCurrentLoginType() == LoginParameters.LOGIN_TYPE.ADS && Strings.isNullOrEmpty((String)domain)) {
                    this.domainLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_DOMAIN));
                    this.domainEditText.requestFocus();
                    return false;
                }
                this.domainLayout.setErrorEnabled(false);
                if (LoginParameters.getCurrentLoginType() == LoginParameters.LOGIN_TYPE.SAP && Strings.isNullOrEmpty((String)domain)) {
                    this.domainLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_PORT_NAME));
                    this.domainEditText.requestFocus();
                    return false;
                }
                this.domainLayout.setErrorEnabled(false);
                break;
            }
            case UNVIRED_ID_LOCAL_AUTH: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
                break;
            }
            case UNVIRED_ID_FORGOT_PASSWORD_REAUTH: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
            }
        }
        return true;
    }

    private boolean validateForSSO(String url, String companyAlias) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        switch (LoginParameters.getLoginMode()) {
            case UNVIRED_ID_AUTH_ACTIVATE: {
                if (Strings.isNullOrEmpty((String)url)) {
                    this.urlLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_URL));
                    this.urlEditText.requestFocus();
                    return false;
                }
                this.urlLayout.setErrorEnabled(false);
                if (Strings.isNullOrEmpty((String)companyAlias)) {
                    this.companyLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_COMPANY_ALIAS));
                    this.companyAliasEditText.requestFocus();
                    return false;
                }
                this.companyLayout.setErrorEnabled(false);
            }
        }
        return true;
    }

    private void startServiceAndGetURL(Vector<InitialURL> listOfURLsFromClient) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        if (this.urlProgressDialog != null) {
            this.urlProgressDialog.dismiss();
            this.urlProgressDialog = null;
        }
        this.urlProgressDialog = new ProgressDialog((Context)this);
        this.urlProgressDialog.setTitle((CharSequence)messageHelper.getValue(messageHelper.WAIT_MESSAGE));
        this.urlProgressDialog.setMessage((CharSequence)messageHelper.getValue(messageHelper.SEARCHING_UMP_SERVERS));
        this.urlProgressDialog.setCancelable(false);
        this.urlProgressDialog.setCanceledOnTouchOutside(false);
        this.urlProgressDialog.setButton(-2, (CharSequence)messageHelper.getValue(messageHelper.CANCEL), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                try {
                    LoginActivity.this.urlProgressDialog.dismiss();
                    isCancelled = true;
                    LoginActivity.this.loadInitialURLList();
                }
                catch (Exception e) {
                    Logger.log(8, this.getClass().getName(), "startServiceAndGetURL", e.getMessage());
                }
            }
        });
        this.urlProgressDialog.show();
        Thread t = new Thread(new FetchUMPURLs(listOfURLsFromClient));
        t.start();
    }

    private void loadURLList() {
        final MessageHelper messageHelper = MessageHelper.getInstance();
        if (this.listOfURLs.isEmpty() && clientURLs.isEmpty()) {
            this.displayToast(messageHelper.getValue(messageHelper.NO_UMP_SERVERS_FOUND));
            return;
        }
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
        if (this.urlProgressDialog != null) {
            this.urlProgressDialog.dismiss();
            this.urlProgressDialog = null;
        }
        final ProgressDialog progressDialog = new ProgressDialog((Context)this);
        progressDialog.setMessage((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_WAIT));
        progressDialog.setCancelable(false);
        progressDialog.setCanceledOnTouchOutside(false);
        progressDialog.show();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    final ListView listView = new ListView((Context)LoginActivity.this);
                    listView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-2, -2));
                    listView.setPadding(UIStyle.dp24, UIStyle.dp8, UIStyle.dp24, 0);
                    listView.setChoiceMode(1);
                    listView.setHorizontalFadingEdgeEnabled(true);
                    listView.setFadingEdgeLength(30);
                    listView.isFocusable();
                    listView.setSelected(true);
                    listView.requestFocus();
                    if (LoginActivity.this.listOfURLs == null || LoginActivity.this.listOfURLs.isEmpty()) {
                        LoginActivity.this.loginURLAdapter = new LoginURLAdapter((Context)loginActivity, clientURLs);
                    } else {
                        LoginActivity.this.loginURLAdapter = new LoginURLAdapter((Context)loginActivity, LoginActivity.this.listOfURLs);
                    }
                    listView.setAdapter((ListAdapter)LoginActivity.this.loginURLAdapter);
                    LoginActivity.this.loginURLAdapter.notifyDataSetChanged();
                    listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                            InitialURL url = (InitialURL)listView.getItemAtPosition(position);
                            String selectedURL = url.getAddress();
                            LoginActivity.this.urlEditText.setText(selectedURL);
                            com.unvired.utils.Context.getInstance().remove("SELECTED_URL");
                            com.unvired.utils.Context.getInstance().add("SELECTED_URL", LoginActivity.this.urlEditText.getText().toString());
                            LoginActivity.this.dialog.dismiss();
                        }
                    });
                    progressDialog.dismiss();
                    LoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            Button buttonNegative;
                            AlertDialog.Builder builder = new AlertDialog.Builder((Context)LoginActivity.this);
                            builder.setTitle((CharSequence)messageHelper.getValue(messageHelper.PICK_URL));
                            builder.setView((View)listView);
                            builder.setNegativeButton((CharSequence)messageHelper.getValue(messageHelper.CANCEL), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    dialog.dismiss();
                                }
                            });
                            LoginActivity.this.dialog = builder.create();
                            LoginActivity.this.dialog.show();
                            Button buttonPositive = LoginActivity.this.dialog.getButton(-1);
                            if (buttonPositive != null) {
                                buttonPositive.setTextColor(UITheme.getColorPrimary());
                            }
                            if ((buttonNegative = LoginActivity.this.dialog.getButton(-2)) != null) {
                                buttonNegative.setTextColor(UITheme.getDividerColor());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Logger.log(8, this.getClass().getName(), "startServiceAndGetURL", e.getMessage());
                }
            }
        });
        t.start();
    }

    private void loadInitialURLList() {
        final MessageHelper messageHelper = MessageHelper.getInstance();
        final ProgressDialog progressDialog = new ProgressDialog((Context)this);
        progressDialog.setMessage((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_WAIT));
        progressDialog.setCancelable(false);
        progressDialog.setCanceledOnTouchOutside(false);
        progressDialog.show();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LoginActivity.this.listOfURLs = LoginParameters.getInitialURLs();
                    final ListView listView = LoginActivity.this.getUrlListView(LoginActivity.this.listOfURLs);
                    progressDialog.dismiss();
                    LoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            Button buttonNegative;
                            AlertDialog.Builder builder = new AlertDialog.Builder((Context)LoginActivity.this);
                            builder.setTitle((CharSequence)messageHelper.getValue(messageHelper.PICK_URL));
                            if (LoginActivity.this.listOfURLs.size() != 0) {
                                builder.setView((View)listView);
                            } else {
                                builder.setMessage((CharSequence)messageHelper.getValue(messageHelper.NO_URLS_LISTED));
                            }
                            builder.setPositiveButton((CharSequence)messageHelper.getValue(messageHelper.SEARCH), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    isCancelled = false;
                                    Vector<InitialURL> listOfURLsFromClient = LoginParameters.getInitialURLs();
                                    LoginActivity.this.startServiceAndGetURL(listOfURLsFromClient);
                                }
                            });
                            builder.setNegativeButton((CharSequence)messageHelper.getValue(messageHelper.CANCEL), new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    dialog.dismiss();
                                }
                            });
                            progressDialog.dismiss();
                            LoginActivity.this.dialog = builder.create();
                            LoginActivity.this.dialog.show();
                            Button buttonPositive = LoginActivity.this.dialog.getButton(-1);
                            if (buttonPositive != null) {
                                buttonPositive.setTextColor(UITheme.getColorPrimary());
                            }
                            if ((buttonNegative = LoginActivity.this.dialog.getButton(-2)) != null) {
                                buttonNegative.setTextColor(UITheme.getDividerColor());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Logger.log(8, this.getClass().getName(), "startServiceAndGetURL", e.getMessage());
                }
            }
        });
        t.start();
    }

    private ListView getUrlListView(Vector<InitialURL> listOfURLs) {
        if (listOfURLs.size() != 0) {
            final ListView listView = new ListView((Context)this);
            listView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-2, -2));
            listView.setPadding(UIStyle.dp24, UIStyle.dp8, UIStyle.dp24, 0);
            listView.setChoiceMode(1);
            listView.setHorizontalFadingEdgeEnabled(true);
            listView.setFadingEdgeLength(30);
            listView.isFocusable();
            listView.setSelected(true);
            listView.requestFocus();
            this.loginURLAdapter = new LoginURLAdapter((Context)this, listOfURLs);
            listView.setAdapter((ListAdapter)this.loginURLAdapter);
            this.loginURLAdapter.notifyDataSetChanged();
            listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    InitialURL url = (InitialURL)listView.getItemAtPosition(position);
                    String selectedURL = url.getAddress();
                    LoginActivity.this.urlEditText.setText(selectedURL);
                    com.unvired.utils.Context.getInstance().remove("SELECTED_URL");
                    com.unvired.utils.Context.getInstance().add("SELECTED_URL", LoginActivity.this.urlEditText.getText().toString());
                    LoginActivity.this.dialog.dismiss();
                }
            });
            return listView;
        }
        return null;
    }

    protected void displayToast(final String msg) {
        loginActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)loginActivity, (CharSequence)msg, (int)1).show();
            }
        });
    }

    static {
        clientURLs = null;
        isCancelled = false;
    }

    private class FetchUMPURLs
    implements Runnable {
        private Vector<InitialURL> listOfURLsFromClient;

        public FetchUMPURLs(Vector<InitialURL> listOfURLsFromClient) {
            this.listOfURLsFromClient = listOfURLsFromClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Vector<InitialURL> umpServers = new Vector<InitialURL>();
            LoginActivity.this.listOfURLs = new Vector();
            try {
                JmDNS mdnsService = JmDNS.create();
                ServiceInfo[] serviceInfos = mdnsService.list("_ump._tcp.local.");
                if (serviceInfos != null && serviceInfos.length > 0) {
                    for (ServiceInfo serviceInfo : serviceInfos) {
                        String name = serviceInfo.getName();
                        String url = serviceInfo.getURL();
                        if (Strings.isNullOrEmpty((String)url) || Strings.isNullOrEmpty((String)name)) continue;
                        url = url + "/UMP";
                        umpServers.addElement(new InitialURL(url, name, false));
                    }
                }
                if (this.listOfURLsFromClient != null && this.listOfURLsFromClient.size() > 0) {
                    for (InitialURL initialURL : this.listOfURLsFromClient) {
                        umpServers.addElement(initialURL);
                    }
                }
                if (!isCancelled) {
                    LoginActivity.this.listOfURLs.addAll(umpServers);
                }
                mdnsService.unregisterAllServices();
                mdnsService.close();
                LoginActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!isCancelled) {
                            LoginActivity.this.loadURLList();
                        }
                    }
                });
            }
            catch (Exception e) {
                Logger.log(8, this.getClass().getName(), "startServiceAndGetURL", e.getMessage());
                if (this.listOfURLsFromClient != null && this.listOfURLsFromClient.size() > 0) {
                    for (InitialURL initialURL : this.listOfURLsFromClient) {
                        umpServers.addElement(initialURL);
                    }
                }
                if (!isCancelled) {
                    LoginActivity.this.listOfURLs.addAll(umpServers);
                    LoginActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            LoginActivity.this.loadURLList();
                        }
                    });
                }
            }
            finally {
                if (LoginActivity.this.urlProgressDialog != null) {
                    LoginActivity.this.urlProgressDialog.dismiss();
                    LoginActivity.this.urlProgressDialog = null;
                }
            }
        }
    }

    private class AuthenticateAndActivateThread
    implements Runnable {
        private boolean cancelled = false;
        private LoginActivity loginActivity;
        MessageHelper messageHelper = MessageHelper.getInstance();
        private String customDeviceId = null;
        private String errorMessage = null;
        private Thread t;

        public AuthenticateAndActivateThread(LoginActivity loginActivity2) {
            this.loginActivity = loginActivity2;
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            IAuthenticationResponse authenticationResponse = AuthenticationService.authenticateAndActivate(this.loginActivity.getApplicationContext());
            if (authenticationResponse instanceof AuthenticationResponse) {
                if (!this.cancelled) {
                    this.handleAuthenticationResponse((AuthenticationResponse)authenticationResponse);
                }
            } else {
                String[] frontendIdStrings = null;
                MultipleFrontendUsersResponse multipleFrontendUsersResponse = (MultipleFrontendUsersResponse)authenticationResponse;
                Vector<String> frontendIds = multipleFrontendUsersResponse.getFrontendIds();
                int size = frontendIds.size();
                frontendIdStrings = new String[size];
                for (int i = 0; i < size; ++i) {
                    frontendIdStrings[i] = frontendIds.elementAt(i);
                }
                String[] finalFrontendIdStrings = frontendIdStrings;
                String customDeviceId = this.getUserPickedId(finalFrontendIdStrings);
                if (customDeviceId == null || customDeviceId.length() == 0) {
                    Logger.log(8, "", "", this.messageHelper.getValue(this.messageHelper.CUSTOM_ID_NOT_PICKED));
                    return;
                }
                LoginParameters.setDeviceId(customDeviceId);
                AuthenticationResponse authenticationResponseAfterSendingFEId = (AuthenticationResponse)AuthenticationService.authenticateAndActivate(this.loginActivity.getApplicationContext());
                if (!this.cancelled) {
                    this.handleAuthenticationResponse(authenticationResponseAfterSendingFEId);
                }
            }
        }

        private void handleAuthenticationResponse(AuthenticationResponse authenticationResponse) {
            final LoginListener loginListener = LoginParameters.getLoginListener();
            block0 : switch (LoginParameters.getLoginMode()) {
                case UNVIRED_ID_AUTH_ACTIVATE: {
                    switch (authenticationResponse.getResponseStatus()) {
                        case SUCCESS: {
                            if ("MESSAGE_SUBTYPE_GET_LOGIN_TOKEN".equals(authenticationResponse.getMessage())) {
                                LoginActivity.this.startActivity(new Intent((Context)this.loginActivity, WaitingForTokenActivity.class));
                                this.loginActivity.finish();
                                break block0;
                            }
                            this.loginActivity.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (loginListener != null) {
                                        AuthenticationService.setLoginSuccessful();
                                        if (!LoginParameters.getLoginScreenType().equals((Object)LoginParameters.LOGIN_SCREEN_TYPE.CUSTOM)) {
                                            AuthenticateAndActivateThread.this.loginActivity.finish();
                                        }
                                        LoginParameters.setUnviredPassword(null);
                                        LoginParameters.setADSPassword(null);
                                        LoginParameters.setMD5Password(null);
                                        loginListener.authenticateAndActivationSuccessful();
                                    }
                                }
                            });
                            break block0;
                        }
                    }
                    this.errorMessage = authenticationResponse.getMessage();
                    if (this.errorMessage == null || this.errorMessage.length() == 0) {
                        this.errorMessage = this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_CANNOT_AUTHENTICATE) + this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_CONTACT_ADMINISTRATOR) + this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_NO_VALID_ERROR);
                    }
                    this.loginActivity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            LoginActivity.this.loginButton.setText(AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.LOGIN_ACTIVITY_LOGIN));
                            LoginActivity.this.loginButton.removeDrawable();
                            LoginActivity.this.loginButton.stop();
                            LoginActivity.this.loginButton.setBackgroundColor(UITheme.getColorPrimary());
                            LoginActivity.this.loginButton.setEnabled(true);
                            AuthenticateAndActivateThread.this.showInfo(true, AuthenticateAndActivateThread.this.errorMessage);
                        }
                    });
                    if (loginListener == null) break;
                    loginListener.authenticateAndActivationFailure(this.errorMessage);
                    break;
                }
                case UNVIRED_ID_LOCAL_AUTH: {
                    if (IAuthenticationResponse.RESPONSE_STATUS.SUCCESS == authenticationResponse.getResponseStatus()) {
                        LoginActivity.this.startActivity(new Intent((Context)this.loginActivity, WaitingForTokenActivity.class));
                        this.loginActivity.finish();
                        break;
                    }
                    final String error = authenticationResponse.getMessage();
                    this.loginActivity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            LoginActivity.this.loginButton.setText(AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.LOGIN_ACTIVITY_LOGIN));
                            LoginActivity.this.loginButton.removeDrawable();
                            LoginActivity.this.loginButton.stop();
                            LoginActivity.this.loginButton.setBackgroundColor(UITheme.getColorPrimary());
                            LoginActivity.this.loginButton.setEnabled(true);
                            AuthenticateAndActivateThread.this.showInfo(true, error);
                        }
                    });
                    if (loginListener == null) break;
                    loginListener.loginFailure(error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getUserPickedId(final String[] frontendIdStrings) {
            final Thread dialogThread = Thread.currentThread();
            LoginActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)AuthenticateAndActivateThread.this.loginActivity);
                    builder.setTitle((CharSequence)AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.PICK_DEVICE));
                    LinearLayout layout2 = new LinearLayout((Context)AuthenticateAndActivateThread.this.loginActivity);
                    layout2.setOrientation(1);
                    ListView lv = new ListView((Context)AuthenticateAndActivateThread.this.loginActivity);
                    TextView label = new TextView((Context)AuthenticateAndActivateThread.this.loginActivity);
                    label.setText((CharSequence)AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.MULTIPLE_IDS_HAVE_BEEEN_MAPPED));
                    label.setPadding(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp16);
                    ArrayAdapter adapter = new ArrayAdapter((Context)AuthenticateAndActivateThread.this.loginActivity, 0x1090009, (Object[])frontendIdStrings);
                    lv.setAdapter((ListAdapter)adapter);
                    layout2.addView((View)label);
                    builder.setView((View)layout2);
                    builder.setItems((CharSequence[])frontendIdStrings, new DialogInterface.OnClickListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onClick(DialogInterface dialog, int which) {
                            String id2 = frontendIdStrings[which];
                            int indexOfSeparator = id2.indexOf(":");
                            AuthenticateAndActivateThread.this.customDeviceId = id2.substring(indexOfSeparator + 2);
                            Thread thread = dialogThread;
                            synchronized (thread) {
                                dialogThread.notify();
                            }
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setCancelable(false);
                    dialog.setCanceledOnTouchOutside(false);
                    dialog.show();
                }
            });
            Thread thread = dialogThread;
            synchronized (thread) {
                try {
                    dialogThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.customDeviceId;
        }

        private AlertDialog showInfo(boolean error, String message) {
            AlertDialog alertDialog = new AlertDialog.Builder((Context)this.loginActivity).create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.setCancelable(false);
            if (error) {
                alertDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_ALERT_TITLE));
            } else {
                alertDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_TITLE));
            }
            alertDialog.setMessage((CharSequence)message);
            alertDialog.setButton(-1, (CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_BUTTON_OK), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            alertDialog.show();
            Button button = alertDialog.getButton(-1);
            if (button != null) {
                button.setTextColor(UITheme.getColorPrimary());
            }
            return alertDialog;
        }
    }
}

