/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TextInputLayout;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.google.common.base.Strings;
import com.unvired.core.FrameworkVersion;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationResponse;
import com.unvired.login.AuthenticationService;
import com.unvired.login.IAuthenticationResponse;
import com.unvired.login.LoginListener;
import com.unvired.login.LoginParameters;
import com.unvired.login.MultipleFrontendUsersResponse;
import com.unvired.model.ApplicationVersion;
import com.unvired.model.OutObject;
import com.unvired.sync.out.Outbox;
import com.unvired.ui.R;
import com.unvired.ui.UIStyle;
import com.unvired.ui.WaitingForTokenActivity;
import com.unvired.ui.resources.IconHelper;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.TokenHelper;
import com.unvired.utils.UITheme;
import com.unvired.utils.uiutils.ClearableEditText;
import com.unvired.utils.uiutils.PasswordEditText;
import com.unvired.utils.uiutils.ProgressButton;
import java.io.InputStream;
import java.util.Vector;

public class LoginLocalActivity
extends AppCompatActivity
implements View.OnClickListener {
    private static final int MENU_ITEM_UNVIRED_ID_LOGIN = 1;
    private static final int MENU_ITEM_ADS_LOGIN = 2;
    private static final int MENU_ITEM_SAP_LOGIN = 3;
    private static final int MENU_ITEM_EMAIL_LOGIN = 6;
    private static final int MENU_ITEM_FORGOT_PASSWORD = 4;
    private static final int MENU_ITEM_CLEAR_DATA = 5;
    private static final int MENU_ITEM_SAML2_LOGIN = 7;
    private ScrollView rootLayout;
    private ImageView appImage;
    private ImageView loginTypeImage = null;
    private TextView loginTypeText = null;
    private TextInputLayout usernameLayout;
    private ClearableEditText userIdEditText;
    private TextInputLayout passwordLayout;
    private PasswordEditText passwordEditText;
    private ProgressButton loginButton;
    private TextView options;
    private TextView sendLinkToLogin;
    private TextView versionText;
    private ProgressDialog progressDialog;
    private AuthenticateAndActivateThread authenticateAndActivateThread = null;
    private Thread thread = null;

    public void onCreate(Bundle savedInstanceState) {
        this.getWindow().setSoftInputMode(3);
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.setContentView(R.layout.activity_login_local);
        this.initViews();
        this.setClickListeners();
        this.setValues();
        this.resetLayout();
    }

    private void initViews() {
        this.rootLayout = (ScrollView)this.findViewById(R.id.rootLayout);
        this.appImage = (ImageView)this.findViewById(R.id.appImage);
        this.loginTypeImage = (ImageView)this.findViewById(R.id.loginTypeImage);
        this.loginTypeText = (TextView)this.findViewById(R.id.loginTypeText);
        this.usernameLayout = (TextInputLayout)this.findViewById(R.id.usernameLayout);
        this.userIdEditText = (ClearableEditText)this.findViewById(R.id.usernameEditText);
        this.passwordLayout = (TextInputLayout)this.findViewById(R.id.passwordLayout);
        this.passwordEditText = (PasswordEditText)this.findViewById(R.id.passwordEditText);
        this.loginButton = (ProgressButton)this.findViewById(R.id.login);
        this.options = (TextView)this.findViewById(R.id.options);
        this.sendLinkToLogin = (TextView)this.findViewById(R.id.sendLinkToLogin);
        this.versionText = (TextView)this.findViewById(R.id.versionText);
    }

    private void setClickListeners() {
        this.loginButton.setOnClickListener(this);
        this.options.setOnClickListener((View.OnClickListener)this);
        this.sendLinkToLogin.setOnClickListener((View.OnClickListener)this);
        this.registerForContextMenu((View)this.options);
    }

    private void setValues() {
        MessageHelper messageHelper = MessageHelper.getInstance();
        if (LoginParameters.getCurrentLoginType() != null) {
            switch (LoginParameters.getCurrentLoginType()) {
                case UNVIRED_ID: {
                    this.userIdEditText.setText(LoginParameters.getUnviredUserId());
                    break;
                }
                case ADS: {
                    this.userIdEditText.setText(LoginParameters.getADSUserId());
                    break;
                }
                case SAP: {
                    this.userIdEditText.setText(LoginParameters.getADSUserId());
                    break;
                }
                case EMAIL: {
                    this.userIdEditText.setText(LoginParameters.getUnviredUserId());
                }
            }
        } else {
            this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_TITLE));
        }
        InputStream logoIcon = LoginParameters.getLogo();
        if (logoIcon != null) {
            Drawable unviredIcon = Drawable.createFromStream((InputStream)logoIcon, (String)"");
            this.appImage.setImageDrawable(unviredIcon);
        } else {
            this.appImage.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.unvired_logo_white));
        }
        String applicationVersionFromApp = ApplicationVersion.getAPPLICATION_VERSION();
        String applicationVersion = !Strings.isNullOrEmpty((String)applicationVersionFromApp) ? applicationVersionFromApp : FrameworkVersion.getApplicationVersion();
        this.versionText.setText((CharSequence)("Version: " + applicationVersion));
        if (LoginParameters.getLoginBackgroundImageResource() != null) {
            this.rootLayout.setBackground(Drawable.createFromStream((InputStream)LoginParameters.getLoginBackgroundImageResource(), (String)""));
        } else {
            this.rootLayout.setBackgroundColor(UITheme.getColorPrimary());
        }
        this.loginButton.setBackground(UIStyle.getButtonBG());
        this.loginButton.setTextColor(UITheme.getTextColor());
    }

    private void resetLayout() {
        MessageHelper messageHelper = MessageHelper.getInstance();
        try {
            UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
            String userId = userSettingsManager.getLocalUserId();
            if (userId != null) {
                this.userIdEditText.setText(userId);
                this.userIdEditText.setInputType(0);
                this.userIdEditText.clearFocus();
                this.userIdEditText.setFocusable(false);
                this.userIdEditText.setFocusableInTouchMode(false);
            }
            switch (LoginParameters.getCurrentLoginType()) {
                case UNVIRED_ID: {
                    this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_UNVIRED_ID));
                    this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("unvired_icon_64.png"), (String)""));
                    if (userSettingsManager.getUnviredPassword() != null && !userSettingsManager.getUnviredPassword().isEmpty() || userSettingsManager.getMD5Password() != null && !userSettingsManager.getMD5Password().isEmpty()) break;
                    this.passwordLayout.setVisibility(8);
                    break;
                }
                case ADS: {
                    this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_ADS));
                    this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("ads_login.png"), (String)""));
                    if (userSettingsManager.getADSPassword() != null && !userSettingsManager.getADSPassword().isEmpty()) break;
                    this.passwordLayout.setVisibility(8);
                    break;
                }
                case SAP: {
                    this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_SAP));
                    this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("sap_login.png"), (String)""));
                    if (userSettingsManager.getADSPassword() != null && !userSettingsManager.getADSPassword().isEmpty()) break;
                    this.passwordLayout.setVisibility(8);
                    break;
                }
                case EMAIL: {
                    this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_EMAIL));
                    this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("email_login.png"), (String)""));
                    if (userSettingsManager.getUnviredPassword() != null && !userSettingsManager.getUnviredPassword().isEmpty() || userSettingsManager.getMD5Password() != null && !userSettingsManager.getMD5Password().isEmpty()) break;
                    this.passwordLayout.setVisibility(8);
                    break;
                }
                case SAML2: {
                    this.loginTypeText.setText((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_UNVIRED_ID));
                    this.loginTypeImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("unvired_icon_64.png"), (String)""));
                    break;
                }
            }
            switch (LoginParameters.getLoginMode()) {
                case UNVIRED_ID_LOCAL_AUTH: {
                    this.usernameLayout.setHint((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_USER_ID));
                    this.passwordLayout.setHint((CharSequence)messageHelper.getValue(messageHelper.PASSWORD));
                    this.options.setVisibility(0);
                    if (LoginParameters.passwordLessLoginAllowed()) break;
                    this.sendLinkToLogin.setVisibility(8);
                    break;
                }
                case UNVIRED_ID_FORGOT_PASSWORD_REAUTH: {
                    this.enableAllFields();
                    this.usernameLayout.setHint((CharSequence)"Token");
                    this.userIdEditText.setText("");
                    this.userIdEditText.requestFocus();
                    this.userIdEditText.setEnabled(true);
                    this.userIdEditText.setFocusable(true);
                    this.userIdEditText.setFocusableInTouchMode(true);
                    this.passwordEditText.setText("");
                    this.passwordEditText.setHint("");
                    this.passwordLayout.setHint((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_NEW_PASSWORD));
                    this.options.setVisibility(8);
                    this.sendLinkToLogin.setVisibility(8);
                }
            }
        }
        catch (DBException e) {
            Logger.log(9, ((Object)((Object)this)).getClass().getName(), "setLocalLoginScreen", e.getMessage());
        }
    }

    public void onClick(View v) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        if (v == this.loginButton || v == this.sendLinkToLogin) {
            AuthenticationService.loginActivity = this;
            AuthenticationService.progressButton = this.loginButton;
            if (messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_CANCEL).equals(this.loginButton.getText())) {
                if (this.authenticateAndActivateThread != null) {
                    this.authenticateAndActivateThread.cancel();
                }
                if (this.thread != null && this.thread.isAlive()) {
                    this.thread.interrupt();
                    this.thread = null;
                }
                this.loginButton.setText(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN));
                this.loginButton.removeDrawable();
                this.enableAllFields();
                return;
            }
            String userId = this.userIdEditText.getText().toString().toUpperCase();
            String password = this.passwordEditText.getText().toString();
            if (!userId.isEmpty()) {
                userId = userId.trim();
            }
            if (!password.isEmpty()) {
                password = password.trim();
            }
            if (LoginParameters.LOGIN_MODE.UNVIRED_ID_FORGOT_PASSWORD_REAUTH == LoginParameters.getLoginMode()) {
                this.handleResetPassword(userId, password);
                return;
            }
            boolean proceed = false;
            if (v == this.sendLinkToLogin) {
                proceed = this.validateForToken(LoginParameters.getUrl(), userId, LoginParameters.getADSDomain(), LoginParameters.getCompany());
            } else if ("SSO".equals(this.loginButton.getTag())) {
                proceed = true;
                this.loginButton.setTag(null);
            } else {
                proceed = this.validate(LoginParameters.getUrl(), userId, password, LoginParameters.getADSDomain(), LoginParameters.getCompany());
            }
            if (!proceed) {
                return;
            }
            this.handleLogin(LoginParameters.getUrl(), userId, password, LoginParameters.getADSDomain(), LoginParameters.getCompany());
        } else if (v == this.options) {
            v.showContextMenu();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 100 && resultCode == -1) {
            if (Strings.isNullOrEmpty((String)TokenHelper.getToken())) {
                this.showInfo(true, "Unable to login");
            } else {
                LoginParameters.setJwtToken(TokenHelper.getToken());
                this.loginButton.setTag("SSO");
                this.loginButton.performClick();
            }
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putString("USER_ID", this.userIdEditText.getText() == null ? "" : this.userIdEditText.getText().toString());
        savedInstanceState.putString("PASSWORD", this.passwordEditText.getText() == null ? "" : this.passwordEditText.getText().toString());
        super.onSaveInstanceState(savedInstanceState);
    }

    public boolean onContextItemSelected(MenuItem item) {
        int selectedItemId = item.getItemId();
        switch (selectedItemId) {
            case 4: {
                LoginParameters.setLoginMode(LoginParameters.LOGIN_MODE.UNVIRED_ID_FORGOT_PASSWORD_REAUTH);
                this.handleForgotPassword();
                return true;
            }
            case 5: {
                MessageHelper messageHelper = MessageHelper.getInstance();
                int outbox = 0;
                try {
                    OutObject[] outObject = Outbox.getInstance().getOutObjects();
                    if (outObject != null) {
                        outbox = outObject.length;
                    }
                }
                catch (DBException dbException) {
                    Logger.log(8, ((Object)((Object)this)).getClass().getName(), "GettingOutboxObject", dbException.getMessage());
                    this.displayToast(messageHelper.getValue(messageHelper.UNABLE_TO_READ_OUTBOX));
                    return false;
                }
                if (outbox > 0) {
                    Button buttonNegative;
                    AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
                    alertDialog.setTitle((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DIALOG_ALERT_TITLE));
                    alertDialog.setMessage((CharSequence)messageHelper.getValue(messageHelper.INFO_APPLICATION_RESET_ERROR));
                    alertDialog.setButton(-1, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DIALOG_BUTTON_OK), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                        }
                    });
                    alertDialog.setButton(-2, (CharSequence)messageHelper.getValue(messageHelper.CONTINUE), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            LoginLocalActivity.this.getConfirmationDialogReset();
                        }
                    });
                    alertDialog.show();
                    Button buttonPositive = alertDialog.getButton(-1);
                    if (buttonPositive != null) {
                        buttonPositive.setTextColor(UITheme.getColorPrimary());
                    }
                    if ((buttonNegative = alertDialog.getButton(-2)) != null) {
                        buttonNegative.setTextColor(UITheme.getColorPrimary());
                    }
                } else {
                    this.getConfirmationDialogReset();
                }
                return true;
            }
            case 2: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.ADS);
                this.resetLayout();
                return true;
            }
            case 1: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.UNVIRED_ID);
                this.resetLayout();
                return true;
            }
            case 3: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.SAP);
                this.resetLayout();
                return true;
            }
            case 6: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.EMAIL);
                this.resetLayout();
                return true;
            }
            case 7: {
                LoginParameters.setCurrentLoginType(LoginParameters.LOGIN_TYPE.SAML2);
                this.resetLayout();
                return true;
            }
        }
        return false;
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        MessageHelper messageHelper = MessageHelper.getInstance();
        menu.setHeaderTitle((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_OPTIONS));
        LoginParameters.LOGIN_MODE loginMode = LoginParameters.getLoginMode();
        switch (loginMode) {
            case UNVIRED_ID_LOCAL_AUTH: {
                menu.add(0, 4, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_FORGOT_PASSWORD));
                menu.add(0, 5, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_CLEAR_DATA));
                return;
            }
            case UNVIRED_ID_FORGOT_PASSWORD_REAUTH: {
                this.options.setVisibility(8);
                this.sendLinkToLogin.setVisibility(8);
                return;
            }
        }
        menu.setHeaderTitle((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_OPTIONS_LOGIN_TYPES_TITLE));
        this.setMenuItems(menu);
    }

    private void setMenuItems(ContextMenu menu) {
        LoginParameters.LOGIN_TYPE[] loginTypes = LoginParameters.getLoginTypes();
        if (loginTypes == null || loginTypes.length < 2) {
            return;
        }
        LoginParameters.LOGIN_TYPE currentloginType = LoginParameters.getCurrentLoginType();
        MessageHelper messageHelper = MessageHelper.getInstance();
        block6: for (LoginParameters.LOGIN_TYPE loginType : loginTypes) {
            switch (loginType) {
                case UNVIRED_ID: {
                    MenuItem item = menu.add(0, 1, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_UNVIRED_ID));
                    if (currentloginType != LoginParameters.LOGIN_TYPE.UNVIRED_ID) continue block6;
                    item.setCheckable(true);
                    item.setChecked(true);
                    continue block6;
                }
                case ADS: {
                    MenuItem item = menu.add(0, 2, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_ADS));
                    if (currentloginType != LoginParameters.LOGIN_TYPE.ADS) continue block6;
                    item.setCheckable(true);
                    item.setChecked(true);
                    continue block6;
                }
                case SAP: {
                    MenuItem item = menu.add(0, 3, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_SAP));
                    if (currentloginType != LoginParameters.LOGIN_TYPE.SAP) continue block6;
                    item.setCheckable(true);
                    item.setChecked(true);
                    continue block6;
                }
                case EMAIL: {
                    MenuItem item = menu.add(0, 6, 0, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_LOGIN_TYPE_EMAIL));
                    if (currentloginType != LoginParameters.LOGIN_TYPE.EMAIL) continue block6;
                    item.setCheckable(true);
                    item.setChecked(true);
                }
            }
        }
    }

    private void handleResetPassword(final String forgotToken, final String newPassword) {
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                final IAuthenticationResponse authenticationResponse = AuthenticationService.resetPassword(forgotToken, newPassword);
                if (authenticationResponse instanceof AuthenticationResponse) {
                    LoginLocalActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            LoginLocalActivity.this.showInfo(false, ((AuthenticationResponse)authenticationResponse).getMessage());
                        }
                    });
                }
            }
        });
        t1.start();
    }

    private AlertDialog showInfo(boolean error, String message) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
        if (error) {
            alertDialog.setTitle((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DIALOG_TITLE));
        } else {
            alertDialog.setTitle((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DIALOG_TITLE));
        }
        alertDialog.setMessage((CharSequence)message);
        alertDialog.setButton(-1, (CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_DIALOG_BUTTON_OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        alertDialog.show();
        Button button = alertDialog.getButton(-1);
        button.setTextColor(UITheme.getColorPrimary());
        return alertDialog;
    }

    private void disableAllFields() {
        this.userIdEditText.setEnabled(false);
        this.passwordEditText.setEnabled(false);
        this.options.setEnabled(false);
        this.options.setOnClickListener(null);
        this.sendLinkToLogin.setEnabled(false);
        this.sendLinkToLogin.setOnClickListener(null);
    }

    public void enableAllFields() {
        this.userIdEditText.setEnabled(true);
        this.passwordEditText.setEnabled(true);
        this.options.setEnabled(true);
        this.options.setOnClickListener((View.OnClickListener)this);
        this.sendLinkToLogin.setEnabled(true);
        this.sendLinkToLogin.setOnClickListener((View.OnClickListener)this);
        this.loginButton.setOnClickListener(this);
        this.loginButton.setBackground(UIStyle.getButtonBG());
    }

    private void handleLogin(String url, String userId, String password, String domain, String companyAlias) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        if (LoginParameters.getLoginMode() == LoginParameters.LOGIN_MODE.UNVIRED_ID_LOCAL_AUTH) {
            try {
                UserSettingsManager settingsManager = UserSettingsManager.getInstance();
                url = settingsManager.getServerUrl();
                domain = settingsManager.getADSDomain();
                companyAlias = settingsManager.getCompanyAlias();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LoginParameters.setUrl(url);
        LoginParameters.setCompany(companyAlias);
        LoginParameters.setUnviredUserId(userId);
        LoginParameters.setUnviredPassword(password);
        LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
        switch (loginType) {
            case UNVIRED_ID: 
            case EMAIL: {
                LoginParameters.setUnviredIdCredentials(userId, password);
                break;
            }
            case ADS: 
            case SAP: {
                LoginParameters.setADSCredentials(userId, password, domain);
            }
        }
        LoginListener loginListener = LoginParameters.getLoginListener();
        switch (LoginParameters.getLoginMode()) {
            case UNVIRED_ID_LOCAL_AUTH: {
                if (password == null || password.isEmpty()) {
                    this.loginButton.startRotate();
                    this.disableAllFields();
                    this.loginButton.setText(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_CANCEL));
                    this.loginButton.setOnAnimFinishListener(new ProgressButton.onAnimFinish(){

                        @Override
                        public void onFinish() {
                            LoginLocalActivity.this.enableAllFields();
                        }
                    });
                    this.authenticateAndActivateThread = new AuthenticateAndActivateThread(this);
                    this.thread = new Thread(this.authenticateAndActivateThread);
                    this.thread.start();
                    break;
                }
                AuthenticationResponse authenticationResponse = AuthenticationService.authenticateLocal(this.getApplicationContext());
                if (IAuthenticationResponse.RESPONSE_STATUS.SUCCESS == authenticationResponse.getResponseStatus()) {
                    if (loginListener != null) {
                        LoginParameters.setUnviredPassword(null);
                        LoginParameters.setADSPassword(null);
                        LoginParameters.setMD5Password(null);
                        AuthenticationService.setLoginSuccessful();
                        loginListener.loginSuccessful();
                    }
                    this.finish();
                    break;
                }
                final String error = authenticationResponse.getMessage();
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        LoginLocalActivity.this.showInfo(true, error);
                    }
                });
                if (loginListener == null) break;
                loginListener.loginFailure(error);
                break;
            }
            case UNVIRED_ID_AUTH_ACTIVATE: {
                this.loginButton.startRotate();
                this.disableAllFields();
                this.loginButton.setText(messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_CANCEL));
                this.loginButton.setOnAnimFinishListener(new ProgressButton.onAnimFinish(){

                    @Override
                    public void onFinish() {
                        LoginLocalActivity.this.enableAllFields();
                    }
                });
                this.authenticateAndActivateThread = new AuthenticateAndActivateThread(this);
                this.thread = new Thread(this.authenticateAndActivateThread);
                this.thread.start();
                break;
            }
            case UNVIRED_ID_FORGOT_PASSWORD_REAUTH: {
                this.loginButton.startRotate();
                this.disableAllFields();
                this.loginButton.setBackgroundColor(UITheme.getDividerColor());
                this.loginButton.setOnClickListener(null);
                this.loginButton.setOnAnimFinishListener(new ProgressButton.onAnimFinish(){

                    @Override
                    public void onFinish() {
                        LoginLocalActivity.this.loginButton.setBackgroundColor(UITheme.getColorPrimary());
                        LoginLocalActivity.this.enableAllFields();
                    }
                });
                break;
            }
        }
    }

    private boolean validate(String url, String userId, String password, String domain, String companyAlias) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        switch (LoginParameters.getLoginMode()) {
            case UNVIRED_ID_AUTH_ACTIVATE: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
                if (Strings.isNullOrEmpty((String)password)) {
                    this.passwordLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_PASSWORD));
                    this.passwordEditText.requestFocus();
                    return false;
                }
                this.passwordLayout.setErrorEnabled(false);
                break;
            }
            case UNVIRED_ID_LOCAL_AUTH: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
                if (Strings.isNullOrEmpty((String)password)) {
                    this.passwordLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_PASSWORD));
                    this.passwordEditText.requestFocus();
                    return false;
                }
                this.passwordLayout.setErrorEnabled(false);
                break;
            }
            case UNVIRED_ID_FORGOT_PASSWORD_REAUTH: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
            }
        }
        return true;
    }

    private boolean validateForToken(String url, String userId, String domain, String companyAlias) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        switch (LoginParameters.getLoginMode()) {
            case UNVIRED_ID_AUTH_ACTIVATE: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
                break;
            }
            case UNVIRED_ID_LOCAL_AUTH: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
                break;
            }
            case UNVIRED_ID_FORGOT_PASSWORD_REAUTH: {
                if (Strings.isNullOrEmpty((String)userId)) {
                    this.usernameLayout.setError((CharSequence)messageHelper.getValue(messageHelper.LOGIN_ACTIVITY_INVALID_USER_ID));
                    this.userIdEditText.requestFocus();
                    return false;
                }
                this.usernameLayout.setErrorEnabled(false);
            }
        }
        return true;
    }

    protected void displayToast(final String msg) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)LoginLocalActivity.this, (CharSequence)msg, (int)1).show();
            }
        });
    }

    private void handleForgotPassword() {
        this.showOrHideProgress(true);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final IAuthenticationResponse authenticationResponse = AuthenticationService.forgotPassword();
                if (authenticationResponse instanceof AuthenticationResponse) {
                    LoginLocalActivity.this.showOrHideProgress(false);
                    LoginLocalActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            LoginLocalActivity.this.showInfo(false, ((AuthenticationResponse)authenticationResponse).getMessage());
                            LoginLocalActivity.this.resetLayout();
                        }
                    });
                }
            }
        });
        thread.start();
    }

    private void showOrHideProgress(final boolean show) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (LoginLocalActivity.this.progressDialog != null) {
                    LoginLocalActivity.this.progressDialog.dismiss();
                    LoginLocalActivity.this.progressDialog = null;
                }
                if (!show) {
                    return;
                }
                MessageHelper messageHelper = MessageHelper.getInstance();
                LoginLocalActivity.this.progressDialog = new ProgressDialog((Context)LoginLocalActivity.this);
                LoginLocalActivity.this.progressDialog.setTitle((CharSequence)messageHelper.getValue(messageHelper.WAIT_MESSAGE));
                LoginLocalActivity.this.progressDialog.setCancelable(false);
                LoginLocalActivity.this.progressDialog.setCanceledOnTouchOutside(false);
                LoginLocalActivity.this.progressDialog.show();
            }
        });
    }

    private void getConfirmationDialogReset() {
        MessageHelper messageHelper = MessageHelper.getInstance();
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)messageHelper.getValue(messageHelper.CONFIRMATION_RESET));
        builder.setPositiveButton((CharSequence)messageHelper.getValue(messageHelper.OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                FrameworkHelper.resetApplication(true);
                LoginLocalActivity.this.finish();
                try {
                    AuthenticationService.login(FrameworkHelper.getApplicationContext());
                }
                catch (ApplicationException e) {
                    Logger.log(8, this.getClass().getName(), "getConfirmationDialogReset", e.getMessage());
                }
                catch (DBException e) {
                    Logger.log(8, this.getClass().getName(), "getConfirmationDialogReset", e.getMessage());
                }
                catch (Exception e) {
                    Logger.log(8, this.getClass().getName(), "getConfirmationDialogReset", "Exception caught: " + e.getMessage());
                }
            }
        });
        builder.setNegativeButton((CharSequence)messageHelper.getValue(messageHelper.CANCEL), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    private class AuthenticateAndActivateThread
    implements Runnable {
        private boolean cancelled = false;
        private LoginLocalActivity loginActivity;
        MessageHelper messageHelper = MessageHelper.getInstance();
        private String customDeviceId = null;
        private String errorMessage = null;
        private Thread t;

        public AuthenticateAndActivateThread(LoginLocalActivity loginActivity) {
            this.loginActivity = loginActivity;
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            IAuthenticationResponse authenticationResponse = AuthenticationService.authenticateAndActivate(this.loginActivity.getApplicationContext());
            if (authenticationResponse instanceof AuthenticationResponse) {
                if (!this.cancelled) {
                    this.handleAuthenticationResponse((AuthenticationResponse)authenticationResponse);
                }
            } else {
                String[] frontendIdStrings = null;
                MultipleFrontendUsersResponse multipleFrontendUsersResponse = (MultipleFrontendUsersResponse)authenticationResponse;
                Vector<String> frontendIds = multipleFrontendUsersResponse.getFrontendIds();
                int size = frontendIds.size();
                frontendIdStrings = new String[size];
                for (int i = 0; i < size; ++i) {
                    frontendIdStrings[i] = frontendIds.elementAt(i);
                }
                String[] finalFrontendIdStrings = frontendIdStrings;
                String customDeviceId = this.getUserPickedId(finalFrontendIdStrings);
                if (customDeviceId == null || customDeviceId.length() == 0) {
                    Logger.log(8, "", "", this.messageHelper.getValue(this.messageHelper.CUSTOM_ID_NOT_PICKED));
                    return;
                }
                LoginParameters.setDeviceId(customDeviceId);
                AuthenticationResponse authenticationResponseAfterSendingFEId = (AuthenticationResponse)AuthenticationService.authenticateAndActivate(this.loginActivity.getApplicationContext());
                if (!this.cancelled) {
                    this.handleAuthenticationResponse(authenticationResponseAfterSendingFEId);
                }
            }
        }

        private void handleAuthenticationResponse(AuthenticationResponse authenticationResponse) {
            final LoginListener loginListener = LoginParameters.getLoginListener();
            block0 : switch (LoginParameters.getLoginMode()) {
                case UNVIRED_ID_AUTH_ACTIVATE: {
                    switch (authenticationResponse.getResponseStatus()) {
                        case SUCCESS: {
                            if ("MESSAGE_SUBTYPE_GET_LOGIN_TOKEN".equals(authenticationResponse.getMessage())) {
                                LoginLocalActivity.this.startActivity(new Intent((Context)this.loginActivity, WaitingForTokenActivity.class));
                                this.loginActivity.finish();
                                break block0;
                            }
                            this.loginActivity.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (loginListener != null) {
                                        AuthenticationService.setLoginSuccessful();
                                        if (!LoginParameters.getLoginScreenType().equals((Object)LoginParameters.LOGIN_SCREEN_TYPE.CUSTOM)) {
                                            AuthenticateAndActivateThread.this.loginActivity.finish();
                                        }
                                        LoginParameters.setUnviredPassword(null);
                                        LoginParameters.setADSPassword(null);
                                        LoginParameters.setMD5Password(null);
                                        loginListener.authenticateAndActivationSuccessful();
                                    }
                                }
                            });
                            break block0;
                        }
                    }
                    this.errorMessage = authenticationResponse.getMessage();
                    if (this.errorMessage == null || this.errorMessage.length() == 0) {
                        this.errorMessage = this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_CANNOT_AUTHENTICATE) + this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_CONTACT_ADMINISTRATOR) + this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_NO_VALID_ERROR);
                    }
                    this.loginActivity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            LoginLocalActivity.this.loginButton.setText(AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.LOGIN_ACTIVITY_LOGIN));
                            LoginLocalActivity.this.loginButton.removeDrawable();
                            LoginLocalActivity.this.loginButton.stop();
                            LoginLocalActivity.this.loginButton.setBackgroundColor(UITheme.getColorPrimary());
                            LoginLocalActivity.this.loginButton.setEnabled(true);
                            AuthenticateAndActivateThread.this.showInfo(true, AuthenticateAndActivateThread.this.errorMessage);
                        }
                    });
                    if (loginListener == null) break;
                    loginListener.authenticateAndActivationFailure(this.errorMessage);
                    break;
                }
                case UNVIRED_ID_LOCAL_AUTH: {
                    if (IAuthenticationResponse.RESPONSE_STATUS.SUCCESS == authenticationResponse.getResponseStatus()) {
                        LoginLocalActivity.this.startActivity(new Intent((Context)this.loginActivity, WaitingForTokenActivity.class));
                        this.loginActivity.finish();
                        break;
                    }
                    final String error = authenticationResponse.getMessage();
                    this.loginActivity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            LoginLocalActivity.this.loginButton.setText(AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.LOGIN_ACTIVITY_LOGIN));
                            LoginLocalActivity.this.loginButton.removeDrawable();
                            LoginLocalActivity.this.loginButton.stop();
                            LoginLocalActivity.this.loginButton.setBackgroundColor(UITheme.getColorPrimary());
                            LoginLocalActivity.this.loginButton.setEnabled(true);
                            AuthenticateAndActivateThread.this.showInfo(true, error);
                        }
                    });
                    if (loginListener == null) break;
                    loginListener.loginFailure(error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getUserPickedId(final String[] frontendIdStrings) {
            final Thread dialogThread = Thread.currentThread();
            LoginLocalActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)AuthenticateAndActivateThread.this.loginActivity);
                    builder.setTitle((CharSequence)AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.PICK_DEVICE));
                    LinearLayout layout2 = new LinearLayout((Context)AuthenticateAndActivateThread.this.loginActivity);
                    layout2.setOrientation(1);
                    ListView lv = new ListView((Context)AuthenticateAndActivateThread.this.loginActivity);
                    TextView label = new TextView((Context)AuthenticateAndActivateThread.this.loginActivity);
                    label.setText((CharSequence)AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.MULTIPLE_IDS_HAVE_BEEEN_MAPPED));
                    label.setPadding(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp16);
                    ArrayAdapter adapter = new ArrayAdapter((Context)AuthenticateAndActivateThread.this.loginActivity, 0x1090009, (Object[])frontendIdStrings);
                    lv.setAdapter((ListAdapter)adapter);
                    layout2.addView((View)label);
                    builder.setView((View)layout2);
                    builder.setItems((CharSequence[])frontendIdStrings, new DialogInterface.OnClickListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onClick(DialogInterface dialog, int which) {
                            String id2 = frontendIdStrings[which];
                            int indexOfSeparator = id2.indexOf(":");
                            AuthenticateAndActivateThread.this.customDeviceId = id2.substring(indexOfSeparator + 2);
                            Thread thread = dialogThread;
                            synchronized (thread) {
                                dialogThread.notify();
                            }
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setCancelable(false);
                    dialog.setCanceledOnTouchOutside(false);
                    dialog.show();
                }
            });
            Thread thread = dialogThread;
            synchronized (thread) {
                try {
                    dialogThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.customDeviceId;
        }

        private AlertDialog showInfo(boolean error, String message) {
            AlertDialog alertDialog = new AlertDialog.Builder((Context)this.loginActivity).create();
            alertDialog.setCanceledOnTouchOutside(false);
            alertDialog.setCancelable(false);
            if (error) {
                alertDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_ALERT_TITLE));
            } else {
                alertDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_TITLE));
            }
            alertDialog.setMessage((CharSequence)message);
            alertDialog.setButton(-1, (CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_BUTTON_OK), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            alertDialog.show();
            Button button = alertDialog.getButton(-1);
            if (button != null) {
                button.setTextColor(UITheme.getColorPrimary());
            }
            return alertDialog;
        }
    }
}

