/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Looper;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import com.google.common.base.Strings;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationResponse;
import com.unvired.login.AuthenticationService;
import com.unvired.login.IAuthenticationResponse;
import com.unvired.login.LoginListener;
import com.unvired.login.LoginParameters;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.sync.out.DataSender;
import com.unvired.sync.out.Outbox;
import com.unvired.sync.out.ServerErrors;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.UIConstants;
import com.unvired.utils.UITheme;
import com.unvired.utils.uiutils.PasswordEditText;

public class ServerErrorMessageActivity
extends AppCompatActivity {
    private String messageToDisplay = "";
    protected static float density = 0.0f;
    private PasswordEditText passwordField = null;
    public static Activity activity;
    private MessageHelper messageHelper = MessageHelper.getInstance();
    private AlertDialog alertDialog = null;
    private ProgressDialog progressdialog = null;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        this.getWindow().requestFeature(8);
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        activity = this;
        Toolbar toolbar = UIStyle.getToolBar((Context)this);
        this.setSupportActionBar(toolbar);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ServerErrorMessageActivity.this.onBackPressed();
            }
        });
        LinearLayout rootLinearLayout = new LinearLayout((Context)this);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        rootLinearLayout.setLayoutParams(params);
        rootLinearLayout.setOrientation(1);
        rootLinearLayout.addView((View)toolbar);
        this.setContentView((View)rootLinearLayout);
        this.messageToDisplay = (String)com.unvired.utils.Context.getInstance().get(UIConstants.MESSAGE_TO_DISPLAY);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (ServerErrors.isWaitingEmailVerification()) {
                    ServerErrorMessageActivity.this.showEmailVerifyProgressDialog(ServerErrorMessageActivity.this.messageToDisplay);
                } else {
                    ServerErrorMessageActivity.this.showInfo(ServerErrorMessageActivity.this.messageToDisplay);
                }
            }
        });
    }

    protected void onResume() {
        super.onResume();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private void showInfo(String message) {
        if (this.alertDialog != null) {
            this.alertDialog.dismiss();
            this.alertDialog = null;
        }
        this.alertDialog = new AlertDialog.Builder((Context)this).create();
        this.alertDialog.setTitle((CharSequence)"Server Error Message");
        this.alertDialog.setMessage((CharSequence)message);
        this.alertDialog.setCancelable(false);
        this.alertDialog.setCanceledOnTouchOutside(false);
        this.alertDialog.setButton(-1, (CharSequence)this.messageHelper.getValue(this.messageHelper.OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                com.unvired.utils.Context.getInstance().remove(UIConstants.MESSAGE_TO_DISPLAY);
                if (ServerErrors.isDisplayMessageOnly()) {
                    ServerErrorMessageActivity.this.finish();
                    return;
                }
                if (ServerErrors.isPasswordChange()) {
                    ServerErrorMessageActivity.this.alertDialog.dismiss();
                    ServerErrorMessageActivity.this.getChangePasswordDialog();
                } else {
                    NotificationListener notificationListener = SyncEngine.getInstance().getNotificationListener();
                    FrameworkHelper.resetApplication(true);
                    ServerErrorMessageActivity.this.finish();
                    if (notificationListener != null) {
                        notificationListener.notifyApplicationReset();
                    }
                }
            }
        });
        this.alertDialog.show();
    }

    private void showEmailVerifyProgressDialog(String message) {
        if (this.progressdialog != null) {
            this.progressdialog.dismiss();
            this.progressdialog = null;
        }
        this.progressdialog = new ProgressDialog((Context)this);
        this.progressdialog.setTitle((CharSequence)"Waiting...");
        this.progressdialog.setMessage((CharSequence)message);
        this.progressdialog.setCancelable(false);
        this.progressdialog.show();
    }

    @SuppressLint(value={"NewApi"})
    protected void getChangePasswordDialog() {
        Button negativeButton;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        this.passwordField = new PasswordEditText((Context)this);
        this.passwordField.setInputType(129);
        builder.setTitle((CharSequence)"Enter new password");
        builder.setView((View)this.passwordField);
        builder.setPositiveButton((CharSequence)this.messageHelper.getValue(this.messageHelper.OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String userId = null;
                try {
                    userId = UserSettingsManager.getInstance().getUnviredUserId();
                }
                catch (DBException dbException) {
                    Logger.log(8, this.getClass().getName(), "onClick", "DBException:" + dbException.getMessage());
                }
                String password = ServerErrorMessageActivity.this.passwordField.getText().toString();
                if (Strings.isNullOrEmpty((String)password)) {
                    ServerErrorMessageActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ServerErrorMessageActivity.this.showInfo("Enter valid password");
                        }
                    });
                    return;
                }
                LoginParameters.setUnviredPassword(password);
                ProgressDialog passwordProgressDialog = ProgressDialog.show((Context)ServerErrorMessageActivity.this, (CharSequence)"", (CharSequence)ServerErrorMessageActivity.this.messageHelper.getValue(((ServerErrorMessageActivity)ServerErrorMessageActivity.this).messageHelper.LOGIN_ACTIVITY_WAIT), (boolean)true);
                passwordProgressDialog.setCancelable(false);
                passwordProgressDialog.setCanceledOnTouchOutside(false);
                Thread passwordThread = new Thread(new PasswordThread(passwordProgressDialog, userId, password));
                passwordThread.start();
            }
        });
        builder.setNegativeButton((CharSequence)this.messageHelper.getValue(this.messageHelper.CANCEL), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                ServerErrorMessageActivity.this.showMsgToUser();
            }
        });
        AlertDialog alertDialog = builder.create();
        Activity activity = alertDialog.getOwnerActivity();
        if (activity != null) {
            builder.create().setOwnerActivity(null);
        }
        alertDialog.show();
        alertDialog.setCancelable(false);
        alertDialog.setCanceledOnTouchOutside(false);
        Button positiveButton = alertDialog.getButton(-1);
        if (positiveButton != null) {
            positiveButton.setTextColor(UITheme.getColorPrimary());
        }
        if ((negativeButton = alertDialog.getButton(-2)) != null) {
            negativeButton.setTextColor(UITheme.getDividerColor());
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return false;
    }

    public void onBackPressed() {
        this.getChangePasswordDialog();
    }

    private void processOutbox() {
        Outbox outbox = Outbox.getInstance();
        outbox.unlockAllOutObject();
        DataSender dataSender = DataSender.getInstance();
        dataSender.start();
    }

    private void showMsgToUser() {
        final String infoMsg = this.messageHelper.getValue(this.messageHelper.RESET_PASSWORD_TO_PROCESS_OUTBOX);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ServerErrorMessageActivity.this.showUserInfo(infoMsg);
            }
        });
    }

    private void showUserInfo(String message) {
        if (this.alertDialog != null) {
            this.alertDialog.dismiss();
            this.alertDialog = null;
        }
        this.alertDialog = new AlertDialog.Builder((Context)this).create();
        this.alertDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.ALERT_DIALOG_TITLE_INFO));
        this.alertDialog.setMessage((CharSequence)message);
        this.alertDialog.setButton(-1, (CharSequence)this.messageHelper.getValue(this.messageHelper.OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ServerErrorMessageActivity.this.finish();
            }
        });
        this.alertDialog.show();
        this.alertDialog.setCancelable(false);
        this.alertDialog.setCanceledOnTouchOutside(false);
    }

    protected void onDestroy() {
        super.onDestroy();
        activity = null;
    }

    class PasswordThread
    implements Runnable {
        private ProgressDialog activateProgressDialog;
        private String userId;
        private String password;

        public PasswordThread(ProgressDialog activateProgressDialog, String userId, String password) {
            this.activateProgressDialog = activateProgressDialog;
            this.userId = userId;
            this.password = password;
        }

        @Override
        public void run() {
            Looper.prepare();
            AuthenticationResponse authenticationResponse = AuthenticationService.reAuthenticate(LoginParameters.getContext(), this.userId, this.password);
            this.activateProgressDialog.dismiss();
            String message = authenticationResponse.getMessage();
            final LoginListener loginListener = LoginParameters.getLoginListener();
            if (IAuthenticationResponse.RESPONSE_STATUS.SUCCESS == authenticationResponse.getResponseStatus()) {
                ServerErrorMessageActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (loginListener != null) {
                            UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
                            try {
                                LoginParameters.setUnviredPassword(userSettingsManager.getUnviredPassword());
                                LoginParameters.setMD5Password(userSettingsManager.getMD5Password());
                            }
                            catch (DBException dbException) {
                                Logger.log(8, this.getClass().getName(), "setUnviredPassword", "DBException:" + dbException.getMessage());
                            }
                            AuthenticationService.setLoginSuccessful();
                            loginListener.loginSuccessful();
                        }
                        ServerErrorMessageActivity.this.processOutbox();
                        ServerErrorMessageActivity.this.finish();
                    }
                });
            } else {
                final String errorMessage = message == null || message.length() == 0 ? ServerErrorMessageActivity.this.messageHelper.getValue(((ServerErrorMessageActivity)ServerErrorMessageActivity.this).messageHelper.LOGIN_ACTIVITY_CANNOT_AUTHENTICATE) + ServerErrorMessageActivity.this.messageHelper.getValue(((ServerErrorMessageActivity)ServerErrorMessageActivity.this).messageHelper.LOGIN_ACTIVITY_CONTACT_ADMINISTRATOR) + ServerErrorMessageActivity.this.messageHelper.getValue(((ServerErrorMessageActivity)ServerErrorMessageActivity.this).messageHelper.LOGIN_ACTIVITY_NO_VALID_ERROR) : message;
                ServerErrorMessageActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerErrorMessageActivity.this.showInfo(errorMessage);
                    }
                });
                if (loginListener != null) {
                    loginListener.loginFailure(errorMessage);
                }
            }
        }
    }
}

