/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.design.widget.TextInputLayout;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.CardView;
import android.support.v7.widget.Toolbar;
import android.text.InputFilter;
import android.text.Spanned;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.unvired.core.FrameworkManager;
import com.unvired.database.IDataManager;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationResponse;
import com.unvired.login.AuthenticationService;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.IconHelper;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.UITheme;
import com.unvired.utils.uiutils.PasswordEditText;
import com.unvired.utils.uiutils.ProgressButton;
import java.io.InputStream;

public class SystemCredential
extends AppCompatActivity
implements View.OnClickListener {
    private final int SAVE_KEY = 1;
    private final int TEST_KEY = 2;
    private final int MORE_KEY = 3;
    private static final int SAVE_MENU_ID = 100;
    private AppCompatEditText userIdEdit = null;
    private TextView sysDescEdit = null;
    private PasswordEditText passwordEdit = null;
    private TextView sysDescValueMore = null;
    private TextView portNameValueMore = null;
    private TextView portTypeValueMore = null;
    private TextView portDescValueMore = null;
    private ProgressButton testButton;
    private LinearLayout mainLayout = null;
    private CardView moreCardView = null;
    private TextInputLayout userIdMainLayout = null;
    private TextInputLayout passwordMainLayout = null;
    private LinearLayout buttonsMainLayout = null;
    private LinearLayout imageMainLayout = null;
    private LinearLayout sysDescMainLayout = null;
    private TextView moreOrLessTextView = null;
    private com.unvired.model.SystemCredential systemCredential = null;
    private MessageHelper messageHelper = MessageHelper.getInstance();
    private Thread t = null;
    private boolean isTesting = false;
    private Toolbar toolbar;
    private ImageView backIcon;
    private float density = 0.0f;
    private int screenWidth = 0;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        this.getWindow().setSoftInputMode(3);
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        this.density = displayMetrics.density;
        this.screenWidth = displayMetrics.widthPixels;
        this.toolbar = UIStyle.getToolBar((Context)this);
        this.setSupportActionBar(this.toolbar);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SystemCredential.this.onBackPressed();
            }
        });
        this.systemCredential = (com.unvired.model.SystemCredential)com.unvired.utils.Context.getInstance().get("SYSTEM_CREDENTIAL_SELECTED");
        if (this.systemCredential == null) {
            return;
        }
        this.setLayout();
        this.draw();
        if (savedInstanceState != null) {
            String userIdText = savedInstanceState.getString("USER_ID");
            String passwordText = savedInstanceState.getString("PASSWORD");
            this.userIdEdit.setText((CharSequence)userIdText);
            this.passwordEdit.setText(passwordText);
        }
    }

    public void onResume() {
        super.onResume();
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putString("USER_ID", this.userIdEdit.getText().toString());
        savedInstanceState.putString("PASSWORD", this.passwordEdit.getText().toString());
        super.onSaveInstanceState(savedInstanceState);
    }

    private void draw() {
        String userIdValue = this.systemCredential.getUserId();
        String passwordValue = this.systemCredential.getPassword();
        String sysDescValue = this.systemCredential.getSystemDesc();
        if (userIdValue != null && userIdValue.length() > 0) {
            this.userIdEdit.setText((CharSequence)userIdValue);
        }
        if (passwordValue != null && passwordValue.length() > 0) {
            this.passwordEdit.setText(passwordValue);
        }
        if (sysDescValue != null && sysDescValue.length() > 0) {
            this.sysDescEdit.setText((CharSequence)sysDescValue);
        }
        String portNameValue = this.systemCredential.getPortName();
        String portTypeValue = this.systemCredential.getPortType();
        String portDescValue = this.systemCredential.getPortDesc();
        if (sysDescValue != null && sysDescValue.length() > 0) {
            this.sysDescValueMore.setText((CharSequence)sysDescValue);
        }
        if (portNameValue != null && portNameValue.length() > 0) {
            this.portNameValueMore.setText((CharSequence)portNameValue);
        }
        if (portTypeValue != null && portTypeValue.length() > 0) {
            this.portTypeValueMore.setText((CharSequence)portTypeValue);
        }
        if (portDescValue != null && portDescValue.length() > 0) {
            this.portDescValueMore.setText((CharSequence)portDescValue);
        }
    }

    private void setLayout() {
        this.sysDescEdit = new TextView((Context)this);
        this.userIdEdit = new AppCompatEditText((Context)this);
        this.passwordEdit = new PasswordEditText((Context)this);
        this.userIdEdit.setInputType(1);
        this.userIdEdit.setSupportBackgroundTintList(ColorStateList.valueOf((int)UITheme.getColorPrimary()));
        this.passwordEdit.setSupportBackgroundTintList(ColorStateList.valueOf((int)UITheme.getColorPrimary()));
        int buttonWidth = (int)((double)this.screenWidth * 0.75);
        this.testButton = new ProgressButton((Context)this);
        this.testButton.setLayoutParams(new ViewGroup.LayoutParams(buttonWidth, -2));
        this.testButton.setTextColor(UITheme.getTextColor());
        this.testButton.setBackgroundColor(UITheme.getColorPrimary());
        this.moreOrLessTextView = new TextView((Context)this);
        this.moreOrLessTextView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.moreOrLessTextView.setPaintFlags(this.moreOrLessTextView.getPaintFlags() | 8);
        this.moreOrLessTextView.setTextColor(-16776961);
        this.moreOrLessTextView.setGravity(17);
        this.testButton.setOnClickListener(this);
        this.moreOrLessTextView.setOnClickListener((View.OnClickListener)this);
        this.testButton.setText(this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIAL_TEST));
        this.moreOrLessTextView.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIAL_MORE));
        this.sysDescMainLayout = new LinearLayout((Context)this);
        this.sysDescMainLayout.setPadding(UIStyle.dp16, 0, UIStyle.dp16, 0);
        this.sysDescMainLayout.setLayoutParams(UIStyle.getLayoutParam());
        this.sysDescMainLayout.setOrientation(1);
        this.sysDescEdit.setGravity(1);
        this.sysDescEdit.setTypeface(null, 1);
        this.sysDescMainLayout.addView((View)this.sysDescEdit);
        this.userIdMainLayout = new TextInputLayout((Context)this);
        this.userIdMainLayout.setPadding(UIStyle.dp16, 0, UIStyle.dp16, 0);
        this.userIdMainLayout.setLayoutParams(UIStyle.getLayoutParam());
        this.userIdMainLayout.setOrientation(1);
        this.userIdEdit.setHint((CharSequence)this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIALS_USER_ID));
        this.userIdMainLayout.addView((View)this.userIdEdit);
        int height = (int)(this.density * 125.0f);
        this.imageMainLayout = new LinearLayout((Context)this);
        this.imageMainLayout.setPadding(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp16);
        LinearLayout.LayoutParams sapImageMainLayoutParams = new LinearLayout.LayoutParams((ViewGroup.MarginLayoutParams)new LinearLayout.LayoutParams(-1, height));
        this.imageMainLayout.setLayoutParams((ViewGroup.LayoutParams)sapImageMainLayoutParams);
        this.imageMainLayout.setGravity(17);
        this.imageMainLayout.setOrientation(1);
        ImageView sapImage = new ImageView((Context)this);
        String portType = this.systemCredential.getPortType();
        InputStream image = null;
        image = "RFC".equals(portType) ? IconHelper.getIcon("sap_rfc.png") : ("SALES_FORCE".equals(portType) ? IconHelper.getIcon("salesforce.png") : IconHelper.getIcon("others.png"));
        Drawable sapImageDrawable = Drawable.createFromStream((InputStream)image, (String)"");
        sapImage.setImageDrawable(sapImageDrawable);
        this.imageMainLayout.addView((View)sapImage);
        this.passwordMainLayout = new TextInputLayout((Context)this);
        this.passwordMainLayout.setPadding(UIStyle.dp16, 0, UIStyle.dp16, 0);
        this.passwordMainLayout.setLayoutParams(UIStyle.getLayoutParam());
        this.passwordMainLayout.setOrientation(1);
        this.passwordEdit.setLayoutParams(UIStyle.getLayoutParam());
        this.passwordEdit.setHint(this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIALS_PASSWORD));
        this.passwordEdit.setInputType(129);
        this.passwordMainLayout.addView((View)this.passwordEdit);
        this.buttonsMainLayout = new LinearLayout((Context)this);
        this.buttonsMainLayout.setOrientation(0);
        this.buttonsMainLayout.setPadding(UIStyle.dp16, UIStyle.dp16, 0, UIStyle.dp16);
        this.buttonsMainLayout.addView((View)this.testButton);
        this.buttonsMainLayout.addView((View)this.moreOrLessTextView);
        this.mainLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams mainLayoutParams = new LinearLayout.LayoutParams((ViewGroup.MarginLayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mainLayout.setLayoutParams((ViewGroup.LayoutParams)mainLayoutParams);
        this.mainLayout.setOrientation(1);
        this.mainLayout.addView((View)this.imageMainLayout);
        this.mainLayout.addView((View)this.sysDescMainLayout);
        this.mainLayout.addView((View)this.userIdMainLayout);
        this.mainLayout.addView((View)this.passwordMainLayout);
        this.mainLayout.addView((View)this.buttonsMainLayout);
        CardView cardView = UIStyle.getCardView((Context)this);
        cardView.addView((View)this.mainLayout);
        this.moreCardView = this.getMoreLayout();
        this.moreCardView.setVisibility(8);
        LinearLayout.LayoutParams cardParam = new LinearLayout.LayoutParams(-1, -2);
        cardParam.setMargins(UIStyle.dp8, UIStyle.dp8, UIStyle.dp8, UIStyle.dp8);
        LinearLayout layout2 = new LinearLayout((Context)this);
        layout2.setOrientation(1);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        layout2.setBackgroundColor(UITheme.getBackgroundColor());
        layout2.addView((View)cardView, (ViewGroup.LayoutParams)cardParam);
        layout2.addView((View)this.moreCardView, (ViewGroup.LayoutParams)cardParam);
        ScrollView scrollView = new ScrollView((Context)this);
        scrollView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        scrollView.addView((View)layout2);
        LinearLayout finalLayout = new LinearLayout((Context)this);
        finalLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        finalLayout.setOrientation(1);
        finalLayout.setBackgroundColor(UITheme.getBackgroundColor());
        finalLayout.addView((View)this.toolbar);
        finalLayout.addView((View)scrollView);
        this.setContentView((View)finalLayout);
    }

    private CardView getMoreLayout() {
        TextView sysDescLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView portNameLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView portTypeLabel = UIStyle.getDetailLabelTextView((Context)this);
        TextView portDescLabel = UIStyle.getDetailLabelTextView((Context)this);
        sysDescLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIALS_SYS_DESC));
        portNameLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIALS_PORT_NAME));
        portTypeLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIALS_PORT_TYPE));
        portDescLabel.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIALS_PORT_DESC));
        this.sysDescValueMore = UIStyle.getDetailContentTextView((Context)this);
        this.portNameValueMore = UIStyle.getDetailContentTextView((Context)this);
        this.portTypeValueMore = UIStyle.getDetailContentTextView((Context)this);
        this.portDescValueMore = UIStyle.getDetailContentTextView((Context)this);
        this.sysDescValueMore.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                return source.length() < 1 ? dest.subSequence(dstart, dend) : null;
            }
        }});
        this.portNameValueMore.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                return source.length() < 1 ? dest.subSequence(dstart, dend) : null;
            }
        }});
        this.portTypeValueMore.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                return source.length() < 1 ? dest.subSequence(dstart, dend) : null;
            }
        }});
        this.portDescValueMore.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                return source.length() < 1 ? dest.subSequence(dstart, dend) : null;
            }
        }});
        LinearLayout layout2 = new LinearLayout((Context)this);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        layout2.setOrientation(1);
        layout2.setPadding(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp16);
        layout2.addView((View)sysDescLabel);
        layout2.addView((View)this.sysDescValueMore);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)portNameLabel);
        layout2.addView((View)this.portNameValueMore);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)portTypeLabel);
        layout2.addView((View)this.portTypeValueMore);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        layout2.addView((View)portDescLabel);
        layout2.addView((View)this.portDescValueMore);
        layout2.addView((View)UIStyle.getDivider((Context)this));
        CardView cardView = UIStyle.getCardView((Context)this);
        cardView.addView((View)layout2);
        return cardView;
    }

    public void onClick(View v) {
        if (v == this.testButton) {
            if (this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIAL_CANCEL).equalsIgnoreCase(this.testButton.getText().toString())) {
                if (this.t != null && this.t.isAlive()) {
                    this.t.interrupt();
                }
                this.testButton.setText(this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIAL_TEST));
                this.testButton.removeDrawable();
                this.enableAllFields();
                return;
            }
            this.onClick(2);
        } else if (v == this.moreOrLessTextView) {
            this.onClick(3);
        }
    }

    private void onClick(int key) {
        switch (key) {
            case 1: {
                String userId = this.userIdEdit.getText().toString();
                String password = this.passwordEdit.getText().toString();
                this.systemCredential.setUserId(userId);
                this.systemCredential.setPassword(password);
                try {
                    IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
                    dataManager.update(this.systemCredential);
                }
                catch (Exception e) {
                    return;
                }
                Toast.makeText((Context)this, (CharSequence)this.messageHelper.getValue(this.messageHelper.SAVED), (int)0).show();
                this.finish();
                break;
            }
            case 3: {
                int visible = this.moreCardView.getVisibility();
                if (visible == 0) {
                    this.moreCardView.setVisibility(8);
                    this.moreOrLessTextView.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIAL_MORE));
                }
                if (visible != 8) break;
                this.moreCardView.setVisibility(0);
                this.moreOrLessTextView.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIAL_LESS));
                break;
            }
            case 2: {
                this.disableAllFields();
                this.testButton.start();
                this.testButton.setText(this.messageHelper.getValue(this.messageHelper.SYSTEM_CREDENTIAL_CANCEL));
                String usrName = this.userIdEdit.getText().toString();
                String pasword = this.passwordEdit.getText().toString();
                this.systemCredential.setUserId(usrName);
                this.systemCredential.setPassword(pasword);
                try {
                    IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
                    dataManager.update(this.systemCredential);
                }
                catch (Exception e) {
                    return;
                }
                this.t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AuthenticationResponse authenticationResponse = AuthenticationService.authenticateBackendCredentials(SystemCredential.this.systemCredential);
                            final String message = authenticationResponse.getMessage();
                            SystemCredential.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (SystemCredential.this.isTesting) {
                                        SystemCredential.this.showInfo(false, message);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            try {
                                Logger.log(8, this.getClass().getName(), "TestConnection from Backend Credentials", e.getMessage());
                            }
                            catch (Throwable throwable) {
                                SystemCredential.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        SystemCredential.this.testButton.removeDrawable();
                                        SystemCredential.this.testButton.setText(SystemCredential.this.messageHelper.getValue(((SystemCredential)SystemCredential.this).messageHelper.SYSTEM_CREDENTIAL_TEST));
                                        SystemCredential.this.enableAllFields();
                                    }
                                });
                                throw throwable;
                            }
                            SystemCredential.this.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
                        }
                        SystemCredential.this.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
                    }
                });
                this.t.start();
            }
        }
    }

    private void showInfo(boolean error, String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton((CharSequence)this.messageHelper.getValue(this.messageHelper.OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        Drawable icDone = Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_action_done.png"), (String)"");
        icDone.setBounds(0, 0, UIStyle.dp24, UIStyle.dp24);
        if (menu != null) {
            menu.clear();
        }
        MenuItem saveItem = menu.add(0, 100, 1, (CharSequence)"Save");
        saveItem.setShowAsActionFlags(2);
        saveItem.setIcon(icDone);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        } else if (item.getItemId() == 100) {
            if (this.isTesting) {
                return false;
            }
            this.onClick(1);
        }
        return true;
    }

    public void onBackPressed() {
        this.finish();
        super.onBackPressed();
    }

    private void enableAllFields() {
        this.isTesting = false;
        this.userIdEdit.setEnabled(true);
        this.passwordEdit.setEnabled(true);
        this.sysDescEdit.setEnabled(true);
        this.moreOrLessTextView.setEnabled(true);
        this.moreOrLessTextView.setOnClickListener((View.OnClickListener)this);
    }

    private void disableAllFields() {
        this.isTesting = true;
        this.userIdEdit.setEnabled(false);
        this.passwordEdit.setEnabled(false);
        this.sysDescEdit.setEnabled(false);
        this.moreOrLessTextView.setEnabled(false);
        this.moreOrLessTextView.setOnClickListener(null);
    }
}

