/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.unvired.core.SystemCredentialManager;
import com.unvired.logger.Logger;
import com.unvired.ui.SystemCredential;
import com.unvired.ui.UIStyle;
import com.unvired.ui.adapter.SystemCredentialsAdapter;
import com.unvired.utils.UITheme;
import com.unvired.utils.uiutils.DividerItemDecoration;

public class SystemCredentials
extends AppCompatActivity {
    private final int DETAILS_KEY = 1;
    private Activity activity;
    private LoadData loadData = null;
    private RecyclerView recyclerView = null;
    private ImageView backIcon;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.activity = this;
        Toolbar toolbar = UIStyle.getToolBar((Context)this);
        this.setSupportActionBar(toolbar);
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SystemCredentials.this.onBackPressed();
            }
        });
        this.recyclerView = new RecyclerView((Context)this);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        DividerItemDecoration itemDecoration = new DividerItemDecoration((Activity)this, 1);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setBackgroundColor(-1);
        LinearLayout homeLayout = new LinearLayout((Context)this);
        homeLayout.setOrientation(1);
        homeLayout.addView((View)toolbar);
        homeLayout.addView((View)this.recyclerView);
        this.setContentView((View)homeLayout);
    }

    public void onResume() {
        super.onResume();
        this.loadData = new LoadData();
        this.loadData.execute(new Void[0]);
    }

    public void onDestroy() {
        super.onDestroy();
        if (!this.loadData.isCancelled()) {
            this.loadData.cancel(true);
        }
    }

    public void onClick(int key) {
        switch (key) {
            case 1: {
                Intent intent = new Intent((Context)this, SystemCredential.class);
                this.startActivity(intent);
            }
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return false;
    }

    public void onBackPressed() {
        this.finish();
        super.onBackPressed();
    }

    private class LoadData
    extends AsyncTask<Void, Void, Void> {
        private com.unvired.model.SystemCredential[] systemCredentials = null;

        private LoadData() {
        }

        protected Void doInBackground(Void ... params) {
            try {
                this.systemCredentials = SystemCredentialManager.getClientCredentials();
            }
            catch (Exception e) {
                Logger.log(8, ((Object)((Object)this)).getClass().getName(), "", "Exception caught while getting system credentials from database, " + e.getMessage());
            }
            return null;
        }

        protected void onPostExecute(Void voids) {
            if (this.systemCredentials == null || this.systemCredentials.length <= 0) {
                SystemCredentials.this.recyclerView.setAdapter(null);
                return;
            }
            SystemCredentialsAdapter adapter = new SystemCredentialsAdapter(SystemCredentials.this.activity, this.systemCredentials);
            SystemCredentials.this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        }
    }
}

