/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.v7.widget.CardView;
import android.support.v7.widget.Toolbar;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.ui.resources.IconHelper;
import com.unvired.utils.UITheme;
import java.io.InputStream;

public class UIStyle {
    public static float density = 56.0f;
    public static int dp2 = 2;
    public static int dp4 = 4;
    public static int dp8 = 8;
    public static int dp16 = 16;
    public static int dp20 = 20;
    public static int dp24 = 24;
    public static int dp32 = 32;
    public static int dp48 = 48;
    public static int dp56 = 56;

    public static void init(float density) {
        UIStyle.density = density;
        dp2 = (int)(density * 2.0f);
        dp4 = (int)(density * 4.0f);
        dp8 = (int)(density * 8.0f);
        dp16 = (int)(density * 16.0f);
        dp20 = (int)(density * 20.0f);
        dp24 = (int)(density * 24.0f);
        dp32 = (int)(density * 32.0f);
        dp48 = (int)(density * 48.0f);
        dp56 = (int)(density * 56.0f);
    }

    public static float getDensity() {
        return density;
    }

    public static CardView getCardView(Context context) {
        CardView cardView = new CardView(context);
        cardView.setRadius((float)dp4);
        cardView.setCardBackgroundColor(-1);
        if (Build.VERSION.SDK_INT >= 21) {
            cardView.setCardElevation((float)dp2);
        }
        return cardView;
    }

    public static TextView getSectionHeaderTextView(Context context) {
        TextView textView = new TextView(context);
        textView.setTextSize(16.0f);
        textView.setTypeface(null, 1);
        textView.setTextColor(UITheme.getColorPrimary());
        return textView;
    }

    public static TextView getLabelTextView(Context context) {
        TextView textView = new TextView(context);
        textView.setTextSize(16.0f);
        textView.setTypeface(null, 0);
        textView.setTextColor(UITheme.getTextColorSecondary());
        return textView;
    }

    public static TextView getSecondaryTextView(Context context) {
        TextView textView = new TextView(context);
        textView.setTextSize(14.0f);
        textView.setTypeface(null, 0);
        textView.setTextColor(UITheme.getDividerColor());
        return textView;
    }

    public static TextView getDetailLabelTextView(Context context) {
        TextView textView = new TextView(context);
        textView.setTextSize(12.0f);
        textView.setTypeface(null, 0);
        textView.setTextColor(UITheme.getTextColorSecondary());
        textView.setPadding(0, dp16, 0, 0);
        return textView;
    }

    public static TextView getDetailContentTextView(Context context) {
        TextView textView = new TextView(context);
        textView.setTextColor(UITheme.getTextColorPrimary());
        textView.setMinHeight(dp48);
        textView.setPadding(0, dp16, 0, dp16);
        textView.setTextSize(16.0f);
        textView.setTypeface(null, 0);
        textView.setTextIsSelectable(true);
        return textView;
    }

    public static TextView getListFirstRowTextView(Context context) {
        TextView textView = new TextView(context);
        textView.setTextSize(16.0f);
        textView.setTypeface(null, 0);
        textView.setTextIsSelectable(true);
        textView.setTextColor(UITheme.getTextColorPrimary());
        return textView;
    }

    public static TextView getListOtherRowTextView(Context context) {
        TextView textView = new TextView(context);
        textView.setTextSize(14.0f);
        textView.setTypeface(null, 0);
        textView.setTextIsSelectable(true);
        textView.setTextColor(UITheme.getTextColorSecondary());
        return textView;
    }

    public static ImageView getHomeIcons(Context context) {
        ImageView imageView = new ImageView(context);
        imageView.setLayoutParams(new ViewGroup.LayoutParams(dp24, dp24));
        imageView.setColorFilter(UITheme.getColorPrimary());
        return imageView;
    }

    public static ViewGroup.LayoutParams getLayoutParam() {
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
        return params;
    }

    public static LinearLayout.LayoutParams getWidgetLayoutParam() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        return params;
    }

    public static TextView getDivider(Context context) {
        TextView textView = new TextView(context);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-1, dp2 / 2));
        textView.setBackgroundColor(UITheme.getDividerColor());
        textView.setDrawingCacheEnabled(true);
        return textView;
    }

    public static Toolbar getToolBar(Context context) {
        Toolbar toolbar = new Toolbar(context);
        if (Build.VERSION.SDK_INT >= 21) {
            toolbar = new Toolbar(context, null, 16974392);
            toolbar.setElevation((float)dp2);
            toolbar.setTitleTextAppearance(context, 16974370);
            toolbar.setPopupTheme(16974410);
        }
        toolbar.setMinimumHeight(dp56);
        boolean demo = false;
        String name = "";
        try {
            demo = UserSettingsManager.getInstance().getDemoMode();
            String firstName = UserSettingsManager.getInstance().getFirstName() == null ? "" : UserSettingsManager.getInstance().getFirstName();
            String lastName = UserSettingsManager.getInstance().getLastName() == null ? "" : UserSettingsManager.getInstance().getLastName();
            name = firstName + " " + lastName;
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        if (demo) {
            toolbar.setTitle((CharSequence)"DEMO");
        } else {
            toolbar.setTitle((CharSequence)name);
        }
        toolbar.setBackgroundColor(UITheme.getColorPrimary());
        Drawable tempDraw = Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_action_back.png"), (String)"");
        Bitmap b = ((BitmapDrawable)tempDraw).getBitmap();
        Bitmap bitmapResized = Bitmap.createScaledBitmap((Bitmap)b, (int)dp24, (int)dp24, (boolean)false);
        toolbar.setNavigationIcon((Drawable)new BitmapDrawable(context.getResources(), bitmapResized));
        if (toolbar.getNavigationIcon() != null) {
            toolbar.getNavigationIcon().setColorFilter(UITheme.getTextColor(), PorterDuff.Mode.MULTIPLY);
        }
        if (toolbar.getOverflowIcon() != null) {
            toolbar.getOverflowIcon().setColorFilter(UITheme.getTextColor(), PorterDuff.Mode.MULTIPLY);
        }
        toolbar.setTitleTextColor(UITheme.getTextColor());
        return toolbar;
    }

    public static ImageView getSAPLoginIcon(Context context) {
        int width = (int)(density * 240.0f);
        int height = (int)(density * 120.0f);
        ImageView imageView = new ImageView(context);
        imageView.setLayoutParams(new ViewGroup.LayoutParams(width, height));
        imageView.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("sap_login.png"), (String)""));
        return imageView;
    }

    public static ImageView getADSLoginIcon(Context context) {
        int size = (int)(density * 120.0f);
        ImageView imageView = new ImageView(context);
        imageView.setLayoutParams(new ViewGroup.LayoutParams(size, size));
        imageView.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("ads_login.png"), (String)""));
        return imageView;
    }

    public static ImageView getUnviredLoginIcon(Context context) {
        int size = (int)(density * 120.0f);
        ImageView imageView = new ImageView(context);
        imageView.setLayoutParams(new ViewGroup.LayoutParams(size, size));
        imageView.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("unvired_icon_64.png"), (String)""));
        return imageView;
    }

    public static ImageView getUnviredHomeIconSmall(Context context) {
        int width = (int)(density * 100.0f);
        int height = (int)(density * 50.0f);
        ImageView imageView = new ImageView(context);
        imageView.setLayoutParams(new ViewGroup.LayoutParams(width, height));
        imageView.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("unvired_logo.png"), (String)""));
        return imageView;
    }

    public static ImageView getUnviredHomeIconLargeBlue(Context context) {
        int width = (int)(density * 250.0f);
        int height = (int)(density * 125.0f);
        ImageView imageView = new ImageView(context);
        imageView.setLayoutParams(new ViewGroup.LayoutParams(width, height));
        imageView.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("unvired_logo.png"), (String)""));
        return imageView;
    }

    public static ImageView getUnviredHomeIconLargeWhite(Context context) {
        int width = (int)(density * 250.0f);
        int height = (int)(density * 125.0f);
        ImageView imageView = new ImageView(context);
        imageView.setLayoutParams(new ViewGroup.LayoutParams(width, height));
        imageView.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("unvired_logo_white.png"), (String)""));
        return imageView;
    }

    public static Drawable getButtonBG() {
        GradientDrawable shape = new GradientDrawable();
        shape.setShape(0);
        shape.setCornerRadius(20.0f);
        shape.setColor(UITheme.getColorPrimary());
        return shape;
    }

    public static Drawable getButtonBGDisabled() {
        GradientDrawable shape = new GradientDrawable();
        shape.setShape(0);
        shape.setCornerRadius(20.0f);
        shape.setColor(UITheme.getDividerColor());
        return shape;
    }
}

