/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatButton;
import android.text.Html;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.google.common.base.Strings;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.FrameworkVersion;
import com.unvired.core.RuntimeEngine;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.DatabaseHelper;
import com.unvired.database.DatabaseRestore;
import com.unvired.database.IDataManager;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationService;
import com.unvired.login.LoginListener;
import com.unvired.login.LoginParameters;
import com.unvired.model.ApplicationMeta;
import com.unvired.model.BusinessEntityMeta;
import com.unvired.model.FieldMeta;
import com.unvired.model.InObject;
import com.unvired.model.SentItemObject;
import com.unvired.model.StructureMeta;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.notifier.NotificationListener;
import com.unvired.ui.R;
import com.unvired.ui.resources.IconHelper;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.NetworkUtil;
import com.unvired.utils.PathManager;
import com.unvired.utils.UITheme;
import com.unvired.utils.Utils;
import java.io.File;
import java.io.InputStream;

public class VersionUpgradeActivity
extends AppCompatActivity
implements View.OnClickListener {
    protected static float density = 0.0f;
    protected TextView title = null;
    private ImageView appIcon = null;
    private TextView upgradeInfo = null;
    private ProgressBar progressBar = null;
    private AppCompatButton upgradeButton;
    private AppCompatButton resetButton;
    private MessageHelper messageHelper;
    private static LoginListener loginListener;
    private String oldDBKey = "";
    private boolean reset = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.setRequestedOrientation(1);
        this.setContentView(R.layout.version_upgrade_activity);
        loginListener = LoginParameters.getLoginListener();
        this.messageHelper = MessageHelper.getInstance();
        this.initViews();
        this.setValues();
        this.upgradeButton.post(new Runnable(){

            @Override
            public void run() {
                VersionUpgradeActivity.this.upgradeButton.performClick();
            }
        });
    }

    protected void onResume() {
        super.onResume();
    }

    private void initViews() {
        this.title = (TextView)this.findViewById(R.id.title);
        this.title.setText((CharSequence)LoginParameters.getAppTitle());
        this.appIcon = (ImageView)this.findViewById(R.id.appImage);
        this.upgradeInfo = (TextView)this.findViewById(R.id.upgradeInfo);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.progressBar.setVisibility(8);
        if (Build.VERSION.SDK_INT >= 21) {
            this.progressBar.setIndeterminateTintMode(PorterDuff.Mode.SRC_IN);
            this.progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)UITheme.getColorPrimary()));
        }
        this.upgradeButton = (AppCompatButton)this.findViewById(R.id.upgradeButton);
        this.upgradeButton.getBackground().setColorFilter(UITheme.getColorPrimary(), PorterDuff.Mode.SRC_IN);
        this.upgradeButton.setTextColor(UITheme.getTextColor());
        this.upgradeButton.setOnClickListener((View.OnClickListener)this);
        this.resetButton = (AppCompatButton)this.findViewById(R.id.resetButton);
        if (LoginParameters.isAutoUpgrade()) {
            this.upgradeButton.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.OK));
            this.resetButton.setVisibility(8);
        } else {
            this.upgradeButton.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.VERSION_UPGRADE_ACTIVITY_LOGIN));
            this.resetButton.setOnClickListener((View.OnClickListener)this);
            this.resetButton.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.VERSION_UPGRADE_ACTIVITY_RESET));
        }
    }

    private void setValues() {
        InputStream logoIcon = LoginParameters.getLogo();
        if (logoIcon != null) {
            Drawable unviredIcon = Drawable.createFromStream((InputStream)logoIcon, (String)"");
            this.appIcon.setImageDrawable(unviredIcon);
        } else {
            this.appIcon.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("unvired_logo.png"), (String)""));
        }
        String message = "";
        message = LoginParameters.isAutoUpgrade() ? this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_MESSAGE_STANDARD) : this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_MESSAGE_ONE);
        this.upgradeInfo.setText((CharSequence)Html.fromHtml((String)message));
    }

    public void onClick(View v) {
        if (v == this.upgradeButton) {
            if (LoginParameters.isAutoUpgrade() && this.reset) {
                this.getConfirmationDialogReset();
            } else {
                this.upgradeInfo.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_PROGRESS_MESSAGE));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        VersionUpgradeActivity.this.upgradeDatabase();
                    }
                }).start();
            }
        } else if (v == this.resetButton) {
            this.getConfirmationDialogReset();
        }
    }

    private void upgradeDatabase() {
        this.disableAllFields();
        SharedPreferences sharedPrefs = this.getSharedPreferences("VERSION_UPGRADE", 0);
        boolean fwUpgrade = sharedPrefs.getBoolean("FW_DB_UPGRADE", false);
        boolean appUpgrade = sharedPrefs.getBoolean("APP_DB_UPGRADE", false);
        try {
            ApplicationMeta applicationMeta = ApplicationManager.getInstance().getApplicationMeta(LoginParameters.getAppName());
            if (applicationMeta == null) {
                Logger.i("ApplicationMeta is null");
                if (LoginParameters.isAutoUpgrade()) {
                    this.setFailedToUpgrade(this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_FAILED_MESSAGE_STANDARD));
                } else {
                    this.setFailedToUpgrade("Unable to upgrade Database. Please contact developer or <b>Reset</b> to clear.");
                }
                return;
            }
            String oldFWVersion = applicationMeta.getFrameworkVersion();
            String oldAppVersion = applicationMeta.getVersion();
            if (!NetworkUtil.isEmulator()) {
                this.oldDBKey = sharedPrefs.getString("DB_KEY", "");
            }
            if (!DatabaseHelper.isBackupAppDBExists() && !DatabaseHelper.backupAppDB()) {
                if (LoginParameters.isAutoUpgrade()) {
                    this.setFailedToUpgrade(this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_FAILED_MESSAGE_STANDARD));
                } else {
                    this.setFailedToUpgrade("<font color=\"#FF0000\">Unable to backup existing data.</font> Please contact developer." + this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_FAILED_MESSAGE_TWO));
                }
                return;
            }
            if (fwUpgrade && !DatabaseHelper.isBackupFWDBExists() && !DatabaseHelper.backupFWDB()) {
                if (LoginParameters.isAutoUpgrade()) {
                    this.setFailedToUpgrade(this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_FAILED_MESSAGE_STANDARD));
                } else {
                    this.setFailedToUpgrade("<font color=\"#FF0000\">Unable to backup existing data.</font> Please contact developer." + this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_FAILED_MESSAGE_TWO));
                }
                return;
            }
            if (fwUpgrade && !this.reCreateFrameworkDB(oldFWVersion)) {
                this.setFailedToUpgrade(this.getStandardFailedMessage(""));
                return;
            }
            if (appUpgrade && !fwUpgrade && !this.reCreateApplicationDB(oldAppVersion)) {
                this.setFailedToUpgrade(this.getStandardFailedMessage(""));
                return;
            }
            if (!(!fwUpgrade || this.restoreFWDB() && this.restoreAppDB(oldAppVersion))) {
                this.setFailedToUpgrade(this.getStandardFailedMessage(""));
                return;
            }
            if (!fwUpgrade && appUpgrade && !this.restoreAppDB(oldAppVersion)) {
                this.setFailedToUpgrade(this.getStandardFailedMessage(""));
                return;
            }
            FrameworkSettingsManager.getInstance().setPushToken("");
            VersionUpgradeActivity.removeUnviredPreferences((Context)this);
            AuthenticationService.setLoginSuccessful();
            Logger.i("Starting App Launch Activity");
            Intent intent = ((Activity)LoginParameters.getContext()).getIntent();
            intent.setFlags(335577088);
            LoginParameters.getContext().startActivity(intent);
            ((Activity)LoginParameters.getContext()).finishAffinity();
        }
        catch (DBException e) {
            this.setFailedToUpgrade(this.getStandardFailedMessage(e.getMessage()));
        }
        catch (Exception e) {
            this.setFailedToUpgrade(this.getStandardFailedMessage(e.getMessage()));
        }
    }

    private boolean reCreateFrameworkDB(String oldVersion) {
        try {
            String newVersion = FrameworkVersion.getFrameworkVersion();
            Logger.i("Framework will be upgraded");
            this.dropAppDatabase();
            this.dropFWDatabase();
            boolean isHybrid = RuntimeEngine.getInstance().isHTML5Framework();
            RuntimeEngine.destroy();
            ApplicationManager.destroy();
            FrameworkManager.destroy();
            FrameworkSettingsManager.destroy();
            UserSettingsManager.destroy();
            Logger.i("================================== Framework UPGRADED =========================");
            Logger.i("Framework has been upgraded From : " + oldVersion + " To: " + newVersion + ".");
            try {
                String keyToOpenDatabase = FrameworkHelper.getUniqueId();
                RuntimeEngine.getInstance().initialize(this.getApplicationContext(), LoginParameters.getAppName(), LoginParameters.getMetaData(), keyToOpenDatabase);
                if (isHybrid) {
                    RuntimeEngine.getInstance().setApplicationTypeAsHTML5();
                }
            }
            catch (DBException e) {
                Logger.e("DBException caught while initializing RuntimeEngine." + e.getMessage(), e);
            }
            catch (Exception e) {
                Logger.e("Exception caught while initializing RuntimeEngine." + e.getMessage(), e);
            }
            return true;
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reCreateApplicationDB(String oldVersion) {
        try {
            String newVersion = LoginParameters.getAppVersion();
            Logger.i("Application will be upgraded");
            String savePointName = Utils.getSavePointName();
            IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
            try {
                frameworkDataManager.createSavepoint(savePointName);
                frameworkDataManager.execute("UPDATE " + ApplicationMeta.TABLE_NAME + " SET " + ApplicationMeta.VERSION + "= NULL");
                frameworkDataManager.execute("DELETE FROM " + FieldMeta.TABLE_NAME);
                frameworkDataManager.execute("DELETE FROM " + BusinessEntityMeta.TABLE_NAME);
                frameworkDataManager.execute("DELETE FROM " + StructureMeta.TABLE_NAME);
                frameworkDataManager.execute("DELETE FROM " + InObject.TABLE_NAME);
                frameworkDataManager.execute("DELETE FROM " + SentItemObject.TABLE_NAME);
                frameworkDataManager.execute("DELETE FROM INFO_MESSAGE");
            }
            catch (DBException e) {
                frameworkDataManager.rollbackToSavepoint(savePointName);
                Logger.e("Error while resetting App version and clearing framework tables." + e.getMessage(), e);
            }
            finally {
                frameworkDataManager.releaseSavepoint(savePointName);
            }
            this.dropAppDatabase();
            boolean isHybrid = RuntimeEngine.getInstance().isHTML5Framework();
            RuntimeEngine.destroy();
            ApplicationManager.destroy();
            FrameworkManager.destroy();
            Logger.i("================================== Application UPGRADED =========================");
            Logger.i("Application has been upgraded From : " + oldVersion + " To: " + newVersion + ". Framework version remains same.");
            try {
                String keyToOpenDatabase = FrameworkHelper.getUniqueId();
                RuntimeEngine.getInstance().initialize(this.getApplicationContext(), LoginParameters.getAppName(), LoginParameters.getMetaData(), keyToOpenDatabase);
                if (isHybrid) {
                    RuntimeEngine.getInstance().setApplicationTypeAsHTML5();
                }
            }
            catch (DBException e) {
                Logger.e("DBException caught while initializing RuntimeEngine." + e.getMessage(), e);
            }
            catch (ApplicationException e) {
                Logger.e("ApplicationException caught while initializing RuntimeEngine." + e.getMessage(), e);
            }
            return true;
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
            return false;
        }
    }

    private void dropAppDatabase() {
        try {
            Logger.i("Closing application database");
            ApplicationManager.getInstance().closeDB();
            Logger.i("Deleting App database");
            String appDBPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.APP_DB_FILE);
            File applicationDatabaseFile = new File(appDBPath);
            boolean applicationDatabaseFileDeleteSuccess = false;
            if (applicationDatabaseFile.exists()) {
                applicationDatabaseFileDeleteSuccess = applicationDatabaseFile.delete();
            }
            if (applicationDatabaseFileDeleteSuccess) {
                Logger.i("Application database file delete success");
            } else {
                Logger.i("Application database file delete failure");
            }
        }
        catch (Exception exception) {
            Logger.e("Exception caught while resetting databases." + exception.getMessage(), exception);
        }
    }

    private void dropFWDatabase() {
        try {
            Logger.i("Closing Framework database");
            FrameworkManager.getInstance().closeDB();
            Logger.i("Deleting Framework database");
            String appDBPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.FW_DB_FILE);
            File applicationDatabaseFile = new File(appDBPath);
            boolean applicationDatabaseFileDeleteSuccess = false;
            if (applicationDatabaseFile.exists()) {
                applicationDatabaseFileDeleteSuccess = applicationDatabaseFile.delete();
            }
            if (applicationDatabaseFileDeleteSuccess) {
                Logger.i("Application database file delete success");
            } else {
                Logger.i("Application database file delete failure");
            }
        }
        catch (Exception exception) {
            Logger.e("Exception caught while resetting databases." + exception.getMessage(), exception);
        }
    }

    private boolean restoreFWDB() {
        try {
            Logger.i("Restoring FW DB");
            new DatabaseRestore(DatabaseRestore.DB_TYPE.FW_DB, 1, this.oldDBKey).restoreData();
            Logger.i("FW DB Restored");
            SharedPreferences sharedPrefs = LoginParameters.getContext().getSharedPreferences("VERSION_UPGRADE", 0);
            SharedPreferences.Editor editor = sharedPrefs.edit();
            editor.putBoolean("APP_DB_UPGRADE", true);
            editor.putBoolean("FW_DB_UPGRADE", false);
            editor.commit();
            return DatabaseHelper.deleteBackupFWDB();
        }
        catch (DBException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean restoreAppDB(String oldVersion) {
        try {
            Logger.i("Restoring App DB");
            new DatabaseRestore(DatabaseRestore.DB_TYPE.APP_DB, (int)Float.parseFloat(oldVersion), this.oldDBKey).restoreData();
            Logger.i("App DB Restored");
            return DatabaseHelper.deleteBackupAppDB();
        }
        catch (DBException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void getConfirmationDialogReset() {
        Button negativeButton;
        Button positiveButton;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)this.messageHelper.getValue(this.messageHelper.CONFIRMATION_RESET));
        builder.setPositiveButton((CharSequence)this.messageHelper.getValue(this.messageHelper.OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                VersionUpgradeActivity.removeUnviredPreferences(LoginParameters.getContext());
                DatabaseHelper.deleteBackupFWDB();
                DatabaseHelper.deleteBackupAppDB();
                NotificationListener notificationListener = SyncEngine.getInstance().getNotificationListener();
                FrameworkHelper.resetApplication(true);
                VersionUpgradeActivity.this.finish();
                if (notificationListener != null) {
                    notificationListener.notifyApplicationReset();
                }
            }
        });
        builder.setNegativeButton((CharSequence)this.messageHelper.getValue(this.messageHelper.CANCEL), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.setCancelable(false);
        alertDialog.setCanceledOnTouchOutside(false);
        if (!this.isFinishing()) {
            alertDialog.show();
        }
        if ((positiveButton = alertDialog.getButton(-1)) != null) {
            positiveButton.setTextColor(UITheme.getColorPrimary());
        }
        if ((negativeButton = alertDialog.getButton(-2)) != null) {
            negativeButton.setTextColor(UITheme.getDividerColor());
        }
    }

    private static void removeUnviredPreferences(Context context) {
        Logger.i("Removing upgrade preferences");
        SharedPreferences preferences = context.getSharedPreferences("VERSION_UPGRADE", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.clear();
        editor.commit();
        Logger.i("Removed upgrade preferences");
    }

    private void showInfo(boolean error, String message) {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).create();
        if (error) {
            alertDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_TITLE));
        } else {
            alertDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_TITLE));
        }
        alertDialog.setMessage((CharSequence)message);
        VersionUpgradeActivity.removeUnviredPreferences((Context)this);
        alertDialog.setButton(-1, (CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_BUTTON_OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        alertDialog.show();
        Button positiveButton = alertDialog.getButton(-1);
        if (positiveButton != null) {
            positiveButton.setTextColor(UITheme.getColorPrimary());
        }
    }

    private void enableAllFields() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (LoginParameters.isAutoUpgrade()) {
                    VersionUpgradeActivity.this.progressBar.setVisibility(8);
                    VersionUpgradeActivity.this.upgradeButton.setVisibility(0);
                    VersionUpgradeActivity.this.resetButton.setVisibility(8);
                } else {
                    VersionUpgradeActivity.this.progressBar.setVisibility(8);
                    VersionUpgradeActivity.this.upgradeButton.setVisibility(0);
                    VersionUpgradeActivity.this.resetButton.setVisibility(0);
                }
            }
        });
    }

    private void disableAllFields() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VersionUpgradeActivity.this.progressBar.setVisibility(0);
                VersionUpgradeActivity.this.upgradeButton.setVisibility(8);
                VersionUpgradeActivity.this.resetButton.setVisibility(8);
            }
        });
    }

    private void setFailedToUpgrade(final String errorMessage) {
        this.enableAllFields();
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (LoginParameters.isAutoUpgrade()) {
                    VersionUpgradeActivity.this.reset = true;
                    VersionUpgradeActivity.this.resetButton.setVisibility(8);
                    VersionUpgradeActivity.this.upgradeButton.setVisibility(0);
                    VersionUpgradeActivity.this.upgradeInfo.setText((CharSequence)Html.fromHtml((String)errorMessage));
                } else {
                    VersionUpgradeActivity.this.upgradeButton.setVisibility(8);
                    VersionUpgradeActivity.this.upgradeInfo.setText((CharSequence)Html.fromHtml((String)errorMessage));
                }
            }
        });
        if (loginListener != null) {
            loginListener.authenticateAndActivationFailure("");
        }
    }

    private String getStandardFailedMessage(String msg) {
        if (LoginParameters.isAutoUpgrade()) {
            return this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_FAILED_MESSAGE_STANDARD);
        }
        String message = this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_FAILED_MESSAGE_ONE);
        if (!Strings.isNullOrEmpty((String)msg)) {
            message = message + "<font color=\"#000000\"><b>Error:</b></font>" + msg;
        }
        message = message + "<br>Please contact developer.";
        message = message + this.messageHelper.getValue(this.messageHelper.VERSION_CHANGE_UPGRADE_FAILED_MESSAGE_TWO);
        return message;
    }
}

