/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.logger.Logger;
import com.unvired.login.AuthenticationResponse;
import com.unvired.login.AuthenticationService;
import com.unvired.login.IAuthenticationResponse;
import com.unvired.login.LoginListener;
import com.unvired.login.LoginParameters;
import com.unvired.login.MultipleFrontendUsersResponse;
import com.unvired.ui.LoginActivity;
import com.unvired.ui.LoginLocalActivity;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.TokenHelper;
import com.unvired.utils.UITheme;
import com.unvired.utils.uiutils.DonutProgress;
import java.util.Vector;

public class WaitingForTokenActivity
extends AppCompatActivity {
    private MessageHelper messageHelper = MessageHelper.getInstance();
    private TextView logSizeTextView;
    private AppCompatButton cancelButton;
    CountDownTimer countDownTimer;
    private DonutProgress countDownProgress;
    private ProgressDialog progressDialog;
    private Toolbar toolbar;
    private WaitingForTokenActivity waitingForTokenActivity;

    @SuppressLint(value={"NewApi"})
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        UITheme.applyTheme((Activity)this);
        this.waitingForTokenActivity = this;
        this.initViews();
        this.loadViews();
        this.startTimer();
    }

    private void initViews() {
        this.toolbar = UIStyle.getToolBar((Context)this);
        this.setSupportActionBar(this.toolbar);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WaitingForTokenActivity.this.onBackPressed();
            }
        });
        this.cancelButton = new AppCompatButton((Context)this);
        LinearLayout.LayoutParams buttonParams = new LinearLayout.LayoutParams(-1, UIStyle.dp48);
        buttonParams.setMargins(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp20);
        this.cancelButton.setLayoutParams((ViewGroup.LayoutParams)buttonParams);
        this.cancelButton.setBackgroundColor(UITheme.getColorPrimary());
        this.cancelButton.setTextColor(UITheme.getTextColor());
        this.cancelButton.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.CANCEL));
        this.cancelButton.setTypeface(null, 1);
        this.cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WaitingForTokenActivity.this.onBackPressed();
            }
        });
        this.logSizeTextView = UIStyle.getDetailLabelTextView((Context)this);
        this.logSizeTextView.setTextSize(16.0f);
        this.logSizeTextView.setLayoutParams(UIStyle.getLayoutParam());
        this.logSizeTextView.setPadding(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp20);
        this.logSizeTextView.setGravity(17);
        this.logSizeTextView.setText((CharSequence)this.messageHelper.getValue(this.messageHelper.WAITING_FOR_TOKEN));
        this.countDownProgress = new DonutProgress((Context)this);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)(UIStyle.getDensity() * 300.0f), (int)(UIStyle.getDensity() * 300.0f));
        params.gravity = 17;
        this.countDownProgress.setLayoutParams((ViewGroup.LayoutParams)params);
        this.countDownProgress.setFinishedStrokeWidth(UIStyle.dp8);
        this.countDownProgress.setFinishedStrokeColor(UITheme.getBackgroundColor());
        this.countDownProgress.setUnfinishedStrokeColor(UITheme.getColorPrimary());
        this.countDownProgress.setUnfinishedStrokeWidth(UIStyle.dp8);
        this.countDownProgress.setInnerBackgroundColor(-1);
        this.countDownProgress.setStartingDegree(270);
        this.countDownProgress.setInnerBottomTextSize(20.0f);
        this.countDownProgress.setTextColor(UITheme.getColorPrimary());
        this.countDownProgress.setTextSize(UIStyle.dp48);
        this.countDownProgress.setMax(300);
        this.countDownProgress.setProgress(300.0f);
        this.progressDialog = new ProgressDialog((Context)this.waitingForTokenActivity);
        this.progressDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.AUTHENTICATING));
        this.progressDialog.setCancelable(false);
        this.progressDialog.setCanceledOnTouchOutside(false);
    }

    private void loadViews() {
        LinearLayout homeLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        homeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        homeLayout.setOrientation(1);
        homeLayout.setBackgroundColor(-1);
        homeLayout.addView((View)this.toolbar);
        homeLayout.addView((View)this.logSizeTextView);
        homeLayout.addView((View)this.countDownProgress);
        homeLayout.addView((View)this.cancelButton);
        this.setContentView((View)homeLayout);
    }

    private void startTimer() {
        this.countDownTimer = new CountDownTimer(300000L, 1000L){

            public void onTick(long millisUntilFinished) {
                WaitingForTokenActivity.this.countDownProgress.setText(WaitingForTokenActivity.this.getRemainingTimeText(millisUntilFinished));
                WaitingForTokenActivity.this.countDownProgress.setProgress(300 - (int)millisUntilFinished / 1000);
            }

            public void onFinish() {
                TokenHelper.setData(null);
                WaitingForTokenActivity.this.onBackPressed();
            }
        };
        this.countDownTimer.start();
    }

    public void onBackPressed() {
        Intent intent = LoginParameters.getLoginMode() == LoginParameters.LOGIN_MODE.UNVIRED_ID_LOCAL_AUTH ? new Intent((Context)this, LoginLocalActivity.class) : new Intent((Context)this, LoginActivity.class);
        intent.setFlags(0x10000000);
        this.startActivity(intent);
        this.waitingForTokenActivity.finish();
    }

    public void onResume() {
        super.onResume();
    }

    public void onNewIntent(Intent intent) {
        if (intent.getStringExtra(this.messageHelper.AUTHENTICATE) != null) {
            this.handleLogin();
        }
    }

    private String getRemainingTimeText(long ms) {
        long sec = ms / 1000L;
        long min = sec / 60L;
        return "" + min + " m " + sec % 60L + " s";
    }

    private void handleLogin() {
        if (TokenHelper.getToken() == null || TokenHelper.getToken().isEmpty()) {
            TokenHelper.setData(null);
            Toast.makeText((Context)this, (CharSequence)this.messageHelper.getValue(this.messageHelper.TOKEN_EXPIRED), (int)1).show();
            return;
        }
        AuthenticationService.loginActivity = null;
        AuthenticationService.progressButton = null;
        LoginParameters.setUrl(TokenHelper.getUMP());
        LoginParameters.setCompany(TokenHelper.getCompany());
        LoginParameters.setUnviredUserId(TokenHelper.getEmail());
        LoginParameters.setUnviredPassword(null);
        LoginParameters.LOGIN_TYPE loginType = LoginParameters.getCurrentLoginType();
        switch (loginType) {
            case EMAIL: 
            case UNVIRED_ID: {
                LoginParameters.setUnviredIdCredentials(TokenHelper.getEmail(), null);
                break;
            }
            case ADS: 
            case SAP: {
                LoginParameters.setADSUserId(TokenHelper.getEmail());
                LoginParameters.setADSPassword(null);
                if (TokenHelper.getDomain() == null || TokenHelper.getDomain().isEmpty()) break;
                LoginParameters.setADSDomain(TokenHelper.getDomain());
            }
        }
        this.waitingForTokenActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WaitingForTokenActivity.this.progressDialog.show();
            }
        });
        switch (LoginParameters.getLoginMode()) {
            case UNVIRED_ID_LOCAL_AUTH: {
                new Thread(new ReAuthenticateThread()).start();
                break;
            }
            case UNVIRED_ID_AUTH_ACTIVATE: {
                new Thread(new AuthenticateAndActivateThread()).start();
                break;
            }
        }
    }

    private AlertDialog showInfo(boolean error, String message) {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this.waitingForTokenActivity).create();
        alertDialog.setCanceledOnTouchOutside(false);
        alertDialog.setCancelable(false);
        if (error) {
            alertDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_ALERT_TITLE));
        } else {
            alertDialog.setTitle((CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_TITLE));
        }
        alertDialog.setMessage((CharSequence)message);
        alertDialog.setButton(-1, (CharSequence)this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_DIALOG_BUTTON_OK), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                TokenHelper.setData(null);
                dialog.dismiss();
                WaitingForTokenActivity.this.waitingForTokenActivity.finish();
            }
        });
        alertDialog.show();
        Button button = alertDialog.getButton(-1);
        if (button != null) {
            button.setTextColor(UITheme.getColorPrimary());
        }
        return alertDialog;
    }

    private class ReAuthenticateThread
    implements Runnable {
        private String userId;

        public ReAuthenticateThread() {
            try {
                this.userId = UserSettingsManager.getInstance().getEmail();
            }
            catch (DBException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            AuthenticationResponse authenticationResponse = AuthenticationService.reAuthenticate(WaitingForTokenActivity.this.waitingForTokenActivity.getApplicationContext(), this.userId, null);
            String message = authenticationResponse.getMessage();
            final LoginListener loginListener = LoginParameters.getLoginListener();
            if (IAuthenticationResponse.RESPONSE_STATUS.SUCCESS == authenticationResponse.getResponseStatus()) {
                WaitingForTokenActivity.this.waitingForTokenActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (WaitingForTokenActivity.this.progressDialog != null) {
                            WaitingForTokenActivity.this.progressDialog.dismiss();
                        }
                        if (WaitingForTokenActivity.this.countDownTimer != null) {
                            WaitingForTokenActivity.this.countDownTimer.cancel();
                        }
                        if (loginListener != null) {
                            AuthenticationService.setLoginSuccessful();
                            LoginParameters.setUnviredPassword(null);
                            LoginParameters.setADSPassword(null);
                            LoginParameters.setMD5Password(null);
                            loginListener.loginSuccessful();
                        }
                        WaitingForTokenActivity.this.waitingForTokenActivity.finish();
                    }
                });
            } else {
                final String errorMessage = message == null || message.length() == 0 ? WaitingForTokenActivity.this.messageHelper.getValue(((WaitingForTokenActivity)WaitingForTokenActivity.this).messageHelper.LOGIN_ACTIVITY_CANNOT_AUTHENTICATE) + WaitingForTokenActivity.this.messageHelper.getValue(((WaitingForTokenActivity)WaitingForTokenActivity.this).messageHelper.LOGIN_ACTIVITY_CONTACT_ADMINISTRATOR) + WaitingForTokenActivity.this.messageHelper.getValue(((WaitingForTokenActivity)WaitingForTokenActivity.this).messageHelper.LOGIN_ACTIVITY_NO_VALID_ERROR) : message;
                WaitingForTokenActivity.this.waitingForTokenActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        WaitingForTokenActivity.this.progressDialog.dismiss();
                        if (WaitingForTokenActivity.this.countDownTimer != null) {
                            WaitingForTokenActivity.this.countDownTimer.cancel();
                        }
                        WaitingForTokenActivity.this.showInfo(true, errorMessage);
                    }
                });
                if (loginListener != null) {
                    loginListener.loginFailure(errorMessage);
                }
            }
        }
    }

    private class AuthenticateAndActivateThread
    implements Runnable {
        private boolean cancelled = false;
        MessageHelper messageHelper = MessageHelper.getInstance();
        private String customDeviceId = null;
        private String errorMessage = null;

        AuthenticateAndActivateThread() {
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            IAuthenticationResponse authenticationResponse = AuthenticationService.authenticateAndActivate(WaitingForTokenActivity.this.waitingForTokenActivity.getApplicationContext());
            if (authenticationResponse instanceof AuthenticationResponse) {
                if (!this.cancelled) {
                    this.handleAuthenticationResponse((AuthenticationResponse)authenticationResponse);
                }
            } else {
                String[] frontendIdStrings = null;
                MultipleFrontendUsersResponse multipleFrontendUsersResponse = (MultipleFrontendUsersResponse)authenticationResponse;
                Vector<String> frontendIds = multipleFrontendUsersResponse.getFrontendIds();
                int size = frontendIds.size();
                frontendIdStrings = new String[size];
                for (int i = 0; i < size; ++i) {
                    frontendIdStrings[i] = frontendIds.elementAt(i);
                }
                String[] finalFrontendIdStrings = frontendIdStrings;
                String customDeviceId = this.getUserPickedId(finalFrontendIdStrings);
                if (customDeviceId == null || customDeviceId.length() == 0) {
                    Logger.log(8, "", "", this.messageHelper.getValue(this.messageHelper.CUSTOM_ID_NOT_PICKED));
                    return;
                }
                LoginParameters.setDeviceId(customDeviceId);
                AuthenticationResponse authenticationResponseAfterSendingFEId = (AuthenticationResponse)AuthenticationService.authenticateAndActivate(WaitingForTokenActivity.this.waitingForTokenActivity.getApplicationContext());
                if (!this.cancelled) {
                    this.handleAuthenticationResponse(authenticationResponseAfterSendingFEId);
                }
            }
        }

        private void handleAuthenticationResponse(AuthenticationResponse authenticationResponse) {
            final LoginListener loginListener = LoginParameters.getLoginListener();
            switch (authenticationResponse.getResponseStatus()) {
                case SUCCESS: {
                    WaitingForTokenActivity.this.waitingForTokenActivity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (WaitingForTokenActivity.this.progressDialog != null) {
                                WaitingForTokenActivity.this.progressDialog.dismiss();
                            }
                            if (WaitingForTokenActivity.this.countDownTimer != null) {
                                WaitingForTokenActivity.this.countDownTimer.cancel();
                            }
                            if (loginListener != null) {
                                AuthenticationService.setLoginSuccessful();
                                if (!LoginParameters.getLoginScreenType().equals((Object)LoginParameters.LOGIN_SCREEN_TYPE.CUSTOM)) {
                                    WaitingForTokenActivity.this.waitingForTokenActivity.finish();
                                }
                                LoginParameters.setUnviredPassword(null);
                                LoginParameters.setADSPassword(null);
                                LoginParameters.setMD5Password(null);
                                loginListener.authenticateAndActivationSuccessful();
                            }
                        }
                    });
                    break;
                }
                default: {
                    this.errorMessage = authenticationResponse.getMessage();
                    if (this.errorMessage == null || this.errorMessage.length() == 0) {
                        this.errorMessage = this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_CANNOT_AUTHENTICATE) + this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_CONTACT_ADMINISTRATOR) + this.messageHelper.getValue(this.messageHelper.LOGIN_ACTIVITY_NO_VALID_ERROR);
                    }
                    WaitingForTokenActivity.this.waitingForTokenActivity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            WaitingForTokenActivity.this.progressDialog.dismiss();
                            if (WaitingForTokenActivity.this.countDownTimer != null) {
                                WaitingForTokenActivity.this.countDownTimer.cancel();
                            }
                            WaitingForTokenActivity.this.showInfo(true, AuthenticateAndActivateThread.this.errorMessage);
                        }
                    });
                    if (loginListener == null) break;
                    loginListener.authenticateAndActivationFailure(this.errorMessage);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getUserPickedId(final String[] frontendIdStrings) {
            final Thread dialogThread = Thread.currentThread();
            WaitingForTokenActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)WaitingForTokenActivity.this.waitingForTokenActivity);
                    builder.setTitle((CharSequence)AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.PICK_DEVICE));
                    LinearLayout layout2 = new LinearLayout((Context)WaitingForTokenActivity.this.waitingForTokenActivity);
                    layout2.setOrientation(1);
                    ListView lv = new ListView((Context)WaitingForTokenActivity.this.waitingForTokenActivity);
                    TextView label = new TextView((Context)WaitingForTokenActivity.this.waitingForTokenActivity);
                    label.setText((CharSequence)AuthenticateAndActivateThread.this.messageHelper.getValue(AuthenticateAndActivateThread.this.messageHelper.MULTIPLE_IDS_HAVE_BEEEN_MAPPED));
                    label.setPadding(UIStyle.dp16, UIStyle.dp16, UIStyle.dp16, UIStyle.dp16);
                    ArrayAdapter adapter = new ArrayAdapter((Context)WaitingForTokenActivity.this.waitingForTokenActivity, 0x1090009, (Object[])frontendIdStrings);
                    lv.setAdapter((ListAdapter)adapter);
                    layout2.addView((View)label);
                    builder.setView((View)layout2);
                    builder.setItems((CharSequence[])frontendIdStrings, new DialogInterface.OnClickListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onClick(DialogInterface dialog, int which) {
                            String id2 = frontendIdStrings[which];
                            int indexOfSeparator = id2.indexOf(":");
                            AuthenticateAndActivateThread.this.customDeviceId = id2.substring(indexOfSeparator + 2);
                            Thread thread = dialogThread;
                            synchronized (thread) {
                                dialogThread.notify();
                            }
                        }
                    });
                    AlertDialog dialog = builder.create();
                    dialog.setCancelable(false);
                    dialog.setCanceledOnTouchOutside(false);
                    dialog.show();
                }
            });
            Thread thread = dialogThread;
            synchronized (thread) {
                try {
                    dialogThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.customDeviceId;
        }
    }
}

