/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.unvired.database.DBException;
import com.unvired.exception.ApplicationException;
import com.unvired.login.AuthenticationService;
import com.unvired.login.UnviredAccount;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.IconHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import com.unvired.utils.UITheme;
import java.io.InputStream;
import java.util.List;

public class AccountsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static Activity activity;
    private static List<UnviredAccount> accountList;
    private static boolean isChooseAccount;
    private static LinearLayout.LayoutParams cardParam;
    private static PathManager pathManager;
    private static AccountsAdapter accountsAdapter;
    static Drawable selectedAccDraw;
    static Drawable deleteAccDraw;

    public AccountsAdapter(Activity activity, List<UnviredAccount> accountList, boolean isSwitchAccount) {
        accountsAdapter = this;
        AccountsAdapter.activity = activity;
        AccountsAdapter.accountList = accountList;
        isChooseAccount = isSwitchAccount;
        pathManager = PathManager.getInstance();
        cardParam = new LinearLayout.LayoutParams(-1, -2);
        cardParam.setMargins(8, 8, 8, 8);
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        LinearLayout layout2 = new LinearLayout((Context)activity);
        layout2.setOrientation(0);
        return new ViewHolder((View)layout2);
    }

    public void onBindViewHolder(ViewHolder viewHolder, int i) {
        TextView usernameTextView = viewHolder.username;
        TextView companyTextView = viewHolder.company;
        TextView serverUrlTextView = viewHolder.serverUrl;
        ImageView selectedAccountImageView = viewHolder.selectedAccountImageView;
        usernameTextView.setLongClickable(false);
        companyTextView.setLongClickable(false);
        serverUrlTextView.setLongClickable(false);
        final UnviredAccount unviredAccount = accountList.get(i);
        String userName = unviredAccount.getUserName();
        String company = unviredAccount.getCompany();
        String userId = unviredAccount.getServerUrl();
        if (userName != null && userName.length() > 0) {
            usernameTextView.setText((CharSequence)userName);
            usernameTextView.setVisibility(0);
        } else {
            usernameTextView.setVisibility(8);
        }
        if (company != null && company.length() > 0) {
            companyTextView.setText((CharSequence)company);
            companyTextView.setVisibility(0);
        } else {
            companyTextView.setVisibility(8);
        }
        if (userId != null && userId.length() > 0) {
            serverUrlTextView.setText((CharSequence)userId);
            serverUrlTextView.setVisibility(0);
        } else {
            serverUrlTextView.setVisibility(8);
        }
        if (!isChooseAccount && pathManager.getActiveAccountPath().contains(unviredAccount.getAccountPath())) {
            selectedAccountImageView.setVisibility(0);
        } else if (isChooseAccount) {
            selectedAccountImageView.setVisibility(8);
        } else {
            selectedAccountImageView.setImageDrawable(deleteAccDraw);
            selectedAccountImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AccountsAdapter.confirmationDialogDeleteAccount(unviredAccount);
                }
            });
        }
        viewHolder.textLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountsAdapter.onClick(unviredAccount);
            }
        });
        viewHolder.username.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountsAdapter.onClick(unviredAccount);
            }
        });
        viewHolder.company.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountsAdapter.onClick(unviredAccount);
            }
        });
        viewHolder.serverUrl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountsAdapter.onClick(unviredAccount);
            }
        });
    }

    private static void onClick(UnviredAccount unviredAccount) {
        try {
            if (isChooseAccount) {
                activity.finish();
                AuthenticationService.switchAccount(FrameworkHelper.getApplicationContext(), unviredAccount);
            } else {
                if (pathManager.getActiveAccountPath() != null && pathManager.getActiveAccountPath().contains(unviredAccount.getAccountPath())) {
                    return;
                }
                AccountsAdapter.confirmationDialogSwitchAccount(unviredAccount);
            }
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        if (accountList == null) {
            return 0;
        }
        return accountList.size();
    }

    protected static void confirmationDialogSwitchAccount(final UnviredAccount unviredAccount) {
        Button buttonNegative;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)("Are you sure want to switch to Account: " + unviredAccount.getCompany() + "/" + unviredAccount.getUserName()));
        builder.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                activity.finish();
                FrameworkHelper.shutdown();
                try {
                    AuthenticationService.switchAccount(FrameworkHelper.getApplicationContext(), unviredAccount);
                }
                catch (DBException e) {
                    e.printStackTrace();
                }
                catch (ApplicationException e) {
                    e.printStackTrace();
                }
            }
        });
        builder.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
        Button buttonPositive = alertDialog.getButton(-1);
        if (buttonPositive != null) {
            buttonPositive.setTextColor(UITheme.getColorPrimary());
        }
        if ((buttonNegative = alertDialog.getButton(-2)) != null) {
            buttonNegative.setTextColor(UITheme.getDividerColor());
        }
    }

    private static void confirmationDialogDeleteAccount(final UnviredAccount unviredAccount) {
        Button buttonNegative;
        if (pathManager.getActiveAccountPath() != null && pathManager.getActiveAccountPath().contains(unviredAccount.getAccountPath())) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setCancelable(true);
        builder.setMessage((CharSequence)("Are you sure want to delete Account: " + unviredAccount.getCompany() + "/" + unviredAccount.getUserName()));
        builder.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                unviredAccount.deleteAccount();
                accountList.remove(unviredAccount);
                accountsAdapter.notifyDataSetChanged();
            }
        });
        builder.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
        Button buttonPositive = alertDialog.getButton(-1);
        if (buttonPositive != null) {
            buttonPositive.setTextColor(UITheme.getColorPrimary());
        }
        if ((buttonNegative = alertDialog.getButton(-2)) != null) {
            buttonNegative.setTextColor(UITheme.getDividerColor());
        }
    }

    static {
        isChooseAccount = false;
        pathManager = null;
        selectedAccDraw = Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_action_done.png"), (String)"");
        deleteAccDraw = Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_action_delete.png"), (String)"");
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public TextView username;
        public TextView company;
        public TextView serverUrl;
        public LinearLayout textLayout;
        public ImageView selectedAccountImageView;

        public ViewHolder(View v) {
            super(v);
            LinearLayout mainLayout = (LinearLayout)v;
            mainLayout.setLayoutParams(UIStyle.getLayoutParam());
            this.selectedAccountImageView = UIStyle.getHomeIcons((Context)activity);
            this.selectedAccountImageView.setImageDrawable(selectedAccDraw);
            this.selectedAccountImageView.setLayoutParams(new ViewGroup.LayoutParams(UIStyle.dp32, UIStyle.dp32));
            LinearLayout selectedImageLayout = new LinearLayout((Context)activity);
            selectedImageLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            selectedImageLayout.setOrientation(0);
            selectedImageLayout.setGravity(8388629);
            selectedImageLayout.addView((View)this.selectedAccountImageView);
            this.textLayout = new LinearLayout((Context)activity);
            this.textLayout.setOrientation(1);
            this.textLayout.setPadding(UIStyle.dp16, UIStyle.dp16, 0, UIStyle.dp20);
            this.username = UIStyle.getListFirstRowTextView((Context)activity);
            this.company = UIStyle.getListOtherRowTextView((Context)activity);
            this.serverUrl = UIStyle.getListOtherRowTextView((Context)activity);
            this.textLayout.addView((View)this.username);
            this.textLayout.addView((View)this.company);
            this.textLayout.addView((View)this.serverUrl);
            LinearLayout contentLayout = new LinearLayout((Context)activity);
            contentLayout.setLayoutParams(UIStyle.getLayoutParam());
            contentLayout.setOrientation(0);
            contentLayout.addView((View)this.textLayout);
            contentLayout.addView((View)selectedImageLayout);
            CardView accountCardView = UIStyle.getCardView((Context)activity);
            accountCardView.addView((View)contentLayout);
            mainLayout.addView((View)accountCardView, (ViewGroup.LayoutParams)cardParam);
        }
    }
}

