/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui.adapter;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.common.base.Strings;
import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.logger.Logger;
import com.unvired.model.InfoMessage;
import com.unvired.ui.InfoMessageDetailsActivity;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.IconHelper;
import com.unvired.ui.resources.MessageHelper;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.UIConstants;
import java.io.InputStream;
import java.util.List;

public class InfoMessageAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<InfoMessage> errorDataList = null;
    private static Activity activity;

    public InfoMessageAdapter(Activity activity, List<InfoMessage> errorDataList) {
        InfoMessageAdapter.activity = activity;
        this.errorDataList = errorDataList;
    }

    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        LinearLayout layout2 = new LinearLayout((Context)activity);
        layout2.setOrientation(0);
        return new ViewHolder((View)layout2);
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
        ImageView statusImage = viewHolder.statusImage;
        TextView messageText = viewHolder.messageText;
        TextView beName = viewHolder.beName;
        TextView date = viewHolder.date;
        TextView gid = viewHolder.gid;
        final InfoMessage infoMessage = this.errorDataList.get(i);
        if (infoMessage != null) {
            String categoryValue = infoMessage.getCategory();
            String messageValue = infoMessage.getMessage();
            Object gidValue = null;
            Long dateValue = infoMessage.getTimeStamp();
            String beNameValue = infoMessage.getBeName();
            if (categoryValue != null && categoryValue.length() > 0) {
                if ("FAILURE".equalsIgnoreCase(categoryValue)) {
                    statusImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_alert_error.png"), (String)""));
                } else {
                    statusImage.setImageDrawable(Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_alert_info.png"), (String)""));
                }
            }
            if (messageValue != null && messageValue.length() > 0) {
                messageText.setText((CharSequence)messageValue);
            }
            if (beNameValue != null && beNameValue.length() > 0) {
                beName.setText((CharSequence)("BE: " + beNameValue));
            }
            if (dateValue != null) {
                String d = FrameworkHelper.getDateString(dateValue);
                d = d.substring(0, 10);
                date.setText((CharSequence)d);
            }
            gid.setText((CharSequence)(Strings.isNullOrEmpty((String)infoMessage.getBeLid()) ? "" : "LID: " + infoMessage.getBeLid()));
        }
        viewHolder.mainLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InfoMessageAdapter.onClick(infoMessage);
            }
        });
        viewHolder.messageText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InfoMessageAdapter.onClick(infoMessage);
            }
        });
        viewHolder.gid.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InfoMessageAdapter.onClick(infoMessage);
            }
        });
        viewHolder.mainLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                builder.setTitle((CharSequence)"Action");
                CharSequence[] acctTypes = new String[]{"Delete"};
                builder.setItems(acctTypes, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        FrameworkManager frameworkManager = FrameworkManager.getInstance();
                        IDataManager dataManager = frameworkManager.getDataManager();
                        try {
                            if (infoMessage != null) {
                                dataManager.delete(infoMessage);
                            }
                        }
                        catch (DBException dbException) {
                            Logger.log(8, this.getClass().getName(), "onDeleteInfoMessage", dbException.getMessage());
                            return;
                        }
                        int position = InfoMessageAdapter.this.errorDataList.indexOf(infoMessage);
                        InfoMessageAdapter.this.notifyItemRemoved(position);
                        InfoMessageAdapter.this.errorDataList.remove(position);
                    }
                });
                builder.create().show();
                return true;
            }
        });
    }

    public int getItemCount() {
        return this.errorDataList.size();
    }

    private static void onClick(final InfoMessage infoMessage) {
        MessageHelper messageHelper = MessageHelper.getInstance();
        final ProgressDialog progressDialog = ProgressDialog.show((Context)activity, (CharSequence)"", (CharSequence)messageHelper.getValue(messageHelper.MESSAGE_WAIT), (boolean)true);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        com.unvired.utils.Context.getInstance().add(UIConstants.SELECTED_INFO_MESSAGE_OBJECT, infoMessage);
                        Intent intent = new Intent((Context)activity, InfoMessageDetailsActivity.class);
                        activity.startActivity(intent);
                        progressDialog.dismiss();
                    }
                });
            }
        });
        t.start();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView statusImage;
        public TextView messageText;
        public TextView beName;
        public TextView date;
        public TextView gid;
        public LinearLayout mainLayout;

        public ViewHolder(View v) {
            super(v);
            this.mainLayout = (LinearLayout)v;
            this.mainLayout.setPadding(UIStyle.dp16, 0, 0, 0);
            LinearLayout textLayout = new LinearLayout((Context)activity);
            textLayout.setLayoutParams(UIStyle.getLayoutParam());
            textLayout.setOrientation(1);
            textLayout.setPadding(0, UIStyle.dp16, UIStyle.dp16, UIStyle.dp20);
            this.messageText = UIStyle.getListFirstRowTextView((Context)activity);
            this.beName = UIStyle.getListOtherRowTextView((Context)activity);
            this.date = UIStyle.getListOtherRowTextView((Context)activity);
            this.gid = UIStyle.getListOtherRowTextView((Context)activity);
            this.beName.setGravity(8388627);
            this.date.setGravity(8388629);
            FrameLayout beAndDateLayout = new FrameLayout((Context)activity);
            beAndDateLayout.setLayoutParams(UIStyle.getLayoutParam());
            beAndDateLayout.addView((View)this.gid);
            beAndDateLayout.addView((View)this.date);
            textLayout.addView((View)this.messageText);
            textLayout.addView((View)beAndDateLayout);
            textLayout.addView((View)this.beName);
            LinearLayout iconLayout = new LinearLayout((Context)activity);
            iconLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(UIStyle.dp56, -1));
            iconLayout.setOrientation(1);
            iconLayout.setGravity(8388627);
            this.statusImage = UIStyle.getHomeIcons((Context)activity);
            this.statusImage.setColorFilter(null);
            iconLayout.addView((View)this.statusImage);
            this.mainLayout.addView((View)iconLayout);
            this.mainLayout.addView((View)textLayout);
        }
    }
}

