/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v7.widget.AppCompatCheckBox;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.unvired.model.InitialURL;
import com.unvired.ui.UIStyle;
import com.unvired.utils.UITheme;
import java.util.Vector;

@SuppressLint(value={"NewApi"})
public class LoginURLAdapter
extends ArrayAdapter<InitialURL> {
    private InitialURL initialURL = null;
    private TextView description = null;
    private TextView url = null;
    private AppCompatCheckBox checkBox = null;
    private Context context;

    public LoginURLAdapter(Context context, Vector<InitialURL> listOfURLs) {
        super(context, 0, listOfURLs);
        this.context = context;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View activityView = convertView;
        this.initialURL = (InitialURL)this.getItem(position);
        LinearLayout mainLayout = new LinearLayout(this.getContext());
        AbsListView.LayoutParams mainParams = new AbsListView.LayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        mainLayout.setLayoutParams((ViewGroup.LayoutParams)mainParams);
        mainLayout.setOrientation(1);
        if (Build.VERSION.SDK_INT >= 11) {
            TypedArray a = this.context.obtainStyledAttributes(new int[]{16843517});
            int resource = a.getResourceId(0, 0);
            a.recycle();
            mainLayout.setBackground(this.context.getResources().getDrawable(resource));
        }
        this.description = UIStyle.getListFirstRowTextView(this.context);
        this.url = UIStyle.getListOtherRowTextView(this.context);
        this.checkBox = new AppCompatCheckBox(this.context);
        this.checkBox.setSupportButtonTintList(ColorStateList.valueOf((int)UITheme.getColorPrimary()));
        this.description.setTextIsSelectable(false);
        this.url.setTextIsSelectable(false);
        if (this.initialURL != null) {
            String descriptionValue = this.initialURL.getDescription();
            String urlValue = this.initialURL.getAddress();
            boolean isDefaultURL = this.initialURL.isDefault();
            if (descriptionValue != null && descriptionValue.length() > 0) {
                this.description.setText((CharSequence)descriptionValue);
            }
            if (urlValue != null && urlValue.length() > 0) {
                this.url.setText((CharSequence)urlValue);
            }
            this.checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    buttonView.setChecked(true);
                }
            });
            String selectedURL = (String)com.unvired.utils.Context.getInstance().get("SELECTED_URL");
            if (urlValue.equalsIgnoreCase(selectedURL)) {
                this.checkBox.setChecked(true);
                this.checkBox.setVisibility(0);
            } else {
                this.checkBox.setVisibility(8);
            }
        }
        LinearLayout itemLayout = new LinearLayout(this.context);
        itemLayout.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        itemLayout.setOrientation(1);
        itemLayout.addView((View)this.description);
        itemLayout.addView((View)this.url);
        LinearLayout checkBoxLayout = new LinearLayout(this.context);
        checkBoxLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        checkBoxLayout.setOrientation(0);
        checkBoxLayout.setGravity(8388629);
        checkBoxLayout.addView((View)this.checkBox);
        LinearLayout contentLayout = new LinearLayout(this.context);
        contentLayout.setLayoutParams(UIStyle.getLayoutParam());
        contentLayout.setPadding(0, UIStyle.dp16, 0, 0);
        contentLayout.setOrientation(0);
        contentLayout.addView((View)itemLayout);
        contentLayout.addView((View)checkBoxLayout);
        mainLayout.addView((View)contentLayout);
        return mainLayout;
    }
}

