/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.unvired.ui.SystemCredential;
import com.unvired.ui.UIStyle;

public class SystemCredentialsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static Activity activity;
    private com.unvired.model.SystemCredential[] systemCredentials;

    public SystemCredentialsAdapter(Activity activity, com.unvired.model.SystemCredential[] systemCredentials) {
        SystemCredentialsAdapter.activity = activity;
        this.systemCredentials = systemCredentials;
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        LinearLayout layout2 = new LinearLayout((Context)activity);
        layout2.setOrientation(0);
        return new ViewHolder((View)layout2);
    }

    public void onBindViewHolder(ViewHolder viewHolder, int i) {
        TextView sysDescValue = viewHolder.sysDescValue;
        TextView portDescValue = viewHolder.portDescValue;
        TextView userIdValue = viewHolder.userIdValue;
        LinearLayout statusLayout = viewHolder.statusLayout;
        final com.unvired.model.SystemCredential systemCredential = this.systemCredentials[i];
        String sysDesc = systemCredential.getSystemDesc();
        String portDesc = systemCredential.getPortDesc();
        String userId = systemCredential.getUserId();
        String password = systemCredential.getPassword();
        if (sysDesc != null && sysDesc.length() > 0) {
            sysDescValue.setText((CharSequence)sysDesc);
            sysDescValue.setVisibility(0);
        } else {
            sysDescValue.setVisibility(8);
        }
        if (portDesc != null && portDesc.length() > 0) {
            portDescValue.setText((CharSequence)portDesc);
            portDescValue.setVisibility(0);
        } else {
            portDescValue.setVisibility(8);
        }
        if (userId != null && userId.length() > 0) {
            userIdValue.setText((CharSequence)userId);
            userIdValue.setVisibility(0);
        } else {
            userIdValue.setVisibility(8);
        }
        if (userIdValue == null || userIdValue.length() <= 0 || password == null || password.length() <= 0) {
            statusLayout.setBackgroundColor(Color.rgb((int)255, (int)169, (int)0));
        } else {
            statusLayout.setBackgroundColor(Color.rgb((int)0, (int)167, (int)83));
        }
        viewHolder.mainLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                com.unvired.utils.Context.getInstance().add("SYSTEM_CREDENTIAL_SELECTED", systemCredential);
                Intent intent = new Intent((Context)activity, SystemCredential.class);
                activity.startActivity(intent);
            }
        });
    }

    public int getItemCount() {
        return this.systemCredentials.length;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public TextView sysDescValue;
        public TextView portDescValue;
        public TextView userIdValue;
        public LinearLayout mainLayout;
        public LinearLayout statusLayout;

        public ViewHolder(View v) {
            super(v);
            this.mainLayout = (LinearLayout)v;
            this.mainLayout.setLayoutParams(UIStyle.getLayoutParam());
            LinearLayout textLayout = new LinearLayout((Context)activity);
            textLayout.setOrientation(1);
            textLayout.setPadding(UIStyle.dp16, UIStyle.dp16, 0, UIStyle.dp20);
            this.sysDescValue = UIStyle.getListFirstRowTextView((Context)activity);
            this.portDescValue = UIStyle.getListOtherRowTextView((Context)activity);
            this.userIdValue = UIStyle.getListOtherRowTextView((Context)activity);
            textLayout.addView((View)this.sysDescValue);
            textLayout.addView((View)this.portDescValue);
            textLayout.addView((View)this.userIdValue);
            this.statusLayout = new LinearLayout((Context)activity);
            this.statusLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(UIStyle.dp4, -1));
            this.statusLayout.setOrientation(1);
            this.mainLayout.addView((View)this.statusLayout);
            this.mainLayout.addView((View)textLayout);
        }
    }
}

