/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.ui.controller;

import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.model.InfoMessage;
import java.util.ArrayList;
import java.util.List;

public class InfoMessageHelper {
    public static List<InfoMessage> getAllInfoMessages() {
        ArrayList<InfoMessage> infoMessageList = new ArrayList<InfoMessage>();
        IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
        if (dataManager == null) {
            return infoMessageList;
        }
        try {
            IDataStructure[] dataStructure = dataManager.get("INFO_MESSAGE", new String[]{"TIME_STAMP"});
            if (dataStructure != null) {
                for (IDataStructure structure : dataStructure) {
                    infoMessageList.add((InfoMessage)structure);
                }
            }
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
        }
        return infoMessageList;
    }

    public static List<InfoMessage> getAllInfoMessages(String beLid) {
        ArrayList<InfoMessage> infoMessageList = new ArrayList<InfoMessage>();
        IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
        if (dataManager == null) {
            return infoMessageList;
        }
        try {
            IDataStructure[] dataStructure = dataManager.get("INFO_MESSAGE", "BE_LID = '" + beLid + "'", new String[]{"TIME_STAMP"});
            if (dataStructure != null) {
                for (IDataStructure structure : dataStructure) {
                    infoMessageList.add((InfoMessage)structure);
                }
            }
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
        }
        return infoMessageList;
    }

    public static void deleteAllInfoMessages() {
        FrameworkManager frameworkManager = FrameworkManager.getInstance();
        IDataManager dataManager = frameworkManager.getDataManager();
        try {
            dataManager.delete("INFO_MESSAGE");
        }
        catch (DBException dbException) {
            Logger.e(dbException.getMessage());
        }
    }

    public static int countAllInfoMessages() {
        IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
        if (dataManager == null) {
            return 0;
        }
        try {
            return dataManager.count("INFO_MESSAGE", null);
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
            return 0;
        }
    }

    public static int countErrorInfoMessages() {
        IDataManager dataManager = FrameworkManager.getInstance().getDataManager();
        if (dataManager == null) {
            return 0;
        }
        try {
            return dataManager.count("INFO_MESSAGE", "CATEGORY = 'FAILURE'");
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
            return 0;
        }
    }
}

