/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.sync.SyncConstants;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.response.HTTPResponse;
import com.unvired.utils.AppUpgradeInfo;
import com.unvired.utils.FrameworkHelper;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AppUpgradeManager {
    public static AppUpgradeInfo checkForAppUpgrade() {
        AppUpgradeInfo appUpgradeInfo;
        block10: {
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            String serverId = null;
            try {
                serverId = FrameworkSettingsManager.getInstance().getServerId();
            }
            catch (DBException e) {
                Logger.log(8, AppUpgradeManager.class.getSimpleName(), "AppUpgradeManager", "Error while retrieving Server Id from FrameworkSetting." + e.getMessage());
            }
            appUpgradeInfo = new AppUpgradeInfo();
            try {
                Document document = FrameworkHelper.getSenderDocumentRoot(9000, null, serverId, applicationManager.getApplicationName(), applicationManager.getApplicationId());
                Element root = document.getDocumentElement();
                Element initialDataRequestDataElement = document.createElement("data");
                initialDataRequestDataElement.setAttribute("subtype", String.valueOf(1300));
                root.appendChild(initialDataRequestDataElement);
                Element versionElement = document.createElement("CurrentVersion");
                initialDataRequestDataElement.appendChild(versionElement);
                String namespace = applicationManager.getApplicationMeta().getVersion();
                versionElement.appendChild(document.createTextNode(namespace));
                String xmlString = "";
                try {
                    xmlString = FrameworkHelper.getString(document);
                }
                catch (ApplicationException applicationException) {
                    Logger.log(8, AppUpgradeManager.class.getSimpleName(), "handleLogRequest", "ApplicationException caught while getting string from document, " + applicationException.getMessage());
                }
                String xml = xmlString;
                try {
                    HTTPResponse httpResponse = HTTPConnection.postDirect("ADMIN_SERVICES", String.valueOf(9000), String.valueOf(1300), SyncConstants.MESSAGE_REQUEST_TYPE.RQST, xml, applicationManager.getApplicationName(), null, null);
                    byte[] responseBytes = httpResponse.getResponseBytes();
                    appUpgradeInfo.setCurrentVersion(applicationManager.getApplicationMeta().getVersion());
                    if (httpResponse.getResponseCode() == 200 && responseBytes != null) {
                        String response = new String(responseBytes);
                        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                        Document doc = dBuilder.parse(new InputSource(new ByteArrayInputStream(response.getBytes("utf-8"))));
                        Element element = doc.getDocumentElement();
                        element.normalize();
                        NodeList nList = doc.getElementsByTagName("data");
                        if (nList != null && nList.getLength() > 0) {
                            Node node = nList.item(0);
                            Element element2 = (Element)node;
                            String newVersion = AppUpgradeManager.getValue("NewVersion", element2);
                            appUpgradeInfo.setNewVersion(newVersion);
                            String url = AppUpgradeManager.getValue("URL", element2);
                            appUpgradeInfo.setDownloadURL(url);
                        }
                        break block10;
                    }
                    appUpgradeInfo.setErrorMessage(httpResponse.getErrorMessage());
                }
                catch (Exception domException) {
                    Logger.e("DOMException caught while created data dump request for server, " + domException.getMessage(), domException);
                }
            }
            catch (Exception e) {
                Logger.e("DOMException caught while created data dump request for server, " + e.getMessage(), e);
            }
        }
        return appUpgradeInfo;
    }

    private static String getValue(String tag, Element element) {
        NodeList nodeList = element.getElementsByTagName(tag).item(0).getChildNodes();
        Node node = nodeList.item(0);
        return node.getNodeValue();
    }
}

