/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import com.google.common.base.Strings;
import com.unvired.database.DBException;
import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.model.DataStructure;
import com.unvired.model.JSAttachmentItem;
import com.unvired.model.JSDataStructure;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataStructureHelper {
    public static IDataStructure getDataStructureFromJSON(JSONArray data) throws DBException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        JSONObject dataObj = null;
        String tableName = null;
        boolean isHeader = true;
        DataStructure dataStructure = null;
        Hashtable<Object, Object> colNameValuePair = new Hashtable();
        try {
            dataObj = new JSONObject(data.getString(0).toString());
            tableName = dataObj.getString("tableName");
            isHeader = Boolean.valueOf(dataObj.getString("isHeader"));
            colNameValuePair = DataStructureHelper.getHashTableFromJson(dataObj.getJSONObject("fields"));
            dataStructure = !isHeader && tableName.toLowerCase().endsWith("_attachment") ? new JSAttachmentItem(tableName) : new JSDataStructure(tableName, isHeader);
            dataStructure.setField("tableName", tableName);
            Enumeration<Object> en = colNameValuePair.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = (String)colNameValuePair.get(key);
                try {
                    if (value == null) continue;
                    dataStructure.setField(key, value);
                }
                catch (Exception e) {
                    Logger.log(8, DataStructureHelper.class.getName(), "GetJSONFromDataStructure", "Unable to setField in HashTable " + e.getMessage());
                }
            }
        }
        catch (JSONException e) {
            Logger.log(8, DataStructureHelper.class.getName(), "GetJSONFromDataStructure", "Error in parsing json for Table Name and HashTable" + e.getMessage());
        }
        return dataStructure;
    }

    public static JSONArray getJSONFromDataStructures(IDataStructure[] dataStructureArray) {
        JSONArray jsonDataStructureArray = new JSONArray();
        for (IDataStructure dataStructure : dataStructureArray) {
            JSONObject jsonDataStructure = DataStructureHelper.getJSONFromDataStructure(dataStructure);
            jsonDataStructureArray.put((Object)jsonDataStructure);
        }
        return jsonDataStructureArray;
    }

    public static JSONObject getJSONFromDataStructure(IDataStructure dataStructure) {
        JSONObject jsonDataStructure = new JSONObject();
        JSONObject jsonFieldObject = new JSONObject();
        try {
            jsonDataStructure.put("tableName", (Object)dataStructure.getTableName());
            jsonDataStructure.put("isHeader", dataStructure.isHeader());
        }
        catch (JSONException e) {
            Logger.log(8, DataStructureHelper.class.getName(), "GetJSONFromDataStructure", "Table name and iaHeader not found in DataStructure Array: " + e.getMessage());
        }
        Enumeration<String> en = dataStructure.getFieldNames();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            String value = String.valueOf(dataStructure.getField(key));
            try {
                if (!Strings.isNullOrEmpty((String)value) && !"null".equalsIgnoreCase(value)) {
                    jsonFieldObject.put(key, (Object)value);
                    continue;
                }
                jsonFieldObject.put(key, (Object)"");
            }
            catch (JSONException e) {
                Logger.log(8, DataStructureHelper.class.getName(), "GetJSONFromDataStructure", "Error in JSONObject value setting: " + e.getMessage());
            }
        }
        try {
            jsonDataStructure.put("fields", (Object)jsonFieldObject);
        }
        catch (JSONException e) {
            Logger.log(8, DataStructureHelper.class.getName(), "GetJSONFromDataStructure", "Error in putting JSON filesObject in JSON fielsArray: " + e.getMessage());
        }
        return jsonDataStructure;
    }

    public static IDataStructure createJSDataStructure(JSONObject data, String tableName, boolean isHeader) {
        DataStructure dataStructure = null;
        try {
            dataStructure = !isHeader && tableName.toLowerCase().endsWith("_attachment") ? new JSAttachmentItem(tableName) : new JSDataStructure(tableName, isHeader);
            if (data == null) {
                return null;
            }
            Iterator i = data.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = data.getString(key);
                if ("OBJECT_STATUS".equalsIgnoreCase(key)) {
                    if (Strings.isNullOrEmpty((String)value)) {
                        value = "0";
                    }
                    IDataStructure.OBJECT_STATUS objStatus = IDataStructure.OBJECT_STATUS.values()[Integer.parseInt(value)];
                    dataStructure.setObjectStatus(objStatus);
                    continue;
                }
                if (value == null) continue;
                dataStructure.setField(key, value);
            }
        }
        catch (DBException e) {
            Logger.log(8, DataStructureHelper.class.getName(), "createJSDataStructure", "Error in getting key/value from JSON for HashTable: " + e.getMessage());
        }
        catch (JSONException e) {
            Logger.log(8, DataStructureHelper.class.getName(), "createJSDataStructure", "Error in Setting key/value to JSDataStructure from HashTable: " + e.getMessage());
        }
        return dataStructure;
    }

    public static Hashtable<String, String> getHashTableFromJson(JSONObject fieldObj) {
        Hashtable<String, String> colNameValuePair = new Hashtable<String, String>();
        String colName = null;
        String colValue = null;
        try {
            Iterator it = fieldObj.keys();
            while (it.hasNext()) {
                colName = it.next().toString();
                colValue = fieldObj.getString(colName);
                if (colValue == null) continue;
                colNameValuePair.put(colName, colValue);
            }
        }
        catch (JSONException e) {
            Logger.log(8, DataStructureHelper.class.getName(), "GetJSONFromDataStructure", "Error in getting key/value from JSON for HashTable: " + e.getMessage());
        }
        return colNameValuePair;
    }

    public static JSDataStructure[] getHeaderDataStructure(String tableName, JSONArray data) throws DBException {
        JSDataStructure[] dataStructureArray = new JSDataStructure[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            JSDataStructure dataStructure = new JSDataStructure(tableName, true);
            JSONObject curObj = null;
            try {
                curObj = data.getJSONObject(i);
                HashMap<String, String> headerMap = new HashMap<String, String>();
                Iterator iter = curObj.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = curObj.getString(key);
                    if (value == null) continue;
                    headerMap.put(key, value);
                }
                for (Map.Entry entry : headerMap.entrySet()) {
                    dataStructure.setField((String)entry.getKey(), entry.getValue());
                }
                dataStructureArray[i] = dataStructure;
                continue;
            }
            catch (JSONException e) {
                Logger.log(8, DataStructureHelper.class.getName(), "getHeaderDataStructure", "Error in getting key/value from JSON for generate Header HashTable: " + e.getMessage());
            }
        }
        return dataStructureArray;
    }

    public static String getWhereClauseFromData(JSONObject dataObj) throws Exception {
        if (!dataObj.has("whereClause")) {
            return null;
        }
        Object whereClause = dataObj.get("whereClause");
        if (whereClause instanceof String) {
            return whereClause.toString();
        }
        if (whereClause instanceof JSONObject) {
            return DataStructureHelper.getWhereClauseStringFromJson((JSONObject)whereClause);
        }
        return null;
    }

    public static String getWhereClauseStringFromJson(JSONObject jsonObject) {
        Hashtable<String, String> keyValuePair = DataStructureHelper.getHashTableFromJson(jsonObject);
        Enumeration<String> keysForParameters = keyValuePair.keys();
        Vector<String> fieldNames = new Vector<String>();
        while (keysForParameters.hasMoreElements()) {
            fieldNames.addElement(keysForParameters.nextElement());
        }
        int fieldCount = fieldNames.size();
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = (String)fieldNames.get(i);
            values[i] = keyValuePair.get(fieldName);
        }
        return DataStructureHelper.prepareWhereClause(fieldNames, values);
    }

    private static String prepareWhereClause(Vector<String> tableColumnNames, Object[] tableColumnValues) {
        String query = "";
        int noOfColumns = 0;
        if (tableColumnNames != null) {
            noOfColumns = tableColumnNames.size();
        }
        for (int i = 0; i < noOfColumns; ++i) {
            query = i == 0 ? query + tableColumnNames.get(i) + " = '" + tableColumnValues[i] + "' " : query + " AND " + tableColumnNames.get(i) + " = '" + tableColumnValues[i] + "' ";
        }
        return query;
    }
}

