/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.database.IDataStructure;
import com.unvired.exception.ApplicationException;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.login.UnviredAccount;
import com.unvired.parser.UBXMLParser;
import com.unvired.sync.SyncEngine;
import com.unvired.utils.FrameworkHelper;
import com.unvired.utils.PathManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DemoHelper {
    private static void importData(InputStream demoDataInputStream) throws Exception {
        if (demoDataInputStream == null) {
            return;
        }
        try {
            UBXMLParser ibxmlParser = new UBXMLParser(FrameworkHelper.getBytes(demoDataInputStream), null);
            IDataManager applicationDataManager = ApplicationManager.getInstance().getDataManager();
            Hashtable<String, Hashtable<IDataStructure, Vector<IDataStructure>>> bes = ibxmlParser.getData();
            Enumeration<String> keys = bes.keys();
            applicationDataManager.beginTransaction();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Hashtable<IDataStructure, Vector<IDataStructure>> currentBE = bes.get(key);
                Enumeration<IDataStructure> currentKeys = currentBE.keys();
                while (currentKeys.hasMoreElements()) {
                    IDataStructure header = currentKeys.nextElement();
                    Vector<IDataStructure> items = currentBE.get(header);
                    header.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                    applicationDataManager.insert(header);
                    if (items == null) continue;
                    String headerLid = header.getLid();
                    for (int i = 0; i < items.size(); ++i) {
                        IDataStructure item = items.elementAt(i);
                        item.setFid(headerLid);
                        item.setObjectStatus(IDataStructure.OBJECT_STATUS.GLOBAL);
                        applicationDataManager.insert(item);
                    }
                }
            }
            applicationDataManager.endTransaction();
        }
        catch (DBException e) {
            String error = "DB Exception while inserting data to database: " + e.getMessage();
            Logger.e(error, e);
            throw new Exception(error);
        }
        catch (ApplicationException e) {
            String error = "Application Exception while inserting data to database: " + e.getMessage();
            Logger.e(error, e);
            throw new Exception(error);
        }
    }

    public static void initializeDemoMode(String demoData) throws Exception {
        ByteArrayInputStream demoDataInputStream = new ByteArrayInputStream(demoData.getBytes());
        RuntimeEngine runtimeEngine = RuntimeEngine.getInstance();
        UnviredAccount unviredAccount = new UnviredAccount("demo", "UNVIRED", LoginParameters.getUrl());
        PathManager.getInstance().setActiveAccount(unviredAccount);
        String keyToOpenDatabase = FrameworkHelper.getUniqueId();
        runtimeEngine.initializeFramework(FrameworkHelper.getApplicationContext(), LoginParameters.getAppName(), keyToOpenDatabase);
        FrameworkSettingsManager frameworkSettingsManager = FrameworkSettingsManager.getInstance();
        frameworkSettingsManager.setActId("demo");
        frameworkSettingsManager.setCompanyAlias("UNVIRED");
        frameworkSettingsManager.setDemo(true);
        frameworkSettingsManager.setFEAdapterName("demo");
        frameworkSettingsManager.setFEAdapterType("demo");
        frameworkSettingsManager.setFEUserIDIdentifier("demo");
        frameworkSettingsManager.setFrontEndUserId("demo");
        frameworkSettingsManager.setLocalPassword("false");
        frameworkSettingsManager.setLogLevel(Logger.getDefaultLogLevel());
        frameworkSettingsManager.setNamespace("UNVIRED");
        frameworkSettingsManager.setServerId("demo");
        frameworkSettingsManager.setServerType("demo");
        frameworkSettingsManager.setUrl("http://demo.unviredcloud.com/UNI/");
        UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
        userSettingsManager.setServerUrl(LoginParameters.getUrl());
        userSettingsManager.setUnviredUserId("demo");
        userSettingsManager.setUnviredPassword("demo");
        userSettingsManager.setCompanyAlias("UNVIRED");
        userSettingsManager.setDeviceType("ANDROID");
        userSettingsManager.setCustomDeviceId("demo");
        userSettingsManager.setFirstName("Demo");
        userSettingsManager.setLastName("Demo");
        userSettingsManager.setDemoMode(true);
        runtimeEngine.initializeApplication(FrameworkHelper.getApplicationContext(), LoginParameters.getAppName(), LoginParameters.getMetaData());
        SyncEngine.getInstance().initialize();
        DemoHelper.importData(demoDataInputStream);
        LoginParameters.getDemoModeListener().applicationStartedInDemoMode(FrameworkHelper.getApplicationContext());
    }
}

