/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import com.unvired.database.DBException;
import com.unvired.logger.Logger;
import com.unvired.utils.FrameworkHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sqlcipher.database.SQLiteDatabase;

public class FileHelper {
    public static String readFromFile(File srcFile) {
        String fileContent = null;
        if (srcFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(srcFile);
                byte[] data = new byte[(int)srcFile.length()];
                fis.read(data);
                fis.close();
                fileContent = new String(data, "UTF-8");
            }
            catch (Exception e) {
                Logger.e("Exception caught while reading file :" + srcFile.getAbsolutePath(), e);
            }
        }
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File destFile, String content, boolean append) {
        try {
            if (!destFile.exists() && !destFile.createNewFile()) {
                throw new DBException(Class.class.getName(), "getUniqueId", "Error while creating key file for database to create or open");
            }
            try (FileOutputStream stream = new FileOutputStream(destFile, append);){
                stream.write(content.getBytes());
            }
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, FrameworkHelper.class.getSimpleName(), "writeToFile", "File writing completed");
            }
        }
        catch (Exception e) {
            Logger.e("Error while writing content to file." + e.getMessage(), e);
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists() && !targetLocation.mkdirs()) {
                throw new IOException("Cannot create dir " + targetLocation.getAbsolutePath());
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                FileHelper.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            File directory = targetLocation.getParentFile();
            if (directory != null && !directory.exists() && !directory.mkdirs()) {
                throw new IOException("Cannot create dir " + directory.getAbsolutePath());
            }
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    FileHelper.deleteFile(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                }
            }
        } else {
            file.delete();
        }
    }

    public static void deleteFolderContent(String localPath) {
        File destFile = new File(localPath);
        if (destFile.exists() && destFile.isDirectory()) {
            String[] children = destFile.list();
            for (int i = 0; i < children.length; ++i) {
                new File(destFile, children[i]).delete();
            }
        }
    }

    public static void zip(String[] _files, String zipFileName) {
        try {
            BufferedInputStream origin = null;
            int BUFFER = 1024;
            FileOutputStream dest = new FileOutputStream(zipFileName);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[BUFFER];
            for (int i = 0; i < _files.length; ++i) {
                int count;
                FileInputStream fi = new FileInputStream(_files[i]);
                origin = new BufferedInputStream(fi, BUFFER);
                ZipEntry entry = new ZipEntry(_files[i].substring(_files[i].lastIndexOf("/") + 1));
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (Exception e) {
            Logger.e("Error while Zipping log file." + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnencryptedDatabaseFile(String databasePath) {
        if (!FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").exists()) {
            FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").mkdirs();
        }
        String encryptedDatabase = FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/encrypted";
        String decryptedDatabase = FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/APP";
        if (new File(decryptedDatabase).exists()) {
            new File(decryptedDatabase).delete();
        }
        try {
            FileHelper.copyDirectory(new File(databasePath), new File(encryptedDatabase));
            new File(decryptedDatabase).createNewFile();
            SQLiteDatabase database = SQLiteDatabase.openDatabase((String)encryptedDatabase, (String)FrameworkHelper.getUniqueId(), null, (int)0);
            database.rawExecSQL(String.format("ATTACH DATABASE '%s' as APP KEY '';", decryptedDatabase));
            database.rawExecSQL("SELECT sqlcipher_export('APP');");
            database.rawExecSQL("DETACH DATABASE APP;");
            database.close();
        }
        catch (Exception e) {
            if (new File(decryptedDatabase).exists()) {
                new File(decryptedDatabase).delete();
            }
            Logger.log(8, FileHelper.class.getSimpleName(), "getUnencryptedDatabaseFile", "Error while exporting unencrypted database." + e.getMessage());
            String string = null;
            return string;
        }
        finally {
            try {
                FileHelper.deleteFile(new File(encryptedDatabase));
            }
            catch (IOException e) {
                Logger.log(8, FileHelper.class.getSimpleName(), "getUnencryptedDatabaseFile", "Error while deleting temporary unencrypted database created for Data Export." + e.getMessage());
            }
        }
        return decryptedDatabase;
    }

    public static String getFileContentWithStatus(File srcFile) {
        String fileContent = null;
        String fileStatus = "";
        if (srcFile != null && srcFile.exists()) {
            fileStatus = "\n********** File Status ************ File " + srcFile.getName() + " exists. Is Readable? " + srcFile.canRead() + " Is Writable? " + srcFile.canWrite() + " Content Length: " + srcFile.length() + " Free Space: " + srcFile.getFreeSpace() + "\n";
            try {
                FileInputStream fis = new FileInputStream(srcFile);
                byte[] data = new byte[(int)srcFile.length()];
                fis.read(data);
                fis.close();
                fileContent = new String(data, "UTF-8");
            }
            catch (Exception e) {
                Logger.e("Error while reading file content. File: " + srcFile.getName() + " Message:" + e.getMessage(), e);
            }
        } else {
            fileStatus = "File does not exists!";
        }
        return fileStatus + fileContent;
    }

    public static String getEncryptedDatabaseFile() {
        if (!FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").exists()) {
            FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").mkdirs();
        }
        String encryptedDatabase = FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/APP1";
        String unencryptedDatabase = FrameworkHelper.getApplicationContext().getExternalFilesDir("temp").getAbsolutePath() + "/APP";
        try {
            SQLiteDatabase database = SQLiteDatabase.openDatabase((String)unencryptedDatabase, (String)"", null, (int)1);
            database.rawExecSQL(String.format("ATTACH DATABASE '%s' as APP1 KEY '%s';", encryptedDatabase, FrameworkHelper.getUniqueId()));
            database.rawExecSQL("SELECT sqlcipher_export('APP1');");
            database.rawExecSQL("DETACH DATABASE APP1;");
            database.close();
        }
        catch (Exception e) {
            Logger.log(8, FileHelper.class.getSimpleName(), "getEncryptedDatabaseFile", "Error while exporting unencrypted database." + e.getMessage());
            return null;
        }
        if (new File(unencryptedDatabase).delete()) {
            if (!new File(encryptedDatabase).renameTo(new File(unencryptedDatabase))) {
                Logger.log(8, FileHelper.class.getSimpleName(), "getEncryptedDatabaseFile", "Error while renaming encrypted database.");
                return null;
            }
        } else {
            Logger.log(8, FileHelper.class.getSimpleName(), "getEncryptedDatabaseFile", "Error while deleting unencrypted database.");
            return null;
        }
        return unencryptedDatabase;
    }
}

