/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import android.content.ContentResolver;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.os.Build;
import android.provider.Settings;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.core.RuntimeEngine;
import com.unvired.core.UserSettingsManager;
import com.unvired.database.DBException;
import com.unvired.database.DatabaseHelper;
import com.unvired.database.IDataManager;
import com.unvired.exception.ApplicationException;
import com.unvired.fcm.RegisterToFCM;
import com.unvired.location.Locations;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.security.Security;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.attachment.Attachment;
import com.unvired.sync.attachment.AttachmentDownloader;
import com.unvired.sync.attachment.AttachmentQHelper;
import com.unvired.sync.in.DataRetrieverService;
import com.unvired.sync.in.Inbox;
import com.unvired.sync.in.InboxHandler;
import com.unvired.sync.out.AttachmentOutbox;
import com.unvired.sync.out.AttachmentSender;
import com.unvired.sync.out.DataSender;
import com.unvired.sync.out.HTTPConnection;
import com.unvired.sync.out.Outbox;
import com.unvired.sync.out.SentItems;
import com.unvired.sync.response.FileResponse;
import com.unvired.utils.Context;
import com.unvired.utils.FileHelper;
import com.unvired.utils.PathManager;
import com.unvired.utils.UnviredPreferences;
import com.unvired.utils.XMLUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FrameworkHelper {
    public static android.content.Context applicationContext = null;
    private static String uniqueID = null;
    private static String actId = "";
    private static String ipAddress = "";

    public static void setApplicationContext(android.content.Context context) {
        applicationContext = context;
    }

    public static final android.content.Context getApplicationContext() {
        if (applicationContext == null) {
            applicationContext = LoginParameters.getContext();
        }
        return applicationContext;
    }

    public static boolean isTabletDevice(android.content.Context context) {
        if (Build.VERSION.SDK_INT >= 11) {
            Configuration con = context.getResources().getConfiguration();
            try {
                Method mIsLayoutSizeAtLeast = con.getClass().getMethod("isLayoutSizeAtLeast", Integer.TYPE);
                boolean r = (Boolean)mIsLayoutSizeAtLeast.invoke((Object)con, 4);
                return r;
            }
            catch (Exception x) {
                x.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static final String getDeviceUUID() {
        if (applicationContext == null) {
            return "";
        }
        return Settings.Secure.getString((ContentResolver)applicationContext.getContentResolver(), (String)"android_id");
    }

    public static final String getDeviceIMEI() {
        return "";
    }

    private static String getActId() {
        if (Strings.isNullOrEmpty((String)actId)) {
            try {
                actId = FrameworkSettingsManager.getInstance().getActId();
            }
            catch (DBException e) {
                Logger.e(e.getMessage());
            }
        }
        return actId;
    }

    private static String getIpAddress() {
        if (Strings.isNullOrEmpty((String)ipAddress)) {
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (inetAddress.isLoopbackAddress()) continue;
                        ipAddress = inetAddress.getHostAddress();
                    }
                }
            }
            catch (SocketException e) {
                Logger.e(e.getMessage());
            }
        }
        return ipAddress;
    }

    public static String getDeviceState() {
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.d("getDeviceState start");
        }
        if (applicationContext == null) {
            return "";
        }
        int outBoxCount = 0;
        int sentItemCount = 0;
        int inboxCount = 0;
        try {
            outBoxCount = Outbox.getInstance().count();
            sentItemCount = SentItems.getInstance().count();
            inboxCount = Inbox.getInstance().count();
        }
        catch (Exception e) {
            Logger.e(e.getMessage());
        }
        if (Logger.getDefaultLogLevel() == 9) {
            Logger.d("getDeviceState End. value: O=" + outBoxCount + " S=" + sentItemCount + " I=" + inboxCount + " IP=" + FrameworkHelper.getIpAddress() + " A=" + FrameworkHelper.getActId());
        }
        return "O=" + outBoxCount + " S=" + sentItemCount + " I=" + inboxCount + " IP=" + FrameworkHelper.getIpAddress() + " A=" + FrameworkHelper.getActId();
    }

    @Deprecated
    public static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public static final String getDateString(Date date) throws ApplicationException {
        if (date == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, FrameworkHelper.class.getName(), "getDateString", "Date found as null.");
            }
            throw new ApplicationException(FrameworkHelper.class.getName(), "getDateString", "Date found as null.");
        }
        return FrameworkHelper.getDateString(date.getTime());
    }

    public static final String getDateString(long timeInMilliSeconds) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS", Locale.getDefault());
        String dateString = formatter.format(timeInMilliSeconds);
        return dateString;
    }

    public static final byte[] getBytes(InputStream inputStream) throws ApplicationException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            String error = "Exception while converting inout stream to bytes. Exception: " + e.getMessage();
            Logger.e(error, e);
            throw new ApplicationException(FrameworkHelper.class.getName(), "getBytes", error);
        }
        return buffer.toByteArray();
    }

    public static byte[] getBytes(Document document) throws ApplicationException {
        try {
            return XMLUtils.documentToString(document).getBytes();
        }
        catch (Exception exception) {
            Logger.e("Exception caught while getting bytes from document, " + exception.getMessage(), exception);
            throw new ApplicationException(FrameworkHelper.class.getName(), "getBytes", "Exception caught while getting bytes from document, " + exception.getMessage());
        }
    }

    public static final String getString(Document document) throws ApplicationException {
        try {
            return XMLUtils.documentToString(document);
        }
        catch (Exception exception) {
            Logger.e("Exception caught while getting string from document, " + exception.getMessage(), exception);
            throw new ApplicationException(FrameworkHelper.class.getName(), "getString", "Exception caught while getting string from document, " + exception.getMessage());
        }
    }

    public static final String getString(InputStream inputStream) throws ApplicationException {
        if (inputStream == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, FrameworkHelper.class.getName(), "getString", "InputStream found as null.");
            }
            throw new ApplicationException(FrameworkHelper.class.getName(), "getString", "InputStream found as null.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException ioException) {
            Logger.e("IOException caught while reading input stream, " + ioException.getMessage(), ioException);
            throw new ApplicationException(FrameworkHelper.class.getName(), "getString", "IOException caught while reading input stream, " + ioException.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ioException) {
                Logger.e("IOException caught while closing input stream, " + ioException.getMessage(), ioException);
            }
        }
        return sb.toString();
    }

    public static final Document getDocumentRoot(InputStream inputStream) throws ApplicationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        domFactory.setIgnoringComments(true);
        domFactory.setIgnoringElementContentWhitespace(true);
        domFactory.setCoalescing(true);
        DocumentBuilder domBuilder = null;
        Document domDocument = null;
        try {
            domBuilder = domFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.e("ParserConfigurationException caught while creating DocumentBuilder object, " + parserConfigurationException.getMessage(), parserConfigurationException);
            throw new ApplicationException(FrameworkHelper.class.getName(), "getDocumentRoot", "ParserConfigurationException caught while creating DocumentBuilder object, " + parserConfigurationException.getMessage());
        }
        try {
            domDocument = domBuilder.parse(inputStream);
        }
        catch (IOException ioException) {
            Logger.e("IOException caught while creating document object, " + ioException.getMessage(), ioException);
            throw new ApplicationException(FrameworkHelper.class.getName(), "getDocumentRoot", "IOException caught while creating document object, " + ioException.getMessage());
        }
        catch (SAXException saxException) {
            Logger.e("SAXException caught while creating document object, " + saxException.getMessage(), saxException);
            throw new ApplicationException(FrameworkHelper.class.getName(), "getDocumentRoot", "SAXException caught while creating document object, " + saxException.getMessage());
        }
        return domDocument;
    }

    public static Document getSenderDocumentRoot(int messageType, String conversationId, String serverId, String applicationName, String applicationId) {
        Element conversationIdElement;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.e("Exception while creating a dom document: " + e.getMessage(), e);
        }
        Document domDocument = db.newDocument();
        Element root = domDocument.createElement("Root");
        root.setAttribute("type", String.valueOf(messageType));
        domDocument.appendChild(root);
        FrameworkSettingsManager frameworkSettingsManager = null;
        try {
            frameworkSettingsManager = FrameworkManager.getInstance().getFrameworkSettingsManager();
            if (frameworkSettingsManager.getCompanyAlias() != null && frameworkSettingsManager.getCompanyAlias().length() > 0) {
                Element companyAliasElement = domDocument.createElement("CompanyAlias");
                companyAliasElement.appendChild(domDocument.createTextNode(frameworkSettingsManager.getCompanyAlias()));
                root.appendChild(companyAliasElement);
            }
        }
        catch (DBException dbException) {
            Logger.e("DBException caught while getting framework settings, " + dbException.getMessage(), dbException);
        }
        if (conversationId != null && conversationId.length() > 0) {
            conversationIdElement = domDocument.createElement("ConversationId");
            conversationIdElement.appendChild(domDocument.createTextNode(conversationId));
            root.appendChild(conversationIdElement);
        }
        if (serverId != null && serverId.length() > 0) {
            conversationIdElement = domDocument.createElement("ServerId");
            conversationIdElement.appendChild(domDocument.createTextNode(serverId));
            root.appendChild(conversationIdElement);
        }
        if (applicationName != null && applicationName.length() > 0) {
            conversationIdElement = domDocument.createElement("ApplicationName");
            conversationIdElement.appendChild(domDocument.createTextNode(applicationName));
            root.appendChild(conversationIdElement);
        }
        if (applicationId != null && applicationId.length() > 0) {
            conversationIdElement = domDocument.createElement("ApplicationId");
            conversationIdElement.appendChild(domDocument.createTextNode(applicationId));
            root.appendChild(conversationIdElement);
        }
        return domDocument;
    }

    public static void resetApplication(boolean isFrameworkDBResetRequired) {
        RegisterToFCM.unRegistrationFromServer();
        Logger.log(7, FrameworkHelper.class.getName(), "reset", "****** Application Reset Start *******");
        try {
            Logger.log(7, FrameworkHelper.class.getName(), "reset", "******  Deleting database files ********");
            DatabaseHelper.deleteDatabases(isFrameworkDBResetRequired);
            if (!isFrameworkDBResetRequired) {
                Attachment.deleteFilesAndFolder();
            }
            Logger.log(7, FrameworkHelper.class.getName(), "reset", "Reset: Files deleted.");
            if (LoginParameters.isMultiAccEnabled() && isFrameworkDBResetRequired) {
                PathManager.getInstance().setLastLoginUnviredAccount(null);
                Logger.log(7, FrameworkHelper.class.getName(), "reset", "Reset: Last Login Unvired Account.");
            }
            if (isFrameworkDBResetRequired) {
                SharedPreferences sharedPrefs = LoginParameters.getContext().getSharedPreferences("SSL_CERTIFICATE", 0);
                SharedPreferences.Editor editor = sharedPrefs.edit();
                editor.remove("SSL_CERTIFICATE");
                editor.commit();
            }
        }
        catch (Exception exception) {
            Logger.e("Exception caught while resetting application database.", exception);
        }
        finally {
            FrameworkHelper.shutdown();
        }
        Logger.log(7, FrameworkHelper.class.getName(), "reset", "****** Application Reset End *******");
    }

    public static void shutdown() {
        RuntimeEngine.destroy();
        try {
            FrameworkHelper.stopThreads();
        }
        catch (Exception e) {
            Logger.e("Exception caught while shutting down all communication threads." + e.getMessage(), e);
        }
        finally {
            FrameworkHelper.closeAllDatabases();
            new UnviredPreferences(FrameworkHelper.getApplicationContext(), "UNV_PREF_KEY", "dFS!?CMiPBuhi$^Ycz/=", true).clear();
            AttachmentQHelper.destroy();
            AttachmentOutbox.destroy();
            Inbox.destroy();
            InboxHandler.destroy();
            Outbox.destroy();
            SentItems.destroy();
            HTTPConnection.destroy();
            UserSettingsManager.destroy();
            FrameworkSettingsManager.destroy();
            SyncEngine.destroy();
            ApplicationManager.destroy();
            FrameworkManager.destroy();
            PathManager.destroy();
            Locations.destroy();
            RuntimeEngine.destroy();
            Context.destroy();
        }
    }

    public static final void restart() {
        FrameworkHelper.stopThreads();
        FrameworkHelper.closeAllDatabases();
    }

    public static final void stopThreads() {
        try {
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopping AttachmentDownloader");
            AttachmentDownloader.getInstance().stop();
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopped AttachmentDownloader");
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopping AttachmentSender");
            AttachmentSender.getInstance().stop();
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopped AttachmentSender");
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopping DataRetrieverService");
            DataRetrieverService.getInstance().stop();
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopped DataRetrieverService");
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopping InboxHandler");
            InboxHandler.getInstance().stop();
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopped InboxHandler");
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopping DataSender");
            DataSender.getInstance().stop();
            Logger.log(7, FrameworkHelper.class.getName(), "stopThreads", "Stopped DataSender");
        }
        catch (Exception e) {
            Logger.e("Exception caught while stopping threads: " + e.getMessage(), e);
        }
    }

    public static void closeAllDatabases() {
        try {
            Logger.log(7, FrameworkHelper.class.getName(), "closeAllDatabase", "Closing application database");
            ApplicationManager.getInstance().closeDB();
        }
        catch (DBException dbException) {
            Logger.e("Exception while closing the application database: " + dbException.getMessage(), dbException);
        }
        try {
            Logger.log(7, FrameworkHelper.class.getName(), "closeAllDatabase", "Closing framework database");
            FrameworkManager.getInstance().closeDB();
        }
        catch (DBException dbException) {
            Logger.e("Exception while closing the framework database: " + dbException.getMessage(), dbException);
        }
    }

    public static void cleanUpInfoMessages() {
        IDataManager frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        int infoMessageCount = 0;
        if (frameworkDataManager != null) {
            try {
                infoMessageCount = frameworkDataManager.count("INFO_MESSAGE", null);
                if (infoMessageCount > 50) {
                    String whereClause = "LID NOT IN (SELECT LID FROM INFO_MESSAGE ORDER BY TIME_STAMP DESC LIMIT 40)";
                    frameworkDataManager.delete("INFO_MESSAGE", whereClause);
                }
            }
            catch (DBException e) {
                Logger.e("DBException caught while cleaning up InfoMessage table : " + e.getMessage(), e);
            }
        }
    }

    public static boolean isRunningOnGlass() {
        boolean result = "Google".equalsIgnoreCase(Build.MANUFACTURER) && Build.MODEL.startsWith("Glass");
        return result;
    }

    public static synchronized String getUniqueId() {
        String databaseKey = "KEY";
        String localPath = PathManager.getInstance().getAAccountsRootPath();
        if (localPath == null) {
            return "";
        }
        File destFile = new File(localPath, "KEY");
        uniqueID = FileHelper.readFromFile(destFile);
        if (uniqueID == null) {
            uniqueID = UUID.randomUUID().toString();
            FileHelper.writeToFile(destFile, uniqueID, false);
        }
        String aesSecurityKey = "x9cIhZM0U65CCMWNsiU79dSX6ZW4CzChhJvaldsDCgM=";
        try {
            uniqueID = new String(Security.encryptAES(aesSecurityKey.getBytes(), uniqueID.getBytes()));
        }
        catch (Exception e) {
            Logger.log(8, FrameworkHelper.class.getName(), "getUniqueId", "Error while encrypting database key. " + e.getMessage());
        }
        return uniqueID;
    }

    public static boolean copyIncomingDataToInboxFolder(InputStream inputStream, String conversationId) {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.INBOX_FOLDER);
        String fileName = conversationId + ".xml";
        try {
            File directory;
            File destFile;
            File inboxDir = new File(localPath);
            if (!inboxDir.exists()) {
                inboxDir.mkdirs();
            }
            if (!(destFile = new File(localPath, fileName)).exists()) {
                destFile.createNewFile();
            }
            if ((directory = destFile.getParentFile()) != null && !directory.exists() && !directory.mkdirs()) {
                Logger.log(8, FrameworkHelper.class.getName(), "copyIncomingDataToInboxFolder", "Cannot create dir " + directory.getAbsolutePath());
                return false;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(destFile.getPath());
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)fileOutputStream).write(bytes, 0, read);
            }
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException e) {
            Logger.e("File not found exception while opening files for copy purpose: " + e.getMessage(), e);
            return false;
        }
        catch (IOException e) {
            Logger.e("IOException exception while dealing with file input n out put streams, for copy purpose: " + e.getMessage(), e);
            return false;
        }
        catch (Exception e) {
            Logger.e("Exception exception while dealing with file input n out put streams, for copy purpose: " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveInputStreamToFile(InputStream inputStream, FileResponse fileResponse) {
        boolean deleteFileDueToErr = false;
        String errorMsg = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileResponse.getFile().getPath());
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)fileOutputStream).write(bytes, 0, read);
            }
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException e) {
            errorMsg = "File not found exception while saving input stream to file: " + e.getMessage();
            Logger.e(errorMsg, e);
            deleteFileDueToErr = true;
        }
        catch (IOException e) {
            errorMsg = "IOException while saving input stream to file: " + e.getMessage();
            Logger.e(errorMsg, e);
            deleteFileDueToErr = true;
        }
        catch (Exception e) {
            errorMsg = "Exception while saving input stream to file: " + e.getMessage();
            Logger.e(errorMsg, e);
            deleteFileDueToErr = true;
        }
        finally {
            if (deleteFileDueToErr) {
                try {
                    FileHelper.deleteFile(fileResponse.getFile());
                }
                catch (Exception e) {
                    Logger.e("Exception while deleteing file when file download did not complete and threw an exception: " + e.getMessage(), e);
                }
                fileResponse.setFileStatus(FileResponse.FILE_RESPONSE_STATUS.ERROR);
                fileResponse.setFile(null);
                fileResponse.setErrorMessage(errorMsg);
            }
        }
    }

    public static File readInboxFile(String conversationId) {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.INBOX_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "readInboxFile", "Cannot read inbox file. Conversation Id: " + conversationId);
            return null;
        }
        String fileName = conversationId + ".xml";
        File destFile = new File(localPath, fileName);
        File directory = destFile.getParentFile();
        if (directory != null && !directory.exists()) {
            Logger.log(8, FrameworkHelper.class.getName(), "copyToApplicationLocalPath", "Cannot create dir " + directory.getAbsolutePath());
            return null;
        }
        return destFile;
    }

    public static boolean copyOutgoingDataToOutboxFolder(InputStream inputStream, String lid) {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.OUTBOX_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "copyOutgoingDataToOutboxFolder", "Cannot get local path to save outgoing message files. BE Name: " + lid);
            return false;
        }
        String fileName = lid + ".xml";
        try {
            File directory;
            File destFile = new File(localPath, fileName);
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            if ((directory = destFile.getParentFile()) != null && !directory.exists() && !directory.mkdirs()) {
                Logger.log(8, FrameworkHelper.class.getName(), "copyOutgoingDataToOutboxFolder", "Cannot create dir " + directory.getAbsolutePath());
                return false;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(destFile.getPath());
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)fileOutputStream).write(bytes, 0, read);
            }
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException e) {
            Logger.e("File not found exception while opening files for copy purpose: " + e.getMessage(), e);
            return false;
        }
        catch (IOException e) {
            Logger.e("IOException exception while dealing with file input n out put streams, for copy purpose: " + e.getMessage(), e);
            return false;
        }
        catch (Exception e) {
            Logger.e("Exception exception while dealing with file input n out put streams, for copy purpose: " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    public static boolean deleteOutBoxFile(String lid) {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.OUTBOX_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "deleteOutBoxFile", "Cannot get local path to save outgoing message files. BE Name: " + lid);
            return false;
        }
        String fileName = lid + ".xml";
        File destFile = new File(localPath, fileName);
        return destFile.delete();
    }

    public static boolean deleteInboxFile(String conversationId) {
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.INBOX_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "deleteInboxFile", "Cannot get local path to delete inbox files");
            return false;
        }
        String fileName = conversationId + ".xml";
        File destFile = new File(localPath, fileName);
        return destFile.delete();
    }

    public static byte[] readOutboxFile(String lid) {
        byte[] xml = null;
        String localPath = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.OUTBOX_FOLDER);
        if (localPath == null) {
            Logger.log(8, FrameworkHelper.class.getName(), "readOutboxFile", "Cannot get local path to read outbox files");
            return null;
        }
        String fileName = lid + ".xml";
        File mysourceFile = new File(localPath, fileName);
        File directory = mysourceFile.getParentFile();
        if (directory != null && !directory.exists()) {
            Logger.log(8, FrameworkHelper.class.getName(), "copyToApplicationLocalPath", "Cannot create dir " + directory.getAbsolutePath());
            return null;
        }
        try {
            xml = Files.toByteArray((File)mysourceFile);
        }
        catch (IOException e) {
            Logger.e("Cannot read file to byte[]  " + directory.getAbsolutePath(), e);
        }
        return xml;
    }

    public static void setConnectionTimeout(int position) {
        String currentConnectionTimeOut = FrameworkHelper.getConnectionTimeoutValues()[position];
        currentConnectionTimeOut = currentConnectionTimeOut.substring(0, 1);
        int finalCurrentConnectionTimeOut = Integer.valueOf(currentConnectionTimeOut) * 60;
        UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
        try {
            userSettingsManager.setConnectionTimeout(finalCurrentConnectionTimeOut);
        }
        catch (DBException e) {
            Logger.e(e.getMessage());
        }
    }

    public static int getConnectionTimeout() {
        try {
            UserSettingsManager userSettingsManager = UserSettingsManager.getInstance();
            int connectionTimeOut = userSettingsManager.getConnectionTimeout();
            return connectionTimeOut / 60;
        }
        catch (Exception exception) {
            Logger.e("Exception caught while creating http client, " + exception.getMessage());
            return 0;
        }
    }

    public static String[] getConnectionTimeoutValues() {
        String[] connectionTimeOutValues = new String[]{"1 Min", "2 Mins", "3 Mins", "4 Mins", "5 Mins", "6 Mins"};
        return connectionTimeOutValues;
    }

    public static String getExceptionMessage(Exception e) {
        String msg = "Unknown Exception";
        StringWriter errors = new StringWriter();
        if (e != null) {
            e.printStackTrace(new PrintWriter(errors));
            msg = errors.toString();
        }
        return msg;
    }
}

