/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import com.unvired.database.IDataStructure;
import com.unvired.logger.Logger;
import com.unvired.utils.DataStructureHelper;
import java.util.Enumeration;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonHelper {
    public static String getDataStructureName(JSONObject dataStructureObject) {
        String name = null;
        try {
            Iterator keys = dataStructureObject.keys();
            if (keys.hasNext()) {
                return (String)keys.next();
            }
        }
        catch (Exception e) {
            Logger.log(8, JsonHelper.class.getSimpleName(), "getDataStructureName", "Error while parsing DataStructure JsonObject for Structure Name." + e.getMessage());
        }
        return name;
    }

    public static JSONObject getJSONFromDataStructure(IDataStructure dataStructure) {
        JSONObject jsonDataStructure = new JSONObject();
        JSONObject jsonFieldObject = new JSONObject();
        Enumeration<String> en = dataStructure.getFieldNames();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            String value = String.valueOf(dataStructure.getField(key));
            try {
                if (value != "null") {
                    jsonFieldObject.put(key, (Object)value);
                    continue;
                }
                jsonFieldObject.put(key, (Object)"");
            }
            catch (JSONException e) {
                Logger.log(8, DataStructureHelper.class.getName(), "GetJSONFromDataStructure", "Error in creating JSONObject from DataStructure. " + e.getMessage());
            }
        }
        try {
            jsonDataStructure.put(dataStructure.getTableName(), (Object)jsonFieldObject);
        }
        catch (JSONException e) {
            Logger.log(8, DataStructureHelper.class.getName(), "GetJSONFromDataStructure", "Error in setting DataStructure JSONObject name and field value object. " + e.getMessage());
        }
        return jsonDataStructure;
    }
}

