/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.unvired.logger.Logger;
import com.unvired.sync.SyncEngine;
import com.unvired.sync.notifier.SynchronizationStateListener;
import com.unvired.utils.NetworkStateListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;

public class NetworkChangeReceiver
extends BroadcastReceiver {
    private static ArrayList<NetworkStateListener> networkStateListeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        Logger.d("Network change callback received");
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        Logger.d("NetworkInfo is:: " + activeNetwork);
        if (activeNetwork != null) {
            if (!activeNetwork.isConnected()) {
                Logger.d("Network not connected");
                SynchronizationStateListener synchronizationStateListener = SyncEngine.getInstance().getSynchronizationStateListener();
                if (synchronizationStateListener != null) {
                    synchronizationStateListener.waitingToConnect();
                }
                return;
            }
            Logger.d("Network connected");
            Iterator<NetworkStateListener> iterator = networkStateListeners.iterator();
            while (iterator.hasNext()) {
                NetworkStateListener listener;
                NetworkStateListener networkStateListener = listener = iterator.next();
                synchronized (networkStateListener) {
                    listener.notifyAll();
                }
            }
        }
    }

    public boolean isReachable(String hostname) {
        try {
            InetAddress.getByName(hostname);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public void addNetworkStateListener(NetworkStateListener networkStateListener) {
        if (networkStateListeners == null) {
            networkStateListeners = new ArrayList();
        }
        if (!networkStateListeners.contains(networkStateListener)) {
            networkStateListeners.add(networkStateListener);
        }
    }

    public void removeNetworkStateListener(NetworkStateListener networkStateListener) {
        if (networkStateListeners == null) {
            networkStateListeners = new ArrayList();
        }
        if (networkStateListeners.contains(networkStateListener)) {
            networkStateListeners.add(networkStateListener);
        }
    }
}

