/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.unvired.core.FrameworkManager;
import com.unvired.core.FrameworkSettingsManager;
import com.unvired.database.DBException;
import com.unvired.logger.Logger;
import com.unvired.utils.FrameworkHelper;

public class NetworkUtil {
    public static final boolean hasCoverage() {
        ConnectivityManager connectivity = (ConnectivityManager)FrameworkHelper.getApplicationContext().getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivity.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        boolean wifiConnectionAvailable = networkInfo.getType() == 1;
        boolean mobileConnectionAvailable = networkInfo.getType() == 0;
        boolean ethernetConnectionAvailable = networkInfo.getType() == 9;
        return wifiConnectionAvailable || mobileConnectionAvailable || ethernetConnectionAvailable;
    }

    public static final boolean hasCoverage(boolean attachment) {
        boolean ethernetConnectionAvailable;
        ConnectivityManager connectivity = (ConnectivityManager)FrameworkHelper.getApplicationContext().getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivity.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        boolean wifiConnectionAvailable = networkInfo.getType() == 1;
        boolean mobileConnectionAvailable = networkInfo.getType() == 0;
        boolean bl = ethernetConnectionAvailable = networkInfo.getType() == 9;
        if (!(wifiConnectionAvailable || mobileConnectionAvailable || ethernetConnectionAvailable)) {
            return false;
        }
        try {
            String attachmentConnection;
            FrameworkSettingsManager frameworkSettingsManager = FrameworkManager.getInstance().getFrameworkSettingsManager();
            if (attachment && "WIFI".equalsIgnoreCase(attachmentConnection = frameworkSettingsManager.getAttachmentConnection())) {
                return wifiConnectionAvailable;
            }
            return true;
        }
        catch (DBException e) {
            Logger.e("DBException caught while checking for connection preference(wifi/mobile data) in database:" + e.getMessage(), e);
            return false;
        }
    }

    public static final boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public static final String getResponseText(int responseCode) {
        String text = "";
        switch (responseCode) {
            case -1: 
            case 0: {
                text = "Cannot connect to server. Please try again later.";
                break;
            }
            case 200: {
                text = "Successful.";
                break;
            }
            case 204: {
                text = "No content. The server successfully processed the request, but is not returning any content.";
                break;
            }
            case 400: {
                text = "Bad request. The request could not be understood by the server due to malformed syntax.";
                break;
            }
            case 401: {
                text = "Unauthorized request. The request requires user authentication.";
                break;
            }
            case 403: {
                text = "Forbidden. The server understood the request, but is refusing to fulfill it.";
                break;
            }
            case 404: {
                text = "Not found. The server has not found anything matching the Request-URI.";
                break;
            }
            case 405: {
                text = "Method not allowed. The method specified in the Request-Line is not allowed for the resource identified by the Request-URI.";
                break;
            }
            case 406: {
                text = "Not acceptable.";
                break;
            }
            case 407: {
                text = "Proxy authentication required.";
                break;
            }
            case 408: {
                text = "Request timeout. The client did not produce a request within the time that the server was prepared to wait.";
                break;
            }
            case 410: {
                text = "Gone. The requested resource is no longer available at the server and no forwarding address is known.";
                break;
            }
            case 500: {
                text = "Internal server error. The server encountered an unexpected condition which prevented it from fulfilling the request.";
                break;
            }
            case 501: {
                text = "Not implemented. The server does not support the functionality required to fulfill the request.";
                break;
            }
            case 502: {
                text = "Bad gateway. The server, while acting as a gateway or proxy, received an invalid response from the upstream server it accessed in attempting to fulfill the request.";
                break;
            }
            case 503: {
                text = "Service unavailable. The server is currently unable to handle the request due to a temporary overloading or maintenance of the server.";
                break;
            }
            case 504: {
                text = "Gateway timeout. The server, while acting as a gateway or proxy, did not receive a timely response from the upstream server specified by the URI.";
                break;
            }
            case 505: {
                text = "HTTP version not supported. The server does not support, or refuses to support, the HTTP protocol version that was used in the request message.";
                break;
            }
        }
        return text;
    }
}

