/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.widget.Toast;
import com.unvired.logger.Logger;
import com.unvired.login.LoginListener;
import com.unvired.login.LoginParameters;
import com.unvired.login.UnviredAccount;
import com.unvired.utils.FileHelper;
import com.unvired.utils.FrameworkHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class PathManager {
    public static final String FRAMEWORK_DATABASE_NAME = "FRAMEWORK";
    private static final String APP_DATABASE_NAME = "APP";
    private static final String LOG_FILE_NAME = "LOG.txt";
    private static final String LOG_BACKUP_FILE_NAME = "LOG_BACKUP.txt";
    private static final String INBOX_FOLDER_NAME = "INBOX";
    private static final String OUTBOX_FOLDER_NAME = "OUTBOX";
    private static final String ATTACHMENT_FOLDER_NAME = "ATTACHMENT";
    private static final String TEMP_FILE = "TEMP.txt";
    private static final String TEMP_FOLDER = "TEMP";
    private static String accountsRootPath;
    private static PathManager pathManager;
    private UnviredAccount activeAccount = null;

    public static PathManager getInstance() {
        if (pathManager == null) {
            pathManager = new PathManager();
        }
        if (accountsRootPath == null) {
            PathManager.setAccountsRootPath();
        }
        return pathManager;
    }

    public static void destroy() {
        if (pathManager != null) {
            pathManager = null;
            accountsRootPath = null;
            Logger.log(7, PathManager.class.getName(), "destroy", "Destroyed");
        } else {
            Logger.log(7, PathManager.class.getName(), "destroy", "Destroy not required. Already null.");
        }
    }

    public UnviredAccount getActiveAccount() {
        return this.activeAccount;
    }

    public void setActiveAccount(UnviredAccount unviredAccount) {
        this.activeAccount = unviredAccount;
    }

    public String getActiveAccountPath() {
        String path;
        if (this.activeAccount == null) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, PathManager.class.getSimpleName(), "getActiveAccountPath", "Active account not set.");
            }
            return null;
        }
        String accountPath = this.activeAccount.getAccountPath();
        try {
            path = accountsRootPath + accountPath;
            File filePath = new File(path);
            if (!filePath.exists() && !filePath.mkdirs()) {
                Logger.log(8, PathManager.class.getSimpleName(), "getActiveAccountPath", "Not able to create Account directory.");
                return null;
            }
        }
        catch (Exception e) {
            Logger.e("Error while getting account path." + e.getMessage(), e);
            return null;
        }
        return path;
    }

    public String getDirectoryPathFor(PATH_TYPE pathType) {
        if (pathType == PATH_TYPE.LOG_FILE) {
            return accountsRootPath + LOG_FILE_NAME;
        }
        if (pathType == PATH_TYPE.TEMP_FILE) {
            return accountsRootPath + TEMP_FILE;
        }
        String path = this.getActiveAccountPath();
        if (path == null || path.isEmpty()) {
            Logger.log(8, PathManager.class.getSimpleName(), "getActiveAccountPath", "Active account path found null.");
            return null;
        }
        switch (pathType) {
            case APP_DB_FILE: {
                path = path + "/" + APP_DATABASE_NAME;
                return path;
            }
            case APP_DB_FILE_BACKUP: {
                path = path + "/" + APP_DATABASE_NAME + "_BACKUP.db";
                return path;
            }
            case FW_DB_FILE: {
                path = path + "/" + FRAMEWORK_DATABASE_NAME;
                return path;
            }
            case FW_DB_FILE_BACKUP: {
                path = path + "/" + FRAMEWORK_DATABASE_NAME + "_BACKUP.db";
                return path;
            }
            case INBOX_FOLDER: {
                path = path + "/" + INBOX_FOLDER_NAME;
                break;
            }
            case OUTBOX_FOLDER: {
                path = path + "/" + OUTBOX_FOLDER_NAME;
                break;
            }
            case ATTACHMENT_FOLDER: {
                path = path + "/" + ATTACHMENT_FOLDER_NAME;
                break;
            }
            case TEMP_FOLDER: {
                path = path + "/" + TEMP_FOLDER;
            }
        }
        try {
            File filePath = new File(path);
            if (!filePath.exists() && !filePath.mkdirs()) {
                Logger.log(8, PathManager.class.getSimpleName(), "getDirectoryPathFor", "Not able to create Account directory.");
                return null;
            }
        }
        catch (Exception e) {
            Logger.e("Error while getting account path." + e.getMessage(), e);
            return null;
        }
        return path;
    }

    public boolean isAppDatabaseFileExists() {
        String path = this.getActiveAccountPath();
        if (path == null || path.isEmpty()) {
            if (Logger.getDefaultLogLevel() == 9) {
                Logger.log(9, PathManager.class.getSimpleName(), "isAppDatabaseFileExists", "Active account path found null.");
            }
            return false;
        }
        path = path + "/" + APP_DATABASE_NAME;
        File filePath = new File(path);
        return filePath.exists();
    }

    public List<UnviredAccount> getAllAccounts() {
        try {
            File rootDir = new File(accountsRootPath);
            if (!rootDir.exists()) {
                Logger.log(7, PathManager.class.getSimpleName(), "getAllAccounts", "Account root path does not exist. Hence No Account.");
                return null;
            }
            File[] accounts = rootDir.listFiles();
            if (accounts == null || accounts.length <= 0) {
                Logger.log(7, PathManager.class.getSimpleName(), "getAllAccounts", "Account root directory exists but no contents inside. Expected contents are LOG.txt,KEY and Accounts directory.");
                return null;
            }
            int i = 0;
            ArrayList<UnviredAccount> accountList = new ArrayList<UnviredAccount>();
            for (File f : accounts) {
                if (LOG_FILE_NAME.equals(f.getName()) || LOG_BACKUP_FILE_NAME.equals(f.getName()) || "KEY".equals(f.getName())) continue;
                UnviredAccount account = new UnviredAccount();
                account.getUnviredAccountFromRepresentation(f.getName());
                accountList.add(account);
                ++i;
                Logger.log(7, PathManager.class.getSimpleName(), "getAllAccounts", "*** ACCOUNT *** " + f.getName());
            }
            Logger.log(7, PathManager.class.getSimpleName(), "getAllAccounts", "******** " + i + " ACCOUNT FOUND *********");
            return accountList;
        }
        catch (Exception e) {
            Logger.e("Error while getting account path: " + accountsRootPath + "." + e.getMessage(), e);
            return null;
        }
    }

    private static void setAccountsRootPath() {
        if (LoginParameters.getExternalStoragePath() != null && !LoginParameters.getExternalStoragePath().isEmpty()) {
            String filesRoot = FrameworkHelper.applicationContext.getExternalFilesDir(null).getAbsolutePath();
            filesRoot = filesRoot.substring(filesRoot.indexOf("Android"));
            accountsRootPath = LoginParameters.getExternalStoragePath().endsWith("/") ? LoginParameters.getExternalStoragePath() + filesRoot + "/ACCOUNTS/" : LoginParameters.getExternalStoragePath() + "/" + filesRoot + "/ACCOUNTS/";
        } else {
            accountsRootPath = FrameworkHelper.getApplicationContext().getFilesDir().getAbsolutePath() + "/ACCOUNTS/";
        }
    }

    public String getAAccountsRootPath() {
        return accountsRootPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean initializeApplicationStorage() {
        if (LoginParameters.getExternalStoragePath() == null || LoginParameters.getExternalStoragePath().isEmpty()) return true;
        File mountFile = new File("/proc/mounts");
        boolean isSDCardMounted = false;
        if (mountFile.exists()) {
            try {
                Scanner usbScanner = new Scanner(mountFile);
                while (usbScanner.hasNext()) {
                    String line = usbScanner.nextLine();
                    if (!line.contains(LoginParameters.getExternalStoragePath())) continue;
                    isSDCardMounted = true;
                }
            }
            catch (Exception e) {
                Toast.makeText((Context)FrameworkHelper.applicationContext, (CharSequence)("Error occurred while scanning for Sd Cards : " + e.getMessage()), (int)0).show();
            }
        }
        String appAccountsInternalRootPath = FrameworkHelper.getApplicationContext().getFilesDir().getAbsolutePath() + "/ACCOUNTS/";
        if (!isSDCardMounted) {
            if (!new File(appAccountsInternalRootPath).exists()) {
                LoginListener loginListener = LoginParameters.getLoginListener();
                if (loginListener == null) return true;
                accountsRootPath = null;
                Logger.resetLogFilePath();
                loginListener.noSDCardFound("No SD Card found at given storage path : " + LoginParameters.getExternalStoragePath());
                return false;
            }
            accountsRootPath = null;
            LoginParameters.setExternalStoragePath(null);
            Logger.resetLogFilePath();
            return true;
        }
        String filesRoot = FrameworkHelper.applicationContext.getExternalFilesDir(null).getAbsolutePath();
        filesRoot = filesRoot.substring(filesRoot.indexOf("Android"));
        String appAccountsExternalRootPath = LoginParameters.getExternalStoragePath().endsWith("/") ? LoginParameters.getExternalStoragePath() + filesRoot + "/ACCOUNTS/" : LoginParameters.getExternalStoragePath() + "/" + filesRoot + "/ACCOUNTS/";
        File appAccExternalFile = new File(appAccountsExternalRootPath);
        if (appAccExternalFile.exists() && appAccExternalFile.listFiles() != null && appAccExternalFile.listFiles().length > 2) {
            return true;
        }
        if (!new File(appAccountsInternalRootPath).exists()) return true;
        try {
            Toast.makeText((Context)FrameworkHelper.applicationContext, (CharSequence)"Please wait for the transfer of data from internal storage to SD Card", (int)1).show();
            FileHelper.copyDirectory(new File(appAccountsInternalRootPath), new File(appAccountsExternalRootPath));
            FileHelper.deleteFile(new File(appAccountsInternalRootPath));
            Logger.log(7, PathManager.class.getSimpleName(), "initializeApplicationStorage", "Application data found in internal memory. Internal memory data copied to sd card and continuing with data in SD Card");
            Logger.log(7, PathManager.class.getSimpleName(), "initializeApplicationStorage", "Data Copied From :" + appAccountsInternalRootPath + " To: " + appAccountsExternalRootPath);
            return true;
        }
        catch (IOException e) {
            Logger.log(8, PathManager.class.getSimpleName(), "initializeApplicationStorage", "Error while copying existing app directory from internal memory to external SD Card." + e.getMessage());
        }
        return true;
    }

    public void resetAccountRootDirectory() {
        try {
            if (this.getAAccountsRootPath() == null) {
                return;
            }
            File rootDir = new File(this.getAAccountsRootPath());
            if (!rootDir.exists()) {
                Logger.log(7, PathManager.class.getSimpleName(), "resetAccountRootDirectory", "Account root directory does not exist. No reset required.");
                return;
            }
            File[] accounts = rootDir.listFiles();
            if (accounts == null || accounts.length <= 0) {
                Logger.log(7, PathManager.class.getSimpleName(), "resetAccountRootDirectory", "Account root directory exists but no contents inside. Expected contents are LOG.txt,KEY and Accounts directory.");
                return;
            }
            int i = 0;
            for (File f : accounts) {
                if (LOG_FILE_NAME.equals(f.getName()) || LOG_BACKUP_FILE_NAME.equals(f.getName()) || "KEY".equals(f.getName())) continue;
                FileHelper.deleteFile(f);
                ++i;
                Logger.log(7, PathManager.class.getSimpleName(), "resetAccountRootDirectory", "*** ACCOUNT *** " + f.getName());
            }
            Logger.log(7, PathManager.class.getSimpleName(), "resetAccountRootDirectory", "******** " + i + " ACCOUNT FOUND *********");
        }
        catch (Exception e) {
            Logger.e("Error while resetting Account root directory." + e.getMessage(), e);
        }
    }

    public void setLastLoginUnviredAccount(UnviredAccount unviredAccount) {
        SharedPreferences sharedPrefs = FrameworkHelper.getApplicationContext().getSharedPreferences("UNVIRED_ACCOUNT", 0);
        SharedPreferences.Editor prefsEditor = sharedPrefs.edit();
        if (unviredAccount == null) {
            prefsEditor.remove("LAST_LOGGED_IN_ACCOUNT");
        } else {
            prefsEditor.putString("LAST_LOGGED_IN_ACCOUNT", unviredAccount.getAccountPath());
        }
        prefsEditor.commit();
    }

    public UnviredAccount getLastLoginUnviredAccount() {
        SharedPreferences sharedPrefs = FrameworkHelper.getApplicationContext().getSharedPreferences("UNVIRED_ACCOUNT", 0);
        String accountPath = sharedPrefs.getString("LAST_LOGGED_IN_ACCOUNT", null);
        if (accountPath == null) {
            return null;
        }
        UnviredAccount account = new UnviredAccount();
        account.getUnviredAccountFromRepresentation(accountPath);
        return account;
    }

    static {
        pathManager = null;
    }

    public static enum PATH_TYPE {
        APP_DB_FILE,
        APP_DB_FILE_BACKUP,
        FW_DB_FILE,
        FW_DB_FILE_BACKUP,
        LOG_FILE,
        INBOX_FOLDER,
        OUTBOX_FOLDER,
        ATTACHMENT_FOLDER,
        TEMP_FILE,
        TEMP_FOLDER;

    }
}

