/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import com.unvired.core.FrameworkManager;
import com.unvired.database.DBException;
import com.unvired.database.IDataManager;
import com.unvired.logger.Logger;
import com.unvired.model.QueryFunction;
import java.util.Vector;

public class QueryFunctionUtility {
    private static IDataManager frameworkDataManager = null;

    public static void addFunctions(Vector<String> queryFunctions) {
        frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        if (queryFunctions != null && queryFunctions.size() > 0) {
            for (int i = 0; i < queryFunctions.size(); ++i) {
                String functionName = queryFunctions.elementAt(i);
                QueryFunction queryFunction = new QueryFunction();
                queryFunction.setFunctionName(functionName);
                try {
                    frameworkDataManager.insert(queryFunction);
                    continue;
                }
                catch (DBException dbException) {
                    Logger.log(8, QueryFunctionUtility.class.getName(), "addFunctions", "DBException: " + dbException.getMessage());
                }
            }
        }
    }

    public static void deleteFunctions(Vector<String> queryFunctions) {
        frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        if (queryFunctions != null && queryFunctions.size() > 0) {
            for (int i = 0; i < queryFunctions.size(); ++i) {
                String queryFunction = queryFunctions.elementAt(i);
                String query = "DELETE FROM " + QueryFunction.TABLE_NAME + " WHERE LID IN (SELECT LID FROM " + QueryFunction.TABLE_NAME + " WHERE " + QueryFunction.FUNCTION_NAME + " = " + "'" + queryFunction + "'" + " LIMIT 1)";
                try {
                    frameworkDataManager.execute(query);
                    continue;
                }
                catch (DBException dbException) {
                    Logger.e("DBException caught while executing query: " + query + "." + dbException.getMessage(), dbException);
                }
            }
        }
    }

    public static boolean isFunctionExistInTable(String functionName) {
        if (functionName == null || functionName == "") {
            return false;
        }
        frameworkDataManager = FrameworkManager.getInstance().getDataManager();
        int itemMasterHeaderCount = 0;
        try {
            itemMasterHeaderCount = frameworkDataManager.count(QueryFunction.TABLE_NAME, QueryFunction.FUNCTION_NAME + "='" + functionName + "'");
        }
        catch (DBException e) {
            Logger.e("Error while checking for function - " + functionName + " in table " + QueryFunction.TABLE_NAME, e);
        }
        return itemMasterHeaderCount > 0;
    }
}

