/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import com.google.common.base.Strings;
import java.util.HashMap;

public class TokenHelper {
    private static HashMap<String, String> values;
    private static final String TOKEN = "token";
    private static final String EMAIL = "email";
    private static final String DOMAIN = "domain";
    private static final String UMP = "ump";
    private static final String COMPANY = "company";

    public static boolean isTokenInfoAvailable() {
        return values != null && !values.isEmpty();
    }

    public static void setData(String rawData) {
        String[] params;
        if (Strings.isNullOrEmpty((String)rawData)) {
            values = null;
            return;
        }
        values = new HashMap();
        for (String param : params = rawData.split("&")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            if (keyValue[0].contains(TOKEN)) {
                values.put(TOKEN, keyValue[1]);
                continue;
            }
            values.put(keyValue[0], keyValue[1]);
        }
    }

    public static String getToken() {
        if (values != null && values.containsKey(TOKEN)) {
            return values.get(TOKEN);
        }
        return null;
    }

    public static String getEmail() {
        if (values != null && values.containsKey(EMAIL)) {
            return values.get(EMAIL);
        }
        return null;
    }

    public static String getDomain() {
        if (values != null && values.containsKey(DOMAIN)) {
            return values.get(DOMAIN);
        }
        return null;
    }

    public static String getUMP() {
        if (values != null && values.containsKey(UMP)) {
            return values.get(UMP);
        }
        return null;
    }

    public static String getCompany() {
        if (values != null && values.containsKey(COMPANY)) {
            return values.get(COMPANY);
        }
        return null;
    }
}

