/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Xml;
import android.view.Window;
import android.view.WindowManager;
import com.google.common.base.Strings;
import com.unvired.ui.R;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.IconHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class UITheme {
    public static boolean changed = false;
    private static THEME defaultTheme = THEME.INDIGO;
    private static int colorPrimary = Color.rgb((int)63, (int)81, (int)181);
    private static int colorPrimaryDark = Color.rgb((int)48, (int)63, (int)159);
    private static int colorPrimaryLight = Color.rgb((int)197, (int)202, (int)233);
    private static int colorAccent = Color.rgb((int)255, (int)64, (int)129);
    private static int textColor = Color.rgb((int)255, (int)255, (int)255);
    private static int textColorPrimary = Color.rgb((int)33, (int)33, (int)33);
    private static int textColorSecondary = Color.rgb((int)114, (int)114, (int)114);
    private static int dividerColor = Color.rgb((int)182, (int)182, (int)182);
    private static int backgroundColor = Color.rgb((int)224, (int)224, (int)224);
    private static int blackColor = Color.rgb((int)0, (int)0, (int)0);
    private static InputStream themeXmlIs = null;

    public static void setTheme(THEME theme) {
        if (theme != null) {
            defaultTheme = theme;
            UITheme.setCustomTheme(IconHelper.getFileContent(theme.themeName + ".xml"));
        }
    }

    public static void setCustomTheme(InputStream is) {
        if (is == null) {
            UITheme.setTheme(defaultTheme);
        } else {
            themeXmlIs = is;
            try {
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
                factory.setNamespaceAware(true);
                XmlPullParser xpp = factory.newPullParser();
                xpp.setInput(themeXmlIs, Xml.Encoding.UTF_8.name());
                int eventType = xpp.getEventType();
                List<String> attributeSet = UITheme.getAttributes();
                int attrPosition = -1;
                while (eventType != 1) {
                    String color;
                    if (eventType == 2 && xpp.getAttributeCount() > 0) {
                        String attribute = xpp.getAttributeValue(0);
                        if (attribute != null) {
                            attrPosition = attributeSet.indexOf(attribute);
                        }
                    } else if (eventType == 4 && !Strings.isNullOrEmpty((String)(color = xpp.getText())) && color.charAt(0) == '#') {
                        switch (attrPosition) {
                            case 0: {
                                colorPrimary = Color.parseColor((String)color);
                                break;
                            }
                            case 1: {
                                colorPrimaryDark = Color.parseColor((String)color);
                                break;
                            }
                            case 2: {
                                colorPrimaryLight = Color.parseColor((String)color);
                                break;
                            }
                            case 3: {
                                colorAccent = Color.parseColor((String)color);
                                break;
                            }
                            case 4: {
                                textColorSecondary = Color.parseColor((String)color);
                                break;
                            }
                            case 5: {
                                textColorSecondary = Color.parseColor((String)color);
                                break;
                            }
                            case 6: {
                                textColor = Color.parseColor((String)color);
                                break;
                            }
                            case 7: {
                                dividerColor = Color.parseColor((String)color);
                                break;
                            }
                        }
                    }
                    eventType = xpp.next();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static THEME[] getAvailableThemes() {
        return (THEME[])THEME.class.getEnumConstants();
    }

    public static void applyTheme(Activity activity) {
        if (activity.getActionBar() != null) {
            activity.getActionBar().hide();
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)activity.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        UIStyle.init(displayMetrics.density);
        if (themeXmlIs == null) {
            UITheme.setCustomTheme(IconHelper.getFileContent(UITheme.defaultTheme.themeName + ".xml"));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(UITheme.getColorPrimaryDark());
            activity.setTheme(16974401);
        } else {
            activity.setTheme(R.style.Theme_AppCompat_Light_NoActionBar);
        }
    }

    private static List<String> getAttributes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(0, "colorPrimary");
        list.add(1, "colorPrimaryDark");
        list.add(2, "colorPrimaryLight");
        list.add(3, "colorAccent");
        list.add(4, "android:textColorPrimary");
        list.add(5, "android:textColorSecondary");
        list.add(6, "android:icon");
        list.add(7, "android:divider");
        return list;
    }

    public static int getColorPrimary() {
        return colorPrimary;
    }

    public static int getColorPrimaryDark() {
        return colorPrimaryDark;
    }

    public static int getColorPrimaryLight() {
        return colorPrimaryLight;
    }

    public static int getTextColor() {
        return textColor;
    }

    public static int getTextColorPrimary() {
        return textColorPrimary;
    }

    public static int getTextColorSecondary() {
        return textColorSecondary;
    }

    public static int getColorAccent() {
        return colorAccent;
    }

    public static int getBackgroundColor() {
        return backgroundColor;
    }

    public static int getDividerColor() {
        return dividerColor;
    }

    public static int getBlackColor() {
        return blackColor;
    }

    public static enum THEME {
        TEAL("TEAL"),
        BLUE("BLUE"),
        INDIGO("INDIGO");

        final String themeName;

        private THEME(String themeName) {
            this.themeName = themeName;
        }
    }
}

