/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class UnviredPreferences {
    public static final String UNVIRED_PREFERENCE = "UNV_PREF_KEY";
    public static final String LOGIN_TYPE = "LOGIN_TYPE";
    public static final String URL = "URL";
    public static final String USER_ID = "USER_ID";
    public static final String EMAIL = "EMAIL";
    public static final String PASSWORDMD5 = "PASSWORDMD5";
    public static final String PASSWORD = "PASSWORD";
    public static final String ADS_DOMAIN = "ADS_DOMAIN";
    public static final String COMPANY = "COMPANY";
    public static final String DEMO_MODE = "DEMO_MODE";
    public static final String ACTIVATION_REQUIRED = "ACTIVATION_REQUIRED";
    public static final String SSL_CERTIFICATE = "SSL_CERTIFICATE";
    public static final String VERSION_UPGRADE = "VERSION_UPGRADE";
    public static final String FW_DB_UPGRADE = "FW_DB_UPGRADE";
    public static final String APP_DB_UPGRADE = "APP_DB_UPGRADE";
    public static final String DB_KEY = "DB_KEY";
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String KEY_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static final String SECRET_KEY_HASH_TRANSFORMATION = "SHA-256";
    private static final String CHARSET = "UTF-8";
    private final boolean encryptKeys;
    private final Cipher writer;
    private final Cipher reader;
    private final Cipher keyWriter;
    private final SharedPreferences preferences;

    public UnviredPreferences(Context context, String preferenceName, String secureKey, boolean encryptKeys) throws UnviredPreferencesException {
        try {
            this.writer = Cipher.getInstance(TRANSFORMATION);
            this.reader = Cipher.getInstance(TRANSFORMATION);
            this.keyWriter = Cipher.getInstance(KEY_TRANSFORMATION);
            this.initCiphers(secureKey);
            this.preferences = context.getSharedPreferences(preferenceName, 0);
            this.encryptKeys = encryptKeys;
        }
        catch (GeneralSecurityException e) {
            throw new UnviredPreferencesException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnviredPreferencesException(e);
        }
    }

    @SuppressLint(value={"TrulyRandom"})
    protected void initCiphers(String secureKey) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivSpec = this.getIv();
        SecretKeySpec secretKey = this.getSecretKey(secureKey);
        this.writer.init(1, (Key)secretKey, ivSpec);
        this.reader.init(2, (Key)secretKey, ivSpec);
        this.keyWriter.init(1, secretKey);
    }

    protected IvParameterSpec getIv() {
        byte[] iv = new byte[this.writer.getBlockSize()];
        System.arraycopy("fldsjfodasjifudslfjdsaofshaufihadsf".getBytes(), 0, iv, 0, this.writer.getBlockSize());
        return new IvParameterSpec(iv);
    }

    protected SecretKeySpec getSecretKey(String key) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] keyBytes = this.createKeyBytes(key);
        return new SecretKeySpec(keyBytes, TRANSFORMATION);
    }

    protected byte[] createKeyBytes(String key) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(SECRET_KEY_HASH_TRANSFORMATION);
        md.reset();
        byte[] keyBytes = md.digest(key.getBytes(CHARSET));
        return keyBytes;
    }

    public void put(String key, String value) {
        if (value == null) {
            this.preferences.edit().remove(this.toKey(key)).commit();
        } else {
            this.putValue(this.toKey(key), value);
        }
    }

    public boolean containsKey(String key) {
        return this.preferences.contains(this.toKey(key));
    }

    public void removeValue(String key) {
        this.preferences.edit().remove(this.toKey(key)).commit();
    }

    public String getString(String key) throws UnviredPreferencesException {
        if (this.preferences.contains(this.toKey(key))) {
            String securedEncodedValue = this.preferences.getString(this.toKey(key), "");
            return this.decrypt(securedEncodedValue);
        }
        return null;
    }

    public void clear() {
        this.preferences.edit().clear().commit();
    }

    private String toKey(String key) {
        if (this.encryptKeys) {
            return this.encrypt(key, this.keyWriter);
        }
        return key;
    }

    private void putValue(String key, String value) throws UnviredPreferencesException {
        String secureValueEncoded = this.encrypt(value, this.writer);
        this.preferences.edit().putString(key, secureValueEncoded).commit();
    }

    protected String encrypt(String value, Cipher writer) throws UnviredPreferencesException {
        byte[] secureValue;
        try {
            secureValue = UnviredPreferences.convert(writer, value.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnviredPreferencesException(e);
        }
        String secureValueEncoded = Base64.encodeToString((byte[])secureValue, (int)2);
        return secureValueEncoded;
    }

    protected String decrypt(String securedEncodedValue) {
        byte[] securedValue = Base64.decode((String)securedEncodedValue, (int)2);
        byte[] value = UnviredPreferences.convert(this.reader, securedValue);
        try {
            return new String(value, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnviredPreferencesException(e);
        }
    }

    private static byte[] convert(Cipher cipher, byte[] bs) throws UnviredPreferencesException {
        try {
            return cipher.doFinal(bs);
        }
        catch (Exception e) {
            throw new UnviredPreferencesException(e);
        }
    }

    public static class UnviredPreferencesException
    extends RuntimeException {
        public UnviredPreferencesException(Throwable e) {
            super(e);
        }
    }
}

