/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import android.content.SharedPreferences;
import com.unvired.core.ApplicationManager;
import com.unvired.core.FrameworkVersion;
import com.unvired.database.DBException;
import com.unvired.logger.Logger;
import com.unvired.login.LoginParameters;
import com.unvired.model.ApplicationMeta;
import com.unvired.utils.FrameworkHelper;

public class UpdateManager {
    private static final String RELEASE_NUMBER = "@RELEASE_NUMBER@";

    public static boolean isUpgrade() throws DBException {
        ApplicationMeta applicationMeta = ApplicationManager.getInstance().getApplicationMeta(LoginParameters.getAppName());
        if (applicationMeta == null) {
            return false;
        }
        String fwVersionInDB = applicationMeta.getFrameworkVersion();
        String currentFwVersion = FrameworkVersion.getFrameworkVersion();
        Logger.i("Database FW Version : " + fwVersionInDB);
        Logger.i("Current FW Version : " + currentFwVersion);
        boolean updateRequired = false;
        if (!RELEASE_NUMBER.equals(fwVersionInDB) && !RELEASE_NUMBER.equals(currentFwVersion)) {
            String currentFwVersionMajMin;
            boolean upgradeFramework;
            String fwVersionInDBMajMin = fwVersionInDB.substring(0, fwVersionInDB.lastIndexOf("."));
            boolean bl = upgradeFramework = !fwVersionInDBMajMin.equalsIgnoreCase(currentFwVersionMajMin = currentFwVersion.substring(0, fwVersionInDB.lastIndexOf(".")));
            if (upgradeFramework) {
                SharedPreferences sharedPrefs = LoginParameters.getContext().getSharedPreferences("VERSION_UPGRADE", 0);
                SharedPreferences.Editor editor = sharedPrefs.edit();
                editor.putBoolean("FW_DB_UPGRADE", true);
                editor.putString("DB_KEY", FrameworkHelper.getUniqueId());
                editor.commit();
                updateRequired = true;
            }
        }
        String applicationVersionInMetaXML = LoginParameters.getAppVersion();
        String applicationVersionInDB = applicationMeta.getVersion();
        Logger.i("Meta XML App Version : " + applicationVersionInMetaXML);
        Logger.i("Database App Version : " + applicationVersionInDB);
        if (applicationVersionInMetaXML != null && !applicationVersionInMetaXML.equalsIgnoreCase(applicationVersionInDB)) {
            SharedPreferences sharedPrefs = LoginParameters.getContext().getSharedPreferences("VERSION_UPGRADE", 0);
            SharedPreferences.Editor editor = sharedPrefs.edit();
            editor.putBoolean("APP_DB_UPGRADE", true);
            editor.putString("DB_KEY", FrameworkHelper.getUniqueId());
            editor.commit();
            updateRequired = true;
        }
        return updateRequired;
    }
}

