/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils;

import com.unvired.utils.FileHelper;
import com.unvired.utils.PathManager;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static String documentToString(Document document) throws Exception {
        String filename = PathManager.getInstance().getDirectoryPathFor(PathManager.PATH_TYPE.TEMP_FILE);
        File file = new File(filename);
        if (!file.exists() && !file.createNewFile()) {
            throw new Exception(Class.class.getName() + " : Error while creating file " + filename);
        }
        XMLUtils.writeDocumentToFile(document, filename);
        String content = FileHelper.readFromFile(file);
        file.delete();
        return content;
    }

    private static void writeDocumentToFile(Document document, String fileName) throws Exception {
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("encoding", "UTF-8");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        tr.transform(new DOMSource(document), new StreamResult(new FileOutputStream(fileName)));
    }

    public static String documentToFragmentString(Document document) throws Exception {
        return XMLUtils.nodeToString(document.getDocumentElement(), new HashSet<String>(), document.getDocumentElement().getNamespaceURI());
    }

    /*
     * WARNING - void declaration
     */
    protected static String nodeToString(Node node, Set<String> parentPrefixes, String namespaceURI) throws Exception {
        StringBuilder b = new StringBuilder();
        if (node == null) {
            return "";
        }
        if (node instanceof Element) {
            boolean bl;
            int i;
            Element element = (Element)node;
            b.append("<");
            b.append(element.getNodeName());
            HashMap<String, String> thisLevelPrefixes = new HashMap<String, String>();
            if (element.getPrefix() != null && !parentPrefixes.contains(element.getPrefix())) {
                thisLevelPrefixes.put(element.getPrefix(), element.getNamespaceURI());
            }
            if (element.hasAttributes()) {
                void var7_8;
                NamedNodeMap map = element.getAttributes();
                boolean bl2 = false;
                while (var7_8 < map.getLength()) {
                    Node attr2 = map.item((int)var7_8);
                    if (!attr2.getNodeName().startsWith("xmlns")) {
                        if (attr2.getPrefix() != null && !parentPrefixes.contains(attr2.getPrefix())) {
                            thisLevelPrefixes.put(attr2.getPrefix(), element.getNamespaceURI());
                        }
                        b.append(' ');
                        b.append(attr2.getNodeName());
                        b.append("=\"");
                        b.append(attr2.getNodeValue());
                        b.append('\"');
                    }
                    ++var7_8;
                }
            }
            if (namespaceURI != null && !thisLevelPrefixes.containsValue(namespaceURI) && !namespaceURI.equals(element.getParentNode().getNamespaceURI())) {
                b.append(" xmlns=\"").append(namespaceURI).append('\"');
            }
            for (Map.Entry entry : thisLevelPrefixes.entrySet()) {
                b.append(" xmlns:").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append('\"');
                parentPrefixes.add((String)entry.getKey());
            }
            NodeList children = element.getChildNodes();
            boolean bl3 = true;
            for (i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() == 2) continue;
                bl = false;
                break;
            }
            if (!bl) {
                b.append('>');
                for (i = 0; i < children.getLength(); ++i) {
                    b.append(XMLUtils.nodeToString(children.item(i), parentPrefixes, children.item(i).getNamespaceURI()));
                }
                b.append("</");
                b.append(element.getNodeName());
                b.append('>');
            } else {
                b.append("/>");
            }
            for (String thisLevelPrefix : thisLevelPrefixes.keySet()) {
                parentPrefixes.remove(thisLevelPrefix);
            }
        } else if (node.getNodeValue() != null) {
            b.append(XMLUtils.encodeText(node.getNodeValue()));
        }
        return b.toString();
    }

    protected static String encodeText(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("\"", "&quot;");
        s = s.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
        return s;
    }

    public static Element appendNewElement(Document document, Element parent, Enum el) {
        return XMLUtils.appendNewElement(document, parent, el.toString());
    }

    public static Element appendNewElement(Document document, Element parent, String element) {
        Element child = document.createElement(element);
        parent.appendChild(child);
        return child;
    }

    public static Element appendNewElementIfNotNull(Document document, Element parent, Enum el, Object content) {
        return XMLUtils.appendNewElementIfNotNull(document, parent, el, content, null);
    }

    public static Element appendNewElementIfNotNull(Document document, Element parent, Enum el, Object content, String namespace) {
        return XMLUtils.appendNewElementIfNotNull(document, parent, el.toString(), content, namespace);
    }

    public static Element appendNewElementIfNotNull(Document document, Element parent, String element, Object content) {
        return XMLUtils.appendNewElementIfNotNull(document, parent, element, content, null);
    }

    public static Element appendNewElementIfNotNull(Document document, Element parent, String element, Object content, String namespace) {
        if (content == null) {
            return parent;
        }
        return XMLUtils.appendNewElement(document, parent, element, content, namespace);
    }

    public static Element appendNewElement(Document document, Element parent, String element, Object content) {
        return XMLUtils.appendNewElement(document, parent, element, content, null);
    }

    public static Element appendNewElement(Document document, Element parent, String element, Object content, String namespace) {
        Element childElement = namespace != null ? document.createElementNS(namespace, element) : document.createElement(element);
        if (content != null) {
            childElement.appendChild(document.createTextNode(content.toString()));
        }
        parent.appendChild(childElement);
        return childElement;
    }

    public static String getTextContent(Node node) {
        StringBuffer buffer = new StringBuffer();
        NodeList childList = node.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (child.getNodeType() != 3) continue;
            buffer.append(child.getNodeValue());
        }
        return buffer.toString();
    }
}

