/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils.uiutils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.unvired.ui.UIStyle;
import com.unvired.ui.resources.IconHelper;
import java.io.InputStream;

public class ClearableEditText
extends AppCompatEditText
implements View.OnTouchListener,
View.OnFocusChangeListener,
TextWatcher {
    private Drawable xD;
    private Listener listener;
    private View.OnTouchListener l;
    private View.OnFocusChangeListener f;

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.isFocused()) {
            this.setClearIconVisible(!this.isEmpty(s));
        }
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public ClearableEditText(Context context) {
        super(context);
        this.init();
    }

    public ClearableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ClearableEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.l = l;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener f) {
        this.f = f;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.getCompoundDrawables()[2] != null) {
            boolean tappedX;
            boolean bl = tappedX = event.getX() > (float)(this.getWidth() - this.getPaddingRight() - this.xD.getIntrinsicWidth());
            if (tappedX) {
                if (event.getAction() == 1) {
                    this.setText("");
                    if (this.listener != null) {
                        this.listener.didClearText();
                    }
                }
                return true;
            }
        }
        return this.l != null && this.l.onTouch(v, event);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus && !this.isEmpty((CharSequence)this.getText())) {
            this.setClearIconVisible(true);
        } else {
            this.setClearIconVisible(false);
        }
        if (this.f != null) {
            this.f.onFocusChange(v, hasFocus);
        }
    }

    public boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    private void init() {
        this.xD = this.getCompoundDrawables()[2];
        if (this.xD == null) {
            this.xD = Drawable.createFromStream((InputStream)IconHelper.getIcon("ic_clear.png"), (String)"");
        }
        if (this.xD != null) {
            this.xD.setBounds(0, 0, UIStyle.dp24 - 2, UIStyle.dp24 - 2);
        }
        this.setClearDrawableColor(this.getCurrentTextColor());
        this.setClearIconVisible(false);
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.setSingleLine();
        int padding = UIStyle.dp8;
        this.setPadding(padding, padding, padding, padding);
        this.setInputType(this.getInputType());
    }

    protected void setClearIconVisible(boolean visible) {
        Drawable x = visible ? this.xD : null;
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], x, this.getCompoundDrawables()[3]);
    }

    public void setSupportBackgroundTintList(@Nullable ColorStateList tint) {
        super.setSupportBackgroundTintList(tint);
        if (tint != null) {
            this.setClearDrawableColor(tint.getDefaultColor());
        }
    }

    public void setClearDrawableColor(int color) {
        if (this.xD != null) {
            this.xD.setColorFilter(color, PorterDuff.Mode.MULTIPLY);
        }
    }

    public static interface Listener {
        public void didClearText();
    }
}

