/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils.uiutils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Animatable;
import android.support.annotation.ColorInt;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.widget.Button;
import com.unvired.utils.uiutils.ProgressDrawable;

public class ProgressButton
extends AppCompatButton
implements Animatable {
    private ProgressDrawable drawable;
    private onAnimFinish listener;

    public ProgressButton(Context context) {
        super(context);
        this.init();
    }

    public ProgressButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ProgressButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.drawable = new ProgressDrawable(this.getHeight(), (Button)this);
        this.drawable.setColorDefault(this.getCurrentTextColor());
        this.drawable.setAnimatable(this);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
    }

    public void startRotate() {
        this.drawable = null;
        this.drawable = new ProgressDrawable(this.getHeight(), (Button)this);
        this.drawable.setColorDefault(this.getCurrentTextColor());
        this.drawable.setAnimatable(this);
        this.setCompoundDrawablesWithIntrinsicBounds(this.drawable, null, null, null);
        this.drawable.startRotate();
    }

    public void stopRotate() {
        if (this.drawable != null) {
            this.drawable.stopRotate();
        }
    }

    public void animFinish() {
        this.drawable.animFinish();
    }

    public void animError() {
        this.drawable.animError();
    }

    public void removeDrawable() {
        this.drawable = null;
        this.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.drawable != null) {
            this.drawable.stopRotate();
        }
        this.drawable = null;
    }

    public void start() {
        this.startRotate();
    }

    public void stop() {
        if (this.listener != null) {
            this.listener.onFinish();
        }
    }

    public void setOnAnimFinishListener(onAnimFinish listener) {
        this.listener = listener;
    }

    public boolean isRunning() {
        return false;
    }

    public void setTextColor(@ColorInt int color) {
        super.setTextColor(color);
        if (this.drawable != null) {
            this.drawable.setColorDefault(color);
            this.drawable.setColor(color);
        }
    }

    public static interface onAnimFinish {
        public void onFinish();
    }
}

