/*
 * Decompiled with CFR 0.152.
 */
package com.unvired.utils.uiutils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.animation.AccelerateInterpolator;
import android.widget.Button;

public class ProgressDrawable
extends Drawable {
    private Paint mPaint;
    private float width;
    private static final int STAGE_NULL = 0;
    private static final int STAGE_ROTATE = 1;
    private static final int STAGE_FINISH = 2;
    private static final int STAGE_ERROR = 3;
    private int stage = 0;
    private RectF rectF;
    private float centerX;
    private float centerY;
    private float degreen = 0.0f;
    private ValueAnimator animator;
    private Path pathFinish;
    private Path pathErrorOne;
    private Path pathErrorTwo;
    private float lenFinish;
    private float lenError;
    private float length;
    private int colorDefault = -1;
    private int colorError = -65536;
    private Button button;
    private Animatable animatable;

    public ProgressDrawable(float size, Button button) {
        this.width = (float)((double)size * 0.75);
        this.button = button;
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(4.0f);
        this.rectF = new RectF(0.0f, 0.0f, this.width, this.width);
        this.centerX = this.width / 2.0f;
        this.centerY = this.width / 2.0f;
        this.initPath();
    }

    private void initPath() {
        this.pathFinish = new Path();
        this.pathFinish.moveTo(this.width * 1.0f, this.width * 0.2f);
        this.pathFinish.lineTo(this.width * 0.4f, this.width * 0.8f);
        this.pathFinish.lineTo(0.0f, this.width * 0.4f);
        PathMeasure pm = new PathMeasure(this.pathFinish, false);
        this.lenFinish = pm.getLength();
        this.pathErrorOne = new Path();
        this.pathErrorOne.moveTo(this.width * 0.9f, this.width * 0.9f);
        this.pathErrorOne.lineTo(this.width * 0.1f, this.width * 0.1f);
        pm.setPath(this.pathErrorOne, false);
        this.lenError = pm.getLength();
        this.pathErrorTwo = new Path();
        this.pathErrorTwo.moveTo(this.width * 0.9f, this.width * 0.1f);
        this.pathErrorTwo.lineTo(this.width * 0.1f, this.width * 0.9f);
    }

    public int getIntrinsicHeight() {
        return (int)this.width;
    }

    public int getIntrinsicWidth() {
        return (int)this.width;
    }

    public void draw(Canvas canvas) {
        if (this.stage == 0) {
            return;
        }
        if (this.stage == 1) {
            canvas.save();
            canvas.rotate(this.degreen, this.centerX, this.centerY);
            canvas.drawArc(this.rectF, -90.0f, 100.0f, false, this.mPaint);
            canvas.restore();
            return;
        }
        if (this.stage == 2) {
            canvas.drawPath(this.pathFinish, this.mPaint);
            this.mPaint.setPathEffect(null);
            return;
        }
        if (this.stage == 3) {
            canvas.drawPath(this.pathErrorOne, this.mPaint);
            canvas.drawPath(this.pathErrorTwo, this.mPaint);
            this.mPaint.setPathEffect(null);
            return;
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public void startRotate() {
        this.stage = 1;
        this.mPaint.setColor(this.colorDefault);
        if (this.animator == null) {
            this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.animator.setDuration(2000L);
            this.animator.setRepeatCount(-1);
            this.animator.setRepeatMode(1);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ProgressDrawable.this.degreen = ProgressDrawable.this.degreen + 5.0f;
                    ProgressDrawable.this.invalidateSelf();
                }
            });
        }
        this.animator.start();
    }

    public void stopRotate() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.end();
        }
    }

    private void setPhase(float phase) {
        this.mPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.length, this.length}, -this.length * phase));
        this.invalidateSelf();
    }

    public void animFinish() {
        this.stage = 2;
        this.length = this.lenFinish;
        this.mPaint.setColor(this.colorDefault);
        this.startAnim();
    }

    public void animError() {
        this.stage = 3;
        this.length = this.lenError;
        this.mPaint.setColor(this.colorError);
        this.startAnim();
    }

    private void startAnim() {
        this.stopRotate();
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"Phase", (float[])new float[]{1.0f, 0.0f});
        animator.setDuration(400L);
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ProgressDrawable.this.button.setClickable(true);
                if (ProgressDrawable.this.animatable != null) {
                    ProgressDrawable.this.animatable.stop();
                }
            }
        });
        animator.start();
    }

    public void setColorDefault(int color) {
        this.colorDefault = color;
    }

    public void setColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setAnimatable(Animatable animatable) {
        this.animatable = animatable;
    }
}

