/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.location.Location;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.mirasense.scanditsdk.ScanditSDKBarcodeReader;
import com.mirasense.scanditsdk.ScanditSDKBarcodeReaderFactory;
import com.mirasense.scanditsdk.ScanditSDKDiagnostics;
import com.mirasense.scanditsdk.ScanditSDKGlobals;
import com.mirasense.scanditsdk.ScanditSDKRoughCode;
import com.mirasense.scanditsdk.ScanditSDKScanState;
import com.mirasense.scanditsdk.analytics.LocationHub;
import com.mirasense.scanditsdk.analytics.LocationHubListener;
import com.mirasense.scanditsdk.gui.ScanditSDKOverlayView;
import com.mirasense.scanditsdk.interfaces.ScanditSDK;
import com.mirasense.scanditsdk.interfaces.ScanditSDKCaptureListener;
import com.scandit.camera.SbCameraPreview;
import com.scandit.camera.SbCameraPreviewListener;
import com.scandit.camera.SbDeviceProperties;
import java.io.File;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanditSDKBarcodePicker
extends RelativeLayout
implements ScanditSDK,
LocationHubListener,
SbCameraPreviewListener {
    private static final int DEBUG_OVERLAY_NONE = 0;
    private static final int DEBUG_OVERLAY_1D = 1;
    private static final int LOCATION_NONE = 0;
    private static final int LOCATION_IF_AVAILABLE = 1;
    private static final String SCANDIT_SDK_SHARED_LIBRARY_NAME = "scanditsdk-android-4.0.1";
    private int mLocationGathering;
    private Location mQueuedLocation = null;
    private long mLastLocationPoll = 0L;
    private final String mAppKey;
    private ScanditSDKOverlayView mOverlayView;
    private ScanditSDKBarcodeReader mBarcodeReader = null;
    private SbCameraPreview mCameraPreview = null;
    private boolean mRecognitionRunning = false;
    private boolean mRecognitionPaused = false;
    private ScanditSDKScanState mScanState;
    private byte[] mLastPreviewImageData;
    private ScanditSDKCaptureListener mCaptureListener = null;
    private byte[] mImageDataOfFirstRecognition;
    private int mDebugOverlay = 0;
    private ImageView mDebugOverlayView = null;

    public ScanditSDKBarcodePicker(Context context, Class<?> rawClass, String appKey) {
        this(context, appKey, 0);
    }

    public ScanditSDKBarcodePicker(Context context, String appKey) {
        this(context, appKey, 0);
    }

    public ScanditSDKBarcodePicker(Context context, Class<?> rawClass, String appKey, int cameraFacingPreference) {
        this(context, appKey, cameraFacingPreference);
    }

    public ScanditSDKBarcodePicker(Context context, String appKey, int cameraFacingPreference) {
        super(context);
        ScanditSDKGlobals.deleteInstance();
        this.mCameraPreview = new SbCameraPreview(context, cameraFacingPreference == 1 ? 1 : 0);
        this.mCameraPreview.addListener(this);
        this.mAppKey = appKey;
        ScanditSDKDiagnostics.getInstance().clean();
        SbDeviceProperties.isTabletDevice(this.getContext());
        this.mLocationGathering = 1;
        SbDeviceProperties.isTabletDevice(this.getContext());
        this.initializeRecognitionEngine();
        this.mScanState = new ScanditSDKScanState();
        this.mScanState = new ScanditSDKScanState();
        this.mRecognitionRunning = false;
        this.mRecognitionPaused = false;
        this.mImageDataOfFirstRecognition = null;
        this.mOverlayView = new ScanditSDKOverlayView(context, this, 300L);
        this.setClipChildren(true);
        this.addView((View)this.mCameraPreview, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.addView((View)this.mOverlayView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.setBackgroundColor(-16777216);
    }

    public static boolean canRunPortraitPicker() {
        return SbDeviceProperties.canDisplayProperPortraitCameraPreview();
    }

    @Override
    public boolean supportsCameraFacing(int cameraFacingPreference) {
        return this.mCameraPreview.supportsCamera(cameraFacingPreference == 0 ? 0 : 1);
    }

    @Override
    public boolean changeCameraFacing(int cameraFacingPreference) {
        return this.mCameraPreview.changeCamera(cameraFacingPreference == 0 ? 0 : 1);
    }

    @Override
    public boolean switchCameraFacing() {
        return this.mCameraPreview.switchCamera();
    }

    @Override
    public int getCameraFacingDirection() {
        if (this.mCameraPreview.getCameraPosition() == 1) {
            return 1;
        }
        return 0;
    }

    public boolean hasTorch() {
        return this.mCameraPreview.hasTorch();
    }

    public boolean isCameraBeingStarted() {
        return this.mCameraPreview.isCameraBeingStarted();
    }

    public boolean isTorchBeingSet() {
        return this.mCameraPreview.isTorchBeingSet();
    }

    @Override
    public void didResizePreview(RelativeLayout.LayoutParams layoutParams) {
        this.mOverlayView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void didDestroyPreview() {
        this.mRecognitionRunning = false;
    }

    @Override
    public void didOpenCamera() {
        this.mOverlayView.loadBeep();
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setPreviewRotation(this.mCameraPreview.getDisplayOrientation());
        if (globals.isLegacy()) {
            this.mBarcodeReader.setDefaultDetectorAngle(90);
            this.mBarcodeReader.setOrientation(1);
        } else if (this.mCameraPreview.getDisplayOrientation() == 0) {
            this.mBarcodeReader.setDefaultDetectorAngle(0);
            this.mBarcodeReader.setOrientation(4);
        } else if (this.mCameraPreview.getDisplayOrientation() == 180) {
            this.mBarcodeReader.setDefaultDetectorAngle(0);
            this.mBarcodeReader.setOrientation(3);
        } else if (this.mCameraPreview.getDisplayOrientation() == 270) {
            this.mBarcodeReader.setDefaultDetectorAngle(90);
            this.mBarcodeReader.setOrientation(2);
        } else {
            this.mBarcodeReader.setDefaultDetectorAngle(90);
            this.mBarcodeReader.setOrientation(1);
        }
        if (this.mCameraPreview.getCameraPosition() == 1) {
            this.mBarcodeReader.setCameraUsed(1);
        } else {
            this.mBarcodeReader.setCameraUsed(2);
        }
        String focusMode = this.mCameraPreview.getFocusMode();
        if (focusMode == "continuous-picture") {
            this.mBarcodeReader.setAutoFocusStrategy(4);
        } else if (focusMode == "continuous-video") {
            this.mBarcodeReader.setAutoFocusStrategy(3);
        } else if (focusMode == "auto" || focusMode == "macro") {
            this.mBarcodeReader.setAutoFocusStrategy(2);
        } else {
            this.mBarcodeReader.setAutoFocusStrategy(1);
        }
        this.setScanningHotSpot(globals.getScanningHotSpotX(), globals.getScanningHotSpotY());
    }

    @Override
    public ScanditSDKOverlayView getOverlayView() {
        return this.mOverlayView;
    }

    @Override
    public void setCaptureListener(ScanditSDKCaptureListener listener) {
        this.mCaptureListener = listener;
    }

    @Override
    public void reset() {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.resetEngine();
        }
        this.mScanState.reset();
        this.mOverlayView.resetGUI();
        this.mImageDataOfFirstRecognition = null;
    }

    public static void cleanup() {
        ScanditSDKGlobals.deleteInstance();
    }

    @Override
    public byte[] getCameraPreviewImageOfFirstBarcodeRecognition() {
        return this.mImageDataOfFirstRecognition;
    }

    @Override
    public byte[] getMostRecentCameraPreviewImage() {
        return this.mLastPreviewImageData;
    }

    @Override
    public int getCameraPreviewImageWidth() {
        return this.mCameraPreview.getPreviewWidth();
    }

    @Override
    public int getCameraPreviewImageHeight() {
        return this.mCameraPreview.getPreviewHeight();
    }

    @Override
    public boolean isScanning() {
        return this.mRecognitionRunning;
    }

    @Override
    public void startScanning() {
        if (this.mRecognitionRunning) {
            return;
        }
        this.mOverlayView.startIndicator();
        this.mCameraPreview.startPreview();
        this.reset();
        this.mRecognitionRunning = true;
    }

    @Override
    @TargetApi(value=8)
    public void stopScanning() {
        if (this.mBarcodeReader == null || !this.mRecognitionRunning) {
            return;
        }
        this.mBarcodeReader.reportCancellation();
        this.mOverlayView.stopIndicator();
        this.mCameraPreview.stopPreview();
        this.mRecognitionRunning = false;
    }

    @Override
    public void resumeScanning() {
        this.reset();
        this.mRecognitionPaused = false;
    }

    @Override
    public void pauseScanning() {
        if (this.mRecognitionRunning) {
            this.mRecognitionPaused = true;
        }
    }

    @Override
    public void setScanningHotSpot(float relX, float relY) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setScanningHotSpotX(relX);
        globals.setScanningHotSpotY(relY);
        if (this.mBarcodeReader != null) {
            if (globals.getPreviewRotation() == 90) {
                this.mBarcodeReader.setHotSpot(relX, relY);
            } else if (globals.getPreviewRotation() == 0) {
                this.mBarcodeReader.setHotSpot(1.0f - relY, relX);
            } else if (globals.getPreviewRotation() == 270) {
                this.mBarcodeReader.setHotSpot(1.0f - relX, 1.0f - relY);
            } else {
                this.mBarcodeReader.setHotSpot(relY, 1.0f - relX);
            }
        }
    }

    @Override
    public void setScanningHotSpotHeight(float height) {
        if (height <= 0.0f || (double)height > 1.0) {
            return;
        }
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setScanningHotSpotHeight(height);
        if (this.mBarcodeReader != null) {
            double hotSpotY = globals.getScanningHotSpotY();
            float top = (float)Math.max(hotSpotY - (double)(height / 2.0f), 0.0);
            if (this.getWidth() < this.getHeight()) {
                this.mBarcodeReader.setRelativeRestrictedArea(0.0f, top, 1.0f, height);
            } else {
                this.mBarcodeReader.setRelativeRestrictedArea(top, 0.0f, height, 1.0f);
            }
            if ((double)height <= 0.1 && globals.getRestrictActiveScanningArea()) {
                this.mBarcodeReader.setDetectionStrategy(2);
            } else if (globals.getRestrictActiveScanningArea()) {
                this.mBarcodeReader.setDetectionStrategy(1);
            }
        }
    }

    @Override
    public void ignorePreviewAspectRatio() {
        this.mCameraPreview.dontAdjustSubviewDimensions();
    }

    @Override
    public void set1DScanningEnabled(boolean enabled) {
        this.setEan13AndUpc12Enabled(enabled);
        this.setEan8Enabled(enabled);
        this.setUpceEnabled(enabled);
        this.setCode39Enabled(enabled);
        this.setCode128Enabled(enabled);
        this.setItfEnabled(enabled);
        this.setMsiPlesseyEnabled(enabled);
        this.setGS1DataBarEnabled(enabled);
        this.setGS1DataBarExpandedEnabled(enabled);
    }

    @Override
    public void set2DScanningEnabled(boolean enabled) {
        this.setQrEnabled(enabled);
        this.setDataMatrixEnabled(enabled);
        this.setPdf417Enabled(enabled);
    }

    @Override
    public void setEan13AndUpc12Enabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enableEan13Upc12(enabled);
        }
    }

    @Override
    public void setEan8Enabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enableEan8(enabled);
        }
    }

    @Override
    public void setUpceEnabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enableUpce(enabled);
        }
    }

    @Override
    public void setCode39Enabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enableCode39(enabled);
        }
    }

    @Override
    public void setCode128Enabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enableEan128(enabled);
        }
    }

    @Override
    public void setItfEnabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enableItf(enabled);
        }
    }

    @Override
    public void setQrEnabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enableQR(enabled);
        }
    }

    @Override
    public void setDataMatrixEnabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enableDataMatrix(enabled);
        }
    }

    @Override
    public void setPdf417Enabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enablePdf417(enabled);
        }
    }

    @Override
    public void setMsiPlesseyEnabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.enableMsiPlessey(enabled);
        }
    }

    @Override
    public void setMsiPlesseyChecksumType(int checksumType) {
        if (checksumType < 0 || checksumType > 4) {
            checksumType = 1;
        }
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setMsiPlesseyChecksumType(checksumType);
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.setMsiPlesseyChecksumType(checksumType);
        }
    }

    @Override
    public void setGS1DataBarEnabled(boolean enabled) {
        this.mBarcodeReader.enableGS1DataBar(enabled);
    }

    @Override
    public void setGS1DataBarExpandedEnabled(boolean enabled) {
        this.mBarcodeReader.enableGS1DataBarExpanded(enabled);
    }

    @Override
    public void setInverseRecognitionEnabled(boolean enabled) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.setInverseDetectionActive(enabled);
        }
    }

    @Override
    public void setMicroDataMatrixEnabled(boolean enabled) {
        this.force2dRecognition(enabled);
        if (this.mBarcodeReader != null) {
            if (enabled) {
                this.mBarcodeReader.enableDataMatrix(enabled);
            }
            this.mBarcodeReader.setImprovedMicroDataMatrixRecognitionActive(enabled);
        }
    }

    @Override
    public void force2dRecognition(boolean force) {
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.force2dRecognition(force);
        }
    }

    @Override
    public void restrictActiveScanningArea(boolean restrict) {
        if (this.mBarcodeReader != null) {
            ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
            globals.setRestrictActiveScanningArea(restrict);
            if (restrict && (double)globals.getScanningHotSpotHeight() <= 0.1) {
                this.mBarcodeReader.setDetectionStrategy(2);
            } else if (restrict) {
                this.mBarcodeReader.setDetectionStrategy(1);
            } else {
                this.mBarcodeReader.setDetectionStrategy(0);
            }
        }
    }

    @Override
    public void setZoom(float zoomPercentage) {
        this.mCameraPreview.setZoom(zoomPercentage);
    }

    @Override
    public void setZoom(int zoom) {
        this.mCameraPreview.setZoom(zoom);
    }

    @Override
    public void switchTorchOn(boolean on) {
        this.mOverlayView.switchTorchOn(on);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (name.equals("blurryRecognition") && value instanceof Boolean) {
            this.mBarcodeReader.setEnableBlurryRecognition((Boolean)value);
        } else if (name.equals("sharpRecognition") && value instanceof Boolean) {
            this.mBarcodeReader.setEnableSharpRecognition((Boolean)value);
        } else if (name.equals("2dRecognition") && value instanceof Boolean) {
            this.mBarcodeReader.setEnable2dRecognition((Boolean)value);
        } else if (name.equals("checkDefaultLocation") && value instanceof Boolean) {
            this.mBarcodeReader.setEnableCheckDefaultLocation((Boolean)value);
        } else if (name.equals("autofocus") && value instanceof Boolean) {
            this.mCameraPreview.setAutoFocusEnabled((Boolean)value);
        } else if (name.equals("debugOverlay") && value instanceof Integer) {
            this.mDebugOverlay = Math.min((Integer)value, 2);
            if (this.mDebugOverlay != 0 && this.mDebugOverlayView == null) {
                this.mDebugOverlayView = new ImageView(this.getContext());
                this.addView((View)this.mDebugOverlayView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            } else if (this.mDebugOverlay == 0 && this.mDebugOverlayView != null) {
                this.removeView((View)this.mDebugOverlayView);
                this.mDebugOverlayView = null;
            }
        } else if (name.equals("stopProfiler")) {
            this.mBarcodeReader.stopProfiler();
        } else if (name.equals("dealloc")) {
            this.mBarcodeReader.deallocRecognitionEngine();
        }
    }

    @Override
    public Object getProperty(String name) {
        if (name.equals("diagnostics")) {
            return ScanditSDKDiagnostics.getInstance().getPlaintext();
        }
        if (name.equals("debugInfoText")) {
            return this.mBarcodeReader.getDebugInfoText();
        }
        return null;
    }

    private void setScanLocation(Location location) {
        if (this.mLocationGathering != 0 && location != null) {
            if (this.mBarcodeReader == null) {
                this.mQueuedLocation = location;
            } else {
                this.mBarcodeReader.setScanLocation(location);
            }
        }
    }

    @Override
    public void onLocationUpdate(Location location) {
        if (location != null) {
            this.setScanLocation(location);
        }
    }

    public void setTorch(boolean enabled) {
        this.mCameraPreview.setTorchEnabled(enabled);
    }

    public HashMap<String, String> processImage(byte[] data, int width, int height) {
        if (this.mOverlayView == null || this.mBarcodeReader == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        while (!this.mBarcodeReader.canDealloc()) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= 60000L) continue;
            Log.e((String)"ScanditSDK", (String)"The engine took way too long to initialize the tables, returning with null");
            return null;
        }
        start = System.currentTimeMillis();
        try {
            long curTime;
            if (this.mLocationGathering == 1 && (curTime = System.currentTimeMillis()) - this.mLastLocationPoll > 10000L) {
                this.setScanLocation(LocationHub.getInstance().getLastKnownLocation(this.getContext()));
                this.mLastLocationPoll = curTime;
            }
            this.performRecognition(data, width, height, this.mOverlayView.getWidth(), this.mOverlayView.getHeight());
        }
        catch (Exception e) {
            ScanditSDKDiagnostics diagnostics = ScanditSDKDiagnostics.getInstance();
            diagnostics.addException("Failed in processImage().", e);
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("duration", "" + (end - start));
        map.put("barcode", "");
        map.put("symbology", "");
        if (this.mScanState.codeDecoded) {
            map.put("barcode", this.mScanState.codeNumber);
            map.put("symbology", this.mScanState.codeType);
        }
        return map;
    }

    @Override
    @TargetApi(value=8)
    public boolean onPreviewFrame(byte[] data, Camera camera) {
        if (this.mOverlayView == null || !this.mRecognitionRunning || this.mRecognitionPaused || this.mBarcodeReader == null) {
            return false;
        }
        if (this.mCaptureListener != null) {
            this.mCaptureListener.didCaptureImage(data, this.mCameraPreview.getPreviewWidth(), this.mCameraPreview.getPreviewHeight());
        }
        try {
            long curTime;
            this.performRecognition(data, this.mCameraPreview.getPreviewWidth(), this.mCameraPreview.getPreviewHeight(), this.mOverlayView.getWidth(), this.mOverlayView.getHeight());
            if (this.mLocationGathering == 1 && (curTime = System.currentTimeMillis()) - this.mLastLocationPoll > 10000L) {
                this.setScanLocation(LocationHub.getInstance().getLastKnownLocation(this.getContext()));
                this.mLastLocationPoll = curTime;
            }
        }
        catch (Exception e) {
            ScanditSDKDiagnostics diagnostics = ScanditSDKDiagnostics.getInstance();
            diagnostics.addException("Failed in onPreviewFrame().", e);
            e.printStackTrace();
        }
        this.runDebugUpdate();
        return this.mBarcodeReader.fetchResult().length == 0 && this.mBarcodeReader.needsFocusedImage();
    }

    private void runDebugUpdate() {
        if (this.mDebugOverlay == 1) {
            byte[] imageBytes = this.mBarcodeReader.getLocalizationDebugImageBytes();
            int imageWidth = this.mBarcodeReader.getLocalizationDebugImageWidth();
            int imageHeight = this.mBarcodeReader.getLocalizationDebugImageHeight();
            int[] colors = new int[imageWidth * imageHeight];
            for (int i = 0; i < imageWidth; ++i) {
                for (int j = 0; j < imageHeight; ++j) {
                    int pixel;
                    byte[] colorArray = new byte[]{imageBytes[(i + imageHeight - 1 - j) * 4], imageBytes[(i + imageHeight - 1 - j) * 4 + 1], imageBytes[(i + imageHeight - 1 - j) * 4 + 2], imageBytes[(i + imageHeight - 1 - j) * 4 + 3]};
                    ByteBuffer pixelBuffer = ByteBuffer.wrap(colorArray);
                    colors[i + j * imageWidth] = pixel = pixelBuffer.getInt();
                }
            }
            Bitmap image = Bitmap.createBitmap((int[])colors, (int)imageWidth, (int)imageHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mDebugOverlayView.setImageBitmap(image);
        }
    }

    private void performRecognition(byte[] imageData, int imageWidth, int imageHeight, int screenWidth, int screenHeight) {
        if (imageData == null) {
            Log.e((String)"ScanditSDK", (String)"The data returned by the camera is null.");
            return;
        }
        this.mLastPreviewImageData = imageData;
        if (imageData.length < imageWidth * imageHeight) {
            Log.e((String)"ScanditSDK", (String)("The image information for camera preview images (" + imageData.length + " bytes) is not consistent with the image dimensions (" + imageWidth + "x" + imageHeight + " = min." + imageWidth * imageHeight + " bytes required). No recognition is performed."));
        }
        if (this.mBarcodeReader != null) {
            this.mBarcodeReader.processImage(imageData, imageHeight * imageWidth, imageWidth, imageHeight);
        }
        int guiOverlayW = Math.max(this.mOverlayView.getWidth(), this.mOverlayView.getHeight());
        int guiOverlayH = Math.min(this.mOverlayView.getWidth(), this.mOverlayView.getHeight());
        float factorX = (float)guiOverlayW / (float)imageWidth;
        float factorY = (float)guiOverlayH / (float)imageHeight;
        this.updateScanStateInformation(factorX, factorY);
        if (this.mScanState.codeDecoded && this.mScanState.counterCodeDecodedChanged == this.mScanState.counter) {
            this.mImageDataOfFirstRecognition = imageData;
        }
        this.mOverlayView.didUpdateStatus(this.mScanState);
    }

    private void updateScanStateInformation(float factorX, float factorY) {
        byte[] fetchedBytes;
        ++this.mScanState.counter;
        this.mScanState.roughCodes.clear();
        if (this.mBarcodeReader.fetchResult().equals("")) {
            if (this.mScanState.codeDecoded) {
                this.mScanState.codeDecoded = false;
                this.mScanState.counterCodeDecodedChanged = this.mScanState.counter;
            }
            if (this.mBarcodeReader.getCodeCenter() == null) {
                return;
            }
        }
        if (this.mScanState.codeDecoded != (fetchedBytes = this.mBarcodeReader.fetchResult()).length > 0) {
            this.mScanState.codeDecoded = fetchedBytes.length > 0;
            this.mScanState.counterCodeDecodedChanged = this.mScanState.counter;
        }
        if (fetchedBytes.length > 0) {
            String fetchedResult = new String(fetchedBytes);
            String[] barcodeStr = this.getCodeAndSymbology(fetchedResult);
            if (!this.mScanState.codeNumber.equals(barcodeStr[0])) {
                this.mScanState.counterCodeDecodedChanged = this.mScanState.counter;
            }
            this.mScanState.codeNumber = barcodeStr[0];
            this.mScanState.codeType = barcodeStr[1];
        }
        this.mScanState.stayAtDefaultLocation = this.mBarcodeReader.shouldIndicatorStayAtDefaultLocation();
        if (this.mBarcodeReader.getCodeCenter() != null) {
            int[] center = this.mBarcodeReader.getCodeCenter();
            int[] locationSize = this.mBarcodeReader.getCodeSize();
            ScanditSDKRoughCode code = new ScanditSDKRoughCode(this.getContext(), center, this.mBarcodeReader.getCodeAngle(), this.mOverlayView.getWidth(), this.mOverlayView.getHeight(), factorX, factorY, this.mCameraPreview.getCameraPosition() == 1);
            code.setLongSide((int)((float)Math.max(locationSize[0], locationSize[1]) * Math.max(factorX, factorY)));
            code.setShortSide((int)((float)Math.min(locationSize[0], locationSize[1]) * Math.max(factorX, factorY)));
            code.setLikelihood(this.mBarcodeReader.getCodeConfidence());
            this.mScanState.roughCodes.add(code);
        }
    }

    private String[] getCodeAndSymbology(String concatString) {
        if (concatString == null || concatString.trim().length() == 0) {
            return null;
        }
        String[] result = new String[2];
        int i = concatString.indexOf(":symbology:");
        if (i < 0) {
            return null;
        }
        result[0] = concatString.substring(0, i).trim();
        result[1] = concatString.substring(i + 11).trim();
        return result;
    }

    private void initializeRecognitionEngine() {
        if (this.mBarcodeReader == null) {
            System.loadLibrary(SCANDIT_SDK_SHARED_LIBRARY_NAME);
            ScanditSDKBarcodeReaderFactory factory = ScanditSDKBarcodeReaderFactory.getInstance();
            this.mBarcodeReader = factory.subscribeForReader();
            if (this.mBarcodeReader == null) {
                return;
            }
            File dir = this.getContext().getFilesDir();
            String platformAppId = this.getContext().getPackageName();
            String deviceId = Settings.Secure.getString((ContentResolver)this.getContext().getContentResolver(), (String)"android_id");
            if (deviceId == null || deviceId.length() < 16) {
                deviceId = "0000000000000000";
            }
            this.mBarcodeReader.setLegacyDeviceId(this.sha1Digest(deviceId));
            this.mBarcodeReader.setDeviceId(this.sha1Digest(deviceId));
            this.mBarcodeReader.setDeviceModel(Build.MODEL);
            this.mBarcodeReader.setPlatform("android");
            this.mBarcodeReader.setPlatformVersion(Build.VERSION.RELEASE);
            this.mBarcodeReader.setUsedFramework(ScanditSDKGlobals.usedFramework);
            this.mBarcodeReader.initialize(this.getContext().getFilesDir());
            this.mBarcodeReader.setupLicenseInformation(this.mAppKey, platformAppId);
            ScanditSDKDiagnostics diagnostics = ScanditSDKDiagnostics.getInstance();
            diagnostics.addValue("device", Build.MODEL);
            diagnostics.addValue("os version", Build.VERSION.RELEASE);
            diagnostics.addValue("absolute path", dir.getAbsolutePath());
            diagnostics.addValue("picker", "new");
            if (this.mQueuedLocation != null) {
                this.setScanLocation(this.mQueuedLocation);
                this.mQueuedLocation = null;
            }
        }
    }

    private String sha1Digest(String input) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            sha.update(input.getBytes());
            return this.byteArrayToHexStr(sha.digest());
        }
        catch (NoSuchAlgorithmException e) {
            ScanditSDKDiagnostics diagnostics = ScanditSDKDiagnostics.getInstance();
            diagnostics.addException("sha-1 not available", e);
            return "";
        }
    }

    private String byteArrayToHexStr(byte[] data) {
        char[] chars = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            byte current = data[i];
            int hi = (current & 0xF0) >> 4;
            int lo = current & 0xF;
            chars[2 * i] = (char)(hi < 10 ? 48 + hi : 97 + hi - 10);
            chars[2 * i + 1] = (char)(lo < 10 ? 48 + lo : 97 + lo - 10);
        }
        return new String(chars);
    }
}

