/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk;

import android.location.Location;
import android.os.Build;
import java.io.File;

public class ScanditSDKBarcodeReader {
    protected void initialize(File filesDir) {
        this.initializeRecognitionEngine(filesDir.getAbsolutePath(), filesDir.getAbsolutePath(), Build.MODEL);
    }

    protected void setScanLocation(Location location) {
        String loc = location.getLatitude() + "/" + location.getLongitude();
        this.setScanLocation(this.escapeJson(loc));
    }

    private String escapeJson(String string) {
        String cleanString = string;
        cleanString = cleanString.replaceAll("\"", "\\\"");
        for (byte i = 0; i < 32; i = (byte)((byte)(i + 1))) {
            byte[] chars = new byte[]{i};
            String s = new String(chars);
            cleanString = cleanString.replaceAll(s, "");
        }
        return cleanString;
    }

    private native void initializeRecognitionEngine(String var1, String var2, String var3);

    protected native void deallocRecognitionEngine();

    protected native void stopProfiler();

    protected native void setupLicenseInformation(String var1, String var2);

    protected native void setCameraUsed(int var1);

    protected native void setAutoFocusStrategy(int var1);

    protected native void setOrientation(int var1);

    protected native void setDeviceModel(String var1);

    protected native void setLegacyDeviceId(String var1);

    protected native void setDeviceId(String var1);

    protected native void setPlatform(String var1);

    protected native void setPlatformVersion(String var1);

    protected native void setUsedFramework(String var1);

    protected native void setScanLocation(String var1);

    protected native void reportCancellation();

    protected native void enableEan13Upc12(boolean var1);

    protected native void enableEan8(boolean var1);

    protected native void enableUpce(boolean var1);

    protected native void enableCode39(boolean var1);

    protected native void enableEan128(boolean var1);

    protected native void enableItf(boolean var1);

    protected native void enableQR(boolean var1);

    protected native void enableDataMatrix(boolean var1);

    protected native void enablePdf417(boolean var1);

    protected native void enableMsiPlessey(boolean var1);

    protected native void enableGS1DataBar(boolean var1);

    protected native void enableGS1DataBarExpanded(boolean var1);

    protected native void setMsiPlesseyChecksumType(int var1);

    protected native void setInverseDetectionActive(boolean var1);

    protected native void setImprovedMicroDataMatrixRecognitionActive(boolean var1);

    protected native void force2dRecognition(boolean var1);

    protected native void setDetectionStrategy(int var1);

    protected native void setRelativeRestrictedArea(float var1, float var2, float var3, float var4);

    protected native void tryingToDealloc(int var1);

    protected native boolean canDealloc();

    protected native void setEan128Certainty(int var1);

    protected native void setEan128OversizeOfBlackBars(int var1);

    protected native boolean shouldIndicatorStayAtDefaultLocation();

    protected native void processImage(byte[] var1, int var2, int var3, int var4);

    protected native void resetEngine();

    protected native byte[] fetchResult();

    protected native boolean needsFocusedImage();

    protected native int[] getCodeCenter();

    protected native int[] getCodeSize();

    protected native double getCodeAngle();

    protected native int getCodeConfidence();

    protected native void setHotSpot(float var1, float var2);

    protected native void setDefaultDetectorAngle(int var1);

    protected native void setEnableBlurryRecognition(boolean var1);

    protected native void setEnableSharpRecognition(boolean var1);

    protected native void setEnable2dRecognition(boolean var1);

    protected native void setEnableCheckDefaultLocation(boolean var1);

    protected native String getDebugInfoText();

    protected native int getLocalizationDebugImageWidth();

    protected native int getLocalizationDebugImageHeight();

    protected native byte[] getLocalizationDebugImageBytes();

    protected native int getLocalizationDebugImage2dWidth();

    protected native int getLocalizationDebugImage2dHeight();

    protected native byte[] getLocalizationDebugImage2dBytes();
}

