/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk;

import com.mirasense.scanditsdk.ScanditSDKBarcodeReader;

public class ScanditSDKBarcodeReaderFactory {
    private static ScanditSDKBarcodeReaderFactory sInstance = null;
    private ScanditSDKBarcodeReader mBarcodeReader;
    private int mReaderSubscriptions = 0;

    protected static ScanditSDKBarcodeReaderFactory getInstance() {
        if (sInstance == null) {
            sInstance = new ScanditSDKBarcodeReaderFactory();
        }
        return sInstance;
    }

    protected ScanditSDKBarcodeReader subscribeForReader() {
        ++this.mReaderSubscriptions;
        if (this.mBarcodeReader == null) {
            this.loadBarcodeReader();
        }
        return this.mBarcodeReader;
    }

    protected void unsubscribe() {
        --this.mReaderSubscriptions;
        if (this.mReaderSubscriptions < 1) {
            this.mBarcodeReader.tryingToDealloc(2);
            new DeallocThread().start();
        }
    }

    private void loadBarcodeReader() {
        this.mBarcodeReader = new ScanditSDKBarcodeReader();
    }

    private class DeallocThread
    extends Thread {
        public void run() {
            while (ScanditSDKBarcodeReaderFactory.this.mBarcodeReader != null && ScanditSDKBarcodeReaderFactory.this.mReaderSubscriptions <= 0) {
                if (ScanditSDKBarcodeReaderFactory.this.mBarcodeReader.canDealloc()) {
                    ScanditSDKBarcodeReaderFactory.this.mBarcodeReader.deallocRecognitionEngine();
                    sInstance = null;
                    return;
                }
                try {
                    DeallocThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
    }
}

