/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ScanditSDKDiagnostics {
    private static ScanditSDKDiagnostics sInstance = null;
    private JSONObject mRoot = new JSONObject();
    private OnNewEventListener mListener = null;

    private ScanditSDKDiagnostics() {
    }

    public static ScanditSDKDiagnostics getInstance() {
        if (sInstance == null) {
            sInstance = new ScanditSDKDiagnostics();
        }
        return sInstance;
    }

    public void setOnNewEventListener(OnNewEventListener listener) {
        this.mListener = listener;
    }

    private void notifyListener() {
        if (this.mListener != null) {
            this.mListener.newEventAdded();
        }
    }

    public void addValue(String id, String value) {
        JSONObject json = new JSONObject();
        try {
            json.put("value", (Object)value);
            json.put("time", System.currentTimeMillis());
            this.mRoot.put(id, (Object)json);
        }
        catch (JSONException e) {
            // empty catch block
        }
        this.notifyListener();
    }

    public void addValue(String id, int value) {
        JSONObject json = new JSONObject();
        try {
            json.put("value", value);
            json.put("time", System.currentTimeMillis());
            this.mRoot.put(id, (Object)json);
        }
        catch (JSONException e) {
            // empty catch block
        }
        this.notifyListener();
    }

    public void addValue(String id, boolean value) {
        JSONObject json = new JSONObject();
        try {
            json.put("value", value);
            json.put("time", System.currentTimeMillis());
            this.mRoot.put(id, (Object)json);
        }
        catch (JSONException e) {
            // empty catch block
        }
        this.notifyListener();
    }

    public void addValue(String id, int[] values) {
        JSONObject json = new JSONObject();
        try {
            json.put("id", (Object)id);
            JSONArray array = new JSONArray();
            for (int value : values) {
                array.put(value);
            }
            json.put("content", (Object)array);
            this.mRoot.put(id, (Object)json);
        }
        catch (JSONException e) {
            // empty catch block
        }
        this.notifyListener();
    }

    public void addValue(String id, String[] values) {
        JSONObject json = new JSONObject();
        try {
            json.put("id", (Object)id);
            JSONArray array = new JSONArray();
            for (String value : values) {
                array.put((Object)value);
            }
            json.put("content", (Object)array);
            this.mRoot.put(id, (Object)json);
        }
        catch (JSONException e) {
            // empty catch block
        }
        this.notifyListener();
    }

    public void addValue(String id, int[][] values) {
        JSONObject json = new JSONObject();
        try {
            JSONArray array = new JSONArray();
            for (int[] value : values) {
                JSONArray array2 = new JSONArray();
                for (int value2 : value) {
                    array2.put(value2);
                }
                array.put((Object)array2);
            }
            json.put("value", (Object)array);
            json.put("time", System.currentTimeMillis());
            this.mRoot.put(id, (Object)json);
        }
        catch (JSONException e) {
            // empty catch block
        }
        this.notifyListener();
    }

    public void addEvent(String id, String value) {
        JSONArray events = null;
        try {
            events = this.mRoot.getJSONArray(id);
        }
        catch (JSONException e) {
            events = new JSONArray();
        }
        try {
            JSONObject json = new JSONObject();
            json.put("value", (Object)value);
            json.put("time", System.currentTimeMillis());
            events.put((Object)json);
            this.mRoot.put(id, (Object)events);
        }
        catch (JSONException e) {
            // empty catch block
        }
        this.notifyListener();
    }

    public void addException(String id, Exception e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        JSONObject json = new JSONObject();
        try {
            json.put("value", (Object)((Object)writer).toString());
            json.put("time", System.currentTimeMillis());
            this.mRoot.put(id, (Object)json);
        }
        catch (JSONException ex) {
            // empty catch block
        }
        this.notifyListener();
    }

    public String getPlaintext() {
        try {
            return this.mRoot.toString(2);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public void clean() {
        this.mRoot = new JSONObject();
    }

    public static interface OnNewEventListener {
        public void newEventAdded();
    }
}

