/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.DisplayMetrics;
import com.mirasense.scanditsdk.gui.ScanditSDKRect;
import java.lang.ref.SoftReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanditSDKGlobals {
    private static ScanditSDKGlobals instance = null;
    public static String usedFramework = "native";
    public static final String LOG_NAME = "ScanditSDK";
    public static final boolean EVALUATION_SDK = true;
    public static final boolean ONLY_REGISTRATION_SDK = false;
    public static final int LOCATION_POLL_INTERVAL = 10;
    private final String DEFAULT_INITIAL_SCAN_SCREEN_STATE = "Align code with box";
    private final String DEFAULT_BARCODE_PRESENCE_DETECTED = "Align code and hold still";
    private final String DEFAULT_BARCODE_DECODING_IN_PROGRESS = "Decoding ...";
    private final String DEFAULT_TITLE_MESSAGE = "Scan a barcode";
    private final String DEFAULT_LEFT_BUTTON_CAPTION = "KEYPAD";
    private final String DEFAULT_LEFT_BUTTON_CAPTION_WHEN_KEYPAD_VISIBLE = "OK";
    private final String DEFAULT_RIGHT_BUTTON_CAPTION = "CANCEL";
    private final String DEFAULT_RIGHT_BUTTON_CAPTION_WHEN_KEYPAD_VISIBLE = "CANCEL";
    private final String DEFAULT_SEARCH_BAR_PLACEHOLDER = "Scan barcode or enter it here";
    private final ScanditSDKRect DEFAULT_TORCH_RECT = new ScanditSDKRect(0.05f, 0.01f, 67, 33);
    private final ScanditSDKRect DEFAULT_CAMERA_SWITCH_RECT = new ScanditSDKRect(0.05f, 0.01f, 67, 33);
    private final int DEFAULT_SEARCH_BAR_KEYBOARD_TYPE = 2;
    private final float DEFAULT_VIEWFINDER_RED = 1.0f;
    private final float DEFAULT_VIEWFINDER_GREEN = 1.0f;
    private final float DEFAULT_VIEWFINDER_BLUE = 1.0f;
    private final float DEFAULT_VIEWFINDER_RECOGNIZED_RED = 0.222f;
    private final float DEFAULT_VIEWFINDER_RECOGNIZED_GREEN = 0.753f;
    private final float DEFAULT_VIEWFINDER_RECOGNIZED_BLUE = 0.8f;
    private final float DEFAULT_VIEWFINDER_WIDTH = 0.7f;
    private final float DEFAULT_VIEWFINDER_HEIGHT = 0.3f;
    private final float DEFAULT_VIEWFINDER_LANDSCAPE_WIDTH = 0.4f;
    private final float DEFAULT_VIEWFINDER_LANDSCAPE_HEIGHT = 0.3f;
    private final boolean DEFAULT_DRAW_VIEWFINDER = true;
    private final float DEFAULT_HOT_SPOT_X = 0.5f;
    private final float DEFAULT_HOT_SPOT_Y = 0.5f;
    private final float DEFAULT_HOT_SPOT_HEIGHT = 0.25f;
    private final boolean DEFAULT_RESTRICT_ACTIVE_SCANNING_AREA = false;
    private final int DEFAULT_LOGO_X_OFFSET = 0;
    private final int DEFAULT_LOGO_Y_OFFSET = 0;
    private final int DEFAULT_LOGO_X_LANDSCAPE_OFFSET = 0;
    private final int DEFAULT_LOGO_Y_LANDSCAPE_OFFSET = 0;
    private final boolean DEFAULT_BEEP_ENABLED = true;
    private final boolean DEFAULT_VIBRATE_ENABLED = true;
    private final boolean DEFAULT_TORCH_ENABLED = true;
    private final int DEFAULT_CAMERA_SWITCH_VISIBILITY = 0;
    private final boolean DEFAULT_SHOW_TITLE_BAR = true;
    private final boolean DEFAULT_SHOW_TOOL_BAR = true;
    private final int DEFAULT_PREVIEW_ROTATION = 90;
    private final int DEFAULT_MSI_PLESSEY_CHECKSUM_MOD = 1;
    private final boolean DEFAULT_IS_LEGACY = false;
    private boolean mSetWithNewViewfinderDimensionFunction = true;
    private String mInitialScanScreenState = "Align code with box";
    private String mBarcodePresenceDetected = "Align code and hold still";
    private String mBarcodeDecodingInProgress = "Decoding ...";
    private String mTitleMessage = "Scan a barcode";
    private String mLeftButtonCaption = "KEYPAD";
    private String mLeftButtonCaptionWhenKeypadVisible = "OK";
    private String mRightButtonCaption = "CANCEL";
    private String mRightButtonCaptionWhenKeypadVisible = "CANCEL";
    private String mSearchBarPlaceholder = "Scan barcode or enter it here";
    private int mSearchBarKeyboardType = 2;
    private int mCameraSwitchImageId = 0;
    private int mCameraSwitchImagePressedId = 0;
    private int mTorchOffImageId = 0;
    private int mTorchOffImagePressedId = 0;
    private int mTorchOnImageId = 0;
    private int mTorchOnImagePressedId = 0;
    private int mBannerImageId = 0;
    private int mSearchButtonIconId = 0;
    private Bitmap mCameraSwitchBitmap = null;
    private Bitmap mCameraSwitchBitmapPressed = null;
    private Bitmap mTorchOffBitmap = null;
    private Bitmap mTorchOffBitmapPressed = null;
    private Bitmap mTorchOnBitmap = null;
    private Bitmap mTorchOnBitmapPressed = null;
    private SoftReference<Bitmap> mCameraSwitchImage = null;
    private SoftReference<Bitmap> mCameraSwitchImagePressed = null;
    private SoftReference<Bitmap> mTorchOffImage = null;
    private SoftReference<Bitmap> mTorchOffImagePressed = null;
    private SoftReference<Bitmap> mTorchOnImage = null;
    private SoftReference<Bitmap> mTorchOnImagePressed = null;
    private SoftReference<Bitmap> mBannerImage = null;
    private SoftReference<Bitmap> mSearchButtonIcon = null;
    private ScanditSDKRect mTorchButtonRect = this.DEFAULT_TORCH_RECT;
    private ScanditSDKRect mCameraSwitchButtonRect = this.DEFAULT_CAMERA_SWITCH_RECT;
    private float mViewfinderRed = 1.0f;
    private float mViewfinderGreen = 1.0f;
    private float mViewfinderBlue = 1.0f;
    private float mViewfinderRecognizedRed = 0.222f;
    private float mViewfinderRecognizedGreen = 0.753f;
    private float mViewfinderRecognizedBlue = 0.8f;
    private float mViewfinderWidth = 0.7f;
    private float mViewfinderHeight = 0.3f;
    private float mViewfinderLandscapeWidth = 0.4f;
    private float mViewfinderLandscapeHeight = 0.3f;
    private boolean mDrawViewfinder = true;
    private float mScanningHotSpotX = 0.5f;
    private float mScanningHotSpotY = 0.5f;
    private float mScanningHotSpotHeight = 0.25f;
    private boolean mRestrictActiveScanningArea = false;
    private int mLogoXOffset = 0;
    private int mLogoYOffset = 0;
    private int mLogoXLandscapeOffset = 0;
    private int mLogoYLandscapeOffset = 0;
    private boolean mBeepEnabled = true;
    private int mBeepResource = 0;
    private boolean mVibrateEnabled = true;
    private boolean mTorchEnabled = true;
    private int mCameraSwitchVisibility = 0;
    private boolean mShowTitleBar = true;
    private boolean mShowToolBar = true;
    private int mPreviewRotation = 90;
    private int mMsiPlesseyChecksumType = 1;
    private boolean mIsLegacy = false;

    public static ScanditSDKGlobals getInstance(Context context) {
        if (instance == null) {
            instance = new ScanditSDKGlobals(context);
        }
        return instance;
    }

    public static void deleteInstance() {
        if (instance != null) {
            instance = null;
        }
    }

    public String getInitialScanScreenState() {
        return this.mInitialScanScreenState;
    }

    public void setInitialScanScreenState(String text) {
        this.mInitialScanScreenState = text;
    }

    public String getBarcodePresenceDetected() {
        return this.mBarcodePresenceDetected;
    }

    public void setBarcodePresenceDetected(String text) {
        this.mBarcodePresenceDetected = text;
    }

    public String getBarcodeDecodingInProgress() {
        return this.mBarcodeDecodingInProgress;
    }

    public void setBarcodeDecodingInProgress(String text) {
        this.mBarcodeDecodingInProgress = text;
    }

    public String getTitleMessage() {
        return this.mTitleMessage;
    }

    public void setTitleMessage(String message) {
        this.mTitleMessage = message;
    }

    public String getLeftButtonCaption() {
        return this.mLeftButtonCaption;
    }

    public void setLeftButtonCaption(String caption) {
        this.mLeftButtonCaption = caption;
    }

    public String getLeftButtonCaptionWhenKeypadVisible() {
        return this.mLeftButtonCaptionWhenKeypadVisible;
    }

    public void setLeftButtonCaptionWhenKeypadVisible(String caption) {
        this.mLeftButtonCaptionWhenKeypadVisible = caption;
    }

    public String getRightButtonCaption() {
        return this.mRightButtonCaption;
    }

    public void setRightButtonCaption(String caption) {
        this.mRightButtonCaption = caption;
    }

    public String getRightButtonCaptionWhenKeypadVisible() {
        return this.mRightButtonCaptionWhenKeypadVisible;
    }

    public void setRightButtonCaptionWhenKeypadVisible(String caption) {
        this.mRightButtonCaptionWhenKeypadVisible = caption;
    }

    public String getSearchBarPlaceholder() {
        return this.mSearchBarPlaceholder;
    }

    public void setSearchBarPlaceholder(String text) {
        this.mSearchBarPlaceholder = text;
    }

    public int getSearchBarKeyboardType() {
        return this.mSearchBarKeyboardType;
    }

    public void setSearchBarKeyboardType(int type) {
        this.mSearchBarKeyboardType = type;
    }

    public ScanditSDKRect getTorchButtonRect() {
        return this.mTorchButtonRect;
    }

    public void setTorchButtonRect(ScanditSDKRect rect) {
        this.mTorchButtonRect = rect;
    }

    public ScanditSDKRect getCameraSwitchButtonRect() {
        return this.mCameraSwitchButtonRect;
    }

    public void setCameraSwitchButtonRect(ScanditSDKRect rect) {
        this.mCameraSwitchButtonRect = rect;
    }

    public Bitmap getCameraSwitchImage(Context context) {
        if (this.mCameraSwitchBitmap != null) {
            return this.mCameraSwitchBitmap;
        }
        return this.getBitmapFromReference(context, this.mCameraSwitchImage, this.mCameraSwitchImageId);
    }

    public void setCameraSwitchImage(int imageRefId) {
        this.mCameraSwitchImageId = imageRefId;
    }

    public void setCameraSwitchImage(Bitmap image) {
        this.mCameraSwitchBitmap = image;
    }

    public Bitmap getCameraSwitchImagePressed(Context context) {
        if (this.mCameraSwitchBitmapPressed != null) {
            return this.mCameraSwitchBitmapPressed;
        }
        return this.getBitmapFromReference(context, this.mCameraSwitchImagePressed, this.mCameraSwitchImagePressedId);
    }

    public void setCameraSwitchImagePressed(int imageRefId) {
        this.mCameraSwitchImagePressedId = imageRefId;
    }

    public void setCameraSwitchImagePressed(Bitmap image) {
        this.mCameraSwitchBitmapPressed = image;
    }

    public Bitmap getTorchOffImage(Context context) {
        if (this.mTorchOffBitmap != null) {
            return this.mTorchOffBitmap;
        }
        return this.getBitmapFromReference(context, this.mTorchOffImage, this.mTorchOffImageId);
    }

    public void setTorchOffImage(int imageRefId) {
        this.mTorchOffImageId = imageRefId;
    }

    public void setTorchOffImage(Bitmap image) {
        this.mTorchOffBitmap = image;
    }

    public Bitmap getTorchOffImagePressed(Context context) {
        if (this.mTorchOffBitmapPressed != null) {
            return this.mTorchOffBitmapPressed;
        }
        return this.getBitmapFromReference(context, this.mTorchOffImagePressed, this.mTorchOffImagePressedId);
    }

    public void setTorchOffImagePressed(int imageRefId) {
        this.mTorchOffImagePressedId = imageRefId;
    }

    public void setTorchOffImagePressed(Bitmap image) {
        this.mTorchOffBitmapPressed = image;
    }

    public Bitmap getTorchOnImage(Context context) {
        if (this.mTorchOnBitmap != null) {
            return this.mTorchOnBitmap;
        }
        return this.getBitmapFromReference(context, this.mTorchOnImage, this.mTorchOnImageId);
    }

    public void setTorchOnImage(int imageRefId) {
        this.mTorchOnImageId = imageRefId;
    }

    public void setTorchOnImage(Bitmap image) {
        this.mTorchOnBitmap = image;
    }

    public Bitmap getTorchOnImagePressed(Context context) {
        if (this.mTorchOnBitmapPressed != null) {
            return this.mTorchOnBitmapPressed;
        }
        return this.getBitmapFromReference(context, this.mTorchOnImagePressed, this.mTorchOnImagePressedId);
    }

    public void setTorchOnImagePressed(int imageRefId) {
        this.mTorchOnImagePressedId = imageRefId;
    }

    public void setTorchOnImagePressed(Bitmap image) {
        this.mTorchOnBitmapPressed = image;
    }

    public Bitmap getBannerImage(Context context, int width, int height) {
        if (this.mBannerImage != null && this.mBannerImage.get() != null) {
            return this.mBannerImage.get();
        }
        if (this.mBannerImageId > 0) {
            Bitmap newBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.mBannerImageId);
            Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)newBitmap, (int)width, (int)height, (boolean)true);
            this.mBannerImage = new SoftReference<Bitmap>(scaledBitmap);
            return newBitmap;
        }
        return null;
    }

    public void setBannerImage(int imageRefId) {
        this.mBannerImageId = imageRefId;
    }

    public Bitmap getSearchButtonIcon(Context context) {
        return this.getBitmapFromReference(context, this.mSearchButtonIcon, this.mSearchButtonIconId);
    }

    public void setSearchButtonIcon(int imageRefId) {
        this.mSearchButtonIconId = imageRefId;
    }

    public float getViewfinderRed() {
        return this.mViewfinderRed;
    }

    public float getViewfinderGreen() {
        return this.mViewfinderGreen;
    }

    public float getViewfinderBlue() {
        return this.mViewfinderBlue;
    }

    public void setViewfinderColor(float r, float g, float b) {
        this.mViewfinderRed = r;
        this.mViewfinderGreen = g;
        this.mViewfinderBlue = b;
    }

    public float getViewfinderRecognizedRed() {
        return this.mViewfinderRecognizedRed;
    }

    public float getViewfinderRecognizedGreen() {
        return this.mViewfinderRecognizedGreen;
    }

    public float getViewfinderRecognizedBlue() {
        return this.mViewfinderRecognizedBlue;
    }

    public void setViewfinderRecognizedColor(float r, float g, float b) {
        this.mViewfinderRecognizedRed = r;
        this.mViewfinderRecognizedGreen = g;
        this.mViewfinderRecognizedBlue = b;
    }

    public double getViewfinderWidth() {
        return this.mViewfinderWidth;
    }

    public int getViewfinderWidthForView(int width, int height) {
        if (height > width) {
            return (int)((float)width * this.mViewfinderWidth);
        }
        if (!this.mSetWithNewViewfinderDimensionFunction) {
            return (int)((float)height * this.mViewfinderWidth);
        }
        return (int)((float)width * this.mViewfinderLandscapeWidth);
    }

    public double getViewfinderHeight() {
        return this.mViewfinderHeight;
    }

    public int getViewfinderHeightForView(int width, int height) {
        if (height > width) {
            return (int)((float)height * this.mViewfinderHeight);
        }
        if (!this.mSetWithNewViewfinderDimensionFunction) {
            return (int)((float)width * this.mViewfinderHeight);
        }
        return (int)((float)height * this.mViewfinderLandscapeHeight);
    }

    public void setViewfinderDimension(float width, float height) {
        this.mViewfinderWidth = width;
        this.mViewfinderHeight = height;
        this.mSetWithNewViewfinderDimensionFunction = false;
    }

    public void setViewfinderDimension(float width, float height, float landscapeWidth, float landscapeHeight) {
        this.mViewfinderWidth = width;
        this.mViewfinderHeight = height;
        this.mViewfinderLandscapeWidth = landscapeWidth;
        this.mViewfinderLandscapeHeight = landscapeHeight;
        this.mSetWithNewViewfinderDimensionFunction = true;
    }

    public boolean isViewfinderHeightChanged() {
        return this.mViewfinderHeight != 0.3f || this.mViewfinderLandscapeHeight != 0.3f;
    }

    public boolean getDrawViewfinder() {
        return this.mDrawViewfinder;
    }

    public void setDrawViewfinder(boolean draw) {
        this.mDrawViewfinder = draw;
    }

    public float getScanningHotSpotX() {
        return this.mScanningHotSpotX;
    }

    public void setScanningHotSpotX(float relX) {
        this.mScanningHotSpotX = relX;
    }

    public float getScanningHotSpotY() {
        return this.mScanningHotSpotY;
    }

    public void setScanningHotSpotY(float relY) {
        this.mScanningHotSpotY = relY;
    }

    public float getScanningHotSpotHeight() {
        return this.mScanningHotSpotHeight;
    }

    public void setScanningHotSpotHeight(float height) {
        this.mScanningHotSpotHeight = height;
    }

    public boolean getRestrictActiveScanningArea() {
        return this.mRestrictActiveScanningArea;
    }

    public void setRestrictActiveScanningArea(boolean restrict) {
        this.mRestrictActiveScanningArea = restrict;
    }

    public int getLogoXOffset() {
        return this.mLogoXOffset;
    }

    public void setLogoXOffset(int offset) {
        this.mLogoXOffset = offset;
    }

    public int getLogoYOffset() {
        return this.mLogoYOffset;
    }

    public void setLogoYOffset(int offset) {
        this.mLogoYOffset = offset;
    }

    public int getLogoXLandscapeOffset() {
        return this.mLogoXLandscapeOffset;
    }

    public void setLogoXLandscapeOffset(int offset) {
        this.mLogoXLandscapeOffset = offset;
    }

    public int getLogoYLandscapeOffset() {
        return this.mLogoYLandscapeOffset;
    }

    public void setLogoYLandscapeOffset(int offset) {
        this.mLogoYLandscapeOffset = offset;
    }

    public boolean isBeepEnabled() {
        return this.mBeepEnabled;
    }

    public void setBeepEnabled(boolean enabled) {
        this.mBeepEnabled = enabled;
    }

    public int getBeepResource() {
        return this.mBeepResource;
    }

    public void setBeepResource(int res) {
        this.mBeepResource = res;
    }

    public boolean isVibrateEnabled() {
        return this.mVibrateEnabled;
    }

    public void setVibrateEnabled(boolean enabled) {
        this.mVibrateEnabled = enabled;
    }

    public boolean isTorchEnabled() {
        return this.mTorchEnabled;
    }

    public void setTorchEnabled(boolean enabled) {
        this.mTorchEnabled = enabled;
    }

    public int getCameraSwitchVisibility() {
        return this.mCameraSwitchVisibility;
    }

    public void setCameraSwitchVisibility(int visibility) {
        this.mCameraSwitchVisibility = visibility;
    }

    public boolean isTitleBarShown() {
        return this.mShowTitleBar;
    }

    public void setShowTitleBar(boolean show) {
        this.mShowTitleBar = show;
    }

    public boolean isToolBarShown() {
        return this.mShowToolBar;
    }

    public void setShowToolBar(boolean show) {
        this.mShowToolBar = show;
    }

    public int getPreviewRotation() {
        return this.mPreviewRotation;
    }

    public void setPreviewRotation(int rotation) {
        this.mPreviewRotation = rotation;
    }

    public boolean isInPortraitMode() {
        return this.getPreviewRotation() == 90 || this.getPreviewRotation() == 270;
    }

    public int getMsiPlesseyChecksumType() {
        return this.mMsiPlesseyChecksumType;
    }

    public void setMsiPlesseyChecksumType(int checksumType) {
        this.mMsiPlesseyChecksumType = checksumType;
    }

    public boolean isLegacy() {
        return this.mIsLegacy;
    }

    public void setIsLegacy(boolean isLegacy) {
        this.mIsLegacy = isLegacy;
    }

    public ScanditSDKGlobals(Context context) {
        this.mTorchButtonRect = this.DEFAULT_TORCH_RECT;
        this.mCameraSwitchButtonRect = this.DEFAULT_CAMERA_SWITCH_RECT;
        String pack = context.getPackageName();
        String type = "raw";
        this.setInitialScanScreenState(ScanditSDKGlobals.getStringRes(context, pack, "scanditsdk_initial_scan_screen_state", this.getInitialScanScreenState()));
        this.setBarcodePresenceDetected(ScanditSDKGlobals.getStringRes(context, pack, "scanditsdk_barcode_presence_detected", this.getBarcodePresenceDetected()));
        this.setBarcodeDecodingInProgress(ScanditSDKGlobals.getStringRes(context, pack, "scanditsdk_barcode_decoding_in_progress", this.getBarcodeDecodingInProgress()));
        this.setSearchBarPlaceholder(ScanditSDKGlobals.getStringRes(context, pack, "scanditsdk_searchbar_placeholder", this.getSearchBarPlaceholder()));
        this.setTitleMessage(ScanditSDKGlobals.getStringRes(context, pack, "scanditsdk_title_message", this.getTitleMessage()));
        this.setLeftButtonCaption(ScanditSDKGlobals.getStringRes(context, pack, "scanditsdk_left_button_caption", this.getLeftButtonCaption()));
        this.setLeftButtonCaptionWhenKeypadVisible(ScanditSDKGlobals.getStringRes(context, pack, "scanditsdk_left_button_caption_when_keypad_visible", this.getLeftButtonCaptionWhenKeypadVisible()));
        this.setRightButtonCaption(ScanditSDKGlobals.getStringRes(context, pack, "scanditsdk_right_button_caption", this.getRightButtonCaption()));
        this.setRightButtonCaptionWhenKeypadVisible(ScanditSDKGlobals.getStringRes(context, pack, "scanditsdk_right_button_caption_when_keypad_visible", this.getRightButtonCaptionWhenKeypadVisible()));
        try {
            int beepId = context.getResources().getIdentifier("beep", type, pack);
            if (beepId > 0) {
                this.setBeepResource(beepId);
            }
            String suffix = "";
            DisplayMetrics metrics = new DisplayMetrics();
            Activity activity = (Activity)context;
            activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            if (metrics.densityDpi == 120) {
                suffix = "_ldpi";
            } else if (metrics.densityDpi == 160 || metrics.densityDpi == 160) {
                suffix = "_mdpi";
            } else if (metrics.densityDpi == 240 || metrics.densityDpi == 213) {
                suffix = "_hdpi";
            }
            this.setCameraSwitchImage(ScanditSDKGlobals.getResIdentifier(context, "camera_swap_icon", suffix, type, pack));
            this.setCameraSwitchImagePressed(ScanditSDKGlobals.getResIdentifier(context, "camera_swap_icon_pressed", suffix, type, pack));
            this.setTorchOffImage(ScanditSDKGlobals.getResIdentifier(context, "flashlight_turn_on_icon", suffix, type, pack));
            this.setTorchOffImagePressed(ScanditSDKGlobals.getResIdentifier(context, "flashlight_turn_on_icon_pressed", suffix, type, pack));
            this.setTorchOnImage(ScanditSDKGlobals.getResIdentifier(context, "flashlight_turn_off_icon", suffix, type, pack));
            this.setTorchOnImagePressed(ScanditSDKGlobals.getResIdentifier(context, "flashlight_turn_off_icon_pressed", suffix, type, pack));
            this.setBannerImage(context.getResources().getIdentifier("poweredby2x", type, pack));
            this.setSearchButtonIcon(context.getResources().getIdentifier("ic_btn_search", type, pack));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private Bitmap getBitmapFromReference(Context context, SoftReference<Bitmap> bitmapRef, int imageRefId) {
        if (bitmapRef != null && bitmapRef.get() != null) {
            return bitmapRef.get();
        }
        if (imageRefId > 0) {
            Bitmap newBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)imageRefId);
            bitmapRef = new SoftReference<Bitmap>(newBitmap);
            return newBitmap;
        }
        return null;
    }

    private static String getStringRes(Context context, String pack, String key, String defaultString) {
        int initialScanScreenStateId = context.getResources().getIdentifier(key, "string", pack);
        if (initialScanScreenStateId > 0) {
            return context.getString(initialScanScreenStateId);
        }
        return defaultString;
    }

    private static int getResIdentifier(Context context, String name, String suffix, String type, String pack) {
        int id = context.getResources().getIdentifier(name + suffix, type, pack);
        if (id <= 0) {
            id = context.getResources().getIdentifier(name, type, pack);
        }
        return id;
    }
}

