/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk;

import android.content.Context;
import android.graphics.Point;
import com.mirasense.scanditsdk.ScanditSDKGlobals;

public class ScanditSDKRoughCode {
    private int mX;
    private int mY;
    private Point[] mPoints;
    private double mAngle;
    private int mLikelihood;
    private int mShortSide;
    private int mLongSide;
    private boolean mIsMainBarcode;

    public ScanditSDKRoughCode() {
    }

    public ScanditSDKRoughCode(Context context, int[] center, double angle, int width, int height, float factorX, float factorY, boolean usesFrontCamera) {
        this.mIsMainBarcode = false;
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(context);
        if (globals.getPreviewRotation() == 180) {
            this.mX = (int)((float)width - (float)center[0] * factorX);
            this.mY = (int)((float)height - (float)center[1] * factorY);
        } else if (globals.getPreviewRotation() == 0) {
            this.mX = (int)((float)center[0] * factorX);
            this.mY = (int)((float)center[1] * factorY);
        } else if (globals.getPreviewRotation() == 90) {
            this.mX = (int)((float)width - (float)center[1] * factorY);
            this.mY = (int)((float)center[0] * factorX);
        } else {
            this.mX = (int)((float)width - (float)center[1] * factorY);
            this.mY = (int)((float)center[0] * factorX);
        }
        if (usesFrontCamera) {
            if (globals.getPreviewRotation() == 0 || globals.getPreviewRotation() == 180) {
                this.mY = height - this.mY;
            } else {
                this.mX = width - this.mX;
            }
        }
        this.mAngle = globals.getPreviewRotation() == 0 || globals.getPreviewRotation() == 180 ? -angle : -angle - 1.5707963267948966;
        if (usesFrontCamera) {
            this.mAngle = -this.mAngle;
        }
    }

    public int getX() {
        return this.mX;
    }

    public void setX(int x) {
        this.mX = x;
    }

    public int getY() {
        return this.mY;
    }

    public void setY(int y) {
        this.mY = y;
    }

    public Point[] getPoints() {
        return this.mPoints;
    }

    public void setPoints(Point[] points) {
        this.mPoints = points;
    }

    public double getAngle() {
        return this.mAngle;
    }

    public void setAngle(double angle) {
        this.mAngle = angle;
    }

    public int getLikelihood() {
        return this.mLikelihood;
    }

    public void setLikelihood(int likelyhood) {
        this.mLikelihood = likelyhood;
    }

    public int getShortSide() {
        return this.mShortSide;
    }

    public void setShortSide(int shortSide) {
        this.mShortSide = shortSide;
    }

    public int getLongSide() {
        return this.mLongSide;
    }

    public void setLongSide(int longSide) {
        this.mLongSide = longSide;
    }

    public boolean isMainBarcode() {
        return this.mIsMainBarcode;
    }

    public void setIsMainBarcode(boolean isMainBarcode) {
        this.mIsMainBarcode = isMainBarcode;
    }
}

