/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk.analytics;

import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import com.mirasense.scanditsdk.analytics.LocationHubListener;
import java.util.ArrayList;
import java.util.List;

public class LocationHub
implements LocationListener {
    private static LocationHub sInstance = null;
    private static int DESIRED_ACCURACY = 50;
    private Location mLocation;
    private LocationManager mLocationManager;
    private long mUpdateStart = 0L;
    private long mLastUpdate = 0L;
    private boolean mIsActive = false;
    private boolean mIsActiveForMap = false;
    private ArrayList<LocationHubListener> mListeners = new ArrayList();

    private LocationHub() {
    }

    public void start(Context context) {
        long now = System.currentTimeMillis();
        if (this.mLastUpdate < now - 300000L && this.mUpdateStart == 0L || this.mLocation == null) {
            this.mUpdateStart = now;
            this.mLocationManager = (LocationManager)context.getSystemService("location");
            Criteria criteria = new Criteria();
            criteria.setAccuracy(1);
            String provider = this.mLocationManager.getBestProvider(criteria, true);
            if (provider != null) {
                this.mIsActive = true;
                if (this.mLocation == null) {
                    this.mLocation = this.mLocationManager.getLastKnownLocation(provider);
                }
                this.mLocationManager.requestLocationUpdates(provider, 5L, 5.0f, (LocationListener)this);
            } else {
                this.mLastUpdate = now;
            }
        }
    }

    public void stop(boolean makeLocationInvalid) {
        if (this.mIsActive && !this.mIsActiveForMap) {
            this.mIsActive = false;
            this.mLocationManager.removeUpdates((LocationListener)this);
            if (makeLocationInvalid) {
                this.mLocation = null;
            }
        }
    }

    public void stopMapTracking(LocationHubListener listener) {
        if (this.mIsActiveForMap && !this.mIsActive) {
            this.mIsActiveForMap = false;
            this.mListeners.remove(listener);
            this.mLocationManager.removeUpdates((LocationListener)this);
        }
    }

    public static LocationHub getInstance() {
        if (sInstance == null) {
            sInstance = new LocationHub();
        }
        return sInstance;
    }

    public boolean hasLocation() {
        return this.mLocation != null;
    }

    public Location getLastKnownLocation(Context context) {
        if (this.mLocationManager == null) {
            this.mLocationManager = (LocationManager)context.getSystemService("location");
        }
        Location loc = null;
        Criteria criteria = new Criteria();
        criteria.setAccuracy(1);
        List providers = this.mLocationManager.getProviders(true);
        for (String provider : providers) {
            long timeDiff;
            Location last = this.mLocationManager.getLastKnownLocation(provider);
            if (loc == null) {
                loc = last;
                continue;
            }
            if (last == null) continue;
            float accDiff = 0.0f;
            if (loc.hasAccuracy() && last.hasAccuracy() && Math.abs(accDiff = loc.getAccuracy() - last.getAccuracy()) < (float)DESIRED_ACCURACY) {
                accDiff = 0.0f;
            }
            if ((timeDiff = last.getTime() - loc.getTime()) < 0L || !(accDiff >= 0.0f)) continue;
            loc = last;
        }
        return loc;
    }

    public boolean isLocationPermissionGranted(Context context) {
        PackageManager pm = context.getPackageManager();
        int coarsePermission = pm.checkPermission("android.permission.ACCESS_COARSE_LOCATION", context.getPackageName());
        int finePermission = pm.checkPermission("android.permission.ACCESS_FINE_LOCATION", context.getPackageName());
        return coarsePermission == 0 || finePermission == 0;
    }

    public void onLocationChanged(Location location) {
        long now = System.currentTimeMillis();
        if (this.mIsActive || this.mIsActiveForMap) {
            this.mLocation = location;
            this.notifyListeners();
        }
        if (location.hasAccuracy() && location.getAccuracy() < (float)DESIRED_ACCURACY || now - this.mUpdateStart > 30000L) {
            this.mLastUpdate = now;
            this.mUpdateStart = 0L;
            this.stop(false);
        }
    }

    private void notifyListeners() {
        for (LocationHubListener listener : this.mListeners) {
            listener.onLocationUpdate(this.mLocation);
        }
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }
}

