/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk.gui;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;
import com.mirasense.scanditsdk.ScanditSDKGlobals;
import com.mirasense.scanditsdk.gui.ScanditSDKBarcodeIndicatorView;
import com.mirasense.scanditsdk.gui.animations.ScanditSDKRelativeScaleAnimation;
import com.mirasense.scanditsdk.gui.animations.ScanditSDKRotateAnimation;
import com.mirasense.scanditsdk.gui.animations.ScanditSDKScaleAnimation;
import com.mirasense.scanditsdk.gui.animations.ScanditSDKTranslateAnimation;

public class ScanditSDKBarcodeIndicator
extends RelativeLayout {
    private static final long sAnimationDuration = 100L;
    private static final float sRatioOfDistancePerAnimation = 0.75f;
    private RelativeLayout mIndicator;
    private ScanditSDKBarcodeIndicatorView mIndicatorChild;
    private int targetX;
    private int targetY;
    private int curX;
    private int curY;
    private int targetWidth;
    private int targetHeight;
    private int curWidth;
    private int curHeight;
    private int targetLikelihood;
    private double targetRotation;
    private double curRotation;
    private int defaultCount;
    private boolean isAnimating;

    @TargetApi(value=11)
    public ScanditSDKBarcodeIndicator(Context context) {
        super(context);
        if (Build.VERSION.SDK_INT >= 11) {
            // empty if block
        }
        this.defaultCount = 0;
        this.targetLikelihood = 0;
        this.isAnimating = false;
        this.mIndicatorChild = new ScanditSDKBarcodeIndicatorView(context);
        this.mIndicator = new RelativeLayout(context);
        RelativeLayout.LayoutParams rParams = new RelativeLayout.LayoutParams(-1, -1);
        this.addView(this.mIndicatorChild, (ViewGroup.LayoutParams)rParams);
        rParams = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mIndicator, (ViewGroup.LayoutParams)rParams);
        if (!ScanditSDKGlobals.getInstance(context).getDrawViewfinder()) {
            this.setVisibility(4);
        }
    }

    @TargetApi(value=11)
    public void onWindowFocusChanged(boolean hasFocus) {
        this.targetWidth = this.getViewfinderWidth();
        this.targetHeight = this.getViewfinderHeight();
        this.targetX = this.getScanningHotSpotX();
        this.targetY = this.getScanningHotSpotY();
        this.targetRotation = 0.0;
        this.curWidth = this.targetWidth;
        this.curHeight = this.targetHeight;
        this.curX = this.targetX;
        this.curY = this.targetY;
        this.curRotation = 0.0;
        this.mIndicatorChild.setSize(this.curWidth, this.curHeight);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mIndicatorChild.setRotation((float)Math.toDegrees(this.curRotation));
        }
        this.mIndicatorChild.setLocation(this.curX, this.curY);
        if (this.isAnimating) {
            this.stop();
            this.start();
        }
    }

    @TargetApi(value=11)
    public void start() {
        this.forceDefault();
        this.jumpToTarget(false);
        this.mIndicatorChild.setSize(this.curWidth, this.curHeight);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mIndicatorChild.setRotation((float)Math.toDegrees(this.curRotation));
        }
        this.mIndicatorChild.setLocation(this.curX, this.curY);
        this.pulse();
        this.move(true, true);
        this.isAnimating = true;
    }

    public void stop() {
        this.mIndicator.clearAnimation();
        this.mIndicatorChild.clearAnimation();
        this.isAnimating = false;
    }

    private void pulse() {
        ScanditSDKRelativeScaleAnimation scaleAnim = new ScanditSDKRelativeScaleAnimation(1.0f, 1.0f, 1.0f, 1.0f, this.mIndicatorChild);
        scaleAnim.setDuration(2000L);
        scaleAnim.setInterpolator((Interpolator)new LinearInterpolator());
        scaleAnim.setRepeatCount(1);
        scaleAnim.setRepeatMode(2);
        scaleAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                ScanditSDKBarcodeIndicator.this.pulse();
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }
        });
        this.mIndicator.startAnimation((Animation)scaleAnim);
    }

    private void move(final boolean scale, final boolean rotate) {
        AnimationSet animSet = new AnimationSet(false);
        int diffX = (int)((float)(this.targetX - this.curX) * 0.75f);
        if (this.targetX == this.curX) {
            diffX = 0;
        }
        int diffY = (int)((float)(this.targetY - this.curY) * 0.75f);
        if (this.targetY == this.curY) {
            diffY = 0;
        }
        ScanditSDKTranslateAnimation slide = new ScanditSDKTranslateAnimation(this.curX, this.curY, this.curX + diffX, this.curY + diffY, this.mIndicatorChild);
        slide.setDuration(100L);
        slide.setInterpolator((Interpolator)new LinearInterpolator());
        this.curX += diffX;
        this.curY += diffY;
        int actualTargetWidth = this.curWidth + (int)((float)(this.targetWidth - this.curWidth) * 0.75f);
        if (this.targetWidth == this.curWidth) {
            actualTargetWidth = this.targetWidth;
        }
        int actualTargetHeight = this.curHeight + (int)((float)(this.targetHeight - this.curHeight) * 0.75f);
        if (this.targetHeight == this.curHeight) {
            actualTargetHeight = this.targetHeight;
        }
        ScanditSDKScaleAnimation scaleAnim = new ScanditSDKScaleAnimation(this.curWidth, this.curHeight, actualTargetWidth, actualTargetHeight, this.mIndicatorChild);
        scaleAnim.setDuration(100L);
        scaleAnim.setInterpolator((Interpolator)new LinearInterpolator());
        this.curWidth = actualTargetWidth;
        this.curHeight = actualTargetHeight;
        double angleDist = Math.abs(this.targetRotation - this.curRotation);
        double upperAngleDist = Math.abs(this.targetRotation + Math.PI - this.curRotation);
        double lowerAngleDist = Math.abs(this.targetRotation - Math.PI - this.curRotation);
        double actualDist = Math.min(angleDist, Math.min(upperAngleDist, lowerAngleDist));
        if (actualDist == angleDist) {
            actualDist = this.targetRotation - this.curRotation;
        } else if (actualDist == upperAngleDist) {
            actualDist = this.targetRotation + Math.PI - this.curRotation;
        } else if (actualDist == lowerAngleDist) {
            actualDist = this.targetRotation - Math.PI - this.curRotation;
        }
        double actualTargetRotation = this.curRotation + actualDist * 0.75;
        if (actualTargetRotation > 1.5707963267948966) {
            actualTargetRotation -= Math.PI;
        } else if (actualTargetRotation < -1.5707963267948966) {
            actualTargetRotation += Math.PI;
        }
        ScanditSDKRotateAnimation rotAnim = new ScanditSDKRotateAnimation((float)Math.toDegrees(this.curRotation), (float)Math.toDegrees(actualTargetRotation), this.mIndicatorChild);
        rotAnim.setDuration(100L);
        rotAnim.setInterpolator((Interpolator)new LinearInterpolator());
        this.curRotation = actualTargetRotation;
        animSet.addAnimation((Animation)slide);
        if (scale) {
            animSet.addAnimation((Animation)scaleAnim);
        }
        if (rotate) {
            animSet.addAnimation((Animation)rotAnim);
        }
        animSet.setInterpolator((Interpolator)new LinearInterpolator());
        animSet.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                boolean actualRotate = rotate;
                if (ScanditSDKBarcodeIndicator.this.targetRotation == 0.0) {
                    actualRotate = true;
                }
                ScanditSDKBarcodeIndicator.this.move(scale, actualRotate);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }
        });
        this.mIndicatorChild.startAnimation((Animation)animSet);
    }

    public void setTargetLocation(int x, int y) {
        this.targetX = x;
        this.targetY = y;
        this.defaultCount = 0;
    }

    public void setTargetSize(int width, int height) {
        this.targetWidth = width;
        this.targetHeight = height;
        this.defaultCount = 0;
    }

    public void setTargetRotation(double rotation) {
        this.targetRotation = rotation;
    }

    @TargetApi(value=11)
    public void setTargetLikelihood(int likelihood) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        if (this.targetLikelihood != likelihood && likelihood < 5) {
            if (this.targetLikelihood > 4) {
                this.mIndicator.clearAnimation();
                this.mIndicatorChild.clearAnimation();
                this.mIndicatorChild.setBorderRGB((int)(globals.getViewfinderRed() * 255.0f), (int)(globals.getViewfinderGreen() * 255.0f), (int)(globals.getViewfinderBlue() * 255.0f));
                this.targetWidth = this.getViewfinderWidth();
                this.targetHeight = this.getViewfinderHeight();
                this.targetRotation = 0.0;
                this.curWidth = this.targetWidth;
                this.curHeight = this.targetHeight;
                this.curRotation = this.targetRotation;
                this.mIndicatorChild.setLocation(this.targetX, this.targetY);
                this.mIndicatorChild.setSize(this.targetWidth, this.targetHeight);
                if (Build.VERSION.SDK_INT >= 11) {
                    this.mIndicatorChild.setRotation((float)this.targetRotation);
                }
                this.move(false, false);
            }
            this.targetLikelihood = likelihood;
        } else if (likelihood > 4 && this.targetLikelihood < 5) {
            this.mIndicatorChild.setBorderRGB((int)(globals.getViewfinderRecognizedRed() * 255.0f), (int)(globals.getViewfinderRecognizedGreen() * 255.0f), (int)(globals.getViewfinderRecognizedBlue() * 255.0f));
            this.jumpToTarget(true);
        }
        this.targetLikelihood = likelihood;
    }

    public void redrawColor() {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        if (this.targetLikelihood < 5) {
            this.mIndicatorChild.setBorderRGB((int)(globals.getViewfinderRed() * 255.0f), (int)(globals.getViewfinderGreen() * 255.0f), (int)(globals.getViewfinderBlue() * 255.0f));
        } else {
            this.mIndicatorChild.setBorderRGB((int)(globals.getViewfinderRecognizedRed() * 255.0f), (int)(globals.getViewfinderRecognizedGreen() * 255.0f), (int)(globals.getViewfinderRecognizedBlue() * 255.0f));
        }
    }

    @TargetApi(value=11)
    public void jumpToTarget(boolean scaleAndRotate) {
        this.mIndicator.clearAnimation();
        this.mIndicatorChild.clearAnimation();
        this.curX = this.targetX;
        this.curY = this.targetY;
        this.curWidth = this.targetWidth;
        this.curHeight = this.targetHeight;
        this.curRotation = this.targetRotation;
        this.mIndicatorChild.setLocation(this.targetX, this.targetY);
        this.mIndicatorChild.setSize(this.targetWidth, this.targetHeight);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mIndicatorChild.setRotation((float)this.targetRotation);
        }
        this.pulse();
        this.move(scaleAndRotate, scaleAndRotate);
    }

    public void goToDefault() {
        ++this.defaultCount;
        if (this.defaultCount == 3) {
            this.forceDefault();
        }
    }

    public void forceDefault() {
        this.softForceDefault();
        this.jumpToTarget(false);
    }

    public void softForceDefault() {
        if (!ScanditSDKGlobals.getInstance(this.getContext()).getDrawViewfinder()) {
            this.setVisibility(4);
        } else {
            this.setVisibility(0);
        }
        this.defaultCount = 3;
        this.targetWidth = this.getViewfinderWidth();
        this.targetHeight = this.getViewfinderHeight();
        this.targetX = this.getScanningHotSpotX();
        this.targetY = this.getScanningHotSpotY();
        this.targetRotation = 0.0;
        this.setTargetLikelihood(0);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.forceDefault();
    }

    private int getViewfinderWidth() {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        if (globals.isLegacy()) {
            return globals.getViewfinderHeightForView(this.getHeight(), this.getWidth());
        }
        return globals.getViewfinderWidthForView(this.getWidth(), this.getHeight());
    }

    private int getViewfinderHeight() {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        if (globals.isLegacy()) {
            return globals.getViewfinderWidthForView(this.getHeight(), this.getWidth());
        }
        return globals.getViewfinderHeightForView(this.getWidth(), this.getHeight());
    }

    private int getScanningHotSpotX() {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        if (globals.isLegacy()) {
            return (int)((float)this.getWidth() * globals.getScanningHotSpotY());
        }
        return (int)((float)this.getWidth() * globals.getScanningHotSpotX());
    }

    private int getScanningHotSpotY() {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        if (globals.isLegacy()) {
            return (int)((float)this.getHeight() - (float)this.getHeight() * globals.getScanningHotSpotX());
        }
        return (int)((float)this.getHeight() * globals.getScanningHotSpotY());
    }
}

