/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk.gui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.scandit.camera.SbSystemUtils;

public class ScanditSDKBarcodeIndicatorView
extends View {
    private Paint mBorderPaint;
    private Paint mFillPaint;
    private int mWidth;
    private int mHeight;
    private float mRelativeWidth;
    private float mRelativeHeight;
    private float mRotation;
    private int mX;
    private int mY;
    private float mAlpha;
    private int mFillR;
    private int mFillG;
    private int mFillB;
    private int mBorderR;
    private int mBorderG;
    private int mBorderB;

    public ScanditSDKBarcodeIndicatorView(Context context) {
        super(context);
        this.init(context);
    }

    public ScanditSDKBarcodeIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ScanditSDKBarcodeIndicatorView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mWidth = 0;
        this.mHeight = 0;
        this.mRotation = 0.0f;
        this.mAlpha = 0.0f;
        this.mBorderR = 255;
        this.mBorderG = 255;
        this.mBorderB = 255;
        this.mFillR = 57;
        this.mFillG = 193;
        this.mFillB = 205;
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setARGB(255, this.mBorderR, this.mBorderG, this.mBorderB);
        this.mBorderPaint.setStrokeWidth((float)SbSystemUtils.pxFromDp(context, 2));
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setFilterBitmap(true);
        this.mFillPaint = new Paint();
        this.mFillPaint.setARGB(255, this.mFillR, this.mFillG, this.mFillB);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setFilterBitmap(true);
    }

    public void setStrokeWidth(int width) {
        this.mBorderPaint.setStrokeWidth((float)width);
        this.invalidate();
    }

    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.invalidate();
    }

    public void setRelativeSize(float relativeWidth, float relativeHeight) {
        this.mRelativeWidth = relativeWidth;
        this.mRelativeHeight = relativeHeight;
        this.invalidate();
    }

    public void setRotation(float rotation) {
        this.mRotation = rotation;
        this.invalidate();
    }

    public void setLocation(int x, int y) {
        this.mX = x;
        this.mY = y;
        this.invalidate();
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
        this.invalidate();
    }

    public void setBorderRGB(int r, int g, int b) {
        this.mBorderR = r;
        this.mBorderG = g;
        this.mBorderB = b;
        this.invalidate();
    }

    public void setFillRGB(int r, int g, int b) {
        this.mFillR = r;
        this.mFillG = g;
        this.mFillB = b;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        RectF fillRect = new RectF();
        RectF borderRect = new RectF();
        int actualWidth = (int)(this.mRelativeWidth * (float)this.mWidth);
        int actualHeight = (int)(this.mRelativeHeight * (float)this.mHeight);
        fillRect.set((float)(this.mX - actualWidth / 2 + 2), (float)(this.mY - actualHeight / 2 + 2), (float)(this.mX + actualWidth / 2 - 2), (float)(this.mY + actualHeight / 2 - 2));
        borderRect.set((float)(this.mX - actualWidth / 2), (float)(this.mY - actualHeight / 2), (float)(this.mX + actualWidth / 2), (float)(this.mY + actualHeight / 2));
        canvas.rotate(this.mRotation, (float)this.mX, (float)this.mY);
        this.mFillPaint.setARGB(255, this.mFillR, this.mFillG, this.mFillB);
        this.mFillPaint.setAlpha((int)(255.0f * this.mAlpha));
        this.mBorderPaint.setARGB(255, this.mBorderR, this.mBorderG, this.mBorderB);
        canvas.drawRoundRect(fillRect, 2.0f * this.mFillPaint.getStrokeWidth(), 2.5f * this.mFillPaint.getStrokeWidth(), this.mFillPaint);
        canvas.drawRoundRect(borderRect, 2.0f * this.mBorderPaint.getStrokeWidth(), 2.5f * this.mBorderPaint.getStrokeWidth(), this.mBorderPaint);
    }
}

