/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk.gui;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.mirasense.scanditsdk.ScanditSDKBarcodePicker;
import com.mirasense.scanditsdk.ScanditSDKDiagnostics;
import com.mirasense.scanditsdk.ScanditSDKGlobals;
import com.mirasense.scanditsdk.ScanditSDKRoughCode;
import com.mirasense.scanditsdk.ScanditSDKScanState;
import com.mirasense.scanditsdk.gui.ScanditSDKBarcodeIndicator;
import com.mirasense.scanditsdk.gui.ScanditSDKRect;
import com.mirasense.scanditsdk.gui.animations.ScanditSDKRotatedImageButton;
import com.mirasense.scanditsdk.interfaces.ScanditSDKListener;
import com.mirasense.scanditsdk.interfaces.ScanditSDKOverlay;
import com.scandit.camera.SbDeviceProperties;
import com.scandit.camera.SbSystemUtils;
import java.lang.reflect.Method;
import java.util.Vector;

public class ScanditSDKOverlayView
extends RelativeLayout
implements ScanditSDKOverlay {
    public static final int TORCH_MODE_OFF = 1;
    public static final int TORCH_MODE_ON = 2;
    private static final int SEND_CALLBACK = 1;
    private Vector<ScanditSDKListener> registeredScanDKListerens;
    private Vibrator mVibrator;
    private long mVibrateTime;
    private MediaPlayer mMediaPlayer = null;
    private int mTorchMode;
    private ImageButton mTorchButton;
    private ImageButton mCameraSwapButton;
    private ScanditSDKBarcodePicker mBarcodePicker;
    private RelativeLayout mSearchBar;
    private EditText mSearchEditText;
    private ImageButton mSearchButton;
    private ScanditSDKBarcodeIndicator mBarcodeIndicator;
    private boolean mFirstRound = true;
    private String mBarcode = "";
    private String mSymbology = "";
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                Object[] params = new String[]{ScanditSDKOverlayView.this.mBarcode, ScanditSDKOverlayView.this.mSymbology};
                ScanditSDKOverlayView.this.callMethodOnRegisteredListeners("didScanBarcode", params);
                ScanditSDKDiagnostics.getInstance().addEvent("scanned barcode", ScanditSDKOverlayView.this.mSymbology + ": " + ScanditSDKOverlayView.this.mBarcode);
            }
        }
    };

    public ScanditSDKOverlayView(Context context, ScanditSDKBarcodePicker picker, long vibrateTime) {
        super(context);
        this.mBarcodePicker = picker;
        if (vibrateTime > 0L) {
            this.mVibrator = (Vibrator)context.getSystemService("vibrator");
            this.mVibrateTime = vibrateTime;
        }
        this.registeredScanDKListerens = new Vector();
        System.gc();
        this.mBarcodeIndicator = new ScanditSDKBarcodeIndicator(this.getContext());
        RelativeLayout.LayoutParams rParams = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.mBarcodeIndicator, (ViewGroup.LayoutParams)rParams);
        this.mTorchMode = 1;
        RelativeLayout r = new RelativeLayout(context);
        rParams = new RelativeLayout.LayoutParams(-1, -1);
        r.setBackgroundColor(0);
        this.addView((View)r, (ViewGroup.LayoutParams)rParams);
    }

    public void setTorchButtonAlpha(int alpha) {
    }

    public void loadBeep() {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        int beepResourceID = globals.getBeepResource();
        if (beepResourceID != 0) {
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.release();
            }
            this.mMediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)beepResourceID);
        }
    }

    protected int getTorchMode() {
        return this.mTorchMode;
    }

    public void startIndicator() {
        if (this.mBarcodeIndicator != null) {
            this.mBarcodeIndicator.start();
        }
    }

    public void stopIndicator() {
        if (this.mBarcodeIndicator != null) {
            this.mBarcodeIndicator.stop();
        }
    }

    public void switchTorchOn(boolean on) {
        if (this.mBarcodePicker.isTorchBeingSet()) {
            return;
        }
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        if (this.mTorchMode == 1 && on) {
            this.mTorchMode = 2;
            this.mBarcodePicker.setTorch(true);
            if (this.mTorchButton != null && this.mBarcodePicker.hasTorch()) {
                this.mTorchButton.setImageBitmap(globals.getTorchOnImage(this.getContext()));
            }
        } else if (this.mTorchMode == 2 && !on) {
            this.mTorchMode = 1;
            this.mBarcodePicker.setTorch(false);
            if (this.mTorchButton != null && this.mBarcodePicker.hasTorch()) {
                this.mTorchButton.setImageBitmap(globals.getTorchOffImage(this.getContext()));
            }
        }
    }

    public void showSearchBar(boolean show) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        if (show && this.mSearchBar == null && !globals.isLegacy()) {
            this.mSearchBar = new RelativeLayout(this.getContext());
            this.mSearchButton = new ImageButton(this.getContext());
            this.mSearchButton.setImageBitmap(globals.getSearchButtonIcon(this.getContext()));
            this.mSearchButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            RelativeLayout.LayoutParams rParams = new RelativeLayout.LayoutParams(0, -2);
            rParams.addRule(11);
            this.mSearchBar.addView((View)this.mSearchButton, (ViewGroup.LayoutParams)rParams);
            this.mSearchButton.setId(1234);
            this.mSearchButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ScanditSDKOverlayView.this.onSearchClicked();
                }
            });
            this.mSearchEditText = new EditText(this.getContext());
            this.mSearchEditText.setHint((CharSequence)globals.getSearchBarPlaceholder());
            this.mSearchEditText.setInputType(globals.getSearchBarKeyboardType());
            this.mSearchEditText.setLines(1);
            this.mSearchEditText.setEllipsize(TextUtils.TruncateAt.END);
            rParams = new RelativeLayout.LayoutParams(-2, -2);
            rParams.addRule(9);
            rParams.addRule(0, this.mSearchButton.getId());
            this.mSearchBar.addView((View)this.mSearchEditText, (ViewGroup.LayoutParams)rParams);
            this.mSearchEditText.addTextChangedListener(new TextWatcher(){

                public void afterTextChanged(Editable s) {
                    RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)ScanditSDKOverlayView.this.mSearchButton.getLayoutParams();
                    if (s.length() > 0) {
                        params.width = ScanditSDKOverlayView.this.mSearchEditText.getHeight();
                        params.height = ScanditSDKOverlayView.this.mSearchEditText.getHeight();
                        ScanditSDKOverlayView.this.mSearchButton.setLayoutParams((ViewGroup.LayoutParams)params);
                    } else {
                        params.width = 0;
                        ScanditSDKOverlayView.this.mSearchButton.setLayoutParams((ViewGroup.LayoutParams)params);
                    }
                }

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }
            });
            this.mSearchEditText.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (event.getKeyCode() == 66 && event.getAction() == 1) {
                        ScanditSDKOverlayView.this.onSearchClicked();
                        return true;
                    }
                    return false;
                }
            });
            rParams = new RelativeLayout.LayoutParams(-1, -2);
            rParams.addRule(10);
            this.addView((View)this.mSearchBar, (ViewGroup.LayoutParams)rParams);
            this.requestChildFocus(null, null);
        } else if (!show && this.mSearchBar != null) {
            this.removeView((View)this.mSearchBar);
            this.mSearchBar = null;
        }
    }

    public void showTitleBar(boolean show) {
    }

    public void showToolBar(boolean show) {
    }

    public void resetGUI() {
        if (this.mSearchEditText != null) {
            this.mSearchEditText.setText((CharSequence)"");
        }
    }

    public void showMostLikelyBarcodeUIElement(boolean enabled) {
    }

    public void setInfoBannerY(float y) {
    }

    public void setLogoOffsets(int xOffset, int yOffset, int landscapeXOffset, int landscapeYOffset) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setLogoXOffset(xOffset);
        globals.setLogoYOffset(yOffset);
        globals.setLogoXLandscapeOffset(landscapeXOffset);
        globals.setLogoYLandscapeOffset(landscapeYOffset);
    }

    public void setViewfinderDimension(float width, float height) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setViewfinderDimension(width, height);
    }

    public void setViewfinderDimension(float width, float height, float landscapeWidth, float landscapeHeight) {
        ScanditSDKGlobals.getInstance(this.getContext()).setViewfinderDimension(width, height, landscapeWidth, landscapeHeight);
    }

    public void drawViewfinder(boolean draw) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setDrawViewfinder(draw);
        this.mBarcodeIndicator.softForceDefault();
    }

    public void drawViewfinderTextHook(boolean draw) {
        Log.w((String)"ScanditSDK", (String)"The function 'drawViewfinderTextHook' is deprecated and has no functionality anymore.");
    }

    public void setTextForMostLikelyBarcodeUIElement(String text) {
    }

    public void setTextForInitialScanScreenState(String text) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setInitialScanScreenState(text);
    }

    public void setTextForBarcodePresenceDetected(String text) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setBarcodePresenceDetected(text);
    }

    public void setTextForBarcodeDecodingInProgress(String text) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setBarcodeDecodingInProgress(text);
    }

    public void setTextIfNoBarcodeWasRecognized(String text) {
    }

    public void setTextToSuggestManualEntry(String text) {
    }

    public void setTitleMessage(String message) {
    }

    public void setLeftButtonCaption(String caption) {
    }

    public void setLeftButtonCaptionWhenKeypadVisible(String caption) {
    }

    public void setRightButtonCaption(String caption) {
    }

    public void setRightButtonCaptionWhenKeypadVisible(String caption) {
    }

    public void setSearchBarPlaceholderText(String text) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setSearchBarPlaceholder(text);
        if (this.mSearchBar != null) {
            this.mSearchEditText.setHint((CharSequence)text);
        }
    }

    public void setSearchBarKeyboardType(int inputType) {
        ScanditSDKGlobals.getInstance(this.getContext()).setSearchBarKeyboardType(inputType);
        if (this.mSearchEditText != null) {
            this.mSearchEditText.setInputType(inputType);
        }
    }

    public void setViewfinderColor(float r, float g, float b) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setViewfinderColor(r, g, b);
        this.mBarcodeIndicator.redrawColor();
    }

    public void setViewfinderDecodedColor(float r, float g, float b) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setViewfinderRecognizedColor(r, g, b);
        this.mBarcodeIndicator.redrawColor();
    }

    public void setBeepEnabled(boolean enabled) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setBeepEnabled(enabled);
    }

    public void setVibrateEnabled(boolean enabled) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setVibrateEnabled(enabled);
    }

    public void setTorchEnabled(boolean enabled) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setTorchEnabled(enabled);
    }

    public void setTorchOffImage(Bitmap image) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setTorchOffImage(image);
        globals.setTorchOffImagePressed(image);
    }

    public void setTorchOffImage(Bitmap image, Bitmap pressedImage) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setTorchOffImage(image);
        globals.setTorchOffImagePressed(pressedImage);
    }

    public void setTorchOnImage(Bitmap image) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setTorchOnImage(image);
        globals.setTorchOnImagePressed(image);
    }

    public void setTorchOnImage(Bitmap image, Bitmap pressedImage) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setTorchOffImage(image);
        globals.setTorchOnImagePressed(pressedImage);
    }

    public void setTorchButtonPosition(float relativeX, float relativeY, int width, int height) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setTorchButtonRect(new ScanditSDKRect(relativeX, relativeY, width, height));
    }

    public void setCameraSwitchVisibility(int visibility) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setCameraSwitchVisibility(visibility);
    }

    public void setCameraSwitchImage(Bitmap image, Bitmap pressedImage) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setCameraSwitchImage(image);
        globals.setCameraSwitchImagePressed(pressedImage);
    }

    public void setCameraSwitchButtonPosition(float invertedRelativeX, float relativeY, int width, int height) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        globals.setCameraSwitchButtonRect(new ScanditSDKRect(invertedRelativeX, relativeY, width, height));
    }

    public void addListener(ScanditSDKListener listener) {
        if (!this.registeredScanDKListerens.contains(listener)) {
            this.registeredScanDKListerens.add(listener);
        }
    }

    public void removeListener(ScanditSDKListener listener) {
        this.registeredScanDKListerens.remove(listener);
    }

    public void removeAllListenes() {
        this.registeredScanDKListerens.clear();
    }

    public synchronized void callMethodOnRegisteredListeners(String methodName, Object[] parameters) {
        int i;
        Class[] param_types = null;
        if (parameters != null) {
            param_types = new Class[parameters.length];
            for (i = 0; i < parameters.length; ++i) {
                param_types[i] = parameters[i] == null ? null : parameters[i].getClass();
            }
        }
        for (i = 0; i < this.registeredScanDKListerens.size(); ++i) {
            ScanditSDKListener listener = this.registeredScanDKListerens.elementAt(i);
            try {
                Method method = listener.getClass().getMethod(methodName, param_types);
                method.invoke((Object)listener, parameters);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void onSearchClicked() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.mSearchEditText.getApplicationWindowToken(), 0);
        Object[] params = new String[]{this.mSearchEditText.getText().toString()};
        this.callMethodOnRegisteredListeners("didManualSearch", params);
    }

    public void didUpdateStatus(ScanditSDKScanState scanState) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        boolean updatedLocation = false;
        for (ScanditSDKRoughCode code : scanState.roughCodes) {
            if ((code.getLikelihood() <= 3 || code.getLikelihood() >= 5 || scanState.codeDecoded) && (code.getLikelihood() <= 4 || !scanState.codeDecoded) || updatedLocation) continue;
            int firstSide = code.getLongSide();
            int secondSide = code.getShortSide();
            secondSide = (int)Math.max((double)secondSide, (double)firstSide * globals.getViewfinderHeight() / globals.getViewfinderWidth());
            if (globals.isLegacy() && Build.VERSION.SDK_INT < 11) {
                int tmpSide = firstSide;
                firstSide = secondSide;
                secondSide = tmpSide;
            }
            if (this.mBarcodeIndicator != null) {
                if ((scanState.codeType.equals("QR") || scanState.codeType.equals("DATAMATRIX") || scanState.codeType.equals("GS1-QR") || scanState.codeType.equals("GS1-DATAMATRIX")) && !scanState.stayAtDefaultLocation) {
                    this.mBarcodeIndicator.setTargetLocation(code.getX(), code.getY());
                    this.mBarcodeIndicator.setTargetSize(firstSide, secondSide);
                    this.mBarcodeIndicator.setTargetRotation(code.getAngle());
                    this.mBarcodeIndicator.setTargetLikelihood(code.getLikelihood());
                } else if (!scanState.stayAtDefaultLocation) {
                    this.mBarcodeIndicator.setTargetLocation(code.getX(), code.getY());
                    this.mBarcodeIndicator.setTargetSize((int)((double)firstSide * 1.2), (int)((double)secondSide * 1.2));
                    this.mBarcodeIndicator.setTargetRotation(code.getAngle());
                    this.mBarcodeIndicator.setTargetLikelihood(code.getLikelihood());
                } else {
                    this.mBarcodeIndicator.softForceDefault();
                    this.mBarcodeIndicator.setTargetLikelihood(code.getLikelihood());
                }
            }
            updatedLocation = true;
            break;
        }
        this.invalidate();
        if (scanState.codeDecoded) {
            this.mBarcodeIndicator.setTargetLikelihood(5);
            String finalBarcode = scanState.codeNumber;
            if (scanState.codeType.equals("MSI")) {
                int checksumSize = 1;
                int type = globals.getMsiPlesseyChecksumType();
                if (type == 0) {
                    checksumSize = 0;
                } else if (type == 3 || type == 4) {
                    checksumSize = 2;
                }
                finalBarcode = finalBarcode.substring(0, scanState.codeNumber.length() - checksumSize);
            }
            this.mBarcode = finalBarcode;
            this.mSymbology = scanState.codeType;
            if (!(scanState.counterCodeDecodedChanged != scanState.counter || scanState.lastCodeNumber.equals(scanState.codeNumber) && System.currentTimeMillis() - scanState.lastDecodedTime <= 800L)) {
                AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
                int vibratePermission = this.getContext().getPackageManager().checkPermission("android.permission.VIBRATE", this.getContext().getPackageName());
                if (this.mVibrator != null && globals.isVibrateEnabled() && vibratePermission == 0 && audioManager.getRingerMode() != 0) {
                    this.mVibrator.vibrate(this.mVibrateTime);
                }
                if (this.mMediaPlayer != null && globals.isBeepEnabled() && audioManager.getRingerMode() == 2) {
                    this.mMediaPlayer.start();
                }
                Message msg = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessage(msg);
            }
            scanState.counterLastDecoded = scanState.counter;
            scanState.lastCodeNumber = scanState.codeNumber;
            scanState.lastDecodedTime = System.currentTimeMillis();
        }
        if (!updatedLocation) {
            this.mBarcodeIndicator.goToDefault();
        }
    }

    private void drawInfoBanner(Canvas canvas, int width, int height) {
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        int x = 0;
        int y = 0;
        if (globals.isLegacy()) {
            x = (int)(globals.getScanningHotSpotY() * (float)width + (float)(globals.getViewfinderHeightForView(height, width) / 2)) + globals.getLogoYOffset();
            y = (int)((float)height - (globals.getScanningHotSpotX() * (float)height + (float)(globals.getViewfinderWidthForView(height, width) / 2))) - globals.getLogoXOffset();
        } else {
            x = (int)(globals.getScanningHotSpotX() * (float)width + (float)(globals.getViewfinderWidthForView(width, height) / 2));
            y = (int)(globals.getScanningHotSpotY() * (float)height + (float)(globals.getViewfinderHeightForView(width, height) / 2));
            if (!globals.isInPortraitMode()) {
                x += globals.getLogoXLandscapeOffset();
                y += globals.getLogoYLandscapeOffset();
            } else {
                x += globals.getLogoXOffset();
                y += globals.getLogoYOffset();
            }
        }
        int actualHeight = SbSystemUtils.pxFromDp(this.getContext(), 38);
        if (SbDeviceProperties.isTabletDevice(this.getContext())) {
            actualHeight = (int)((double)actualHeight * 1.5);
        }
        if (globals.isLegacy()) {
            y -= SbSystemUtils.pxFromDp(this.getContext(), 5);
        } else {
            x += SbSystemUtils.pxFromDp(this.getContext(), 5);
        }
        int actualWidth = (int)(3.0f * (float)actualHeight);
        Bitmap logo = globals.getBannerImage(this.getContext(), actualWidth, actualHeight);
        if (logo != null) {
            if (globals.isLegacy()) {
                this.drawBitmap(logo, x, y + actualWidth, actualWidth, actualHeight, false, canvas);
            } else {
                this.drawBitmap(logo, x - actualWidth, y, actualWidth, actualHeight, false, canvas);
            }
        }
    }

    public void drawBitmap(Bitmap bitmap, int x, int y, int targetW, int targetH, boolean antiAlias, Canvas canvas) {
        Paint paint = new Paint();
        paint.setAntiAlias(antiAlias);
        canvas.save();
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        if (globals.isLegacy()) {
            canvas.rotate(270.0f, (float)x, (float)y);
        }
        Rect r2 = new Rect(x, y, x + targetW, y + targetH);
        canvas.drawBitmap(bitmap, null, r2, paint);
        canvas.restore();
    }

    private void addUIElements() {
        final ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        this.mTorchButton = globals.isLegacy() ? new ScanditSDKRotatedImageButton(this.getContext()) : new ImageButton(this.getContext());
        this.mTorchButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mTorchButton.setBackgroundColor(0);
        if (this.mTorchMode == 1) {
            this.mTorchButton.setImageBitmap(globals.getTorchOffImage(this.getContext()));
        } else {
            this.mTorchButton.setImageBitmap(globals.getTorchOnImage(this.getContext()));
        }
        this.mTorchButton.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    if (ScanditSDKOverlayView.this.mTorchMode == 1) {
                        ScanditSDKOverlayView.this.mTorchButton.setImageBitmap(globals.getTorchOffImagePressed(ScanditSDKOverlayView.this.getContext()));
                    } else {
                        ScanditSDKOverlayView.this.mTorchButton.setImageBitmap(globals.getTorchOnImagePressed(ScanditSDKOverlayView.this.getContext()));
                    }
                } else if (event.getAction() == 1) {
                    if (ScanditSDKOverlayView.this.mTorchMode == 1) {
                        ScanditSDKOverlayView.this.mTorchButton.setImageBitmap(globals.getTorchOffImage(ScanditSDKOverlayView.this.getContext()));
                    } else {
                        ScanditSDKOverlayView.this.mTorchButton.setImageBitmap(globals.getTorchOnImage(ScanditSDKOverlayView.this.getContext()));
                    }
                }
                return false;
            }
        });
        this.mTorchButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bitmap image;
                if (ScanditSDKOverlayView.this.mBarcodePicker.isTorchBeingSet()) {
                    return;
                }
                if (ScanditSDKOverlayView.this.mTorchMode == 1) {
                    ScanditSDKOverlayView.this.mTorchMode = 2;
                    ScanditSDKOverlayView.this.mBarcodePicker.setTorch(true);
                    image = globals.getTorchOnImage(ScanditSDKOverlayView.this.getContext());
                } else {
                    ScanditSDKOverlayView.this.mTorchMode = 1;
                    ScanditSDKOverlayView.this.mBarcodePicker.setTorch(false);
                    image = globals.getTorchOffImage(ScanditSDKOverlayView.this.getContext());
                }
                ScanditSDKOverlayView.this.mTorchButton.setImageBitmap(image);
            }
        });
        this.addView((View)this.mTorchButton);
        this.mCameraSwapButton = globals.isLegacy() ? new ScanditSDKRotatedImageButton(this.getContext()) : new ImageButton(this.getContext());
        this.mCameraSwapButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mCameraSwapButton.setBackgroundColor(0);
        this.mCameraSwapButton.setImageBitmap(globals.getCameraSwitchImage(this.getContext()));
        this.mCameraSwapButton.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    ScanditSDKOverlayView.this.mCameraSwapButton.setImageBitmap(globals.getCameraSwitchImagePressed(ScanditSDKOverlayView.this.getContext()));
                } else if (event.getAction() == 1) {
                    ScanditSDKOverlayView.this.mCameraSwapButton.setImageBitmap(globals.getCameraSwitchImage(ScanditSDKOverlayView.this.getContext()));
                }
                return false;
            }
        });
        this.mCameraSwapButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ScanditSDKOverlayView.this.mBarcodePicker.isCameraBeingStarted()) {
                    return;
                }
                if (ScanditSDKOverlayView.this.mBarcodePicker.getCameraFacingDirection() == 1) {
                    ScanditSDKOverlayView.this.mBarcodePicker.changeCameraFacing(0);
                } else {
                    ScanditSDKOverlayView.this.mBarcodePicker.changeCameraFacing(1);
                }
            }
        });
        this.addView((View)this.mCameraSwapButton);
    }

    @TargetApi(value=11)
    protected void dispatchDraw(Canvas canvas) {
        boolean canSwitchCamera;
        ScanditSDKGlobals globals = ScanditSDKGlobals.getInstance(this.getContext());
        super.dispatchDraw(canvas);
        if (this.mFirstRound) {
            this.addUIElements();
            this.mFirstRound = false;
        }
        if (this.mBarcodePicker.hasTorch() && globals.isTorchEnabled()) {
            this.mTorchButton.setVisibility(0);
        } else {
            this.mTorchButton.setVisibility(8);
        }
        boolean shouldShowCameraSwitch = false;
        if (globals.getCameraSwitchVisibility() == 1) {
            if (SbDeviceProperties.isTabletDevice(this.getContext())) {
                shouldShowCameraSwitch = true;
            }
        } else if (globals.getCameraSwitchVisibility() == 2) {
            shouldShowCameraSwitch = true;
        }
        boolean bl = canSwitchCamera = this.mBarcodePicker.supportsCameraFacing(0) && this.mBarcodePicker.supportsCameraFacing(1);
        if (canSwitchCamera && shouldShowCameraSwitch) {
            this.mCameraSwapButton.setVisibility(0);
        } else {
            this.mCameraSwapButton.setVisibility(8);
        }
        ScanditSDKRect torchRect = globals.getTorchButtonRect();
        int buttonHeight = SbSystemUtils.pxFromDp(this.getContext(), torchRect.height);
        int buttonWidth = (int)((float)torchRect.width / (float)torchRect.height * (float)buttonHeight);
        int yOffset = (int)((float)this.getHeight() * torchRect.y);
        if (this.mSearchBar != null) {
            yOffset += this.mSearchBar.getHeight();
        }
        int xOffset = (int)((float)this.getWidth() * torchRect.x);
        RelativeLayout.LayoutParams rParams = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
        if (globals.isLegacy()) {
            rParams.addRule(9);
            rParams.addRule(12);
            rParams.leftMargin = yOffset;
            rParams.bottomMargin = xOffset;
        } else {
            rParams.addRule(9);
            rParams.addRule(10);
            rParams.topMargin = yOffset;
            rParams.leftMargin = xOffset;
        }
        this.mTorchButton.setPadding(0, 0, 0, 0);
        this.mTorchButton.setLayoutParams((ViewGroup.LayoutParams)rParams);
        ScanditSDKRect cameraSwitchRect = globals.getCameraSwitchButtonRect();
        buttonHeight = SbSystemUtils.pxFromDp(this.getContext(), cameraSwitchRect.height);
        buttonWidth = (int)((float)cameraSwitchRect.width / (float)cameraSwitchRect.height * (float)buttonHeight);
        yOffset = (int)((float)this.getHeight() * cameraSwitchRect.y);
        if (this.mSearchBar != null) {
            yOffset += this.mSearchBar.getHeight();
        }
        xOffset = (int)((float)this.getWidth() * cameraSwitchRect.x);
        rParams = new RelativeLayout.LayoutParams(buttonWidth, buttonHeight);
        if (globals.isLegacy()) {
            rParams.addRule(9);
            rParams.addRule(10);
            rParams.leftMargin = yOffset;
            rParams.topMargin = xOffset;
        } else {
            rParams.addRule(11);
            rParams.addRule(10);
            rParams.topMargin = yOffset;
            rParams.rightMargin = xOffset;
        }
        this.mCameraSwapButton.setPadding(0, 0, 0, 0);
        this.mCameraSwapButton.setLayoutParams((ViewGroup.LayoutParams)rParams);
        this.drawInfoBanner(canvas, this.getWidth(), this.getHeight());
    }
}

