/*
 * Decompiled with CFR 0.152.
 */
package com.mirasense.scanditsdk.gui.animations;

import android.annotation.TargetApi;
import android.graphics.Color;
import android.os.Build;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.mirasense.scanditsdk.gui.ScanditSDKBarcodeIndicatorView;

public class ScanditSDKAlphaAnimation
extends Animation {
    ScanditSDKBarcodeIndicatorView mView;
    float mFromAlpha;
    float mToAlpha;
    float mFromRed;
    float mFromGreen;
    float mFromBlue;
    float mToRed;
    float mToGreen;
    float mToBlue;

    public ScanditSDKAlphaAnimation(float fromAlpha, float toAlpha, int fromColor, int toColor, ScanditSDKBarcodeIndicatorView view) {
        this.mView = view;
        this.mFromAlpha = fromAlpha;
        this.mToAlpha = toAlpha;
        this.mFromRed = Color.red((int)fromColor);
        this.mFromGreen = Color.green((int)fromColor);
        this.mFromBlue = Color.blue((int)fromColor);
        this.mToRed = Color.red((int)toColor);
        this.mToGreen = Color.green((int)toColor);
        this.mToBlue = Color.blue((int)toColor);
    }

    @TargetApi(value=11)
    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float targetAlpha = this.mFromAlpha + (this.mToAlpha - this.mFromAlpha) * interpolatedTime;
        if (Build.VERSION.SDK_INT > 10) {
            this.mView.setAlpha(targetAlpha);
        }
        int targetRed = (int)(this.mFromRed + (this.mToRed - this.mFromRed) * interpolatedTime);
        int targetGreen = (int)(this.mFromGreen + (this.mToGreen - this.mFromGreen) * interpolatedTime);
        int targetBlue = (int)(this.mFromBlue + (this.mToBlue - this.mFromBlue) * interpolatedTime);
        this.mView.setFillRGB(targetRed, targetGreen, targetBlue);
    }
}

